/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.View;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AddClassDialog
extends AppDialog {
    private final JButton okButton = new JButton(this.translate("button.ok"));
    private final JButton cancelButton = new JButton(this.translate("button.cancel"));
    private final JTextField classNameTextField = new JTextField(30);
    private String result = null;

    public AddClassDialog(Window owner) {
        super(owner);
        this.setDefaultCloseOperation(1);
        this.setTitle(this.translate("dialog.title"));
        Container cnt = this.getContentPane();
        cnt.setLayout(new BoxLayout(cnt, 1));
        JPanel panButtons = new JPanel(new FlowLayout());
        this.okButton.addActionListener(this::okButtonActionPerformed);
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        panButtons.add(this.okButton);
        panButtons.add(this.cancelButton);
        JLabel classNameLabel = new JLabel(this.translate("classname"));
        classNameLabel.setAlignmentX(0.5f);
        cnt.add(classNameLabel);
        cnt.add(this.classNameTextField);
        cnt.add(panButtons);
        this.classNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddClassDialog.this.checkEnabled();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddClassDialog.this.checkEnabled();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddClassDialog.this.checkEnabled();
            }
        });
        this.classNameTextField.addActionListener(this::okButtonActionPerformed);
        this.pack();
        this.setModal(true);
        this.setResizable(false);
        View.setWindowIcon(this);
        View.centerScreen(this);
        this.checkEnabled();
    }

    private void checkEnabled() {
        boolean ok = true;
        if (this.classNameTextField.getText().isEmpty()) {
            ok = false;
        }
        if (this.classNameTextField.getText().endsWith(".")) {
            ok = false;
        }
        if (ok) {
            SWF swf = Main.getMainFrame().getPanel().getCurrentSwf();
            ArrayList<String> classNames = new ArrayList<String>();
            classNames.add(this.classNameTextField.getText());
            try {
                List scriptPacks = swf.getScriptPacksByClassNames(classNames);
                if (!scriptPacks.isEmpty()) {
                    ok = false;
                }
            }
            catch (Exception ex) {
                ok = false;
            }
        }
        this.okButton.setEnabled(ok);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (!this.okButton.isEnabled()) {
            return;
        }
        this.result = this.classNameTextField.getText();
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.result = null;
        this.setVisible(false);
    }

    public String showDialog() {
        return this.showDialog("");
    }

    public String showDialog(String pkg) {
        this.classNameTextField.setText(pkg);
        this.result = null;
        this.setVisible(true);
        return this.result;
    }
}

