/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private static final String lineSep = System.getProperty("line.separator");
    private DateFormat dateFormat;

    @Override
    public String format(LogRecord record) {
        StringBuilder buf = new StringBuilder(180);
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
        }
        buf.append(this.dateFormat.format(new Date(record.getMillis())));
        buf.append(" > ");
        if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
            buf.append(record.getLevel());
            buf.append(": ");
        }
        buf.append(this.formatMessage(record));
        buf.append(lineSep);
        Throwable throwable = record.getThrown();
        if (throwable != null) {
            StringWriter sink = new StringWriter();
            throwable.printStackTrace(new PrintWriter((Writer)sink, true));
            buf.append(record.getSourceClassName());
            buf.append(' ');
            buf.append(record.getSourceMethodName());
            buf.append(lineSep);
            buf.append(sink.toString());
        }
        return buf.toString();
    }
}

