/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.browsers.cache.firefox;

import com.jpexs.browsers.cache.RafInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Map;

public class Location {
    public int locationSelector;
    public int extraBlocks;
    public long blockNumber;
    public int fileGeneration;
    public int fileSize;
    public boolean isMetadata;
    public long hash;
    private final File rootDir;
    public static final long eReservedMask = 0x4C000000L;
    public static final long eLocationSelectorMask = 0x30000000L;
    public static final int eLocationSelectorOffset = 28;
    public static final long eExtraBlocksMask = 0x3000000L;
    public static final int eExtraBlocksOffset = 24;
    public static final long eBlockNumberMask = 0xFFFFFFL;
    public static final long eFileGenerationMask = 255L;
    public static final long eFileSizeMask = 0xFFFF00L;
    public static final int eFileSizeOffset = 8;
    public static final long eFileReservedMask = 0x4F000000L;
    private final Map<Integer, RandomAccessFile> dataFiles;

    public static int size_shift(int idx) {
        return 2 * (idx - 1);
    }

    public static int bitmapSizeForIndex(int idx) {
        return idx > 0 ? 131072 >> Location.size_shift(idx) : 0;
    }

    public static int blockSizeForIndex(int idx) {
        return idx > 0 ? 256 << Location.size_shift(idx) : 0;
    }

    public InputStream getInputStream() throws IOException {
        String fileName = this.getFileName();
        if (this.locationSelector > 0) {
            RandomAccessFile raf = this.dataFiles.get(this.locationSelector);
            raf.seek((long)(Location.bitmapSizeForIndex(this.locationSelector) / 8) + (long)Location.blockSizeForIndex(this.locationSelector) * this.blockNumber);
            return new RafInputStream(raf);
        }
        return new FileInputStream(new File(this.rootDir, fileName));
    }

    public Location(long val, boolean isMetadata, long hash, File rootDir, Map<Integer, RandomAccessFile> dataFiles) {
        this.hash = hash;
        this.dataFiles = dataFiles;
        this.rootDir = rootDir;
        this.isMetadata = isMetadata;
        this.locationSelector = (int)((val & 0x30000000L) >> 28);
        if (this.locationSelector > 0) {
            this.extraBlocks = (int)((val & 0x3000000L) >> 24);
            this.blockNumber = (int)(val & 0xFFFFFFL);
        } else {
            this.fileSize = (int)((val & 0xFFFF00L) >> 8);
            this.fileGeneration = (int)(val & 0xFFL);
        }
    }

    public String getFileName() {
        if (this.locationSelector > 0) {
            return "_CACHE_00" + this.locationSelector + "_";
        }
        String hashHex = Long.toHexString(this.hash & 0xFFFFFFFFL).toUpperCase();
        while (hashHex.length() < 8) {
            hashHex = "0" + hashHex;
        }
        String genHex = Integer.toHexString(this.fileGeneration);
        while (genHex.length() < 2) {
            genHex = "0" + genHex;
        }
        return hashHex.charAt(0) + File.separator + hashHex.substring(1, 3) + File.separator + hashHex.substring(3) + (this.isMetadata ? "m" : "d") + genHex;
    }

    public String toString() {
        if (this.locationSelector > 0) {
            return this.getFileName() + " block " + this.blockNumber + " extraBlocks " + this.extraBlocks;
        }
        return this.getFileName();
    }
}

