/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.browsers.cache.firefox;

import com.jpexs.browsers.cache.firefox.CacheInputStream;
import com.jpexs.browsers.cache.firefox.MapBucket;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CacheMap {
    public long version;
    public long datasize;
    public long entryCount;
    public long dirtyFlag;
    public long recordCount;
    public long[] evictionRank;
    public long[] bucketUsage;
    public List<MapBucket> mapBuckets;

    public CacheMap(File file) throws IOException {
        int i;
        File cacheDir = file.getParentFile();
        CacheInputStream cis = new CacheInputStream(new FileInputStream(file));
        this.version = cis.readInt32();
        this.datasize = cis.readInt32();
        this.entryCount = cis.readInt32();
        this.dirtyFlag = cis.readInt32();
        this.recordCount = cis.readInt32();
        this.evictionRank = new long[32];
        for (i = 0; i < this.evictionRank.length; ++i) {
            this.evictionRank[i] = cis.readInt32();
        }
        this.bucketUsage = new long[32];
        for (i = 0; i < this.bucketUsage.length; ++i) {
            this.bucketUsage[i] = cis.readInt32();
        }
        this.mapBuckets = new ArrayList<MapBucket>();
        HashMap<Integer, RandomAccessFile> cacheFiles = new HashMap<Integer, RandomAccessFile>();
        for (int i2 = 1; i2 <= 3; ++i2) {
            cacheFiles.put(i2, new RandomAccessFile(new File(cacheDir, "_CACHE_00" + i2 + "_"), "r"));
        }
        while (cis.available() > 0) {
            MapBucket mb = new MapBucket(cis, cacheDir, cacheFiles);
            if (mb.hash == 0L) continue;
            this.mapBuckets.add(mb);
        }
    }
}

