/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import com.jpexs.helpers.streams.SeekableInputStream;
import java.io.IOException;

public class MemoryInputStream
extends SeekableInputStream {
    private final byte[] buffer;
    private long pos;
    private int startPos;
    private int maxLength;

    public MemoryInputStream(byte[] buffer) throws IOException {
        this(buffer, 0, buffer.length);
    }

    public MemoryInputStream(byte[] buffer, int startPos) throws IOException {
        this(buffer, startPos, buffer.length - startPos);
    }

    public MemoryInputStream(byte[] buffer, int startPos, int maxLength) throws IOException {
        this.buffer = buffer;
        this.startPos = startPos;
        if (startPos > buffer.length) {
            throw new IOException("Invalid startPos");
        }
        this.maxLength = maxLength;
        if (startPos + maxLength >= buffer.length) {
            this.maxLength = buffer.length - startPos;
        }
    }

    public byte[] getAllRead() {
        return this.buffer;
    }

    public long getPos() {
        return this.pos;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("Seek to negative position");
        }
        this.pos = pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.seek(0L);
    }

    @Override
    public int read() throws IOException {
        if (this.pos < (long)this.maxLength) {
            int ret = this.buffer[(int)this.pos + this.startPos] & 0xFF;
            ++this.pos;
            return ret;
        }
        return -1;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        if (this.pos < (long)this.maxLength) {
            int toRead = Math.min(this.available(), bytes.length);
            System.arraycopy(this.buffer, (int)this.pos + this.startPos, bytes, 0, toRead);
            this.pos += (long)toRead;
            return toRead;
        }
        return -1;
    }

    @Override
    public int available() throws IOException {
        return this.maxLength - (int)this.pos;
    }
}

