/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class JpegFixer {
    private static final int SOI = 216;
    private static final int EOI = 217;
    private static final int SOF0 = 192;
    private static final int SOF1 = 193;
    private static final int SOF2 = 194;
    private static final int SOF3 = 195;
    private static final int SOF5 = 197;
    private static final int SOF6 = 198;
    private static final int SOF7 = 199;
    private static final int SOF9 = 201;
    private static final int SOF10 = 202;
    private static final int SOF11 = 203;
    private static final int SOF13 = 205;
    private static final int SOF14 = 206;
    private static final int SOF15 = 207;
    private static final int APP0 = 224;

    public void fixJpeg(InputStream is, OutputStream os) throws IOException {
        int i;
        ArrayList<Object> data = new ArrayList<Object>();
        ArrayList<Integer> markers = new ArrayList<Integer>();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int lastMarker = -1;
        int val = is.read();
        if (val == -1) {
            return;
        }
        if (val == 255) {
            val = is.read();
            if (val != 216) {
                os.write(255);
                os.write(val);
                while ((val = is.read()) > -1) {
                    os.write(val);
                }
                return;
            }
        } else {
            os.write(val);
            while ((val = is.read()) > -1) {
                os.write(val);
            }
            return;
        }
        while ((val = is.read()) > -1) {
            if (val == 255) {
                val = is.read();
                if (val == 0) {
                    baos.write(255);
                    baos.write(val);
                    continue;
                }
            } else {
                baos.write(val);
                continue;
            }
            if (lastMarker > -1) {
                data.add(baos.toByteArray());
                markers.add(lastMarker);
                baos = new ByteArrayOutputStream();
            }
            lastMarker = val;
        }
        if (lastMarker > -1) {
            data.add(baos.toByteArray());
            markers.add(lastMarker);
        }
        boolean wasApp0 = false;
        for (i = 0; i < data.size(); ++i) {
            if ((Integer)markers.get(i) == 224) {
                wasApp0 = true;
            }
            if (i <= 0 || (Integer)markers.get(i) != 216 || (Integer)markers.get(i - 1) != 217 || wasApp0) continue;
            markers.remove(i);
            data.remove(i);
            markers.remove(i - 1);
            data.remove(i - 1);
            ArrayList dataToMove = new ArrayList();
            ArrayList markersToMove = new ArrayList();
            for (int j = --i; j < data.size() && ((Integer)markers.get(j) == 224 || Arrays.asList(192, 193, 194, 195, 197, 198, 199, 201, 202, 203, 205, 206, 207).contains(markers.get(j))); ++j) {
                markersToMove.add(markers.get(j));
                dataToMove.add(data.get(j));
                data.remove(j);
                markers.remove(j);
                --j;
            }
            data.addAll(1, dataToMove);
            markers.addAll(1, markersToMove);
            break;
        }
        os.write(255);
        os.write(216);
        for (i = 0; i < data.size(); ++i) {
            os.write(255);
            os.write((Integer)markers.get(i));
            os.write((byte[])data.get(i));
        }
    }
}

