/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import com.jpexs.decompiler.flash.SWFInputStream;

public class ByteArrayRange {
    public static final ByteArrayRange EMPTY = new ByteArrayRange(SWFInputStream.BYTE_ARRAY_EMPTY);
    private final byte[] array;
    private final int pos;
    private final int length;

    public ByteArrayRange(byte[] array) {
        this.array = array;
        this.pos = 0;
        this.length = array.length;
    }

    public ByteArrayRange(byte[] array, int pos, int length) {
        this.array = array;
        this.pos = pos;
        this.length = length;
    }

    public ByteArrayRange(String hexString) {
        byte[] array = new byte[hexString.length() / 2];
        for (int i = 0; i < hexString.length() / 2; ++i) {
            array[i] = (byte)Integer.parseInt(hexString.substring(i * 2, i * 2 + 2), 16);
        }
        this.array = array;
        this.pos = 0;
        this.length = array.length;
    }

    public byte[] getArray() {
        return this.array;
    }

    public int getPos() {
        return this.pos;
    }

    public int getLength() {
        return this.length;
    }

    public byte get(int index) {
        return this.array[this.pos + index];
    }

    public byte[] getRangeData() {
        byte[] data = new byte[this.length];
        System.arraycopy(this.array, this.pos, data, 0, this.length);
        return data;
    }

    public byte[] getRangeData(int pos, int length) {
        byte[] data = new byte[length];
        System.arraycopy(this.array, this.pos + pos, data, 0, length);
        return data;
    }

    public ByteArrayRange getSubRange(int pos, int length) {
        return new ByteArrayRange(this.array, this.pos + pos, length);
    }
}

