/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph.model;

import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.Block;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.ContinueItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.List;

public class GotoItem
extends GraphTargetItem
implements Block {
    public String labelName;
    public List<GraphTargetItem> targetCommands = null;

    public GotoItem(GraphSourceItem src, GraphSourceItem lineStartIns, String labelName) {
        super(src, lineStartIns, 0);
        this.labelName = labelName;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (this.targetCommands != null) {
            if (this.labelName != null) {
                writer.append(this.labelName);
                writer.append(":");
                writer.newLine();
            }
            this.appendCommands(this.value, writer, localData, this.targetCommands, false);
        } else {
            writer.append("\u00a7\u00a7goto(").append(this.labelName).append(")");
        }
        return writer;
    }

    @Override
    public boolean needsSemicolon() {
        if (this.targetCommands != null) {
            return false;
        }
        return super.needsSemicolon();
    }

    @Override
    public boolean needsNewLine() {
        if (this.targetCommands != null) {
            return false;
        }
        return super.needsNewLine();
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.UNBOUNDED;
    }

    @Override
    public Object getResult() {
        return null;
    }

    @Override
    public List<ContinueItem> getContinues() {
        ArrayList<ContinueItem> ret = new ArrayList<ContinueItem>();
        if (this.targetCommands == null) {
            return ret;
        }
        for (GraphTargetItem c : this.targetCommands) {
            if (!(c instanceof ContinueItem)) continue;
            ret.add((ContinueItem)c);
        }
        return ret;
    }

    @Override
    public List<List<GraphTargetItem>> getSubs() {
        ArrayList<List<GraphTargetItem>> ret = new ArrayList<List<GraphTargetItem>>();
        if (this.targetCommands != null) {
            ret.add(this.targetCommands);
        }
        return ret;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        if (this.targetCommands != null) {
            visitor.visitAll(this.targetCommands);
        }
    }

    @Override
    public void visitNoBlock(GraphTargetVisitorInterface visitor) {
    }
}

