/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.gfx;

import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.dumpview.DumpInfo;
import com.jpexs.helpers.MemoryInputStream;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class GFxInputStream {
    private final MemoryInputStream is;
    private static final int MaxUInt7 = 127;
    public DumpInfo dumpInfo;

    public GFxInputStream(MemoryInputStream is) {
        this.is = is;
    }

    public DumpInfo newDumpLevel(String name, String type) {
        if (this.dumpInfo != null) {
            long startByte = this.is.getPos();
            DumpInfo di = new DumpInfo(name, type, null, startByte, 0, 0L, 0);
            di.parent = this.dumpInfo;
            this.dumpInfo.getChildInfos().add(di);
            this.dumpInfo = di;
        }
        return this.dumpInfo;
    }

    public void endDumpLevel() {
        this.endDumpLevel(null);
    }

    public void endDumpLevel(Object value) {
        if (this.dumpInfo != null) {
            this.dumpInfo.lengthBytes = this.is.getPos() - this.dumpInfo.startByte;
            this.dumpInfo.previewValue = value;
            this.dumpInfo = this.dumpInfo.parent;
        }
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public void setPos(long pos) throws IOException {
        this.is.seek(pos);
    }

    public long getPos() {
        return this.is.getPos();
    }

    private int read() throws IOException {
        return this.is.read();
    }

    public int readUI8(String name) throws IOException {
        this.newDumpLevel(name, "UI8");
        int ret = this.read();
        this.endDumpLevel(ret);
        return ret;
    }

    public int readUI16(String name) throws IOException {
        this.newDumpLevel(name, "UI8");
        int ret = this.read() + (this.read() << 8);
        this.endDumpLevel(ret);
        return ret;
    }

    public int readSI16(String name) throws IOException {
        this.newDumpLevel(name, "SI16");
        int uval = this.read() + (this.read() << 8);
        if (uval >= 32768) {
            uval = -((~uval & 0xFFFF) + 1);
        }
        this.endDumpLevel(uval);
        return uval;
    }

    private long readUI32Internal() throws IOException {
        long ret = this.read() + (this.read() << 8) + (this.read() << 16) + (this.read() << 24) & 0xFFFFFFFF;
        return ret;
    }

    public long readUI32(String name) throws IOException {
        this.newDumpLevel(name, "UI32");
        long ret = this.readUI32Internal();
        this.endDumpLevel(ret);
        return ret;
    }

    public long readUI30(String name) throws IOException {
        this.newDumpLevel(name, "UI30");
        int tb = this.read();
        long t = tb;
        switch (tb & 3) {
            case 0: {
                long v = t >> 2;
                this.endDumpLevel(v);
                return v;
            }
            case 1: {
                long v = (t >>= 2) | (long)(this.read() << 6);
                this.endDumpLevel(v);
                return v;
            }
            case 2: {
                t >>= 2;
                long v = (t |= (long)(this.read() << 6)) | (long)(this.read() << 14);
                this.endDumpLevel(v);
                return v;
            }
        }
        t >>= 2;
        t |= (long)(this.read() << 6);
        long v = (t |= (long)(this.read() << 14)) | (long)(this.read() << 22);
        this.endDumpLevel(v);
        return v;
    }

    public float readFLOAT(String name) throws IOException {
        this.newDumpLevel(name, "UI32");
        int val = (int)this.readUI32Internal();
        float ret = Float.intBitsToFloat(val);
        this.endDumpLevel(Float.valueOf(ret));
        return ret;
    }

    public int readSI8(String name) throws IOException {
        this.newDumpLevel(name, "SI8");
        int uval = this.readSI8Internal();
        this.endDumpLevel(uval);
        return uval;
    }

    private int readSI8Internal() throws IOException {
        int uval = this.read();
        if (uval >= 128) {
            uval = -((~uval & 0xFF) + 1);
        }
        return uval;
    }

    public int readSI15(String name) throws IOException {
        this.newDumpLevel(name, "SI15");
        int t = this.readSI8Internal();
        if ((t & 1) == 0) {
            int v = t >> 1;
            this.endDumpLevel(v);
            return v;
        }
        t = t >> 1 & 0x7F;
        int v = t | this.readSI8Internal() << 7;
        this.endDumpLevel(v);
        return v;
    }

    public int readUI15(String name) throws IOException {
        this.newDumpLevel(name, "UI15");
        int t = this.read();
        if ((t & 1) == 0) {
            int v = t >> 1;
            this.endDumpLevel(v);
            return v;
        }
        int v = (t >>= 1) | this.read() << 7;
        this.endDumpLevel(v);
        return v;
    }

    public byte[] readBytes(long count, String name) throws IOException {
        if (count <= 0L) {
            return SWFInputStream.BYTE_ARRAY_EMPTY;
        }
        this.newDumpLevel(name, "bytes");
        byte[] ret = new byte[(int)count];
        int i = 0;
        while ((long)i < count) {
            ret[i] = (byte)this.read();
            ++i;
        }
        this.endDumpLevel();
        return ret;
    }

    void read(byte[] bytes) throws IOException {
        this.is.read(bytes);
    }

    public String readString(String name) throws IOException {
        this.newDumpLevel(name, "string");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (true) {
            int r;
            if ((r = this.read()) == 0) {
                String res = new String(baos.toByteArray(), Utf8Helper.charset);
                this.endDumpLevel(res);
                return res;
            }
            baos.write(r);
        }
    }
}

