/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types;

import com.jpexs.decompiler.flash.tags.base.NeedsCharacters;
import com.jpexs.decompiler.flash.types.FILLSTYLE;
import com.jpexs.decompiler.flash.types.FILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.LINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE2;
import com.jpexs.decompiler.flash.types.LINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.shaperecords.EndShapeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;

public class SHAPEWITHSTYLE
extends SHAPE
implements NeedsCharacters,
Serializable {
    public FILLSTYLEARRAY fillStyles;
    public LINESTYLEARRAY lineStyles;

    @Override
    public void getNeededCharacters(Set<Integer> needed) {
        this.fillStyles.getNeededCharacters(needed);
        this.lineStyles.getNeededCharacters(needed);
        for (SHAPERECORD r : this.shapeRecords) {
            r.getNeededCharacters(needed);
        }
    }

    @Override
    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        boolean modified = false;
        modified |= this.fillStyles.replaceCharacter(oldCharacterId, newCharacterId);
        modified |= this.lineStyles.replaceCharacter(oldCharacterId, newCharacterId);
        for (SHAPERECORD r : this.shapeRecords) {
            modified |= r.replaceCharacter(oldCharacterId, newCharacterId);
        }
        return modified;
    }

    @Override
    public boolean removeCharacter(int characterId) {
        boolean modified = false;
        modified |= this.fillStyles.removeCharacter(characterId);
        modified |= this.lineStyles.removeCharacter(characterId);
        for (SHAPERECORD r : this.shapeRecords) {
            modified |= r.removeCharacter(characterId);
        }
        return modified;
    }

    @Override
    public SHAPEWITHSTYLE resize(double multiplierX, double multiplierY) {
        SHAPEWITHSTYLE ret = new SHAPEWITHSTYLE();
        ret.numFillBits = this.numFillBits;
        ret.numLineBits = this.numLineBits;
        ArrayList<SHAPERECORD> recs = new ArrayList<SHAPERECORD>();
        for (SHAPERECORD r : this.shapeRecords) {
            SHAPERECORD c = r.resize(multiplierX, multiplierY);
            recs.add(c);
        }
        ret.shapeRecords = recs;
        ret.fillStyles = this.fillStyles;
        ret.lineStyles = this.lineStyles;
        return ret;
    }

    public static SHAPEWITHSTYLE createEmpty(int shapeNum) {
        SHAPEWITHSTYLE ret = new SHAPEWITHSTYLE();
        ret.shapeRecords = new ArrayList();
        ret.shapeRecords.add(new EndShapeRecord());
        ret.fillStyles = new FILLSTYLEARRAY();
        ret.fillStyles.fillStyles = new FILLSTYLE[0];
        ret.lineStyles = new LINESTYLEARRAY();
        ret.lineStyles.lineStyles = shapeNum <= 3 ? new LINESTYLE[0] : new LINESTYLE2[0];
        return ret;
    }
}

