/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.tags.base.FontInfoTag;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.LANGCODE;
import com.jpexs.decompiler.flash.types.annotations.Reserved;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@SWFVersion(from=6)
public class DefineFontInfo2Tag
extends FontInfoTag {
    public static final int ID = 62;
    public static final String NAME = "DefineFontInfo2";
    public String fontName;
    @Reserved
    @SWFType(value=BasicType.UB, count=2)
    public int reserved;
    public boolean fontFlagsSmallText;
    public boolean fontFlagsShiftJIS;
    public boolean fontFlagsANSI;
    public boolean fontFlagsItalic;
    public boolean fontFlagsBold;
    public boolean fontFlagsWideCodes;
    public LANGCODE languageCode;
    @SWFType(value=BasicType.UI16)
    public List<Integer> codeTable;

    public DefineFontInfo2Tag(SWF swf) {
        super(swf, 62, NAME, null);
        this.fontName = "New Font Info Name";
        this.languageCode = new LANGCODE();
        this.codeTable = new ArrayList<Integer>();
    }

    public DefineFontInfo2Tag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 62, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.fontID = sis.readUI16("fontID");
        this.fontName = this.swf.version >= 6 ? sis.readNetString("fontName", Utf8Helper.charset) : sis.readNetString("fontName");
        this.reserved = (int)sis.readUB(2, "reserved");
        this.fontFlagsSmallText = sis.readUB(1, "fontFlagsSmallText") == 1L;
        this.fontFlagsShiftJIS = sis.readUB(1, "fontFlagsShiftJIS") == 1L;
        this.fontFlagsANSI = sis.readUB(1, "fontFlagsANSI") == 1L;
        this.fontFlagsItalic = sis.readUB(1, "fontFlagsItalic") == 1L;
        this.fontFlagsBold = sis.readUB(1, "fontFlagsBold") == 1L;
        this.fontFlagsWideCodes = sis.readUB(1, "fontFlagsWideCodes") == 1L;
        this.languageCode = sis.readLANGCODE("languageCode");
        int ctLen = sis.available() / 2;
        this.codeTable = new ArrayList<Integer>();
        for (int i = 0; i < ctLen; ++i) {
            this.codeTable.add(sis.readUI16("code"));
        }
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.fontID);
        if (this.swf.version >= 6) {
            sos.writeNetString(this.fontName, Utf8Helper.charset);
        } else {
            sos.writeNetString(this.fontName);
        }
        sos.writeUB(2, this.reserved);
        sos.writeUB(1, this.fontFlagsSmallText ? 1L : 0L);
        sos.writeUB(1, this.fontFlagsShiftJIS ? 1L : 0L);
        sos.writeUB(1, this.fontFlagsANSI ? 1L : 0L);
        sos.writeUB(1, this.fontFlagsItalic ? 1L : 0L);
        sos.writeUB(1, this.fontFlagsBold ? 1L : 0L);
        sos.writeUB(1, this.fontFlagsWideCodes ? 1L : 0L);
        sos.writeLANGCODE(this.languageCode);
        for (int c : this.codeTable) {
            sos.writeUI16(c);
        }
    }

    @Override
    public List<Integer> getCodeTable() {
        return this.codeTable;
    }

    @Override
    public void addFontCharacter(int index, int character) {
        if (character > 255) {
            this.fontFlagsWideCodes = true;
        }
        this.codeTable.add(index, character);
        this.setModified(true);
    }

    @Override
    public void removeFontCharacter(int index) {
        this.codeTable.remove(index);
        this.setModified(true);
    }

    @Override
    public String getFontName() {
        return this.fontName;
    }

    @Override
    public boolean getFontFlagsBold() {
        return this.fontFlagsBold;
    }

    @Override
    public void setFontFlagsBold(boolean value) {
        this.fontFlagsBold = value;
    }

    @Override
    public boolean getFontFlagsItalic() {
        return this.fontFlagsItalic;
    }

    @Override
    public void setFontFlagsItalic(boolean value) {
        this.fontFlagsItalic = value;
    }
}

