/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers.svg;

import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.exporters.ShapeExporter;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.Point;
import com.jpexs.decompiler.flash.exporters.modes.ShapeExportMode;
import com.jpexs.decompiler.flash.exporters.settings.ShapeExportSettings;
import com.jpexs.decompiler.flash.exporters.shape.BitmapExporter;
import com.jpexs.decompiler.flash.importers.ShapeImporter;
import com.jpexs.decompiler.flash.importers.svg.CubicToQuad;
import com.jpexs.decompiler.flash.importers.svg.SvgBitmapFill;
import com.jpexs.decompiler.flash.importers.svg.SvgColor;
import com.jpexs.decompiler.flash.importers.svg.SvgFill;
import com.jpexs.decompiler.flash.importers.svg.SvgGradient;
import com.jpexs.decompiler.flash.importers.svg.SvgGradientUnits;
import com.jpexs.decompiler.flash.importers.svg.SvgLineCap;
import com.jpexs.decompiler.flash.importers.svg.SvgLineJoin;
import com.jpexs.decompiler.flash.importers.svg.SvgLinearGradient;
import com.jpexs.decompiler.flash.importers.svg.SvgPathReader;
import com.jpexs.decompiler.flash.importers.svg.SvgRadialGradient;
import com.jpexs.decompiler.flash.importers.svg.SvgStop;
import com.jpexs.decompiler.flash.importers.svg.SvgStyle;
import com.jpexs.decompiler.flash.importers.svg.SvgTransparentFill;
import com.jpexs.decompiler.flash.importers.svg.css.CssParseException;
import com.jpexs.decompiler.flash.importers.svg.css.CssParser;
import com.jpexs.decompiler.flash.importers.svg.css.CssSelectorToXPath;
import com.jpexs.decompiler.flash.tags.DefineShape4Tag;
import com.jpexs.decompiler.flash.tags.ExportAssetsTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.types.FILLSTYLE;
import com.jpexs.decompiler.flash.types.FILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.FOCALGRADIENT;
import com.jpexs.decompiler.flash.types.GRADIENT;
import com.jpexs.decompiler.flash.types.GRADRECORD;
import com.jpexs.decompiler.flash.types.LINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE2;
import com.jpexs.decompiler.flash.types.LINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.SHAPEWITHSTYLE;
import com.jpexs.decompiler.flash.types.shaperecords.CurvedEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.EndShapeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.SerializableImage;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SvgImporter {
    private final Set<String> shownWarnings = new HashSet<String>();
    ShapeTag shapeTag;
    private Rectangle2D.Double viewBox;

    public Tag importSvg(ShapeTag st, String svgXml) {
        return this.importSvg(st, svgXml, true);
    }

    public Tag importSvg(ShapeTag st, String svgXml, boolean fill) {
        this.shapeTag = st;
        SHAPEWITHSTYLE shapes = new SHAPEWITHSTYLE();
        shapes.fillStyles = new FILLSTYLEARRAY();
        shapes.lineStyles = new LINESTYLEARRAY();
        shapes.fillStyles.fillStyles = new FILLSTYLE[0];
        shapes.lineStyles.lineStyles = new LINESTYLE[0];
        int shapeNum = st.getShapeNum();
        RECT rect = st.getRect();
        int origXmin = rect.Xmin;
        int origYmin = rect.Ymin;
        shapes.shapeRecords = new ArrayList();
        Rectangle2D.Double viewBox = null;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new InputSource(new StringReader(svgXml)));
            Element rootElement = doc.getDocumentElement();
            HashMap<String, Element> idMap = new HashMap<String, Element>();
            this.populateIds(rootElement, idMap);
            if (!"svg".equals(rootElement.getTagName())) {
                throw new IOException("SVG root element should be 'svg'");
            }
            double width = 800.0;
            double height = 600.0;
            if (rootElement.hasAttribute("viewBox")) {
                String params = rootElement.getAttribute("viewBox");
                String[] args = Matrix.parseSvgNumberList(params);
                viewBox = new Rectangle2D.Double();
                if (args.length > 0) {
                    viewBox.x = this.parseNumber(args[0]);
                }
                if (args.length > 1) {
                    viewBox.y = this.parseNumber(args[1]);
                }
                if (args.length > 2) {
                    viewBox.width = this.parseNumber(args[2]);
                }
                if (args.length > 3) {
                    viewBox.height = this.parseNumber(args[3]);
                }
                width = viewBox.width;
                height = viewBox.height;
            }
            if (rootElement.hasAttribute("width")) {
                width = this.parseLength(rootElement.getAttribute("width"), width);
            }
            if (rootElement.hasAttribute("height")) {
                height = this.parseLength(rootElement.getAttribute("height"), height);
            }
            if (viewBox == null) {
                viewBox = new Rectangle2D.Double();
                viewBox.width = width;
                viewBox.height = height;
            }
            this.viewBox = viewBox;
            SvgStyle style = new SvgStyle(this, idMap, rootElement);
            Matrix transform = new Matrix();
            if (!fill) {
                rect.Xmin -= origXmin;
                rect.Xmax -= origXmin;
                rect.Ymin -= origYmin;
                rect.Ymax -= origYmin;
                rect.Xmin = (int)Math.round(viewBox.x * 20.0);
                rect.Ymin = (int)Math.round(viewBox.y * 20.0);
                rect.Xmax = (int)Math.round((viewBox.x + viewBox.width) * 20.0);
                rect.Ymax = (int)Math.round((viewBox.y + viewBox.height) * 20.0);
            } else {
                double ratioX = (double)rect.getWidth() / width / 20.0;
                double ratioY = (double)rect.getHeight() / height / 20.0;
                transform = Matrix.getScaleInstance(ratioX, ratioY);
                transform.translate((double)origXmin / 20.0 / ratioX, (double)origYmin / 20.0 / ratioY);
            }
            this.processSvgObject(idMap, shapeNum, shapes, rootElement, transform, style);
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Logger.getLogger(ShapeImporter.class.getName()).log(Level.SEVERE, null, ex);
        }
        shapes.shapeRecords.add(new EndShapeRecord());
        st.shapes = shapes;
        st.setModified(true);
        return st;
    }

    protected void populateIds(Element el, Map<String, Element> out) {
        if (el.hasAttribute("id")) {
            out.put(el.getAttribute("id"), el);
        }
        NodeList nodes = el.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (!(nodes.item(i) instanceof Element)) continue;
            this.populateIds((Element)nodes.item(i), out);
        }
    }

    private void processStyle(Element element) {
        String styleSheet = element.getTextContent().trim();
        CssParser cssParser = new CssParser(styleSheet);
        CssSelectorToXPath selectorToXPath = new CssSelectorToXPath();
        Document doc = element.getOwnerDocument();
        try {
            cssParser.styleshet();
            XPath xPath = XPathFactory.newInstance().newXPath();
            for (int i = 0; i < cssParser.getCountRulesets(); ++i) {
                String selector = cssParser.getSelector(i);
                String xPathExpression = selectorToXPath.css2xpath(selector);
                try {
                    NodeList nodeList = (NodeList)xPath.compile(xPathExpression).evaluate(doc, XPathConstants.NODESET);
                    for (int j = 0; j < nodeList.getLength(); ++j) {
                        Node node = nodeList.item(j);
                        NamedNodeMap attrs = node.getAttributes();
                        Node styleAttr = attrs.getNamedItem("ffdec-style");
                        if (styleAttr != null) {
                            styleAttr.setNodeValue(styleAttr.getNodeValue() + ";{" + cssParser.getSpecifity(i) + "}" + cssParser.getDeclarations(i));
                            attrs.setNamedItem(styleAttr);
                            continue;
                        }
                        Attr styleNode = doc.createAttribute("ffdec-style");
                        styleNode.setNodeValue("{" + cssParser.getSpecifity(i) + "}" + cssParser.getDeclarations(i));
                        attrs.setNamedItem(styleNode);
                    }
                    continue;
                }
                catch (XPathExpressionException ex) {
                    Logger.getLogger(SvgImporter.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        catch (CssParseException | IOException ex) {
            this.showWarning("CannotParseCSSStyle", "Cannot parse CSS style: " + ex.getMessage());
        }
    }

    private void processDefs(Element element) {
        for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
            Node childNode = element.getChildNodes().item(i);
            if (!(childNode instanceof Element)) continue;
            Element childElement = (Element)childNode;
            String tagName = childElement.getTagName();
            if ("style".equals(tagName)) {
                this.processStyle(childElement);
                continue;
            }
            if (!"defs".equals(tagName)) continue;
            this.processDefs(childElement);
        }
    }

    private void processSwitch(Element element, Map<String, Element> idMap, int shapeNum, SHAPEWITHSTYLE shapes, Matrix transform, SvgStyle style) {
        for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
            Element childElement;
            Node childNode = element.getChildNodes().item(i);
            if (!(childNode instanceof Element) || (childElement = (Element)childNode).hasAttribute("requiredExtensions") && !childElement.getAttribute("requiredExtensions").isEmpty()) continue;
            if (childElement.hasAttribute("systemLanguage")) {
                String systemLanguage = childElement.getAttribute("systemLanguage");
                if (!systemLanguage.equals("en-us") && !systemLanguage.equals("en")) continue;
                this.processElement(childElement, idMap, shapeNum, shapes, transform, style);
                return;
            }
            this.processElement(childElement, idMap, shapeNum, shapes, transform, style);
            return;
        }
    }

    private void processElement(Element element, Map<String, Element> idMap, int shapeNum, SHAPEWITHSTYLE shapes, Matrix transform, SvgStyle style) {
        Matrix m2;
        if (element.hasAttribute("requiredExtensions") && !element.getAttribute("requiredExtensions").isEmpty()) {
            return;
        }
        String tagName = element.getTagName();
        SvgStyle newStyle = new SvgStyle(this, idMap, element);
        Matrix m = Matrix.parseSvgMatrix(element.getAttribute("transform"), 1.0, 1.0);
        Matrix matrix = m2 = m == null ? transform : transform.concatenate(m);
        if ("switch".equals(tagName)) {
            this.processSwitch(element, idMap, shapeNum, shapes, transform, style);
        } else if ("style".equals(tagName)) {
            this.processStyle(element);
        } else if ("g".equals(tagName)) {
            this.processSvgObject(idMap, shapeNum, shapes, element, m2, newStyle);
        } else if ("path".equals(tagName)) {
            this.processPath(shapeNum, shapes, element, m2, newStyle);
        } else if ("circle".equals(tagName)) {
            this.processCircle(shapeNum, shapes, element, m2, newStyle);
        } else if ("ellipse".equals(tagName)) {
            this.processEllipse(shapeNum, shapes, element, m2, newStyle);
        } else if ("rect".equals(tagName)) {
            this.processRect(shapeNum, shapes, element, m2, newStyle);
        } else if ("line".equals(tagName)) {
            this.processLine(shapeNum, shapes, element, m2, newStyle);
        } else if ("polyline".equals(tagName)) {
            this.processPolyline(shapeNum, shapes, element, m2, newStyle);
        } else if ("polygon".equals(tagName)) {
            this.processPolygon(shapeNum, shapes, element, m2, newStyle);
        } else if ("defs".equals(tagName)) {
            this.processDefs(element);
        } else if (!("title".equals(tagName) || "desc".equals(tagName) || "radialGradient".equals(tagName) || "linearGradient".equals(tagName))) {
            this.showWarning(tagName + "tagNotSupported", "The SVG tag '" + tagName + "' is not supported.");
        }
    }

    private void processSvgObject(Map<String, Element> idMap, int shapeNum, SHAPEWITHSTYLE shapes, Element element, Matrix transform, SvgStyle style) {
        for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
            Node childNode = element.getChildNodes().item(i);
            if (!(childNode instanceof Element)) continue;
            Element childElement = (Element)childNode;
            this.processElement(childElement, idMap, shapeNum, shapes, transform, style);
        }
    }

    private void processCommands(int shapeNum, SHAPEWITHSTYLE shapes, List<PathCommand> commands, Matrix transform, SvgStyle style) {
        Point prevPoint;
        Matrix transform2 = transform.preConcatenate(Matrix.getScaleInstance(20.0));
        Point startPoint = prevPoint = new Point(0.0, 0.0);
        double x0 = 0.0;
        double y0 = 0.0;
        StyleChangeRecord scrStyle = this.getStyleChangeRecord(shapeNum, style);
        int fillStyle = scrStyle.fillStyle1;
        int lineStyle = scrStyle.lineStyle;
        scrStyle.stateFillStyle0 = true;
        scrStyle.stateFillStyle1 = true;
        scrStyle.stateLineStyle = true;
        scrStyle.fillStyle0 = 0;
        scrStyle.fillStyle1 = 0;
        scrStyle.lineStyle = 0;
        ArrayList<SHAPERECORD> newRecords = new ArrayList<SHAPERECORD>();
        newRecords.add(scrStyle);
        LINESTYLE lineStyleObj = scrStyle.lineStyles.lineStyles.length < 1 ? null : scrStyle.lineStyles.lineStyles[0];
        LINESTYLE2 lineStyle2Obj = null;
        if (lineStyleObj instanceof LINESTYLE2) {
            lineStyle2Obj = (LINESTYLE2)lineStyleObj;
            lineStyle2Obj.noClose = true;
        }
        for (PathCommand command : commands) {
            double x = x0;
            double y = y0;
            boolean isRelative = Character.isLowerCase(command.command);
            if (isRelative) {
                throw new Error("processCommands is called with relative command");
            }
            char cmd = command.command;
            switch (cmd) {
                case 'M': {
                    StyleChangeRecord scr = new StyleChangeRecord();
                    if (fillStyle != 0) {
                        scr.stateFillStyle1 = true;
                        scr.fillStyle1 = fillStyle;
                    }
                    if (lineStyle != 0) {
                        scr.lineStyle = lineStyle;
                        scr.stateLineStyle = true;
                    }
                    x = command.params[0];
                    y = command.params[1];
                    Point p = transform2.transform(x, y);
                    scr.moveDeltaX = (int)Math.round(p.x);
                    scr.moveDeltaY = (int)Math.round(p.y);
                    prevPoint = new Point(scr.moveDeltaX, scr.moveDeltaY);
                    scr.stateMoveTo = true;
                    newRecords.add(scr);
                    startPoint = prevPoint;
                    break;
                }
                case 'Z': {
                    StraightEdgeRecord serz = new StraightEdgeRecord();
                    Point p = startPoint;
                    serz.deltaX = (int)Math.round(p.x - prevPoint.x);
                    serz.deltaY = (int)Math.round(p.y - prevPoint.y);
                    prevPoint = new Point(prevPoint.x + (double)serz.deltaX, prevPoint.y + (double)serz.deltaY);
                    serz.generalLineFlag = true;
                    newRecords.add(serz);
                    if (lineStyle2Obj == null) break;
                    lineStyle2Obj.noClose = false;
                    break;
                }
                case 'L': {
                    StraightEdgeRecord serl = new StraightEdgeRecord();
                    x = command.params[0];
                    y = command.params[1];
                    Point p = transform2.transform(x, y);
                    serl.deltaX = (int)Math.round(p.x - prevPoint.x);
                    serl.deltaY = (int)Math.round(p.y - prevPoint.y);
                    prevPoint = new Point(prevPoint.x + (double)serl.deltaX, prevPoint.y + (double)serl.deltaY);
                    serl.generalLineFlag = true;
                    serl.simplify();
                    newRecords.add(serl);
                    break;
                }
                case 'H': {
                    StraightEdgeRecord serh = new StraightEdgeRecord();
                    x = command.params[0];
                    Point p = transform2.transform(x, y);
                    serh.deltaX = (int)Math.round(p.x - prevPoint.x);
                    serh.deltaY = (int)Math.round(p.y - prevPoint.y);
                    prevPoint = new Point(prevPoint.x + (double)serh.deltaX, prevPoint.y + (double)serh.deltaY);
                    serh.generalLineFlag = true;
                    serh.simplify();
                    newRecords.add(serh);
                    break;
                }
                case 'V': {
                    StraightEdgeRecord serv = new StraightEdgeRecord();
                    y = command.params[0];
                    Point p = transform2.transform(x, y);
                    serv.deltaX = (int)Math.round(p.x - prevPoint.x);
                    serv.deltaY = (int)Math.round(p.y - prevPoint.y);
                    prevPoint = new Point(prevPoint.x + (double)serv.deltaX, prevPoint.y + (double)serv.deltaY);
                    serv.generalLineFlag = true;
                    serv.simplify();
                    newRecords.add(serv);
                    break;
                }
                case 'Q': {
                    CurvedEdgeRecord cer = new CurvedEdgeRecord();
                    x = command.params[0];
                    y = command.params[1];
                    Point p = transform2.transform(x, y);
                    cer.controlDeltaX = (int)Math.round(p.x - prevPoint.x);
                    cer.controlDeltaY = (int)Math.round(p.y - prevPoint.y);
                    prevPoint = new Point(prevPoint.x + (double)cer.controlDeltaX, prevPoint.y + (double)cer.controlDeltaY);
                    x = command.params[2];
                    y = command.params[3];
                    p = transform2.transform(x, y);
                    cer.anchorDeltaX = (int)Math.round(p.x - prevPoint.x);
                    cer.anchorDeltaY = (int)Math.round(p.y - prevPoint.y);
                    prevPoint = new Point(prevPoint.x + (double)cer.anchorDeltaX, prevPoint.y + (double)cer.anchorDeltaY);
                    newRecords.add(cer);
                    break;
                }
                case 'C': {
                    this.showWarning("cubicCurvesNotSupported", "Cubic curves are not supported by Flash.");
                    Point pStart = prevPoint;
                    x = command.params[0];
                    y = command.params[1];
                    Point pControl1 = transform2.transform(x, y);
                    x = command.params[2];
                    y = command.params[3];
                    Point pControl2 = transform2.transform(x, y);
                    x = command.params[4];
                    y = command.params[5];
                    Point p = transform2.transform(x, y);
                    List<Double> quadCoordinates = new CubicToQuad().cubicToQuad(pStart.x, pStart.y, pControl1.x, pControl1.y, pControl2.x, pControl2.y, p.x, p.y, 1.0);
                    int i = 2;
                    while (i < quadCoordinates.size()) {
                        CurvedEdgeRecord cerc = new CurvedEdgeRecord();
                        p = new Point(quadCoordinates.get(i++), quadCoordinates.get(i++));
                        cerc.controlDeltaX = (int)Math.round(p.x - prevPoint.x);
                        cerc.controlDeltaY = (int)Math.round(p.y - prevPoint.y);
                        prevPoint = new Point(prevPoint.x + (double)cerc.controlDeltaX, prevPoint.y + (double)cerc.controlDeltaY);
                        p = new Point(quadCoordinates.get(i++), quadCoordinates.get(i++));
                        cerc.anchorDeltaX = (int)Math.round(p.x - prevPoint.x);
                        cerc.anchorDeltaY = (int)Math.round(p.y - prevPoint.y);
                        prevPoint = new Point(prevPoint.x + (double)cerc.anchorDeltaX, prevPoint.y + (double)cerc.anchorDeltaY);
                        newRecords.add(cerc);
                    }
                    break;
                }
                default: {
                    Logger.getLogger(ShapeImporter.class.getName()).log(Level.WARNING, "Unknown command: {0}", command);
                    return;
                }
            }
            x0 = x;
            y0 = y;
        }
        this.applyStyleGradients(SHAPERECORD.getBounds(newRecords), scrStyle, transform2, shapeNum, style);
        shapes.shapeRecords.addAll(newRecords);
    }

    private void processPath(int shapeNum, SHAPEWITHSTYLE shapes, Element childElement, Matrix transform, SvgStyle style) {
        String data = childElement.getAttribute("d");
        int command = 0;
        Point startPoint = new Point(0.0, 0.0);
        Point prevCControlPoint = null;
        Point prevQControlPoint = null;
        double x0 = 0.0;
        double y0 = 0.0;
        ArrayList<PathCommand> pathCommands = new ArrayList<PathCommand>();
        SvgPathReader pathReader = new SvgPathReader(data);
        try {
            while (pathReader.hasNext()) {
                int newCommand = pathReader.readCommand();
                if (newCommand != 0) {
                    command = newCommand;
                }
                boolean isRelative = Character.isLowerCase((char)command);
                double x = x0;
                double y = y0;
                char cmd = Character.toUpperCase((char)command);
                switch (cmd) {
                    case 'M': {
                        PathCommand scr = new PathCommand();
                        scr.command = (char)77;
                        x = pathReader.readDouble();
                        y = pathReader.readDouble();
                        if (isRelative) {
                            x += x0;
                            y += y0;
                        }
                        scr.params = new double[]{x, y};
                        pathCommands.add(scr);
                        startPoint = new Point(x, y);
                        command = isRelative ? 108 : 76;
                        break;
                    }
                    case 'Z': {
                        PathCommand serz = new PathCommand();
                        serz.command = (char)90;
                        x = startPoint.x;
                        y = startPoint.y;
                        pathCommands.add(serz);
                        break;
                    }
                    case 'L': {
                        PathCommand serl = new PathCommand();
                        serl.command = (char)76;
                        x = pathReader.readDouble();
                        y = pathReader.readDouble();
                        if (isRelative) {
                            x += x0;
                            y += y0;
                        }
                        serl.params = new double[]{x, y};
                        pathCommands.add(serl);
                        break;
                    }
                    case 'H': {
                        PathCommand serh = new PathCommand();
                        serh.command = (char)72;
                        x = pathReader.readDouble();
                        if (isRelative) {
                            x += x0;
                        }
                        serh.params = new double[]{x};
                        pathCommands.add(serh);
                        break;
                    }
                    case 'V': {
                        PathCommand serv = new PathCommand();
                        serv.command = (char)86;
                        y = pathReader.readDouble();
                        if (isRelative) {
                            y += y0;
                        }
                        serv.params = new double[]{y};
                        pathCommands.add(serv);
                        break;
                    }
                    case 'Q': 
                    case 'T': {
                        Point pControl;
                        PathCommand cer = new PathCommand();
                        cer.command = (char)81;
                        if (cmd == 'Q') {
                            x = pathReader.readDouble();
                            y = pathReader.readDouble();
                            if (isRelative) {
                                x += x0;
                                y += y0;
                            }
                            pControl = new Point(x, y);
                        } else {
                            pControl = prevQControlPoint != null ? new Point(2.0 * x0 - prevQControlPoint.x, 2.0 * y0 - prevQControlPoint.y) : new Point(x0, y0);
                        }
                        prevQControlPoint = pControl;
                        x = pathReader.readDouble();
                        y = pathReader.readDouble();
                        if (isRelative) {
                            x += x0;
                            y += y0;
                        }
                        cer.params = new double[]{pControl.x, pControl.y, x, y};
                        pathCommands.add(cer);
                        break;
                    }
                    case 'C': 
                    case 'S': {
                        Point pControl2;
                        Point pControl1;
                        this.showWarning("cubicCurvesNotSupported", "Cubic curves are not supported by Flash.");
                        if (cmd == 'C') {
                            x = pathReader.readDouble();
                            y = pathReader.readDouble();
                            if (isRelative) {
                                x += x0;
                                y += y0;
                            }
                            pControl1 = new Point(x, y);
                        } else {
                            pControl1 = prevCControlPoint != null ? new Point(2.0 * x0 - prevCControlPoint.x, 2.0 * y0 - prevCControlPoint.y) : new Point(x0, y0);
                        }
                        x = pathReader.readDouble();
                        y = pathReader.readDouble();
                        if (isRelative) {
                            x += x0;
                            y += y0;
                        }
                        prevCControlPoint = pControl2 = new Point(x, y);
                        x = pathReader.readDouble();
                        y = pathReader.readDouble();
                        if (isRelative) {
                            x += x0;
                            y += y0;
                        }
                        PathCommand cerc = new PathCommand();
                        cerc.command = (char)67;
                        cerc.params = new double[]{pControl1.x, pControl1.y, pControl2.x, pControl2.y, x, y};
                        pathCommands.add(cerc);
                        break;
                    }
                    case 'A': {
                        PathCommand sera;
                        double y1Comma;
                        double rx = pathReader.readDouble();
                        double ry = pathReader.readDouble();
                        double fi = pathReader.readDouble() * Math.PI / 180.0;
                        boolean largeFlag = (int)pathReader.readDouble() != 0;
                        boolean sweepFlag = (int)pathReader.readDouble() != 0;
                        x = pathReader.readDouble();
                        y = pathReader.readDouble();
                        if (isRelative) {
                            x += x0;
                            y += y0;
                        }
                        if (rx == 0.0 || ry == 0.0) {
                            PathCommand sera2 = new PathCommand();
                            sera2.command = (char)76;
                            sera2.params = new double[]{x, y};
                            pathCommands.add(sera2);
                            break;
                        }
                        rx = Math.abs(rx);
                        ry = Math.abs(ry);
                        double x1 = x0;
                        double y1 = y0;
                        double x2 = x;
                        double y2 = y;
                        double d1 = (x1 - x2) / 2.0;
                        double d2 = (y1 - y2) / 2.0;
                        double x1Comma = Math.cos(fi) * d1 + Math.sin(fi) * d2;
                        double lambda = x1Comma * x1Comma / (rx * rx) + (y1Comma = -Math.sin(fi) * d1 + Math.cos(fi) * d2) * y1Comma / (ry * ry);
                        if (lambda > 1.0) {
                            double sqrtLambda = Math.sqrt(lambda);
                            rx = sqrtLambda * rx;
                            ry = sqrtLambda * ry;
                        }
                        double c = Math.sqrt((rx * rx * ry * ry - rx * rx * y1Comma * y1Comma - ry * ry * x1Comma * x1Comma) / (rx * rx * y1Comma * y1Comma + ry * ry * x1Comma * x1Comma));
                        double cxComma = c * rx * y1Comma / ry;
                        double cyComma = c * -ry * x1Comma / rx;
                        if (largeFlag == sweepFlag) {
                            cxComma = -cxComma;
                            cyComma = -cyComma;
                        }
                        double cx = Math.cos(fi) * cxComma - Math.sin(fi) * cyComma + (x1 + x2) / 2.0;
                        double cy = Math.sin(fi) * cxComma + Math.cos(fi) * cyComma + (y1 + y2) / 2.0;
                        double px1 = (x1Comma - cxComma) / rx;
                        double py1 = (y1Comma - cyComma) / ry;
                        double theta1 = this.calcAngle(1.0, 0.0, px1, py1);
                        double px2 = (-x1Comma - cxComma) / rx;
                        double py2 = (-y1Comma - cyComma) / ry;
                        double deltaTheta = this.calcAngle(px1, py1, px2, py2);
                        if (sweepFlag) {
                            if (deltaTheta < 0.0) {
                                deltaTheta += Math.PI * 2;
                            }
                        } else if (deltaTheta > 0.0) {
                            deltaTheta -= Math.PI * 2;
                        }
                        double rcp = Math.sqrt(4.0 - 2.0 * Math.sqrt(2.0));
                        double delta = Math.signum(deltaTheta) * Math.PI / 4.0;
                        int segmentCount = (int)Math.ceil(deltaTheta / delta);
                        double theta = theta1;
                        for (int i = 0; i < segmentCount - 1; ++i) {
                            sera = new PathCommand();
                            sera.command = (char)81;
                            double x12 = Math.cos(theta += delta) * rx;
                            double y12 = Math.sin(theta) * ry;
                            x1Comma = Math.cos(fi) * x12 - Math.sin(fi) * y12;
                            y1Comma = Math.sin(fi) * x12 + Math.cos(fi) * y12;
                            double theta2 = theta - delta / 2.0;
                            x12 = Math.cos(theta2) * rx * rcp;
                            y12 = Math.sin(theta2) * ry * rcp;
                            double x1Comma2 = Math.cos(fi) * x12 - Math.sin(fi) * y12;
                            double y1Comma2 = Math.sin(fi) * x12 + Math.cos(fi) * y12;
                            sera.params = new double[]{cx + x1Comma2, cy + y1Comma2, cx + x1Comma, cy + y1Comma};
                            pathCommands.add(sera);
                        }
                        sera = new PathCommand();
                        sera.command = (char)81;
                        double diff = theta1 + deltaTheta - (theta += delta);
                        diff = -delta - diff;
                        theta = theta - delta - diff / 2.0;
                        double rcpm = 1.0 + (rcp - 1.0) * (diff / delta) * (diff / delta);
                        double x12 = Math.cos(theta) * rx * rcpm;
                        double y12 = Math.sin(theta) * ry * rcpm;
                        x1Comma = Math.cos(fi) * x12 - Math.sin(fi) * y12;
                        y1Comma = Math.sin(fi) * x12 + Math.cos(fi) * y12;
                        sera.params = new double[]{cx + x1Comma, cy + y1Comma, x, y};
                        pathCommands.add(sera);
                        break;
                    }
                    default: {
                        Logger.getLogger(ShapeImporter.class.getName()).log(Level.WARNING, "Unknown command: {0}", Character.valueOf((char)command));
                        return;
                    }
                }
                if (cmd != 'C' && cmd != 'S') {
                    prevCControlPoint = null;
                }
                if (cmd != 'Q' && cmd != 'T') {
                    prevQControlPoint = null;
                }
                x0 = x;
                y0 = y;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.processCommands(shapeNum, shapes, pathCommands, transform, style);
    }

    private double calcAngle(double ux, double uy, double vx, double vy) {
        double lu = Math.sqrt(ux * ux + uy * uy);
        double lv = Math.sqrt(ux * ux + uy * uy);
        double sign = Math.signum(ux * vy - uy * vx);
        if (sign == 0.0) {
            sign = 1.0;
        }
        return sign * Math.acos(ux * vx + uy * vy / (lu * lv));
    }

    private void processCircle(int shapeNum, SHAPEWITHSTYLE shapes, Element childElement, Matrix transform, SvgStyle style) {
        String attr = childElement.getAttribute("cx");
        double cx = attr.length() > 0 ? this.parseCoordinate(attr, this.viewBox.width) : 0.0;
        attr = childElement.getAttribute("cy");
        double cy = attr.length() > 0 ? this.parseCoordinate(attr, this.viewBox.height) : 0.0;
        attr = childElement.getAttribute("r");
        double r = attr.length() > 0 ? this.parseLength(attr, (this.viewBox.width + this.viewBox.height) / 2.0) : 0.0;
        this.processEllipse(shapeNum, shapes, transform, style, cx, cy, r, r);
    }

    private void processEllipse(int shapeNum, SHAPEWITHSTYLE shapes, Element childElement, Matrix transform, SvgStyle style) {
        String attr = childElement.getAttribute("cx");
        double cx = attr.length() > 0 ? this.parseCoordinate(attr, this.viewBox.width) : 0.0;
        attr = childElement.getAttribute("cy");
        double cy = attr.length() > 0 ? this.parseCoordinate(attr, this.viewBox.height) : 0.0;
        attr = childElement.getAttribute("rx");
        double rx = attr.length() > 0 ? this.parseLength(attr, this.viewBox.width) : 0.0;
        attr = childElement.getAttribute("ry");
        double ry = attr.length() > 0 ? this.parseLength(attr, this.viewBox.height) : 0.0;
        this.processEllipse(shapeNum, shapes, transform, style, cx, cy, rx, ry);
    }

    private void processEllipse(int shapeNum, SHAPEWITHSTYLE shapes, Matrix transform, SvgStyle style, double cx, double cy, double rx, double ry) {
        double sqrt2RXHalf = Math.sqrt(2.0) * rx / 2.0;
        double sqrt2Minus1RX = (Math.sqrt(2.0) - 1.0) * rx;
        double sqrt2RYHalf = Math.sqrt(2.0) * ry / 2.0;
        double sqrt2Minus1RY = (Math.sqrt(2.0) - 1.0) * ry;
        ArrayList<PathCommand> pathCommands = new ArrayList<PathCommand>();
        PathCommand scr = new PathCommand();
        scr.command = (char)77;
        scr.params = new double[]{cx + rx, cy};
        pathCommands.add(scr);
        double[] points = new double[]{rx, -sqrt2Minus1RY, sqrt2RXHalf, -sqrt2RYHalf, sqrt2Minus1RX, -ry, 0.0, -ry, -sqrt2Minus1RX, -ry, -sqrt2RXHalf, -sqrt2RYHalf, -rx, -sqrt2Minus1RY, -rx, 0.0, -rx, sqrt2Minus1RY, -sqrt2RXHalf, sqrt2RYHalf, -sqrt2Minus1RX, ry, 0.0, ry, sqrt2Minus1RX, ry, sqrt2RXHalf, sqrt2RYHalf, rx, sqrt2Minus1RY, rx, 0.0};
        for (int i = 0; i < points.length; i += 4) {
            PathCommand cer = new PathCommand();
            cer.command = (char)81;
            cer.params = new double[]{cx + points[i], cy + points[i + 1], cx + points[i + 2], cy + points[i + 3]};
            pathCommands.add(cer);
        }
        PathCommand serz = new PathCommand();
        serz.command = (char)90;
        pathCommands.add(serz);
        this.processCommands(shapeNum, shapes, pathCommands, transform, style);
    }

    private void processRect(int shapeNum, SHAPEWITHSTYLE shapes, Element childElement, Matrix transform, SvgStyle style) {
        PathCommand scr;
        double ry;
        String attr = childElement.getAttribute("x");
        double x = attr.length() > 0 ? this.parseCoordinate(attr, this.viewBox.width) : 0.0;
        attr = childElement.getAttribute("y");
        double y = attr.length() > 0 ? this.parseCoordinate(attr, this.viewBox.height) : 0.0;
        attr = childElement.getAttribute("width");
        double width = attr.length() > 0 ? this.parseLength(attr, this.viewBox.width) : 0.0;
        attr = childElement.getAttribute("height");
        double height = attr.length() > 0 ? this.parseLength(attr, this.viewBox.height) : 0.0;
        attr = childElement.getAttribute("rx");
        double rx = attr.length() > 0 ? this.parseLength(attr, this.viewBox.width) : 0.0;
        attr = childElement.getAttribute("ry");
        double d = ry = attr.length() > 0 ? this.parseLength(attr, this.viewBox.height) : 0.0;
        if (rx == 0.0 && ry != 0.0) {
            rx = ry;
        } else if (rx != 0.0 && ry == 0.0) {
            ry = rx;
        }
        if (rx > width / 2.0) {
            rx = width / 2.0;
        }
        if (ry > height / 2.0) {
            ry = height / 2.0;
        }
        ArrayList<PathCommand> pathCommands = new ArrayList<PathCommand>();
        if (rx > 0.0 || ry > 0.0) {
            scr = new PathCommand();
            scr.command = (char)77;
            scr.params = new double[]{x + width, y + ry};
            pathCommands.add(scr);
            double sqrt2RXHalf = Math.sqrt(2.0) * rx / 2.0;
            double sqrt2Minus1RX = (Math.sqrt(2.0) - 1.0) * rx;
            double sqrt2RYHalf = Math.sqrt(2.0) * ry / 2.0;
            double sqrt2Minus1RY = (Math.sqrt(2.0) - 1.0) * ry;
            double[] points = new double[]{x + width, y + ry - sqrt2Minus1RY, x + width - rx + sqrt2RXHalf, y + ry - sqrt2RYHalf, x + width - rx + sqrt2Minus1RX, y, x + width - rx, y, x + rx, y, x + rx - sqrt2Minus1RX, y, x + rx - sqrt2RXHalf, y + ry - sqrt2RYHalf, x, y + ry - sqrt2Minus1RY, x, y + ry, x, y + height - ry, x, y + height - ry + sqrt2Minus1RY, x + rx - sqrt2RXHalf, y + height - ry + sqrt2RYHalf, x + rx - sqrt2Minus1RX, y + height, x + rx, y + height, x + width - rx, y + height, x + width - rx + sqrt2Minus1RX, y + height, x + width - rx + sqrt2RXHalf, y + height - ry + sqrt2RYHalf, x + width, y + height - ry + sqrt2Minus1RY, x + width, y + height - ry, x + width, y + ry};
            int i = 0;
            while (i < points.length) {
                PathCommand cer;
                if (i % 10 == 8) {
                    cer = new PathCommand();
                    cer.command = (char)76;
                    cer.params = new double[]{points[i], points[i + 1]};
                    pathCommands.add(cer);
                    i += 2;
                    continue;
                }
                cer = new PathCommand();
                cer.command = (char)81;
                cer.params = new double[]{points[i], points[i + 1], points[i + 2], points[i + 3]};
                pathCommands.add(cer);
                i += 4;
            }
        } else {
            scr = new PathCommand();
            scr.command = (char)77;
            scr.params = new double[]{x, y};
            pathCommands.add(scr);
            double[] points = new double[]{x + width, y, x + width, y + height, x, y + height, x, y};
            for (int i = 0; i < points.length; i += 2) {
                PathCommand cer = new PathCommand();
                cer.command = (char)76;
                cer.params = new double[]{points[i], points[i + 1]};
                pathCommands.add(cer);
            }
        }
        PathCommand serz = new PathCommand();
        serz.command = (char)90;
        pathCommands.add(serz);
        this.processCommands(shapeNum, shapes, pathCommands, transform, style);
    }

    private void processLine(int shapeNum, SHAPEWITHSTYLE shapes, Element childElement, Matrix transform, SvgStyle style) {
        String attr = childElement.getAttribute("x1");
        double x1 = attr.length() > 0 ? this.parseCoordinate(attr, this.viewBox.width) : 0.0;
        attr = childElement.getAttribute("y1");
        double y1 = attr.length() > 0 ? this.parseCoordinate(attr, this.viewBox.height) : 0.0;
        attr = childElement.getAttribute("x2");
        double x2 = attr.length() > 0 ? this.parseCoordinate(attr, this.viewBox.width) : 0.0;
        attr = childElement.getAttribute("y2");
        double y2 = attr.length() > 0 ? this.parseCoordinate(attr, this.viewBox.height) : 0.0;
        ArrayList<PathCommand> pathCommands = new ArrayList<PathCommand>();
        PathCommand scr = new PathCommand();
        scr.command = (char)77;
        scr.params = new double[]{x1, y1};
        pathCommands.add(scr);
        PathCommand cer = new PathCommand();
        cer.command = (char)76;
        cer.params = new double[]{x2, y2};
        pathCommands.add(cer);
        this.processCommands(shapeNum, shapes, pathCommands, transform, style);
    }

    private void processPolyline(int shapeNum, SHAPEWITHSTYLE shapes, Element childElement, Matrix transform, SvgStyle style) {
        this.processPolyline(shapeNum, shapes, childElement, transform, style, false);
    }

    private void processPolygon(int shapeNum, SHAPEWITHSTYLE shapes, Element childElement, Matrix transform, SvgStyle style) {
        this.processPolyline(shapeNum, shapes, childElement, transform, style, true);
    }

    private void processPolyline(int shapeNum, SHAPEWITHSTYLE shapes, Element childElement, Matrix transform, SvgStyle style, boolean close) {
        String data = childElement.getAttribute("points");
        int command = 77;
        double x0 = 0.0;
        double y0 = 0.0;
        ArrayList<PathCommand> pathCommands = new ArrayList<PathCommand>();
        SvgPathReader pathReader = new SvgPathReader(data);
        try {
            while (pathReader.hasNext()) {
                double x = x0;
                double y = y0;
                Object p = null;
                switch (command) {
                    case 77: {
                        PathCommand scr = new PathCommand();
                        scr.command = (char)77;
                        x = pathReader.readDouble();
                        y = pathReader.readDouble();
                        scr.params = new double[]{x, y};
                        pathCommands.add(scr);
                        break;
                    }
                    case 76: {
                        PathCommand serl = new PathCommand();
                        serl.command = (char)76;
                        x = pathReader.readDouble();
                        y = pathReader.readDouble();
                        serl.params = new double[]{x, y};
                        pathCommands.add(serl);
                    }
                }
                x0 = x;
                y0 = y;
                command = 76;
            }
        }
        catch (NumberFormatException x) {
            // empty catch block
        }
        if (close) {
            PathCommand serz = new PathCommand();
            serz.command = (char)90;
            pathCommands.add(serz);
        }
        this.processCommands(shapeNum, shapes, pathCommands, transform, style);
    }

    private static void svgTest(String name) throws IOException, InterruptedException {
        System.err.println("running test " + name);
        if (!new File(name + ".original.svg").exists()) {
            URL svgUrl = new URL("http://www.w3.org/Graphics/SVG/Test/20061213/svggen/" + name + ".svg");
            byte[] svgData = Helper.readStream(svgUrl.openStream());
            Helper.writeFile(name + ".orig.svg", new byte[][]{svgData});
            URL pngUrl = new URL("http://www.w3.org/Graphics/SVG/Test/20061213/png/full-" + name + ".png");
            byte[] pngData = Helper.readStream(pngUrl.openStream());
            Helper.writeFile(name + ".orig.png", new byte[][]{pngData});
        }
        String svgDataS = Helper.readTextFile(name + ".orig.svg");
        SWF swf = new SWF();
        DefineShape4Tag st = new DefineShape4Tag(swf);
        st = (DefineShape4Tag)new SvgImporter().importSvg(st, svgDataS, false);
        swf.addTag(st);
        SerializableImage si = new SerializableImage(480, 360, 6);
        BitmapExporter.export(swf, st.shapes, Color.yellow, si, new Matrix(), new Matrix(), null, true);
        ArrayList<Tag> li = new ArrayList<Tag>();
        li.add(st);
        ImageIO.write((RenderedImage)si.getBufferedImage(), "PNG", new File(name + ".imported.png"));
        ExportAssetsTag eat = new ExportAssetsTag(swf);
        eat.tags.add(st.getCharacterId());
        eat.names.add(name);
        swf.addTag(eat);
        swf.assignExportNamesToSymbols();
        st.shapeBounds.Xmax = (int)((double)si.getWidth() * 20.0);
        st.shapeBounds.Ymax = (int)((double)si.getHeight() * 20.0);
        new ShapeExporter().exportShapes(null, "./outex/", swf, new ReadOnlyTagList(li), new ShapeExportSettings(ShapeExportMode.SVG, 1.0), null, 1.0);
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        SvgImporter.svgTest("color-prof-01-f");
        SvgImporter.svgTest("color-prop-01-b");
        SvgImporter.svgTest("color-prop-02-f");
        SvgImporter.svgTest("color-prop-03-t");
        SvgImporter.svgTest("coords-coord-01-t");
        SvgImporter.svgTest("coords-coord-02-t");
        SvgImporter.svgTest("coords-trans-01-b");
        SvgImporter.svgTest("coords-trans-02-t");
        SvgImporter.svgTest("coords-trans-03-t");
        SvgImporter.svgTest("coords-trans-04-t");
        SvgImporter.svgTest("coords-trans-05-t");
        SvgImporter.svgTest("coords-trans-06-t");
        SvgImporter.svgTest("coords-units-01-b");
        SvgImporter.svgTest("coords-units-02-b");
        SvgImporter.svgTest("coords-units-03-b");
        SvgImporter.svgTest("coords-viewattr-01-b");
        SvgImporter.svgTest("coords-viewattr-02-b");
        SvgImporter.svgTest("coords-viewattr-03-b");
        SvgImporter.svgTest("extend-namespace-01-f");
        SvgImporter.svgTest("painting-fill-01-t");
        SvgImporter.svgTest("painting-fill-02-t");
        SvgImporter.svgTest("painting-fill-03-t");
        SvgImporter.svgTest("painting-fill-04-t");
        SvgImporter.svgTest("painting-fill-05-b");
        SvgImporter.svgTest("painting-marker-01-f");
        SvgImporter.svgTest("painting-marker-02-f");
        SvgImporter.svgTest("painting-marker-03-f");
        SvgImporter.svgTest("painting-render-01-b");
        SvgImporter.svgTest("painting-stroke-01-t");
        SvgImporter.svgTest("painting-stroke-02-t");
        SvgImporter.svgTest("painting-stroke-03-t");
        SvgImporter.svgTest("painting-stroke-04-t");
        SvgImporter.svgTest("painting-stroke-07-t");
        SvgImporter.svgTest("paths-data-01-t");
        SvgImporter.svgTest("paths-data-02-t");
        SvgImporter.svgTest("paths-data-03-f");
        SvgImporter.svgTest("paths-data-04-t");
        SvgImporter.svgTest("paths-data-05-t");
        SvgImporter.svgTest("paths-data-06-t");
        SvgImporter.svgTest("paths-data-07-t");
        SvgImporter.svgTest("paths-data-08-t");
        SvgImporter.svgTest("paths-data-09-t");
        SvgImporter.svgTest("paths-data-10-t");
        SvgImporter.svgTest("paths-data-12-t");
        SvgImporter.svgTest("paths-data-13-t");
        SvgImporter.svgTest("paths-data-14-t");
        SvgImporter.svgTest("paths-data-15-t");
        SvgImporter.svgTest("pservers-grad-01-b");
        SvgImporter.svgTest("pservers-grad-02-b");
        SvgImporter.svgTest("pservers-grad-03-b");
        SvgImporter.svgTest("pservers-grad-04-b");
        SvgImporter.svgTest("pservers-grad-05-b");
        SvgImporter.svgTest("pservers-grad-06-b");
        SvgImporter.svgTest("pservers-grad-07-b");
        SvgImporter.svgTest("pservers-grad-08-b");
        SvgImporter.svgTest("pservers-grad-09-b");
        SvgImporter.svgTest("pservers-grad-10-b");
        SvgImporter.svgTest("pservers-grad-11-b");
        SvgImporter.svgTest("pservers-grad-12-b");
        SvgImporter.svgTest("pservers-grad-13-b");
        SvgImporter.svgTest("pservers-grad-14-b");
        SvgImporter.svgTest("pservers-grad-15-b");
        SvgImporter.svgTest("pservers-grad-16-b");
        SvgImporter.svgTest("pservers-grad-17-b");
        SvgImporter.svgTest("pservers-grad-18-b");
        SvgImporter.svgTest("pservers-grad-19-b");
        SvgImporter.svgTest("pservers-pattern-01-b");
        SvgImporter.svgTest("render-elems-01-t");
        SvgImporter.svgTest("render-elems-02-t");
        SvgImporter.svgTest("render-elems-03-t");
        SvgImporter.svgTest("render-elems-06-t");
        SvgImporter.svgTest("render-elems-07-t");
        SvgImporter.svgTest("render-elems-08-t");
        SvgImporter.svgTest("render-groups-01-b");
        SvgImporter.svgTest("render-groups-03-t");
        SvgImporter.svgTest("shapes-circle-01-t");
        SvgImporter.svgTest("shapes-circle-02-t");
        SvgImporter.svgTest("shapes-ellipse-01-t");
        SvgImporter.svgTest("shapes-ellipse-02-t");
        SvgImporter.svgTest("shapes-intro-01-t");
        SvgImporter.svgTest("shapes-line-01-t");
        SvgImporter.svgTest("shapes-polygon-01-t");
        SvgImporter.svgTest("shapes-polyline-01-t");
        SvgImporter.svgTest("shapes-rect-01-t");
        SvgImporter.svgTest("shapes-rect-02-t");
        SvgImporter.svgTest("styling-css-01-b");
        SvgImporter.svgTest("styling-css-02-b");
        SvgImporter.svgTest("styling-css-03-b");
        SvgImporter.svgTest("styling-css-04-f");
        SvgImporter.svgTest("styling-inherit-01-b");
    }

    private void applyFillGradients(SvgFill fill, FILLSTYLE fillStyle, RECT bounds, StyleChangeRecord scr, Matrix transform, int shapeNum, SvgStyle style) {
        if (fill == null || fillStyle == null) {
            return;
        }
        if (fill instanceof SvgGradient) {
            SvgGradient gfill = (SvgGradient)fill;
            Matrix gradientMatrix = Matrix.parseSvgMatrix(gfill.gradientTransform, 20.0, 1.0);
            gradientMatrix = transform.concatenate(Matrix.getScaleInstance(0.05)).concatenate(gradientMatrix);
            fillStyle.gradientMatrix = gradientMatrix.toMATRIX();
            if (fill instanceof SvgLinearGradient) {
                SvgLinearGradient lgfill = (SvgLinearGradient)fill;
                fillStyle.fillStyleType = 16;
                fillStyle.gradient = new GRADIENT();
                double x1 = this.parseCoordinate(lgfill.x1, 1.0);
                double y1 = this.parseCoordinate(lgfill.y1, 1.0);
                double x2 = this.parseCoordinate(lgfill.x2, 1.0);
                double y2 = this.parseCoordinate(lgfill.y2, 1.0);
                Matrix xyMatrix = new Matrix();
                xyMatrix.scaleX = (x2 - x1) * 20.0;
                xyMatrix.rotateSkew0 = (y2 - y1) * 20.0;
                xyMatrix.rotateSkew1 = -xyMatrix.rotateSkew0;
                xyMatrix.scaleY = xyMatrix.scaleX;
                Matrix gmatrix = new Matrix();
                if (lgfill.gradientUnits == SvgGradientUnits.OBJECT_BOUNDING_BOX) {
                    gmatrix.scaleX = (double)(bounds.Xmax - bounds.Xmin) / 20.0;
                    gmatrix.rotateSkew0 = 0.0;
                    gmatrix.rotateSkew1 = 0.0;
                    gmatrix.scaleY = (double)(bounds.Ymax - bounds.Ymin) / 20.0;
                    gmatrix.translateX = bounds.Xmin;
                    gmatrix.translateY = bounds.Ymin;
                    x1 *= (double)bounds.getWidth();
                    y1 *= (double)bounds.getHeight();
                } else {
                    gmatrix = new Matrix(fillStyle.gradientMatrix);
                    x1 *= 20.0;
                    y1 *= 20.0;
                }
                Matrix zeroStartMatrix = Matrix.getTranslateInstance(0.5, 0.0);
                Matrix scaleMatrix = Matrix.getScaleInstance(3.0517578125E-5);
                Matrix transMatrix = Matrix.getTranslateInstance(x1, y1);
                Matrix tMatrix = new Matrix();
                tMatrix = tMatrix.concatenate(transMatrix).concatenate(gmatrix).concatenate(xyMatrix).concatenate(zeroStartMatrix).concatenate(scaleMatrix);
                fillStyle.gradientMatrix = tMatrix.toMATRIX();
            } else if (fill instanceof SvgRadialGradient) {
                Matrix gmatrix;
                SvgRadialGradient rgfill = (SvgRadialGradient)fill;
                double cx = this.parseCoordinate(rgfill.cx, 1.0);
                double cy = this.parseCoordinate(rgfill.cy, 1.0);
                double r = this.parseLength(rgfill.r, 1.0);
                if (rgfill.gradientUnits == SvgGradientUnits.OBJECT_BOUNDING_BOX) {
                    gmatrix = new Matrix();
                    gmatrix.scaleX = (double)(bounds.Xmax - bounds.Xmin) / 20.0;
                    gmatrix.rotateSkew0 = 0.0;
                    gmatrix.rotateSkew1 = 0.0;
                    gmatrix.scaleY = 0.05;
                    gmatrix.scaleY = (double)(bounds.Ymax - bounds.Ymin) / 20.0;
                    gmatrix.translateX = bounds.Xmin;
                    gmatrix.translateY = bounds.Ymin;
                } else {
                    gmatrix = new Matrix(fillStyle.gradientMatrix);
                }
                gmatrix.translate(20.0 * cx, 20.0 * cy);
                gmatrix = gmatrix.concatenate(Matrix.getScaleInstance(r / 819.2));
                fillStyle.gradientMatrix = gmatrix.toMATRIX();
                double fx = this.parseCoordinate(rgfill.fx, 1.0);
                double fy = this.parseCoordinate(rgfill.fy, 1.0);
                if (!rgfill.fx.equals(rgfill.cx) || !rgfill.fy.equals(rgfill.cy)) {
                    fillStyle.fillStyleType = 19;
                    fillStyle.gradient = new FOCALGRADIENT();
                    FOCALGRADIENT fg = (FOCALGRADIENT)fillStyle.gradient;
                    double f = Math.sqrt((fx - cx) * (fx - cx) + (fy - cy) * (fy - cy)) / 819.2;
                    fg.focalPoint = (float)f;
                } else {
                    fillStyle.fillStyleType = 18;
                    fillStyle.gradient = new GRADIENT();
                }
            }
            switch (gfill.spreadMethod) {
                case PAD: {
                    fillStyle.gradient.spreadMode = 0;
                    break;
                }
                case REFLECT: {
                    fillStyle.gradient.spreadMode = 1;
                    break;
                }
                case REPEAT: {
                    fillStyle.gradient.spreadMode = 2;
                }
            }
            switch (gfill.interpolation) {
                case LINEAR_RGB: {
                    fillStyle.gradient.interpolationMode = 1;
                    break;
                }
                case SRGB: {
                    fillStyle.gradient.interpolationMode = 0;
                }
            }
            fillStyle.gradient.gradientRecords = new GRADRECORD[gfill.stops.size()];
            int prevRatio = -1;
            for (int i = 0; i < gfill.stops.size(); ++i) {
                int ratio;
                SvgStop stop = gfill.stops.get(i);
                Color color = stop.color;
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)Math.round((double)color.getAlpha() * style.getOpacity()));
                fillStyle.gradient.gradientRecords[i] = new GRADRECORD();
                fillStyle.gradient.gradientRecords[i].inShape3 = shapeNum >= 3;
                fillStyle.gradient.gradientRecords[i].color = this.getRGB(shapeNum, color);
                fillStyle.gradient.gradientRecords[i].ratio = ratio = Math.max((int)Math.round(stop.offset * 255.0), prevRatio + 1);
                prevRatio = ratio;
                if (prevRatio != 255) {
                    continue;
                }
                break;
            }
        } else if (fill instanceof SvgBitmapFill) {
            SvgBitmapFill bfill = (SvgBitmapFill)fill;
            fillStyle.fillStyleType = 64;
            fillStyle.bitmapId = bfill.characterId;
            Matrix fillMatrix = Matrix.parseSvgMatrix(bfill.patternTransform, 20.0, 20.0);
            fillMatrix = transform.concatenate(Matrix.getScaleInstance(0.05)).concatenate(fillMatrix);
            fillStyle.bitmapMatrix = fillMatrix.toMATRIX();
        }
    }

    private void applyStyleGradients(RECT bounds, StyleChangeRecord scr, Matrix transform, int shapeNum, SvgStyle style) {
        SvgFill strokeFill;
        SvgFill fill = style.getFillWithOpacity();
        if (fill != null && fill != SvgTransparentFill.INSTANCE) {
            this.applyFillGradients(fill, scr.fillStyles.fillStyles[0], bounds, scr, transform, shapeNum, style);
        }
        if ((strokeFill = style.getStrokeFillWithOpacity()) != null && scr.lineStyles.lineStyles.length > 0 && scr.lineStyles.lineStyles[0] instanceof LINESTYLE2) {
            this.applyFillGradients(strokeFill, ((LINESTYLE2)scr.lineStyles.lineStyles[0]).fillType, bounds, scr, transform, shapeNum, style);
        }
    }

    private StyleChangeRecord getStyleChangeRecord(int shapeNum, SvgStyle style) {
        StyleChangeRecord scr = new StyleChangeRecord();
        scr.stateNewStyles = true;
        scr.fillStyles = new FILLSTYLEARRAY();
        scr.stateFillStyle1 = true;
        scr.stateLineStyle = true;
        SvgFill fill = style.getFillWithOpacity();
        if (fill != null && fill != SvgTransparentFill.INSTANCE) {
            scr.fillStyles.fillStyles = new FILLSTYLE[1];
            scr.fillStyles.fillStyles[0] = new FILLSTYLE();
            if (fill instanceof SvgColor) {
                Color colorFill = fill.toColor();
                scr.fillStyles.fillStyles[0].color = this.getRGB(shapeNum, colorFill);
                scr.fillStyles.fillStyles[0].fillStyleType = 0;
            } else if (fill instanceof SvgGradient) {
                // empty if block
            }
            scr.fillStyle1 = 1;
        } else {
            scr.fillStyles.fillStyles = new FILLSTYLE[0];
            scr.fillStyle1 = 0;
        }
        scr.lineStyles = new LINESTYLEARRAY();
        SvgFill strokeFill = style.getStrokeFillWithOpacity();
        if (strokeFill != null && strokeFill != SvgTransparentFill.INSTANCE) {
            Color lineColor = strokeFill.toColor();
            scr.lineStyles.lineStyles = new LINESTYLE[1];
            LINESTYLE lineStyle = shapeNum <= 3 ? new LINESTYLE() : new LINESTYLE2();
            lineStyle.color = this.getRGB(shapeNum, lineColor);
            lineStyle.width = (int)Math.round(style.getStrokeWidth() * 20.0);
            SvgLineCap lineCap = style.getStrokeLineCap();
            SvgLineJoin lineJoin = style.getStrokeLineJoin();
            if (lineStyle instanceof LINESTYLE2) {
                int swfJoin;
                int swfCap;
                LINESTYLE2 lineStyle2 = (LINESTYLE2)lineStyle;
                lineStyle2.startCapStyle = swfCap = lineCap == SvgLineCap.BUTT ? 1 : (lineCap == SvgLineCap.ROUND ? 0 : (lineCap == SvgLineCap.SQUARE ? 2 : 0));
                lineStyle2.endCapStyle = swfCap;
                if (!(strokeFill instanceof SvgColor)) {
                    lineStyle2.hasFillFlag = true;
                    lineStyle2.fillType = new FILLSTYLE();
                }
                lineStyle2.joinStyle = swfJoin = lineJoin == SvgLineJoin.MITER ? 2 : (lineJoin == SvgLineJoin.ROUND ? 0 : (lineJoin == SvgLineJoin.BEVEL ? 1 : 0));
                lineStyle2.miterLimitFactor = (float)style.getStrokeMiterLimit();
            } else {
                if (lineCap != SvgLineCap.ROUND) {
                    this.showWarning("lineCapNotSupported", "LineCap style not supported in shape " + shapeNum);
                }
                if (lineJoin != SvgLineJoin.ROUND) {
                    this.showWarning("lineJoinNotSupported", "LineJoin style not supported in shape " + shapeNum);
                }
            }
            scr.lineStyles.lineStyles[0] = lineStyle;
            scr.lineStyle = 1;
        } else {
            scr.lineStyles.lineStyles = new LINESTYLE[0];
            scr.lineStyle = 0;
        }
        return scr;
    }

    private RGB getRGB(int shapeNum, Color color) {
        if (shapeNum < 3 && color.getAlpha() != 255) {
            this.showWarning("transparentColorNotSupported", "Transparent color is not supported in shape " + shapeNum);
        }
        return shapeNum >= 3 ? new RGBA(color) : new RGB(color);
    }

    private double parseCoordinate(String value, double relativeTo) {
        return this.parseLength(value, relativeTo);
    }

    private double parseLength(String value, double relativeTo) {
        if (value == null) {
            throw new NumberFormatException();
        }
        value = value.toLowerCase();
        String unit = null;
        if (value.endsWith("em") || value.endsWith("ex") || value.endsWith("px") || value.endsWith("in") || value.endsWith("cm") || value.endsWith("mm") || value.endsWith("pt") || value.endsWith("pc")) {
            unit = value.substring(value.length() - 2);
            value = value.substring(0, value.length() - 2);
        } else if (value.endsWith("%")) {
            unit = "%";
            value = value.substring(0, value.length() - 1);
        }
        double result = Double.parseDouble(value);
        if (unit != null) {
            switch (unit) {
                case "em": 
                case "ex": {
                    break;
                }
                case "in": {
                    result *= this.getDpi();
                    break;
                }
                case "pt": {
                    result *= this.getDpi() / 72.0;
                    break;
                }
                case "pc": {
                    result *= this.getDpi() / 6.0;
                    break;
                }
                case "cm": {
                    result *= this.getDpi() / 2.54;
                    break;
                }
                case "mm": {
                    result *= this.getDpi() / 25.4;
                    break;
                }
                case "%": {
                    result = relativeTo * result / 100.0;
                }
            }
        }
        return result;
    }

    public double parseNumber(String value) {
        if (value == null) {
            throw new NumberFormatException();
        }
        double result = Double.parseDouble(value);
        return result;
    }

    public double parseNumberOrPercent(String value) {
        if (value == null) {
            throw new NumberFormatException();
        }
        boolean percent = value.endsWith("%");
        if (percent) {
            value = value.substring(0, value.length() - 1);
        }
        double result = Double.parseDouble(value);
        if (percent) {
            result /= 100.0;
        }
        return result;
    }

    private double getDpi() {
        return 96.0;
    }

    void showWarning(String name, String text) {
        if (!this.shownWarnings.contains(name)) {
            Logger.getLogger(ShapeImporter.class.getName()).log(Level.WARNING, text);
            this.shownWarnings.add(name);
        }
    }

    class PathCommand {
        public char command;
        public double[] params;

        PathCommand() {
        }
    }
}

