/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.helpers.hilight;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightData;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Highlighting
implements Serializable {
    public HighlightType type;
    public String HighlightedText;
    public int startPos;
    public int len;
    private final HighlightData properties;

    public HighlightData getProperties() {
        return this.properties;
    }

    public static Highlighting search(List<Highlighting> list, HighlightData properties, long from, long to) {
        Object ret = null;
        for (Highlighting h : list) {
            if (from > -1L && (long)h.startPos < from || to > -1L && (long)h.startPos > to) continue;
            HighlightData hProp = h.getProperties();
            if (properties.declaration && !hProp.declaration || properties.declaredType != null && !properties.declaredType.equals(hProp.declaredType) || properties.localName != null && !properties.localName.equals(hProp.localName) || properties.specialValue != null && !properties.specialValue.equals(hProp.specialValue)) continue;
            return h;
        }
        return null;
    }

    public static Highlighting searchPos(List<Highlighting> list, long pos) {
        return Highlighting.searchPos(list, pos, -1L, -1L);
    }

    public static Highlighting searchPos(List<Highlighting> list, long pos, long from, long to) {
        Highlighting ret = null;
        for (Highlighting h : list) {
            if (from > -1L && (long)h.startPos < from || to > -1L && (long)h.startPos > to) continue;
            if ((pos == -1L || pos >= (long)h.startPos && (h.len == 0 && pos == (long)h.startPos || pos < (long)(h.startPos + h.len))) && (ret == null || h.startPos > ret.startPos)) {
                ret = h;
            }
            if (pos != -1L || ret == null) continue;
            return ret;
        }
        return ret;
    }

    public static Highlighting searchOffset(List<Highlighting> list, long offset) {
        return Highlighting.searchOffset(list, offset, -1L, -1L);
    }

    public static Highlighting searchOffset(List<Highlighting> list, long offset, long from, long to) {
        for (Highlighting h : list) {
            if (from > -1L && (long)h.startPos < from || to > -1L && (long)h.startPos > to || h.getProperties().offset != offset) continue;
            return h;
        }
        return null;
    }

    public static Highlighting searchIndex(List<Highlighting> list, long index) {
        return Highlighting.searchIndex(list, index, -1L, -1L);
    }

    public static Highlighting searchIndex(List<Highlighting> list, long index, long from, long to) {
        for (Highlighting h : list) {
            if (from > -1L && (long)h.startPos < from || to > -1L && (long)h.startPos > to || h.getProperties().index != index) continue;
            return h;
        }
        return null;
    }

    public static List<Highlighting> searchAllPos(List<Highlighting> list, long pos) {
        ArrayList<Highlighting> ret = new ArrayList<Highlighting>();
        for (Highlighting h : list) {
            if (pos != -1L && (pos < (long)h.startPos || pos >= (long)(h.startPos + h.len))) continue;
            ret.add(h);
        }
        return ret;
    }

    public static List<Highlighting> searchAllIndexes(List<Highlighting> list, long index) {
        ArrayList<Highlighting> ret = new ArrayList<Highlighting>();
        for (Highlighting h : list) {
            long i = h.getProperties().index;
            if (i != index) continue;
            ret.add(h);
        }
        return ret;
    }

    public static List<Highlighting> searchAllLocalNames(List<Highlighting> list, String localName) {
        ArrayList<Highlighting> ret = new ArrayList<Highlighting>();
        for (Highlighting h : list) {
            if (!localName.equals(h.getProperties().localName)) continue;
            ret.add(h);
        }
        return ret;
    }

    public String toString() {
        return this.startPos + "-" + (this.startPos + this.len) + " type:" + (Object)((Object)this.type);
    }

    public Highlighting(int startPos, HighlightData data, HighlightType type, String text) {
        this.startPos = startPos;
        this.type = type;
        if (Configuration._debugMode.get().booleanValue()) {
            this.HighlightedText = text;
        }
        this.properties = data;
    }
}

