/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.shape;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class MiterClipBasicStroke
implements Stroke {
    private final BasicStroke stroke;

    public MiterClipBasicStroke(BasicStroke stroke) {
        this.stroke = stroke;
    }

    @Override
    public Shape createStrokedShape(Shape p) {
        if (this.stroke.getLineJoin() != 0) {
            return this.stroke.createStrokedShape(p);
        }
        PathIterator pi = p.getPathIterator(new AffineTransform());
        float[] points = new float[6];
        Area area = new Area(this.stroke.createStrokedShape(p));
        AffineTransform t = new AffineTransform();
        ArrayList<Vector> vectors = new ArrayList<Vector>();
        ArrayList<Boolean> offPath = new ArrayList<Boolean>();
        float x = 0.0f;
        float y = 0.0f;
        while (!pi.isDone()) {
            int type = pi.currentSegment(points);
            switch (type) {
                case 0: {
                    vectors.add(new Vector(x, y, points[0], points[1]));
                    offPath.add(true);
                    x = points[0];
                    y = points[1];
                    break;
                }
                case 1: {
                    vectors.add(new Vector(x, y, points[0], points[1]));
                    offPath.add(false);
                    x = points[0];
                    y = points[1];
                    break;
                }
                case 3: {
                    vectors.add(new Vector(x, y, points[0], points[1]));
                    offPath.add(true);
                    vectors.add(new Vector(points[0], points[1], points[2], points[3]));
                    offPath.add(true);
                    vectors.add(new Vector(points[2], points[3], points[4], points[5]));
                    offPath.add(false);
                    x = points[4];
                    y = points[5];
                    break;
                }
                case 2: {
                    vectors.add(new Vector(x, y, points[0], points[1]));
                    offPath.add(true);
                    vectors.add(new Vector(points[0], points[1], points[2], points[3]));
                    offPath.add(false);
                    x = points[2];
                    y = points[3];
                }
            }
            pi.next();
        }
        for (int i = 0; i < vectors.size() - 1; ++i) {
            float line_c;
            float line_a;
            float line_d;
            float line_b;
            float intersectY;
            float intersectX;
            if (((Boolean)offPath.get(i)).booleanValue()) continue;
            Vector u = ((Vector)vectors.get(i)).transform(t);
            Vector v = ((Vector)vectors.get(i + 1)).transform(t);
            float parallelSign = 1.0f;
            float dx = u.x2 - u.x1;
            float dy = u.y2 - u.y1;
            float dx2 = v.x2 - v.x1;
            float dy2 = v.y2 - v.y1;
            if (dx <= 0.0f && dy <= 0.0f && dx2 >= 0.0f && dy2 <= 0.0f) {
                parallelSign = -1.0f;
            } else if (dx <= 0.0f && dy >= 0.0f && dx2 <= 0.0f && dy2 <= 0.0f) {
                parallelSign = -1.0f;
            } else if (dx >= 0.0f && dy <= 0.0f && dx2 >= 0.0f && dy2 >= 0.0f) {
                parallelSign = -1.0f;
            } else if (dx >= 0.0f && dy >= 0.0f && dx2 <= 0.0f && dy2 >= 0.0f) {
                parallelSign = -1.0f;
            }
            Vector perp1 = u.parallel(parallelSign * (this.stroke.getLineWidth() / 2.0f));
            Vector perp2 = v.parallel(parallelSign * (this.stroke.getLineWidth() / 2.0f));
            if (perp1.x1 == perp1.x2 && perp2.y1 == perp2.y2) {
                intersectX = perp1.x1;
                intersectY = perp2.y1;
            } else if (perp1.y1 == perp1.y2 && perp2.x1 == perp2.x2) {
                intersectX = perp2.x1;
                intersectY = perp1.y1;
            } else if (perp1.x1 == perp1.x2) {
                intersectX = perp1.x1;
                line_b = (perp2.y2 - perp2.y1) / (perp2.x2 - perp2.x1);
                line_d = perp2.y1 - line_b * perp2.x1;
                intersectY = line_b * intersectX + line_d;
            } else if (perp2.x1 == perp2.x2) {
                intersectX = perp2.x1;
                line_a = (perp1.y2 - perp1.y1) / (perp1.x2 - perp1.x1);
                line_c = perp1.y1 - line_a * perp1.x1;
                intersectY = line_a * intersectX + line_c;
            } else if (perp1.y1 == perp1.y2) {
                intersectY = perp1.y1;
                line_b = (perp2.y2 - perp2.y1) / (perp2.x2 - perp2.x1);
                line_d = perp2.y1 - line_b * perp2.x1;
                intersectX = (intersectY - line_d) / line_b;
            } else if (perp2.y1 == perp2.y2) {
                intersectY = perp2.y1;
                line_a = (perp1.y2 - perp1.y1) / (perp1.x2 - perp1.x1);
                line_c = perp1.y1 - line_a * perp1.x1;
                intersectX = intersectY - line_c / line_a;
            } else {
                line_a = (perp1.y2 - perp1.y1) / (perp1.x2 - perp1.x1);
                line_c = perp1.y1 - line_a * perp1.x1;
                float line_b2 = (perp2.y2 - perp2.y1) / (perp2.x2 - perp2.x1);
                float line_d2 = perp2.y1 - line_b2 * perp2.x1;
                intersectX = (line_d2 - line_c) / (line_a - line_b2);
                intersectY = line_a * intersectX + line_c;
            }
            float ss = (float)Math.sqrt((intersectX - u.x2) * (intersectX - u.x2) + (intersectY - u.y2) * (intersectY - u.y2));
            float miter = this.stroke.getMiterLimit() * this.stroke.getLineWidth() / 2.0f;
            float afterMiter = ss - miter;
            if (!(afterMiter > 0.0f)) continue;
            float ndx1a = intersectX - perp2.x1;
            float ndy1a = intersectY - perp2.y1;
            float ndxa = ndx1a * afterMiter / ss;
            float ndya = ndy1a * afterMiter / ss;
            float intmitxa = intersectX - ndxa;
            float intmitya = intersectY - ndya;
            float ndx1b = intersectX - perp1.x2;
            float ndy1b = intersectY - perp1.y2;
            float ndxb = ndx1b * afterMiter / ss;
            float ndyb = ndy1b * afterMiter / ss;
            float intmitxb = intersectX - ndxb;
            float intmityb = intersectY - ndyb;
            Path2D.Float fp = new Path2D.Float(0);
            ((Path2D)fp).moveTo(perp2.x1, perp2.y1);
            ((Path2D)fp).lineTo(intmitxa, intmitya);
            ((Path2D)fp).lineTo(intmitxb, intmityb);
            ((Path2D)fp).lineTo(perp1.x2, perp1.y2);
            fp.closePath();
            area.add(new Area(fp));
        }
        return area;
    }

    private static class Vector {
        public float x1;
        public float y1;
        public float x2;
        public float y2;

        public Vector(float x1, float y1, float x2, float y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public float getLength() {
            return (float)Math.sqrt((this.x2 - this.x1) * (this.x2 - this.x1) + (this.y2 - this.y1) * (this.y2 - this.y1));
        }

        public float multiply(Vector v2) {
            return (this.x2 - this.x1) * (v2.x2 - v2.x1) + (this.y2 - this.y1) * (v2.y2 - v2.y1);
        }

        public float getAngle(Vector v2) {
            return (float)Math.acos(this.multiply(v2) / (this.getLength() * v2.getLength()));
        }

        public String toString() {
            return "[" + this.x1 + "," + this.y1 + "] -> [" + this.x2 + "," + this.y2 + "]";
        }

        public Vector reverse() {
            return new Vector(this.x2, this.y2, this.x1, this.y1);
        }

        public Vector transform(AffineTransform t) {
            Point2D.Float fromSrc = new Point2D.Float(this.x1, this.y1);
            Point2D.Float toSrc = new Point2D.Float(this.x2, this.y2);
            Point2D.Float fromDest = new Point2D.Float();
            Point2D.Float toDest = new Point2D.Float();
            t.transform(fromSrc, fromDest);
            t.transform(toSrc, toDest);
            return new Vector((float)((Point2D)fromDest).getX(), (float)((Point2D)fromDest).getY(), (float)((Point2D)toDest).getX(), (float)((Point2D)toDest).getY());
        }

        public Vector parallel(float w) {
            float len = (float)Math.sqrt((this.x2 - this.x1) * (this.x2 - this.x1) + (this.y2 - this.y1) * (this.y2 - this.y1));
            float xd = (this.y1 - this.y2) * w / len;
            float yd = (this.x2 - this.x1) * w / len;
            float x3 = this.x1 + xd;
            float y3 = this.y1 + yd;
            float x4 = this.x2 + xd;
            float y4 = this.y2 + yd;
            return new Vector(x3, y3, x4, y4);
        }
    }
}

