/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters;

import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.RetryTask;
import com.jpexs.decompiler.flash.exporters.modes.SoundExportMode;
import com.jpexs.decompiler.flash.exporters.settings.SoundExportSettings;
import com.jpexs.decompiler.flash.flv.AUDIODATA;
import com.jpexs.decompiler.flash.flv.FLVOutputStream;
import com.jpexs.decompiler.flash.flv.FLVTAG;
import com.jpexs.decompiler.flash.tags.DefineSoundTag;
import com.jpexs.decompiler.flash.tags.SoundStreamBlockTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.SoundStreamHeadTypeTag;
import com.jpexs.decompiler.flash.tags.base.SoundTag;
import com.jpexs.decompiler.flash.types.sound.SoundExportFormat;
import com.jpexs.decompiler.flash.types.sound.SoundFormat;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SoundExporter {
    public List<File> exportSounds(AbortRetryIgnoreHandler handler, String outdir, ReadOnlyTagList tags, SoundExportSettings settings, EventListener evl) throws IOException, InterruptedException {
        ArrayList<File> ret = new ArrayList<File>();
        if (tags.isEmpty()) {
            return ret;
        }
        File foutdir = new File(outdir);
        Path.createDirectorySafe(foutdir);
        int count = 0;
        for (Tag t : tags) {
            if (!(t instanceof SoundTag)) continue;
            ++count;
        }
        if (count == 0) {
            return ret;
        }
        int currentIndex = 1;
        for (Tag t : tags) {
            if (!(t instanceof SoundTag)) continue;
            if (evl != null) {
                evl.handleExportingEvent("sound", currentIndex, count, t.getName());
            }
            SoundTag st = (SoundTag)((Object)t);
            String ext = "wav";
            SoundFormat fmt = st.getSoundFormat();
            switch (fmt.getNativeExportFormat()) {
                case MP3: {
                    if (!settings.mode.hasMP3()) break;
                    ext = "mp3";
                    break;
                }
                case FLV: {
                    if (!settings.mode.hasFlv()) break;
                    ext = "flv";
                }
            }
            if (settings.mode == SoundExportMode.FLV) {
                ext = "flv";
            }
            File file = new File(outdir + File.separator + Helper.makeFileName(st.getCharacterExportFileName()) + "." + ext);
            new RetryTask(() -> {
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
                    this.exportSound(os, st, settings.mode);
                }
            }, handler).run();
            ret.add(file);
            if (evl != null) {
                evl.handleExportedEvent("sound", currentIndex, count, t.getName());
            }
            ++currentIndex;
        }
        return ret;
    }

    public byte[] exportSound(SoundTag t, SoundExportMode mode) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.exportSound(baos, t, mode);
        return baos.toByteArray();
    }

    public void exportSound(OutputStream fos, SoundTag st, SoundExportMode mode) throws IOException {
        SoundFormat fmt = st.getSoundFormat();
        SoundExportFormat nativeFormat = fmt.getNativeExportFormat();
        if (nativeFormat == SoundExportFormat.MP3 && mode.hasMP3()) {
            List<ByteArrayRange> datas = st.getRawSoundData();
            for (ByteArrayRange data : datas) {
                fos.write(data.getRangeData());
            }
        } else if (nativeFormat == SoundExportFormat.FLV && mode.hasFlv() || mode == SoundExportMode.FLV) {
            if (st instanceof DefineSoundTag) {
                FLVOutputStream flv = new FLVOutputStream(fos);
                flv.writeHeader(true, false);
                List<ByteArrayRange> datas = st.getRawSoundData();
                for (ByteArrayRange data : datas) {
                    flv.writeTag(new FLVTAG(0L, new AUDIODATA(st.getSoundFormatId(), st.getSoundRate(), st.getSoundSize(), st.getSoundType(), data.getRangeData())));
                }
            } else if (st instanceof SoundStreamHeadTypeTag) {
                SoundStreamHeadTypeTag sh = (SoundStreamHeadTypeTag)st;
                FLVOutputStream flv = new FLVOutputStream(fos);
                flv.writeHeader(true, false);
                List<SoundStreamBlockTag> blocks = sh.getBlocks();
                int ms = (int)(1000.0 / (double)((Tag)((Object)st)).getSwf().frameRate);
                for (int b = 0; b < blocks.size(); ++b) {
                    byte[] data = blocks.get((int)b).streamSoundData.getRangeData();
                    if (st.getSoundFormatId() == 2) {
                        data = Arrays.copyOfRange(data, 4, data.length);
                    }
                    flv.writeTag(new FLVTAG((long)(ms * b), new AUDIODATA(st.getSoundFormatId(), st.getSoundRate(), st.getSoundSize(), st.getSoundType(), data)));
                }
            }
        } else {
            List<ByteArrayRange> soundData = st.getRawSoundData();
            fmt.createWav(null, soundData, fos);
        }
    }
}

