/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters;

import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.RetryTask;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.exporters.MorphShapeExporter;
import com.jpexs.decompiler.flash.exporters.PreviewExporter;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.exporters.modes.ShapeExportMode;
import com.jpexs.decompiler.flash.exporters.settings.ShapeExportSettings;
import com.jpexs.decompiler.flash.exporters.shape.CanvasShapeExporter;
import com.jpexs.decompiler.flash.helpers.BMPFile;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.types.CXFORMWITHALPHA;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import com.jpexs.helpers.SerializableImage;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.awt.Graphics2D;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShapeExporter {
    public List<File> exportShapes(AbortRetryIgnoreHandler handler, String outdir, SWF swf, ReadOnlyTagList tags, ShapeExportSettings settings, EventListener evl, double unzoom) throws IOException, InterruptedException {
        ArrayList<File> ret = new ArrayList<File>();
        if (tags.isEmpty()) {
            return ret;
        }
        File foutdir = new File(outdir);
        Path.createDirectorySafe(foutdir);
        int count = 0;
        for (Object t : tags) {
            if (!(t instanceof ShapeTag)) continue;
            ++count;
        }
        if (count == 0) {
            return ret;
        }
        int currentIndex = 1;
        for (Tag t : tags) {
            if (!(t instanceof ShapeTag)) continue;
            ShapeTag st = (ShapeTag)t;
            if (evl != null) {
                evl.handleExportingEvent("shape", currentIndex, count, t.getName());
            }
            File file = new File(outdir + File.separator + Helper.makeFileName(st.getCharacterExportFileName() + settings.getFileExtension()));
            new RetryTask(() -> ShapeExporter.lambda$exportShapes$0(settings, file, st, swf, unzoom), handler).run();
            ret.add(file);
            if (evl != null) {
                evl.handleExportedEvent("shape", currentIndex, count, t.getName());
            }
            ++currentIndex;
        }
        if (settings.mode == ShapeExportMode.CANVAS) {
            File fcanvas = new File(foutdir + File.separator + "canvas.js");
            Helper.saveStream(SWF.class.getClassLoader().getResourceAsStream("com/jpexs/helpers/resource/canvas.js"), fcanvas);
            ret.add(fcanvas);
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$exportShapes$0(ShapeExportSettings settings, File file, ShapeTag st, SWF swf, double unzoom) throws IOException, InterruptedException {
        switch (1.$SwitchMap$com$jpexs$decompiler$flash$exporters$modes$ShapeExportMode[settings.mode.ordinal()]) {
            case 1: {
                fos = new BufferedOutputStream(new FileOutputStream(file));
                var7_7 = null;
                rect = new ExportRectangle(st.getRect());
                rect.xMax *= settings.zoom;
                rect.yMax *= settings.zoom;
                rect.xMin *= settings.zoom;
                rect.yMin *= settings.zoom;
                exporter = new SVGExporter(rect, settings.zoom);
                st.toSVG(exporter, -2, new CXFORMWITHALPHA(), 0);
                fos.write(Utf8Helper.getBytes(exporter.getSVG()));
                if (fos == null) break;
                if (var7_7 == null) ** GOTO lbl22
                try {
                    fos.close();
                }
                catch (Throwable rect) {
                    var7_7.addSuppressed(rect);
                }
                break;
lbl22:
                // 1 sources

                fos.close();
                break;
                catch (Throwable rect) {
                    try {
                        var7_7 = rect;
                        throw rect;
                    }
                    catch (Throwable var10_15) {
                        if (fos != null) {
                            if (var7_7 != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable var11_17) {
                                    var7_7.addSuppressed(var11_17);
                                }
                            } else {
                                fos.close();
                            }
                        }
                        throw var10_15;
                    }
                }
            }
            case 2: 
            case 3: {
                rect = st.getRect();
                newWidth = (int)((double)rect.getWidth() * settings.zoom / 20.0) + 1;
                newHeight = (int)((double)rect.getHeight() * settings.zoom / 20.0) + 1;
                img = new SerializableImage(newWidth, newHeight, SerializableImage.TYPE_INT_ARGB_PRE);
                img.fillTransparent();
                if (settings.mode == ShapeExportMode.BMP && (backColor = swf.getBackgroundColor().backgroundColor) != null) {
                    g = (Graphics2D)img.getGraphics();
                    g.setColor(backColor.toColor());
                    g.fillRect(0, 0, img.getWidth(), img.getHeight());
                }
                m = Matrix.getScaleInstance(settings.zoom);
                m.translate(-rect.Xmin, -rect.Ymin);
                st.toImage(0, 0, 0, new RenderContext(), img, img, false, m, m, m, m, new CXFORMWITHALPHA(), unzoom, false, new ExportRectangle(rect), true, 0);
                if (settings.mode == ShapeExportMode.PNG) {
                    ImageHelper.write(img.getBufferedImage(), ImageFormat.PNG, file);
                    break;
                }
                BMPFile.saveBitmap(img.getBufferedImage(), file);
                break;
            }
            case 4: {
                fos = new BufferedOutputStream(new FileOutputStream(file));
                var12_21 = null;
                shp = st.getShapes();
                deltaX = -shp.getBounds().Xmin;
                deltaY = -shp.getBounds().Ymin;
                cse = new CanvasShapeExporter(null, 20.0 / settings.zoom, st.getSwf(), shp, new CXFORMWITHALPHA(), deltaX, deltaY);
                cse.export();
                needed = new HashSet<Integer>();
                needed.add(st.getCharacterId());
                st.getNeededCharactersDeep(needed);
                baos = new ByteArrayOutputStream();
                SWF.libraryToHtmlCanvas(st.getSwf(), needed, baos);
                fos.write(Utf8Helper.getBytes(cse.getHtml(new String(baos.toByteArray(), Utf8Helper.charset), SWF.getTypePrefix(st) + st.getCharacterId(), st.getRect())));
                if (fos == null) break;
                if (var12_21 == null) ** GOTO lbl81
                try {
                    fos.close();
                }
                catch (Throwable shp) {
                    var12_21.addSuppressed(shp);
                }
                break;
lbl81:
                // 1 sources

                fos.close();
                break;
                catch (Throwable shp) {
                    try {
                        var12_21 = shp;
                        throw shp;
                    }
                    catch (Throwable var19_34) {
                        if (fos != null) {
                            if (var12_21 != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable var20_35) {
                                    var12_21.addSuppressed(var20_35);
                                }
                            } else {
                                fos.close();
                            }
                        }
                        throw var19_34;
                    }
                }
            }
            case 5: {
                fos = new BufferedOutputStream(new FileOutputStream(file));
                var12_22 = null;
                try {
                    new PreviewExporter().exportSwf(fos, st, null, 0, false);
                }
                catch (ActionParseException ex) {
                    Logger.getLogger(MorphShapeExporter.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (fos == null) break;
                if (var12_22 == null) ** GOTO lbl116
                try {
                    fos.close();
                }
                catch (Throwable var13_27) {
                    var12_22.addSuppressed(var13_27);
                }
                break;
lbl116:
                // 1 sources

                fos.close();
                break;
                catch (Throwable var13_28) {
                    try {
                        var12_22 = var13_28;
                        throw var13_28;
                    }
                    catch (Throwable var21_36) {
                        if (fos != null) {
                            if (var12_22 != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable var22_37) {
                                    var12_22.addSuppressed(var22_37);
                                }
                            } else {
                                fos.close();
                            }
                        }
                        throw var21_36;
                    }
                }
            }
        }
    }
}

