/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters;

import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.RetryTask;
import com.jpexs.decompiler.flash.exporters.settings.BinaryDataExportSettings;
import com.jpexs.decompiler.flash.tags.DefineBinaryDataTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class BinaryDataExporter {
    public List<File> exportBinaryData(AbortRetryIgnoreHandler handler, String outdir, ReadOnlyTagList tags, BinaryDataExportSettings settings, EventListener evl) throws IOException, InterruptedException {
        ArrayList<File> ret = new ArrayList<File>();
        if (tags.isEmpty()) {
            return ret;
        }
        File foutdir = new File(outdir);
        Path.createDirectorySafe(foutdir);
        int count = 0;
        for (Tag t : tags) {
            if (!(t instanceof DefineBinaryDataTag)) continue;
            ++count;
        }
        if (count == 0) {
            return ret;
        }
        int currentIndex = 1;
        for (Tag t : tags) {
            if (!(t instanceof DefineBinaryDataTag)) continue;
            DefineBinaryDataTag bdt = (DefineBinaryDataTag)t;
            if (evl != null) {
                evl.handleExportingEvent("binarydata", currentIndex, count, t.getName());
            }
            String ext = bdt.innerSwf == null ? ".bin" : ".swf";
            File file = new File(outdir + File.separator + Helper.makeFileName(bdt.getCharacterExportFileName() + ext));
            new RetryTask(() -> {
                try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));){
                    ((OutputStream)fos).write(bdt.binaryData.getRangeData());
                }
            }, handler).run();
            ret.add(file);
            if (evl != null) {
                evl.handleExportedEvent("binarydata", currentIndex, count, t.getName());
            }
            ++currentIndex;
        }
        return ret;
    }
}

