/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class TemporaryRegister
extends ActionItem {
    private final int regId;

    public TemporaryRegister(int regId, GraphTargetItem value) {
        super(value.getSrc(), value.getLineStartItem(), value.getPrecedence(), value);
        this.regId = regId;
    }

    public int getRegId() {
        return this.regId;
    }

    @Override
    public String toString() {
        return "temp reg " + this.regId + ":" + this.value.toString();
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        return this.value.toString(writer, localData);
    }

    @Override
    public boolean hasReturnValue() {
        return this.value.hasReturnValue();
    }

    @Override
    public Object getResult() {
        return this.value.getResult();
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.value);
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        return this.value.getNeededSources();
    }

    @Override
    public GraphTargetItem getNotCoerced() {
        return this.value.getNotCoerced();
    }

    @Override
    public GraphTargetItem getNotCoercedNoDup() {
        return this.value.getNotCoercedNoDup();
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + this.regId;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemporaryRegister other = (TemporaryRegister)obj;
        if (this.regId != other.regId) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }

    @Override
    public boolean valueEquals(GraphTargetItem obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemporaryRegister other = (TemporaryRegister)obj;
        if (this.regId != other.regId) {
            return false;
        }
        return GraphTargetItem.objectsValueEquals(this.value, other.value);
    }
}

