/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action;

import com.jpexs.decompiler.flash.action.DepthStateObjectAdapter;
import com.jpexs.decompiler.flash.action.DisplayObject;
import com.jpexs.decompiler.flash.timeline.DepthState;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.timeline.Timelined;
import java.util.ArrayList;
import java.util.List;

public class Stage
extends DisplayObject {
    protected long startTime = System.currentTimeMillis();
    protected Timelined timelined;
    protected Timeline timeline;
    protected Frame frame;

    public Stage(Timelined timelined) {
        this.timelined = timelined;
        this.timeline = timelined != null ? timelined.getTimeline() : null;
        this.frame = timelined != null && this.timeline.getFrameCount() > 0 ? this.timeline.getFrame(0) : null;
    }

    @Override
    public List<String> enumerate() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.frame != null) {
            for (DepthState ds : this.frame.layers.values()) {
                if (ds.instanceName == null) continue;
                ret.add(ds.instanceName);
            }
        }
        return ret;
    }

    @Override
    protected Object getThisMember(String name) {
        if (this.frame != null) {
            for (DepthState ds : this.frame.layers.values()) {
                if (!name.equals(ds.instanceName)) continue;
                return new DepthStateObjectAdapter(ds);
            }
        }
        return null;
    }

    public long getTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public int getTotalFrames() {
        if (this.timeline == null) {
            return 1;
        }
        return this.timeline.getFrameCount();
    }

    @Override
    public void gotoFrame(int frameNum) {
        super.gotoFrame(frameNum);
        if (this.timeline != null) {
            this.frame = this.timeline.getFrame(this.getCurrentFrame() - 1);
        }
    }

    @Override
    public void gotoLabel(String label) {
        if (this.timeline == null) {
            return;
        }
        int f = this.timeline.getFrameWithLabel(label);
        if (f != -1) {
            this.gotoFrame(f + 1);
        }
    }

    public void stopSounds() {
    }

    public void toggleQuality() {
    }

    public void getURL(String url, String target) {
    }

    public void trace(Object ... val) {
    }
}

