/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ApplyTypeAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.IntegerValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AVM2SourceGenerator;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.NamespaceItem;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class InitVectorAVM2Item
extends AVM2Item {
    public static final DottedChain VECTOR_PACKAGE = new DottedChain(new String[]{"__AS3__", "vec"}, "");
    public static final DottedChain VECTOR_FQN = new DottedChain(new String[]{"__AS3__", "vec", "Vector"}, "");
    public static final DottedChain VECTOR_INT = new DottedChain(new String[]{"__AS3__", "vec", "Vector$int"}, "");
    public static final DottedChain VECTOR_DOUBLE = new DottedChain(new String[]{"__AS3__", "vec", "Vector$double"}, "");
    public static final DottedChain VECTOR_UINT = new DottedChain(new String[]{"__AS3__", "vec", "Vector$uint"}, "");
    public static final DottedChain VECTOR_OBJECT = new DottedChain(new String[]{"__AS3__", "vec", "Vector$object"}, "");
    public GraphTargetItem subtype;
    public List<GraphTargetItem> arguments;
    List<NamespaceItem> openedNamespaces;

    private int allNsSet(AbcIndexing abc) throws CompilationException {
        return NamespaceItem.getCpoolSetIndex(abc, this.openedNamespaces);
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.subtype);
        visitor.visitAll(this.arguments);
    }

    public InitVectorAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem subtype, List<GraphTargetItem> arguments) {
        super(instruction, lineStartIns, 0);
        this.subtype = subtype;
        this.arguments = arguments;
    }

    public InitVectorAVM2Item(GraphTargetItem subtype, List<GraphTargetItem> arguments, List<NamespaceItem> openedNamespaces) {
        super(null, null, 0);
        this.subtype = subtype;
        this.arguments = arguments;
        this.openedNamespaces = openedNamespaces;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.append("<");
        this.subtype.appendTry(writer, localData);
        writer.append(">");
        writer.append("[");
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (i > 0) {
                writer.append(",");
            }
            this.arguments.get(i).appendTry(writer, localData);
        }
        writer.append("]");
        return writer;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    @Override
    public GraphTargetItem returnType() {
        ArrayList<GraphTargetItem> pars = new ArrayList<GraphTargetItem>();
        pars.add(this.subtype);
        return new ApplyTypeAVM2Item(null, null, new TypeItem(VECTOR_FQN), pars);
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        AVM2SourceGenerator g = (AVM2SourceGenerator)generator;
        ABC abc = g.abcIndex.getSelectedAbc();
        AVM2ConstantPool constants = abc.constants;
        List<GraphSourceItem> ret = InitVectorAVM2Item.toSourceMerge(localData, generator, InitVectorAVM2Item.ins(93, constants.getMultinameId(Multiname.createMultiname(false, constants.getStringId("Vector", true), constants.getNamespaceSetId(new int[]{constants.getNamespaceId(22, "__AS3__.vec", 0, true)}, true)), true)), InitVectorAVM2Item.ins(102, constants.getMultinameId(Multiname.createMultiname(false, constants.getStringId("Vector", true), this.allNsSet(g.abcIndex)), true)), this.subtype, InitVectorAVM2Item.ins(83, 1), new IntegerValueAVM2Item(null, null, Long.valueOf(this.arguments.size())), InitVectorAVM2Item.ins(66, 1));
        for (int i = 0; i < this.arguments.size(); ++i) {
            ret.addAll(InitVectorAVM2Item.toSourceMerge(localData, generator, InitVectorAVM2Item.ins(42, new Integer[0]), new IntegerValueAVM2Item(null, null, Long.valueOf(i)), this.arguments.get(i), InitVectorAVM2Item.ins(97, constants.getMultinameId(Multiname.createMultinameL(false, NamespaceItem.getCpoolSetIndex(g.abcIndex, this.openedNamespaces)), true))));
        }
        return ret;
    }

    public int hashCode() {
        int hash = 5;
        hash = 31 * hash + Objects.hashCode(this.subtype);
        hash = 31 * hash + Objects.hashCode(this.arguments);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InitVectorAVM2Item other = (InitVectorAVM2Item)obj;
        if (!Objects.equals(this.subtype, other.subtype)) {
            return false;
        }
        return Objects.equals(this.arguments, other.arguments);
    }
}

