/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetLexAVM2Item;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.Callable;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CallAVM2Item
extends AVM2Item {
    public GraphTargetItem receiver;
    public GraphTargetItem function;
    public List<GraphTargetItem> arguments;
    private static Map<String, Func> bundledFunctions = new HashMap<String, Func>();

    public CallAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem receiver, GraphTargetItem function, List<GraphTargetItem> arguments) {
        super(instruction, lineStartIns, 0);
        this.receiver = receiver;
        this.function = function;
        this.arguments = arguments;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.receiver);
        visitor.visit(this.function);
        visitor.visitAll(this.arguments);
    }

    @Override
    public Object getResult() {
        if (!this.isCompileTime()) {
            return null;
        }
        ArrayList<Object> oargs = new ArrayList<Object>();
        for (GraphTargetItem ot : this.arguments) {
            Object r = ot.getResult();
            if (r == null) {
                return false;
            }
            oargs.add(r);
        }
        if (this.function instanceof GetLexAVM2Item) {
            String propName = ((GetLexAVM2Item)this.function).getRawPropertyName();
            if (bundledFunctions.containsKey(propName)) {
                return bundledFunctions.get(propName).call(oargs);
            }
        } else if (this.function instanceof Callable) {
            return ((Callable)((Object)this.function)).call(oargs);
        }
        return null;
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        String propName;
        for (GraphTargetItem a : this.arguments) {
            if (a.isCompileTime(dependencies)) continue;
            return false;
        }
        if (this.function instanceof Callable && this.function.isCompileTime()) {
            return true;
        }
        return this.function instanceof GetLexAVM2Item && bundledFunctions.containsKey(propName = ((GetLexAVM2Item)this.function).getRawPropertyName());
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (this.function.getPrecedence() > this.precedence) {
            writer.append("(");
            this.function.toString(writer, localData);
            writer.append(")");
        } else {
            this.function.toString(writer, localData);
        }
        writer.spaceBeforeCallParenthesies(this.arguments.size());
        writer.append("(");
        for (int a = 0; a < this.arguments.size(); ++a) {
            if (a > 0) {
                writer.append(",");
            }
            this.arguments.get(a).toString(writer, localData);
        }
        return writer.append(")");
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.UNBOUNDED;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.receiver);
        hash = 97 * hash + Objects.hashCode(this.function);
        hash = 97 * hash + Objects.hashCode(this.arguments);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallAVM2Item other = (CallAVM2Item)obj;
        if (!Objects.equals(this.receiver, other.receiver)) {
            return false;
        }
        if (!Objects.equals(this.function, other.function)) {
            return false;
        }
        return Objects.equals(this.arguments, other.arguments);
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }

    static {
        bundledFunctions.put("parseInt", new Func(){

            @Override
            public Object call(List<Object> args) {
                Object v = args.get(0);
                Object r = args.size() > 1 ? args.get(0) : Long.valueOf(0L);
                return EcmaScript.parseInt(v, r);
            }
        });
        bundledFunctions.put("parseFloat", new Func(){

            @Override
            public Object call(List<Object> args) {
                return EcmaScript.parseFloat(args.get(0));
            }
        });
        bundledFunctions.put("Number", new Func(){

            @Override
            public Object call(List<Object> args) {
                return EcmaScript.toNumber(args.get(0));
            }
        });
        bundledFunctions.put("isNaN", new Func(){

            @Override
            public Object call(List<Object> args) {
                return EcmaScript.isNaN(args.get(0));
            }
        });
        bundledFunctions.put("int", new Func(){

            @Override
            public Object call(List<Object> args) {
                return EcmaScript.toInt32(args.get(0));
            }
        });
        bundledFunctions.put("uint", new Func(){

            @Override
            public Object call(List<Object> args) {
                return EcmaScript.toUint32(args.get(0));
            }
        });
        bundledFunctions.put("encodeURI", new Func(){

            @Override
            public Object call(List<Object> args) {
                return EcmaScript.encodeUri(args.get(0));
            }
        });
        bundledFunctions.put("decodeURI", new Func(){

            @Override
            public Object call(List<Object> args) {
                return EcmaScript.decodeUri(args.get(0));
            }
        });
        bundledFunctions.put("encodeURIComponent", new Func(){

            @Override
            public Object call(List<Object> args) {
                return EcmaScript.encodeUriComponent(args.get(0));
            }
        });
        bundledFunctions.put("decodeURIComponent", new Func(){

            @Override
            public Object call(List<Object> args) {
                return EcmaScript.decodeUriComponent(args.get(0));
            }
        });
        bundledFunctions.put("escape", new Func(){

            @Override
            public Object call(List<Object> args) {
                return EcmaScript.escape(args.get(0));
            }
        });
        bundledFunctions.put("unescape", new Func(){

            @Override
            public Object call(List<Object> args) {
                return EcmaScript.unescape(args.get(0));
            }
        });
    }

    private static abstract class Func
    implements Callable {
        private Func() {
        }

        @Override
        public Object call(String methodName, List<Object> args) {
            return this.call(args);
        }
    }
}

