/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.exceptions;

import com.jpexs.decompiler.flash.abc.avm2.exceptions.AVM2ExecutionException;

public class AVM2VerifyErrorException
extends AVM2ExecutionException {
    public static final int ILLEGAL_OPCODE = 1011;
    public static final int BRANCH_TARGET_INVALID_INSTRUCTION = 1021;
    public static final int CPOOL_INDEX_OUT_OF_RANGE = 1032;

    public AVM2VerifyErrorException(int code, boolean debug) {
        super(AVM2VerifyErrorException.codeToMessage(code, debug, null));
    }

    public AVM2VerifyErrorException(int code, boolean debug, Object[] params) {
        super(AVM2VerifyErrorException.codeToMessage(code, debug, params));
    }

    private static String codeToMessage(int code, boolean debug, Object[] params) {
        String msg = null;
        switch (code) {
            case 1011: {
                msg = "Method " + params[0] + " contained illegal opcode " + params[1] + " at offset " + params[2] + ".";
                break;
            }
            case 1014: {
                msg = "class could not be found";
                break;
            }
            case 1021: {
                msg = "At least one branch target was not on a valid instruction in the method.";
                break;
            }
            case 1030: {
                msg = "Stack depth is unbalanced";
                break;
            }
            case 1032: {
                msg = "Cpool index " + params[0] + " is out of range " + params[1] + ".";
            }
        }
        String result = "VerifyError: Error #" + code;
        if (debug && msg != null) {
            result = result + ": " + msg;
        }
        return result;
    }
}

