/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2;

import com.jpexs.decompiler.flash.abc.ABCVersionRequirements;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.types.Decimal;
import com.jpexs.decompiler.flash.abc.types.Float4;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.NamespaceSet;
import com.jpexs.decompiler.flash.ecma.Null;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.annotations.SWFField;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.HashArrayList;
import com.jpexs.helpers.utf8.Utf8PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AVM2ConstantPool
implements Cloneable {
    private static final Logger logger = Logger.getLogger(AVM2ConstantPool.class.getName());
    @SWFField
    private HashArrayList<Long> constant_int = new HashArrayList();
    @SWFField
    private HashArrayList<Long> constant_uint = new HashArrayList();
    @SWFField
    private HashArrayList<Double> constant_double = new HashArrayList();
    @SWFField
    @ABCVersionRequirements(exactMinor=17)
    private HashArrayList<Decimal> constant_decimal = new HashArrayList();
    @SWFField
    @SWFVersion(from=16)
    @ABCVersionRequirements(minMajor=47, minMinor=16)
    private HashArrayList<Float> constant_float = new HashArrayList();
    @SWFField
    @SWFVersion(from=16)
    @ABCVersionRequirements(minMajor=47, minMinor=16)
    private HashArrayList<Float4> constant_float4 = new HashArrayList();
    @SWFField
    private HashArrayList<String> constant_string = new HashArrayList();
    @SWFField
    private HashArrayList<Namespace> constant_namespace = new HashArrayList();
    @SWFField
    private HashArrayList<NamespaceSet> constant_namespace_set = new HashArrayList();
    @SWFField
    private HashArrayList<Multiname> constant_multiname = new HashArrayList();
    @Internal
    public Map<String, DottedChain> dottedChainCache = new HashMap<String, DottedChain>();

    private void ensureDefault(List<?> list) {
        if (list.isEmpty()) {
            list.add(null);
        }
    }

    public void ensureIntCapacity(int capacity) {
        this.constant_int.ensureCapacity(capacity);
        if (capacity > 0) {
            this.ensureDefault(this.constant_int);
        }
    }

    public void ensureNamespaceCapacity(int capacity) {
        this.constant_namespace.ensureCapacity(capacity);
        if (capacity > 0) {
            this.ensureDefault(this.constant_namespace);
        }
    }

    public void ensureNamespaceSetCapacity(int capacity) {
        this.constant_namespace_set.ensureCapacity(capacity);
        if (capacity > 0) {
            this.ensureDefault(this.constant_namespace_set);
        }
    }

    public void ensureMultinameCapacity(int capacity) {
        this.constant_multiname.ensureCapacity(capacity);
        if (capacity > 0) {
            this.ensureDefault(this.constant_multiname);
        }
    }

    public void ensureUIntCapacity(int capacity) {
        this.constant_uint.ensureCapacity(capacity);
        if (capacity > 0) {
            this.ensureDefault(this.constant_uint);
        }
    }

    public void ensureDoubleCapacity(int capacity) {
        this.constant_double.ensureCapacity(capacity);
        if (capacity > 0) {
            this.ensureDefault(this.constant_double);
        }
    }

    public void ensureDecimalCapacity(int capacity) {
        this.constant_decimal.ensureCapacity(capacity);
        if (capacity > 0) {
            this.ensureDefault(this.constant_decimal);
        }
    }

    public void ensureFloatCapacity(int capacity) {
        this.constant_float.ensureCapacity(capacity);
        if (capacity > 0) {
            this.ensureDefault(this.constant_float);
        }
    }

    public void ensureFloat4Capacity(int capacity) {
        this.constant_float4.ensureCapacity(capacity);
        if (capacity > 0) {
            this.ensureDefault(this.constant_float4);
        }
    }

    public void ensureStringCapacity(int capacity) {
        this.constant_string.ensureCapacity(capacity);
        if (capacity > 0) {
            this.ensureDefault(this.constant_string);
        }
    }

    public synchronized int addInt(long value) {
        this.ensureDefault(this.constant_int);
        value = (int)value;
        this.constant_int.add(value);
        return this.constant_int.size() - 1;
    }

    public synchronized int addNamespace(Namespace ns) {
        this.ensureDefault(this.constant_namespace);
        this.constant_namespace.add(ns);
        return this.constant_namespace.size() - 1;
    }

    public int addNamespace(int kind, int nameIndex) {
        return this.addNamespace(new Namespace(kind, nameIndex));
    }

    public synchronized int addNamespaceSet(NamespaceSet nss) {
        this.ensureDefault(this.constant_namespace_set);
        this.constant_namespace_set.add(nss);
        return this.constant_namespace_set.size() - 1;
    }

    public synchronized int addMultiname(Multiname m) {
        this.ensureDefault(this.constant_multiname);
        this.constant_multiname.add(m);
        return this.constant_multiname.size() - 1;
    }

    public synchronized int addUInt(long value) {
        this.ensureDefault(this.constant_uint);
        this.constant_uint.add(value &= 0xFFFFFFFFL);
        return this.constant_uint.size() - 1;
    }

    public synchronized int addDouble(double value) {
        this.ensureDefault(this.constant_double);
        this.constant_double.add(value);
        return this.constant_double.size() - 1;
    }

    public synchronized int addDecimal(Decimal value) {
        this.ensureDefault(this.constant_decimal);
        this.constant_decimal.add(value);
        return this.constant_decimal.size() - 1;
    }

    public synchronized int addFloat(Float value) {
        this.ensureDefault(this.constant_float);
        this.constant_float.add(value);
        return this.constant_float.size() - 1;
    }

    public synchronized int addFloat4(Float4 value) {
        this.ensureDefault(this.constant_float4);
        this.constant_float4.add(value);
        return this.constant_float4.size() - 1;
    }

    public synchronized int addString(String value) {
        this.ensureDefault(this.constant_string);
        this.constant_string.add(value);
        return this.constant_string.size() - 1;
    }

    public long setInt(int index, long value) {
        this.constant_int.set(index, value);
        return value;
    }

    public Namespace setNamespace(int index, Namespace ns) {
        this.constant_namespace.set(index, ns);
        return ns;
    }

    public NamespaceSet setNamespaceSet(int index, NamespaceSet nss) {
        this.constant_namespace_set.set(index, nss);
        return nss;
    }

    public Multiname setMultiname(int index, Multiname m) {
        this.constant_multiname.set(index, m);
        return m;
    }

    public long setUInt(int index, long value) {
        this.constant_uint.set(index, value);
        return value;
    }

    public double setDouble(int index, double value) {
        this.constant_double.set(index, value);
        return value;
    }

    public Decimal setDecimal(int index, Decimal value) {
        this.constant_decimal.set(index, value);
        return value;
    }

    public float setFloat(int index, float value) {
        this.constant_float.set(index, Float.valueOf(value));
        return value;
    }

    public Float4 setFloat4(int index, Float4 value) {
        this.constant_float4.set(index, value);
        return value;
    }

    public String setString(int index, String value) {
        this.constant_string.set(index, value);
        return value;
    }

    public long getInt(int index) {
        try {
            if (index == 0) {
                return 0L;
            }
            return (Long)this.constant_int.get(index);
        }
        catch (IndexOutOfBoundsException ex) {
            logger.log(Level.SEVERE, "Int not found. Index: " + index, ex);
            return 0L;
        }
    }

    public Namespace getNamespace(int index) {
        try {
            return (Namespace)this.constant_namespace.get(index);
        }
        catch (IndexOutOfBoundsException ex) {
            logger.log(Level.SEVERE, "Namespace not found. Index: " + index, ex);
            return null;
        }
    }

    public NamespaceSet getNamespaceSet(int index) {
        try {
            return (NamespaceSet)this.constant_namespace_set.get(index);
        }
        catch (IndexOutOfBoundsException ex) {
            logger.log(Level.SEVERE, "NamespaceSet not found. Index: " + index, ex);
            return null;
        }
    }

    public int convertToQname(AVM2ConstantPool cpool, int index) {
        Multiname mx = cpool.getMultiname(index);
        if (mx.isMULTINAMEwithOneNs(cpool)) {
            Multiname mx2 = new Multiname();
            mx2.kind = 7;
            mx2.name_index = mx.name_index;
            mx2.namespace_index = mx.getSingleNamespaceIndex(cpool);
            int newMultinameIndex = cpool.getMultinameId(mx2, false);
            if (newMultinameIndex > 0) {
                index = newMultinameIndex;
            }
        }
        return index;
    }

    public Multiname getMultiname(int index) {
        try {
            return (Multiname)this.constant_multiname.get(index);
        }
        catch (IndexOutOfBoundsException ex) {
            logger.log(Level.SEVERE, "Multiname not found. Index: " + index, ex);
            return null;
        }
    }

    public long getUInt(int index) {
        try {
            if (index == 0) {
                return 0L;
            }
            return (Long)this.constant_uint.get(index);
        }
        catch (IndexOutOfBoundsException ex) {
            logger.log(Level.SEVERE, "UInt not found. Index: " + index, ex);
            return 0L;
        }
    }

    public double getDouble(int index) {
        try {
            if (index == 0) {
                return 0.0;
            }
            return (Double)this.constant_double.get(index);
        }
        catch (IndexOutOfBoundsException ex) {
            logger.log(Level.SEVERE, "Double not found. Index: " + index, ex);
            return 0.0;
        }
    }

    public Decimal getDecimal(int index) {
        try {
            return (Decimal)this.constant_decimal.get(index);
        }
        catch (IndexOutOfBoundsException ex) {
            logger.log(Level.SEVERE, "Decimal not found. Index: " + index, ex);
            return null;
        }
    }

    public int getDecimalId(Decimal val, boolean add) {
        int id = this.getDecimalId(val);
        if (add && id == -1) {
            id = this.addDecimal(val);
        }
        return id;
    }

    public Float getFloat(int index) {
        try {
            return (Float)this.constant_float.get(index);
        }
        catch (IndexOutOfBoundsException ex) {
            logger.log(Level.SEVERE, "Float not found. Index: " + index, ex);
            return null;
        }
    }

    public Float4 getFloat4(int index) {
        try {
            return (Float4)this.constant_float4.get(index);
        }
        catch (IndexOutOfBoundsException ex) {
            logger.log(Level.SEVERE, "Float4 not found. Index: " + index, ex);
            return null;
        }
    }

    public String getString(int index) {
        try {
            return (String)this.constant_string.get(index);
        }
        catch (IndexOutOfBoundsException ex) {
            logger.log(Level.SEVERE, "String not found. Index: " + index, ex);
            return null;
        }
    }

    public int getIntCount() {
        return this.constant_int.size();
    }

    public int getNamespaceCount() {
        return this.constant_namespace.size();
    }

    public int getNamespaceSetCount() {
        return this.constant_namespace_set.size();
    }

    public int getMultinameCount() {
        return this.constant_multiname.size();
    }

    public int getUIntCount() {
        return this.constant_uint.size();
    }

    public int getDoubleCount() {
        return this.constant_double.size();
    }

    public int getDecimalCount() {
        return this.constant_decimal.size();
    }

    public int getFloatCount() {
        return this.constant_float.size();
    }

    public int getFloat4Count() {
        return this.constant_float4.size();
    }

    public int getStringCount() {
        return this.constant_string.size();
    }

    public int getNamespaceSubIndex(int namespaceId) {
        Namespace ns = (Namespace)this.constant_namespace.get(namespaceId);
        int index = 0;
        for (int n = 1; n < namespaceId; ++n) {
            if (((Namespace)this.constant_namespace.get((int)n)).name_index != ns.name_index || ((Namespace)this.constant_namespace.get((int)n)).kind != ns.kind) continue;
            ++index;
        }
        return index;
    }

    private int getNamespaceId(int kind, int nameIndex, int index) {
        for (int n = 1; n < this.constant_namespace.size(); ++n) {
            Namespace ns = (Namespace)this.constant_namespace.get(n);
            if (ns.name_index != nameIndex || ns.kind != kind) continue;
            if (index == 0) {
                return n;
            }
            --index;
        }
        return -1;
    }

    public int getNamespaceId(int kind, int nameIndex, int index, boolean add) {
        int id = this.getNamespaceId(kind, nameIndex, index);
        if (add && id == -1) {
            id = this.addNamespace(kind, nameIndex);
        }
        return id;
    }

    public int getNamespaceId(int kind, String name, int index, boolean add) {
        int nameIndex = this.getStringId(name, add);
        if (nameIndex == -1) {
            return -1;
        }
        return this.getNamespaceId(kind, nameIndex, index, add);
    }

    public int getNamespaceId(int kind, DottedChain name, int index, boolean add) {
        int nameIndex = this.getStringId(name, add);
        if (nameIndex == -1) {
            return -1;
        }
        return this.getNamespaceId(kind, nameIndex, index, add);
    }

    private int getIntId(long value) {
        return this.constant_int.indexOf(value);
    }

    private int getUIntId(long value) {
        return this.constant_uint.indexOf(value);
    }

    private int getDoubleId(double value) {
        return this.constant_double.indexOf(value);
    }

    private int getFloatId(float value) {
        return this.constant_float.indexOf(Float.valueOf(value));
    }

    private int getFloat4Id(Float4 value) {
        return this.constant_float4.indexOf(value);
    }

    private int getDecimalId(Decimal value) {
        return this.constant_decimal.indexOf(value);
    }

    private int getStringId(String value) {
        return this.constant_string.indexOf(value);
    }

    private int getMultinameId(Multiname value) {
        return this.constant_multiname.indexOf(value);
    }

    public int getQnameId(String name, int namespaceKind, String namespaceName, boolean add) {
        return this.getMultinameId(Multiname.createQName(false, this.getStringId(name, add), this.getNamespaceId(namespaceKind, namespaceName, 0, add)), add);
    }

    public int getPublicQnameId(String name, boolean add) {
        return this.getQnameId(name, 22, "", add);
    }

    public int getMultinameId(Multiname val, boolean add) {
        int id = this.getMultinameId(val);
        if (add && id == -1) {
            id = this.addMultiname(val);
        }
        return id;
    }

    public List<Integer> getMultinameIds(Multiname val, AVM2ConstantPool origConst) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 1; i < this.getMultinameCount(); ++i) {
            if (!this.getMultiname(i).qnameEquals(this, val, origConst)) continue;
            ret.add(i);
        }
        return ret;
    }

    public int getStringId(String val, boolean add) {
        if (val == null) {
            return 0;
        }
        int id = this.getStringId(val);
        if (add && id == -1) {
            id = this.addString(val);
        }
        return id;
    }

    public int getStringId(DottedChain val, boolean add) {
        if (val == null) {
            return 0;
        }
        return this.getStringId(val.toRawString(), add);
    }

    public int getIntId(long val, boolean add) {
        int id = this.getIntId(val);
        if (add && id == -1) {
            id = this.addInt(val);
        }
        return id;
    }

    private int getNamespaceSetId(int[] namespaces) {
        block0: for (int i = 1; i < this.constant_namespace_set.size(); ++i) {
            NamespaceSet ts = (NamespaceSet)this.constant_namespace_set.get(i);
            if (ts.namespaces.length != namespaces.length) continue;
            for (int j = 0; j < namespaces.length; ++j) {
                boolean found = false;
                for (int k = 0; k < namespaces.length; ++k) {
                    if (ts.namespaces[j] != namespaces[k]) continue;
                    found = true;
                    break;
                }
                if (!found) continue block0;
            }
            return i;
        }
        return -1;
    }

    public int getNamespaceSetId(int[] namespaces, boolean add) {
        int id = this.getNamespaceSetId(namespaces);
        if (add && id == -1) {
            id = this.addNamespaceSet(new NamespaceSet(namespaces));
        }
        return id;
    }

    public int getUIntId(long val, boolean add) {
        int id = this.getUIntId(val);
        if (add && id == -1) {
            id = this.addUInt(val);
        }
        return id;
    }

    public int getDoubleId(double val, boolean add) {
        int id = this.getDoubleId(val);
        if (add && id == -1) {
            id = this.addDouble(val);
        }
        return id;
    }

    public int getFloatId(float val, boolean add) {
        int id = this.getFloatId(val);
        if (add && id == -1) {
            id = this.addFloat(Float.valueOf(val));
        }
        return id;
    }

    public int getFloat4Id(Float4 val, boolean add) {
        int id = this.getFloat4Id(val);
        if (add && id == -1) {
            id = this.addFloat4(val);
        }
        return id;
    }

    public DottedChain getDottedChain(int index) {
        String str = this.getString(index);
        DottedChain chain = this.dottedChainCache.get(str);
        if (chain == null) {
            chain = DottedChain.parseWithSuffix(str);
            this.dottedChainCache.put(str, chain);
        }
        return chain;
    }

    public void dump(Utf8PrintWriter writer) {
        int i;
        for (i = 1; i < this.constant_int.size(); ++i) {
            writer.println("INT[" + i + "]=" + this.constant_int.get(i));
        }
        for (i = 1; i < this.constant_uint.size(); ++i) {
            writer.println("UINT[" + i + "]=" + this.constant_uint.get(i));
        }
        for (i = 1; i < this.constant_double.size(); ++i) {
            writer.println("Double[" + i + "]=" + this.constant_double.get(i));
        }
        for (i = 1; i < this.constant_string.size(); ++i) {
            writer.println("String[" + i + "]=" + (String)this.constant_string.get(i));
        }
        for (i = 1; i < this.constant_namespace.size(); ++i) {
            writer.println("Namespace[" + i + "]=" + ((Namespace)this.constant_namespace.get(i)).toString(this));
        }
        for (i = 1; i < this.constant_namespace_set.size(); ++i) {
            writer.println("NamespaceSet[" + i + "]=" + ((NamespaceSet)this.constant_namespace_set.get(i)).toString(this));
        }
        for (i = 1; i < this.constant_multiname.size(); ++i) {
            writer.println("Multiname[" + i + "]=" + ((Multiname)this.constant_multiname.get(i)).toString(this, new ArrayList<DottedChain>()));
        }
    }

    public String multinameToString(int index) {
        if (index == 0) {
            return "null";
        }
        return ((Multiname)this.constant_multiname.get(index)).toString(this, new ArrayList<DottedChain>());
    }

    public String namespaceToString(int index) {
        if (index == 0) {
            return "null";
        }
        return ((Namespace)this.constant_namespace.get(index)).toString(this);
    }

    public String namespaceSetToString(int index) {
        if (index == 0) {
            return "null";
        }
        return ((NamespaceSet)this.constant_namespace_set.get(index)).toString(this);
    }

    public AVM2ConstantPool clone() {
        try {
            AVM2ConstantPool ret = (AVM2ConstantPool)super.clone();
            ret.constant_int = new HashArrayList<Long>(this.constant_int);
            ret.constant_uint = new HashArrayList<Long>(this.constant_uint);
            ret.constant_double = new HashArrayList<Double>(this.constant_double);
            ret.constant_decimal = new HashArrayList<Decimal>(this.constant_decimal);
            ret.constant_float = new HashArrayList<Float>(this.constant_float);
            ret.constant_float4 = new HashArrayList<Float4>(this.constant_float4);
            ret.constant_string = new HashArrayList<String>(this.constant_string);
            ret.constant_namespace = new HashArrayList<Namespace>(this.constant_namespace);
            ret.constant_namespace_set = new HashArrayList<NamespaceSet>(this.constant_namespace_set);
            ret.constant_multiname = new HashArrayList<Multiname>(this.constant_multiname);
            ret.dottedChainCache = new HashMap<String, DottedChain>();
            return ret;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException();
        }
    }

    public AVM2Instruction makePush(Object ovalue) {
        if (ovalue instanceof Long) {
            long value = (Long)ovalue;
            if (value >= -128L && value <= 127L) {
                return new AVM2Instruction(0L, 36, new int[]{(int)value});
            }
            if (value >= -32768L && value <= 32767L) {
                return new AVM2Instruction(0L, 37, new int[]{(int)value & 0xFFFF});
            }
            return new AVM2Instruction(0L, 45, new int[]{this.getIntId(value, true)});
        }
        if (ovalue instanceof Double) {
            return new AVM2Instruction(0L, 47, new int[]{this.getDoubleId((Double)ovalue, true)});
        }
        if (ovalue instanceof String) {
            return new AVM2Instruction(0L, 44, new int[]{this.getStringId((String)ovalue, true)});
        }
        if (ovalue instanceof Boolean) {
            if (((Boolean)ovalue).booleanValue()) {
                return new AVM2Instruction(0L, 38, null);
            }
            return new AVM2Instruction(0L, 39, null);
        }
        if (ovalue == Null.INSTANCE) {
            return new AVM2Instruction(0L, 32, null);
        }
        if (ovalue == Undefined.INSTANCE) {
            return new AVM2Instruction(0L, 33, null);
        }
        return null;
    }

    public void merge(AVM2ConstantPool secondPool, Map<Integer, Integer> stringMap, Map<Integer, Integer> intMap, Map<Integer, Integer> uintMap, Map<Integer, Integer> doubleMap, Map<Integer, Integer> floatMap, Map<Integer, Integer> float4Map, Map<Integer, Integer> decimalMap, Map<Integer, Integer> namespaceMap, Map<Integer, Integer> namespaceSetMap, Map<Integer, Integer> multinameMap) {
        int newNameIndex;
        Object val;
        int i;
        stringMap.put(0, 0);
        for (i = 1; i < secondPool.constant_string.size(); ++i) {
            val = (String)secondPool.constant_string.get(i);
            stringMap.put(i, this.getStringId((String)val, true));
        }
        intMap.put(0, 0);
        for (i = 1; i < secondPool.constant_int.size(); ++i) {
            val = (Long)secondPool.constant_int.get(i);
            intMap.put(i, this.getIntId((Long)val, true));
        }
        uintMap.put(0, 0);
        for (i = 1; i < secondPool.constant_uint.size(); ++i) {
            val = (Long)secondPool.constant_uint.get(i);
            uintMap.put(i, this.getUIntId((Long)val, true));
        }
        doubleMap.put(0, 0);
        for (i = 1; i < secondPool.constant_double.size(); ++i) {
            val = (Double)secondPool.constant_double.get(i);
            doubleMap.put(i, this.getDoubleId((Double)val, true));
        }
        floatMap.put(0, 0);
        for (i = 1; i < secondPool.constant_float.size(); ++i) {
            val = (Float)secondPool.constant_float.get(i);
            floatMap.put(i, this.getFloatId(((Float)val).floatValue(), true));
        }
        float4Map.put(0, 0);
        for (i = 1; i < secondPool.constant_float4.size(); ++i) {
            val = (Float4)secondPool.constant_float4.get(i);
            float4Map.put(i, this.getFloat4Id((Float4)val, true));
        }
        decimalMap.put(0, 0);
        for (i = 1; i < secondPool.constant_decimal.size(); ++i) {
            val = (Decimal)secondPool.constant_decimal.get(i);
            decimalMap.put(i, this.getDecimalId((Decimal)val, true));
        }
        namespaceMap.put(0, 0);
        for (i = 1; i < secondPool.constant_namespace.size(); ++i) {
            Namespace secondNamespace = (Namespace)secondPool.constant_namespace.get(i);
            newNameIndex = stringMap.get(secondNamespace.name_index);
            int mappedId = secondNamespace.kind == 5 ? this.addNamespace(secondNamespace.kind, newNameIndex) : this.getNamespaceId(secondNamespace.kind, newNameIndex, 0, true);
            namespaceMap.put(i, mappedId);
        }
        namespaceSetMap.put(0, 0);
        for (i = 1; i < secondPool.constant_namespace_set.size(); ++i) {
            NamespaceSet secondNamespaceSet = (NamespaceSet)secondPool.constant_namespace_set.get(i);
            int[] mappedsNss = new int[secondNamespaceSet.namespaces.length];
            for (int n = 0; n < secondNamespaceSet.namespaces.length; ++n) {
                mappedsNss[n] = namespaceMap.get(secondNamespaceSet.namespaces[n]);
            }
            int mappedId = this.getNamespaceSetId(mappedsNss, true);
            namespaceSetMap.put(i, mappedId);
        }
        multinameMap.put(0, 0);
        for (i = 1; i < secondPool.constant_multiname.size(); ++i) {
            Multiname secondMultiname = (Multiname)secondPool.constant_multiname.get(i);
            Multiname newMultiname = null;
            newNameIndex = secondMultiname.name_index <= 0 ? secondMultiname.name_index : stringMap.get(secondMultiname.name_index);
            int newNsIndex = secondMultiname.namespace_index <= 0 ? secondMultiname.namespace_index : namespaceMap.get(secondMultiname.namespace_index);
            int newNssIndex = secondMultiname.namespace_set_index <= 0 ? secondMultiname.namespace_set_index : namespaceSetMap.get(secondMultiname.namespace_set_index);
            switch (secondMultiname.kind) {
                case 9: {
                    newMultiname = Multiname.createMultiname(false, newNameIndex, newNssIndex);
                    break;
                }
                case 14: {
                    newMultiname = Multiname.createMultiname(true, newNameIndex, newNssIndex);
                    break;
                }
                case 27: {
                    newMultiname = Multiname.createMultinameL(false, newNssIndex);
                    break;
                }
                case 28: {
                    newMultiname = Multiname.createMultinameL(true, newNssIndex);
                    break;
                }
                case 7: {
                    newMultiname = Multiname.createQName(false, newNameIndex, newNsIndex);
                    break;
                }
                case 13: {
                    newMultiname = Multiname.createQName(true, newNameIndex, newNsIndex);
                    break;
                }
                case 15: {
                    newMultiname = Multiname.createRTQName(false, newNameIndex);
                    break;
                }
                case 16: {
                    newMultiname = Multiname.createRTQName(true, newNameIndex);
                    break;
                }
                case 17: {
                    newMultiname = Multiname.createRTQNameL(false);
                    break;
                }
                case 18: {
                    newMultiname = Multiname.createRTQNameL(true);
                    break;
                }
                case 29: {
                    int newQnameIndex = multinameMap.get(secondMultiname.qname_index);
                    int[] newParams = new int[secondMultiname.params.length];
                    for (int p = 0; p < secondMultiname.params.length; ++p) {
                        newParams[p] = multinameMap.get(secondMultiname.params[p]);
                    }
                    newMultiname = Multiname.createTypeName(newQnameIndex, newParams);
                }
            }
            int mappedId = this.getMultinameId(newMultiname, true);
            multinameMap.put(i, mappedId);
        }
    }
}

