/******************************************************************************
 *            Copyright (c) 2006-2011 Michel Gutierrez. All Rights Reserved.
 ******************************************************************************/

onmessage = function(event) {
	try {
		if(typeof(event.data.Components)!="undefined")
			Components=event.data.Components;
		var exeFile=Components.classes["@mozilla.org/file/local;1"]
	                               	.createInstance(Components.interfaces.nsILocalFile);
		exeFile.initWithPath(event.data.exeFilePath);
		var process = Components.classes["@mozilla.org/process/util;1"]
		                                 .createInstance(Components.interfaces.nsIProcess);
		//dump("[ScapWorker] executing "+exeFile.path+"\n");
		if(!exeFile.exists()) {
			dump("!!! [ScapWorker] does not exist\n");
	       	this.postMessage({ exitValue: -123 });
	       	return;
		}
		if(!exeFile.isExecutable()) {
			dump("!!! [ScapWorker] is not executable\n");
	       	this.postMessage({ exitValue: -124 });
	       	return;
		}
		process.init(exeFile);
       	var args=[];
       	if(event.data.args.length>0)
       		args=event.data.args;
		//dump("[ScapWorker] onmessage: execute "+exeFile.path+" "+args.join(" ")+"\n");
       	process.runw(true, args, args.length,{});
       	this.postMessage({ exitValue: process.exitValue });
	} catch(e) {
		dump("!!! [ScapWorker] onmessage: "+e+"\n");
	}
};
