/*
 * Decompiled with CFR 0.152.
 */
package anon.mixminion.fec;

import anon.mixminion.fec.FECCode;
import anon.mixminion.fec.FECMath;
import anon.util.ByteArrayUtil;

public class PureCode
extends FECCode {
    public static final int FEC_MAGIC = -20181524;
    protected static final FECMath fecMath = new FECMath(8);
    protected char[] encMatrix;

    public PureCode(int n, int n2) {
        this(n, n2, fecMath.createEncodeMatrix(n, n2));
    }

    public PureCode(int n, int n2, char[] cArray) {
        super(n, n2);
        this.encMatrix = cArray;
    }

    public void encode(byte[][] byArray, int[] nArray, byte[][] byArray2, int[] nArray2, int[] nArray3, int n) {
        for (int i = 0; i < byArray2.length; ++i) {
            this.encode(byArray, nArray, byArray2[i], nArray2[i], nArray3[i], n);
        }
    }

    protected void encode(byte[][] byArray, int[] nArray, byte[] byArray2, int n, int n2, int n3) {
        if (n2 < this.k) {
            System.arraycopy(byArray[n2], nArray[n2], byArray2, n, n3);
        } else {
            int n4 = n2 * this.k;
            ByteArrayUtil.bzero(byArray2, n, n3);
            for (int i = 0; i < this.k; ++i) {
                fecMath.addMul(byArray2, n, byArray[i], nArray[i], (byte)this.encMatrix[n4 + i], n3);
            }
        }
    }

    public void decode(byte[][] byArray, int[] nArray, int[] nArray2, int n, boolean bl) {
        int n2;
        if (!bl) {
            FECCode.shuffle(byArray, nArray, nArray2, this.k);
        }
        char[] cArray = fecMath.createDecodeMatrix(this.encMatrix, nArray2, this.k, this.n);
        byte[][] byArrayArray = new byte[this.k][];
        for (n2 = 0; n2 < this.k; ++n2) {
            if (nArray2[n2] < this.k) continue;
            byArrayArray[n2] = new byte[n];
            for (int i = 0; i < this.k; ++i) {
                fecMath.addMul(byArrayArray[n2], 0, byArray[i], nArray[i], (byte)cArray[n2 * this.k + i], n);
            }
        }
        for (n2 = 0; n2 < this.k; ++n2) {
            if (nArray2[n2] < this.k) continue;
            System.arraycopy(byArrayArray[n2], 0, byArray[n2], nArray[n2], n);
            nArray2[n2] = n2;
        }
    }

    public String toString() {
        return new String("PureCode[k=" + this.k + ",n=" + this.n + "]");
    }
}

