/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.apply.modules;

import com.pnf.androsig.apply.matcher.ContextMatches;
import com.pnf.androsig.apply.matcher.DatabaseMatcherParameters;
import com.pnf.androsig.apply.matcher.DatabaseReferenceFile;
import com.pnf.androsig.apply.matcher.FileMatches;
import com.pnf.androsig.apply.matcher.IAndrosigModule;
import com.pnf.androsig.apply.matcher.MatchingSearch;
import com.pnf.androsig.apply.model.DatabaseReference;
import com.pnf.androsig.apply.model.DexHashcodeList;
import com.pnf.androsig.apply.model.MethodSignature;
import com.pnf.androsig.apply.modules.AbstractModule;
import com.pnf.androsig.apply.util.DexUtilLocal;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexClass;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexPrototype;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ReverseMatchingModule
extends AbstractModule {
    private DatabaseMatcherParameters params;
    private List<IAndrosigModule> modules;

    public ReverseMatchingModule(ContextMatches contextMatches, FileMatches fileMatches, DatabaseReference ref, DatabaseMatcherParameters params, List<IAndrosigModule> modules) {
        super(contextMatches, fileMatches, ref);
        this.params = params;
        this.modules = modules;
    }

    @Override
    public void initNewPass(IDexUnit unit, DexHashcodeList dexHashCodeList, boolean firstRound) {
    }

    @Override
    public Map<Integer, String> postProcessRenameClasses(IDexUnit dex, DexHashcodeList dexHashCodeList, boolean firstRound) {
        if (!firstRound) {
            Map<DatabaseReferenceFile, List<ClassInfo>> mostUsed = this.getMostUsedFiles();
            MatchingSearch mSearch = new MatchingSearch(dex, dexHashCodeList, this.ref, this.params, this.fileMatches, this.modules, firstRound, false);
            List classes = dex.getClasses();
            for (Map.Entry<DatabaseReferenceFile, List<ClassInfo>> entry : mostUsed.entrySet()) {
                for (ClassInfo cl : entry.getValue()) {
                    HashMap bestCandidate = new HashMap();
                    IDexClass classCandidate = null;
                    ArrayList<MethodSignature> alreadyMatches = new ArrayList<MethodSignature>();
                    HashMap<Integer, MethodSignature> current = new HashMap<Integer, MethodSignature>();
                    long t0 = System.currentTimeMillis();
                    for (IDexClass eClass : classes) {
                        List methods;
                        if (this.hasMatchedClass(eClass.getIndex()) || (methods = eClass.getMethods()) == null || methods.size() == 0 || methods.size() < this.params.reverseMatchingMethodThreshold || methods.size() > cl.distinctSignaturesSize) continue;
                        for (IDexMethod m : methods) {
                            MethodSignature sig;
                            if (!m.isInternal() || (sig = mSearch.findMethodName(cl.signatures, cl.classname, alreadyMatches, m)) == null || Strings.isBlank((String)sig.getMname()) || Strings.isBlank((String)sig.getPrototype())) continue;
                            alreadyMatches.add(sig);
                            current.put(m.getIndex(), sig);
                        }
                        if (current.size() <= bestCandidate.size()) continue;
                        bestCandidate = current;
                        classCandidate = eClass;
                    }
                    System.out.println("took " + (System.currentTimeMillis() - t0));
                    if (bestCandidate.size() < this.params.reverseMatchingMethodThreshold) continue;
                    int nbObjParam = 0;
                    for (Map.Entry en : bestCandidate.entrySet()) {
                        String[] mparams = ((MethodSignature)en.getValue()).getPrototype().substring(1).split("\\)");
                        List<String> mparamsList = DexUtilLocal.parseSignatureParameters(mparams[0]);
                        mparamsList.add(mparams[1]);
                        IDexPrototype proto = dex.getPrototype(dex.getMethod(((Integer)en.getKey()).intValue()).getPrototypeIndex());
                        String prototypes = proto.generate(true);
                        String[] realParams = prototypes.substring(1).split("\\)");
                        List<String> realParamList = DexUtilLocal.parseSignatureParameters(realParams[0]);
                        realParamList.add(realParams[1]);
                        for (int i = 0; i < mparamsList.size(); ++i) {
                            String p = mparamsList.get(i);
                            String r = realParamList.get(i);
                            if (p.length() == 1 || p.equals("Ljava/lang/Object;") || p.equals("Ljava/lang/String;") || !p.equals(r)) continue;
                            ++nbObjParam;
                        }
                    }
                    if (nbObjParam < this.params.reverseMatchingComplexObjectThreshold) continue;
                    this.saveClassMatchInherit(classCandidate.getSignature(true), cl.classname, "");
                }
            }
        }
        return new HashMap<Integer, String>();
    }

    @Override
    public Map<Integer, String> postProcessRenameMethods(IDexUnit unit, DexHashcodeList dexHashCodeList, boolean firstRound) {
        return new HashMap<Integer, String>();
    }

    @Override
    public Set<MethodSignature> filterList(IDexUnit dex, IDexMethod eMethod, List<MethodSignature> results) {
        return null;
    }

    private int getDistinctSignaturesSize(List<MethodSignature> signatures) {
        HashSet<String> distinctSignature = new HashSet<String>();
        for (MethodSignature m : signatures) {
            distinctSignature.add(m.getMname() + m.getPrototype());
        }
        return distinctSignature.size();
    }

    private ClassInfo buildClassInfo(DatabaseReferenceFile refFile, String classname) {
        if (this.containsMatchedClassValue(classname)) {
            return null;
        }
        List<MethodSignature> signatures = this.getSignaturesForClassname(refFile, classname);
        int distinctSignaturesSize = 0;
        if (signatures.size() < this.params.reverseMatchingMethodThreshold || (distinctSignaturesSize = this.getDistinctSignaturesSize(signatures)) < this.params.reverseMatchingMethodThreshold) {
            return null;
        }
        ClassInfo cl = new ClassInfo();
        cl.classname = classname;
        cl.signatures = signatures;
        cl.distinctSignaturesSize = distinctSignaturesSize;
        return cl;
    }

    private Map<DatabaseReferenceFile, List<ClassInfo>> getMostUsedFiles() {
        HashMap<DatabaseReferenceFile, Integer> fileOccurences = new HashMap<DatabaseReferenceFile, Integer>();
        for (Map.Entry<Integer, String> entry : this.fileMatches.entrySetMatchedClasses()) {
            DatabaseReferenceFile refFile = this.getFileFromClassId(entry.getKey());
            if (refFile == null) continue;
            Integer occ = (Integer)fileOccurences.get(refFile);
            occ = occ == null ? 1 : occ + 1;
            fileOccurences.put(refFile, occ);
        }
        HashMap<DatabaseReferenceFile, List<ClassInfo>> res = new HashMap<DatabaseReferenceFile, List<ClassInfo>>();
        for (Map.Entry entry : fileOccurences.entrySet()) {
            if ((Integer)entry.getValue() < this.params.reverseMatchingClassThreshold) continue;
            List<String> classes = this.ref.getClassList(((DatabaseReferenceFile)entry.getKey()).file);
            classes = classes.stream().filter(cl -> !DexUtilLocal.isInnerClass(cl)).collect(Collectors.toList());
            if (!(((Integer)entry.getValue()).doubleValue() / (double)classes.size() >= this.params.reverseMatchingFoundClassPercentage)) continue;
            ArrayList<ClassInfo> clInfoList = new ArrayList<ClassInfo>();
            res.put((DatabaseReferenceFile)entry.getKey(), (List<ClassInfo>)clInfoList);
            for (String cl2 : classes) {
                ClassInfo clInfo = this.buildClassInfo((DatabaseReferenceFile)entry.getKey(), cl2);
                if (clInfo == null) continue;
                clInfoList.add(clInfo);
            }
        }
        return res;
    }

    private class ClassInfo {
        public String classname;
        public List<MethodSignature> signatures;
        public int distinctSignaturesSize;

        private ClassInfo() {
        }
    }
}

