/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.unit;

import com.pnf.plugin.pdf.AddressUtils;
import com.pnf.plugin.pdf.PdfFileUnit;
import com.pnf.plugin.pdf.PdfStatistics;
import com.pnf.plugin.pdf.obj.PdfStream;
import com.pnf.plugin.pdf.unit.AbstractStreamUnit;
import com.pnfsoftware.jeb.core.input.BytesInput;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.output.AbstractTransientUnitRepresentation;
import com.pnfsoftware.jeb.core.output.IGenericDocument;
import com.pnfsoftware.jeb.core.output.IUnitDocumentPresentation;
import com.pnfsoftware.jeb.core.output.IUnitFormatter;
import com.pnfsoftware.jeb.core.output.UnitFormatterUtil;
import com.pnfsoftware.jeb.core.output.text.impl.AsciiDocument;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class BinaryStreamUnit
extends AbstractStreamUnit {
    @SerId(value=1)
    boolean decode;

    public BinaryStreamUnit(IUnit parent, PdfStatistics statistics, PdfStream stream, String identifier, boolean decode) {
        super(parent, statistics, stream, identifier);
        this.decode = decode;
    }

    public BinaryStreamUnit(PdfFileUnit parent, PdfStream stream, String identifier, boolean decode) {
        super((IUnit)parent, parent.getStatistics(), stream, identifier);
        this.decode = decode;
    }

    public boolean process() {
        this.setProcessed(true);
        return true;
    }

    @Override
    public IUnitFormatter getFormatter() {
        IUnitFormatter formatter = super.getFormatter();
        if (this.decode) {
            String docLabel = "Decoded Stream";
            final String defaultText = this.stream.getAsText();
            if (this.getInput().getCurrentSize() != 0L && UnitFormatterUtil.getPresentationByName((IUnitFormatter)formatter, (String)"Decoded Stream") == null) {
                if (defaultText != null) {
                    formatter.insertPresentation(0, (IUnitDocumentPresentation)new AbstractTransientUnitRepresentation("Decoded Stream", true){

                        public IGenericDocument createDocument() {
                            return new AsciiDocument((IInput)new BytesInput(defaultText.getBytes()));
                        }
                    }, false);
                } else {
                    formatter.insertPresentation(0, (IUnitDocumentPresentation)new AbstractTransientUnitRepresentation("Decoded Stream", true){

                        public IGenericDocument createDocument() {
                            return new AsciiDocument(BinaryStreamUnit.this.getInput());
                        }
                    }, false);
                }
            }
        }
        return formatter;
    }

    public String getDescription() {
        StringBuilder description = new StringBuilder(super.getDescription());
        description.append("- Obj start Address: ").append(this.stream.getParent().getStartIndex());
        description.append("\n- Stream start Address: ").append(this.stream.getStartIndex());
        description.append("\n- Stream parsed length: ").append(this.stream.getParsedLength());
        Integer dictionaryLength = this.stream.getLengthFromDictionary();
        if (dictionaryLength == null) {
            description.append("\n- Stream has no length defined");
        } else {
            description.append("\n- Stream length: ").append(dictionaryLength);
        }
        return description.toString();
    }

    @Override
    public AddressUtils getAddressUtils() {
        return null;
    }
}

