/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf;

import com.pnf.plugin.pdf.PdfStatistics;
import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfDictionary;
import com.pnf.plugin.pdf.obj.PdfIndirectObj;
import com.pnf.plugin.pdf.obj.PdfIndirectReference;
import com.pnf.plugin.pdf.obj.PdfStream;
import com.pnf.plugin.pdf.obj.PdfTrailer;
import com.pnfsoftware.jeb.core.units.IUnitNotification;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.List;

public class PdfFormatter {
    public static String displayValue(IPdfAttribute attribute, List<IUnitNotification> notifications) {
        if (attribute == null) {
            return "";
        }
        switch (attribute.getType()) {
            case Array: {
                return PdfFormatter.toStringWithSuspiciousType("", attribute, notifications);
            }
            case IndirectReference: {
                return PdfFormatter.toStringWithSuspiciousType(((PdfIndirectReference)attribute).getId().toString(), attribute, notifications);
            }
            case Stream: {
                return PdfFormatter.toStringWithSuspiciousType(PdfFormatter.displayStream((PdfStream)attribute), attribute, notifications);
            }
            case Dictionary: {
                String dictionaryType = ((PdfDictionary)attribute).getDictionaryFullType();
                if (attribute.getParent() != null && attribute.getParent().getType() == IPdfAttribute.Type.Trailer) {
                    dictionaryType = "@" + ((PdfTrailer)attribute.getParent()).getStartIndex();
                }
                return PdfFormatter.toStringWithSuspiciousType(dictionaryType == null ? "" : dictionaryType, attribute, notifications);
            }
            case IndirectObject: 
            case IndirectObjectStream: {
                IPdfAttribute subattribute = ((PdfIndirectObj)attribute).getAttribute();
                if (subattribute.getType() == IPdfAttribute.Type.Stream) {
                    return PdfFormatter.toStringWithSuspiciousType(PdfFormatter.displayStream((PdfStream)subattribute), attribute, notifications);
                }
                return PdfFormatter.toStringWithSuspiciousType("", attribute, notifications);
            }
        }
        return PdfFormatter.toStringWithSuspiciousType(attribute.toString(), attribute, notifications);
    }

    private static String displayStream(PdfStream attribute) {
        if (attribute.isObjStm()) {
            return String.format("%s (%s)", attribute.getStreamType(), Strings.join((String)";", attribute.getObjStmId()));
        }
        return attribute.getStreamType();
    }

    private static String toStringWithSuspiciousType(String prefix, IPdfAttribute attribute, List<IUnitNotification> notifications) {
        return String.format("%s %s", prefix, PdfFormatter.toString(notifications, attribute));
    }

    private static String toString(List<IUnitNotification> notifications, IPdfAttribute attribute) {
        if (notifications == null || notifications.isEmpty()) {
            return "";
        }
        return String.format("[%s]", PdfStatistics.toString(notifications));
    }
}

