/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf;

import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfArray;
import com.pnf.plugin.pdf.obj.PdfDictionary;
import com.pnf.plugin.pdf.obj.PdfDictionaryAttribute;
import com.pnf.plugin.pdf.obj.PdfIndirectObj;
import com.pnf.plugin.pdf.obj.PdfIndirectReference;
import com.pnf.plugin.pdf.obj.PdfObjId;
import com.pnf.plugin.pdf.obj.PdfStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CrossReferences {
    private Map<Long, List<String>> crossReferences = new HashMap<Long, List<String>>();

    public CrossReferences(List<PdfIndirectObj> objList) {
        int i = 0;
        for (PdfIndirectObj obj : objList) {
            String prefix = String.valueOf(i);
            this.addCrossReference(obj.getId(), prefix);
            this.parseChild(obj.getAttribute(), prefix);
            ++i;
        }
    }

    public void parseChildren(List<IPdfAttribute> attributes, String prefix) {
        int i = 0;
        for (IPdfAttribute attribute : attributes) {
            String prefixAttr = this.addAddress(prefix, i);
            this.parseChild(attribute, prefixAttr);
            ++i;
        }
    }

    public void parseChild(IPdfAttribute attribute, String prefix) {
        switch (attribute.getType()) {
            case Array: {
                List<IPdfAttribute> arrayAttributes = ((PdfArray)attribute).getAttributes();
                for (int j = 0; j < arrayAttributes.size(); ++j) {
                    this.parseChild(arrayAttributes.get(j), this.addAddress(prefix, j));
                }
                break;
            }
            case Boolean: 
            case Name: 
            case Null: 
            case Number: 
            case String: 
            case Unknown: {
                break;
            }
            case IndirectReference: {
                PdfObjId idRef = ((PdfIndirectReference)attribute).getId();
                this.addCrossReference(idRef, prefix);
                break;
            }
            case Stream: {
                this.parseDictionaryChildren(((PdfStream)attribute).getDictionary().getAttributes(), prefix);
                break;
            }
            case Dictionary: {
                this.parseDictionaryChildren(((PdfDictionary)attribute).getAttributes(), prefix);
                break;
            }
        }
    }

    public void parseDictionaryChildren(List<PdfDictionaryAttribute> attributes, String prefix) {
        int i = 0;
        for (PdfDictionaryAttribute attribute : attributes) {
            String prefixAttr = this.addAddress(prefix, i);
            switch (attribute.getValue().getType()) {
                case Array: {
                    this.parseChild(attribute.getValue(), prefixAttr);
                    break;
                }
                case Boolean: 
                case Name: 
                case Null: 
                case Number: 
                case String: 
                case Unknown: {
                    break;
                }
                case IndirectReference: {
                    PdfObjId idRef = ((PdfIndirectReference)attribute.getValue()).getId();
                    this.addCrossReference(idRef, prefixAttr);
                    break;
                }
                case Stream: 
                case Dictionary: {
                    this.parseChild(attribute.getValue(), prefixAttr);
                    break;
                }
            }
            ++i;
        }
    }

    private String addAddress(String prefix, int line) {
        return prefix + "/" + line;
    }

    private void addCrossReference(PdfObjId id, String address) {
        List<String> addresses = this.crossReferences.get(id.getObjectNumber());
        if (addresses == null) {
            addresses = new ArrayList<String>();
            this.crossReferences.put(Long.valueOf(id.getObjectNumber()), addresses);
        }
        addresses.add(address);
    }

    public List<String> getCrossReference(long itemId) {
        return this.crossReferences.get(itemId);
    }
}

