/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.util;

import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ColorsGradient {
    private static final Map<String, Integer> colors = new LinkedHashMap<String, Integer>();
    private static List<Integer> rgbvalues;

    private static int get(String colorName, boolean loose) {
        if (colorName == null) {
            return 0;
        }
        Integer v = colors.get(colorName = Strings.trim(colorName).toLowerCase());
        if (v == null && !colorName.endsWith("*")) {
            v = colors.get(colorName + "*");
        }
        if (v == null && loose) {
            for (String key : colors.keySet()) {
                if (!key.contains(colorName)) continue;
                v = colors.get(key);
                break;
            }
        }
        return v == null ? 0 : v;
    }

    public static int get(String colorName) {
        return ColorsGradient.get(colorName, false);
    }

    public static int getx(String colorName) {
        return ColorsGradient.get(colorName, true);
    }

    public static Map<String, Integer> getAll() {
        return Collections.unmodifiableMap(colors);
    }

    public static Iterator<Integer> getSequentialIterator() {
        return ColorsGradient.getSequentialIterator(0, 1);
    }

    public static Iterator<Integer> getSequentialIterator(int start, int increment) {
        return new InfiIter(start, increment);
    }

    public static Iterator<Integer> getRandomIterator() {
        return new RandomIter();
    }

    static {
        colors.put("indian red", 11540255);
        colors.put("crimson", 14423100);
        colors.put("lightpink", 16758465);
        colors.put("lightpink 1", 16756409);
        colors.put("lightpink 2", 15639213);
        colors.put("lightpink 3", 13470869);
        colors.put("lightpink 4", 9133925);
        colors.put("pink", 16761035);
        colors.put("pink 1", 16758213);
        colors.put("pink 2", 15641016);
        colors.put("pink 3", 13472158);
        colors.put("pink 4", 9134956);
        colors.put("palevioletred", 14381203);
        colors.put("palevioletred 1", 16745131);
        colors.put("palevioletred 2", 15628703);
        colors.put("palevioletred 3", 13461641);
        colors.put("palevioletred 4", 9127773);
        colors.put("lavenderblush 1 (lavenderblush)", 0xFFF0F5);
        colors.put("lavenderblush 2", 0xEEE0E5);
        colors.put("lavenderblush 3", 13484485);
        colors.put("lavenderblush 4", 9143174);
        colors.put("violetred 1", 16727702);
        colors.put("violetred 2", 15612556);
        colors.put("violetred 3", 13447800);
        colors.put("violetred 4", 9118290);
        colors.put("hotpink", 16738740);
        colors.put("hotpink 1", 16740020);
        colors.put("hotpink 2", 15624871);
        colors.put("hotpink 3", 13459600);
        colors.put("hotpink 4", 9124450);
        colors.put("raspberry", 8857175);
        colors.put("deeppink 1 (deeppink)", 16716947);
        colors.put("deeppink 2", 15602313);
        colors.put("deeppink 3", 13439094);
        colors.put("deeppink 4", 9112144);
        colors.put("maroon 1", 16725171);
        colors.put("maroon 2", 15610023);
        colors.put("maroon 3", 13445520);
        colors.put("maroon 4", 9116770);
        colors.put("mediumvioletred", 13047173);
        colors.put("violetred", 13639824);
        colors.put("orchid", 14315734);
        colors.put("orchid 1", 16745466);
        colors.put("orchid 2", 15629033);
        colors.put("orchid 3", 13461961);
        colors.put("orchid 4", 9127817);
        colors.put("thistle", 14204888);
        colors.put("thistle 1", 0xFFE1FF);
        colors.put("thistle 2", 0xEED2EE);
        colors.put("thistle 3", 13481421);
        colors.put("thistle 4", 0x8B7B8B);
        colors.put("plum 1", 0xFFBBFF);
        colors.put("plum 2", 0xEEAEEE);
        colors.put("plum 3", 13473485);
        colors.put("plum 4", 0x8B668B);
        colors.put("plum", 0xDDA0DD);
        colors.put("violet", 0xEE82EE);
        colors.put("magenta (fuchsia*)", 0xFF00FF);
        colors.put("magenta*", 0xFF00FF);
        colors.put("magenta 2", 0xEE00EE);
        colors.put("magenta 3", 0xCD00CD);
        colors.put("magenta 4 (darkmagenta)", 0x8B008B);
        colors.put("purple*", 0x800080);
        colors.put("mediumorchid", 12211667);
        colors.put("mediumorchid 1", 14706431);
        colors.put("mediumorchid 2", 13721582);
        colors.put("mediumorchid 3", 11817677);
        colors.put("mediumorchid 4", 8009611);
        colors.put("darkviolet", 9699539);
        colors.put("darkorchid", 10040012);
        colors.put("darkorchid 1", 12533503);
        colors.put("darkorchid 2", 11680494);
        colors.put("darkorchid 3", 10105549);
        colors.put("darkorchid 4", 6824587);
        colors.put("indigo", 4915330);
        colors.put("blueviolet", 9055202);
        colors.put("purple 1", 10170623);
        colors.put("purple 2", 9514222);
        colors.put("purple 3", 8201933);
        colors.put("purple 4", 5577355);
        colors.put("mediumpurple", 9662683);
        colors.put("mediumpurple 1", 11240191);
        colors.put("mediumpurple 2", 10451438);
        colors.put("mediumpurple 3", 9005261);
        colors.put("mediumpurple 4", 6113163);
        colors.put("darkslateblue", 4734347);
        colors.put("lightslateblue", 8679679);
        colors.put("mediumslateblue", 8087790);
        colors.put("slateblue", 6970061);
        colors.put("slateblue 1", 8613887);
        colors.put("slateblue 2", 8021998);
        colors.put("slateblue 3", 6904269);
        colors.put("slateblue 4", 4668555);
        colors.put("ghostwhite", 0xF8F8FF);
        colors.put("lavender", 15132410);
        colors.put("blue*", 255);
        colors.put("blue 2", 238);
        colors.put("blue 3 (mediumblue)", 205);
        colors.put("blue 4 (darkblue)", 139);
        colors.put("navy*", 128);
        colors.put("midnightblue", 1644912);
        colors.put("cobalt", 4020651);
        colors.put("royalblue", 4286945);
        colors.put("royalblue 1", 4749055);
        colors.put("royalblue 2", 4419310);
        colors.put("royalblue 3", 3825613);
        colors.put("royalblue 4", 2572427);
        colors.put("cornflowerblue", 6591981);
        colors.put("lightsteelblue", 11584734);
        colors.put("lightsteelblue 1", 13296127);
        colors.put("lightsteelblue 2", 12374766);
        colors.put("lightsteelblue 3", 10663373);
        colors.put("lightsteelblue 4", 7240587);
        colors.put("lightslategray", 0x778899);
        colors.put("slategray", 7372944);
        colors.put("slategray 1", 13034239);
        colors.put("slategray 2", 12178414);
        colors.put("slategray 3", 10467021);
        colors.put("slategray 4", 7109515);
        colors.put("dodgerblue 1 (dodgerblue)", 2003199);
        colors.put("dodgerblue 2", 1869550);
        colors.put("dodgerblue 3", 1602765);
        colors.put("dodgerblue 4", 1068683);
        colors.put("aliceblue", 0xF0F8FF);
        colors.put("steelblue", 4620980);
        colors.put("steelblue 1", 6535423);
        colors.put("steelblue 2", 6073582);
        colors.put("steelblue 3", 5215437);
        colors.put("steelblue 4", 3564683);
        colors.put("lightskyblue", 8900346);
        colors.put("lightskyblue 1", 11592447);
        colors.put("lightskyblue 2", 10802158);
        colors.put("lightskyblue 3", 9287373);
        colors.put("lightskyblue 4", 6323083);
        colors.put("skyblue 1", 8900351);
        colors.put("skyblue 2", 8306926);
        colors.put("skyblue 3", 7120589);
        colors.put("skyblue 4", 4878475);
        colors.put("skyblue", 8900331);
        colors.put("deepskyblue 1 (deepskyblue)", 49151);
        colors.put("deepskyblue 2", 45806);
        colors.put("deepskyblue 3", 39629);
        colors.put("deepskyblue 4", 26763);
        colors.put("peacock", 3383753);
        colors.put("lightblue", 11393254);
        colors.put("lightblue 1", 0xBFEFFF);
        colors.put("lightblue 2", 11722734);
        colors.put("lightblue 3", 10141901);
        colors.put("lightblue 4", 6849419);
        colors.put("powderblue", 11591910);
        colors.put("cadetblue 1", 10024447);
        colors.put("cadetblue 2", 0x8EE5EE);
        colors.put("cadetblue 3", 8046029);
        colors.put("cadetblue 4", 5473931);
        colors.put("turquoise 1", 62975);
        colors.put("turquoise 2", 58862);
        colors.put("turquoise 3", 50637);
        colors.put("turquoise 4", 34443);
        colors.put("cadetblue", 6266528);
        colors.put("darkturquoise", 52945);
        colors.put("azure 1 (azure)", 0xF0FFFF);
        colors.put("azure 2", 0xE0EEEE);
        colors.put("azure 3", 0xC1CDCD);
        colors.put("azure 4", 0x838B8B);
        colors.put("lightcyan 1 (lightcyan)", 0xE0FFFF);
        colors.put("lightcyan 2", 0xD1EEEE);
        colors.put("lightcyan 3", 11849165);
        colors.put("lightcyan 4", 8031115);
        colors.put("paleturquoise 1", 0xBBFFFF);
        colors.put("paleturquoise 2 (paleturquoise)", 0xAEEEEE);
        colors.put("paleturquoise 3", 9883085);
        colors.put("paleturquoise 4", 0x668B8B);
        colors.put("darkslategray", 0x2F4F4F);
        colors.put("darkslategray 1", 0x97FFFF);
        colors.put("darkslategray 2", 0x8DEEEE);
        colors.put("darkslategray 3", 7982541);
        colors.put("darkslategray 4", 5409675);
        colors.put("cyan / aqua*", 65535);
        colors.put("cyan*", 65535);
        colors.put("cyan 2", 61166);
        colors.put("cyan 3", 52685);
        colors.put("cyan 4 (darkcyan)", 35723);
        colors.put("teal*", 32896);
        colors.put("mediumturquoise", 4772300);
        colors.put("lightseagreen", 2142890);
        colors.put("manganeseblue", 239774);
        colors.put("turquoise", 4251856);
        colors.put("coldgrey", 8424071);
        colors.put("turquoiseblue", 51084);
        colors.put("aquamarine 1 (aquamarine)", 8388564);
        colors.put("aquamarine 2", 7794374);
        colors.put("aquamarine 3 (mediumaquamarine)", 6737322);
        colors.put("aquamarine 4", 4557684);
        colors.put("mediumspringgreen", 64154);
        colors.put("mintcream", 0xF5FFFA);
        colors.put("springgreen", 65407);
        colors.put("springgreen 1", 61046);
        colors.put("springgreen 2", 52582);
        colors.put("springgreen 3", 35653);
        colors.put("mediumseagreen", 3978097);
        colors.put("seagreen 1", 5570463);
        colors.put("seagreen 2", 0x4EEE94);
        colors.put("seagreen 3", 4443520);
        colors.put("seagreen 4 (seagreen)", 3050327);
        colors.put("emeraldgreen", 51543);
        colors.put("mint", 12451017);
        colors.put("cobaltgreen", 4034880);
        colors.put("honeydew 1 (honeydew)", 0xF0FFF0);
        colors.put("honeydew 2", 0xE0EEE0);
        colors.put("honeydew 3", 0xC1CDC1);
        colors.put("honeydew 4", 0x838B83);
        colors.put("darkseagreen", 9419919);
        colors.put("darkseagreen 1", 0xC1FFC1);
        colors.put("darkseagreen 2", 0xB4EEB4);
        colors.put("darkseagreen 3", 10210715);
        colors.put("darkseagreen 4", 6916969);
        colors.put("palegreen", 10025880);
        colors.put("palegreen 1", 0x9AFF9A);
        colors.put("palegreen 2 (lightgreen)", 0x90EE90);
        colors.put("palegreen 3", 0x7CCD7C);
        colors.put("palegreen 4", 5540692);
        colors.put("limegreen", 3329330);
        colors.put("forestgreen", 0x228B22);
        colors.put("green 1 (lime*)", 65280);
        colors.put("lime*", 65280);
        colors.put("green 2", 60928);
        colors.put("green 3", 52480);
        colors.put("green 4", 35584);
        colors.put("green*", 32768);
        colors.put("darkgreen", 25600);
        colors.put("sapgreen", 3178516);
        colors.put("lawngreen", 8190976);
        colors.put("chartreuse 1 (chartreuse)", 0x7FFF00);
        colors.put("chartreuse 2", 7794176);
        colors.put("chartreuse 3", 6737152);
        colors.put("chartreuse 4", 4557568);
        colors.put("greenyellow", 11403055);
        colors.put("darkolivegreen 1", 13303664);
        colors.put("darkolivegreen 2", 12381800);
        colors.put("darkolivegreen 3", 10669402);
        colors.put("darkolivegreen 4", 7244605);
        colors.put("darkolivegreen", 5597999);
        colors.put("olivedrab", 7048739);
        colors.put("olivedrab 1", 12648254);
        colors.put("olivedrab 2", 11791930);
        colors.put("olivedrab 3 (yellowgreen)", 10145074);
        colors.put("olivedrab 4", 6916898);
        colors.put("ivory 1 (ivory)", 0xFFFFF0);
        colors.put("ivory 2", 0xEEEEE0);
        colors.put("ivory 3", 0xCDCDC1);
        colors.put("ivory 4", 0x8B8B83);
        colors.put("beige", 16119260);
        colors.put("lightyellow 1 (lightyellow)", 0xFFFFE0);
        colors.put("lightyellow 2", 0xEEEED1);
        colors.put("lightyellow 3", 13487540);
        colors.put("lightyellow 4", 9145210);
        colors.put("lightgoldenrodyellow", 16448210);
        colors.put("yellow 1 (yellow*)", 0xFFFF00);
        colors.put("yellow*", 0xFFFF00);
        colors.put("yellow 2", 0xEEEE00);
        colors.put("yellow 3", 0xCDCD00);
        colors.put("yellow 4", 0x8B8B00);
        colors.put("warmgrey", 8421481);
        colors.put("olive*", 0x808000);
        colors.put("darkkhaki", 12433259);
        colors.put("khaki 1", 0xFFF68F);
        colors.put("khaki 2", 15656581);
        colors.put("khaki 3", 13485683);
        colors.put("khaki 4", 9143886);
        colors.put("khaki", 15787660);
        colors.put("palegoldenrod", 0xEEE8AA);
        colors.put("lemonchiffon 1 (lemonchiffon)", 16775885);
        colors.put("lemonchiffon 2", 15657407);
        colors.put("lemonchiffon 3", 13486501);
        colors.put("lemonchiffon 4", 9144688);
        colors.put("lightgoldenrod 1", 16772235);
        colors.put("lightgoldenrod 2", 15654018);
        colors.put("lightgoldenrod 3", 13483632);
        colors.put("lightgoldenrod 4", 9142604);
        colors.put("banana", 14929751);
        colors.put("gold 1 (gold)", 16766720);
        colors.put("gold 2", 15649024);
        colors.put("gold 3", 13479168);
        colors.put("gold 4", 9139456);
        colors.put("cornsilk 1 (cornsilk)", 16775388);
        colors.put("cornsilk 2", 15657165);
        colors.put("cornsilk 3", 13486257);
        colors.put("cornsilk 4", 0x8B8878);
        colors.put("goldenrod", 14329120);
        colors.put("goldenrod 1", 16761125);
        colors.put("goldenrod 2", 15643682);
        colors.put("goldenrod 3", 13474589);
        colors.put("goldenrod 4", 9136404);
        colors.put("darkgoldenrod", 12092939);
        colors.put("darkgoldenrod 1", 16759055);
        colors.put("darkgoldenrod 2", 15641870);
        colors.put("darkgoldenrod 3", 13473036);
        colors.put("darkgoldenrod 4", 9135368);
        colors.put("orange 1 (orange)", 16753920);
        colors.put("orange 2", 15636992);
        colors.put("orange 3", 13468928);
        colors.put("orange 4", 9132544);
        colors.put("floralwhite", 0xFFFAF0);
        colors.put("oldlace", 16643558);
        colors.put("wheat", 16113331);
        colors.put("wheat 1", 16771002);
        colors.put("wheat 2", 15653038);
        colors.put("wheat 3", 13482646);
        colors.put("wheat 4", 9141862);
        colors.put("moccasin", 16770229);
        colors.put("papayawhip", 16773077);
        colors.put("blanchedalmond", 16772045);
        colors.put("navajowhite 1 (navajowhite)", 16768685);
        colors.put("navajowhite 2", 15650721);
        colors.put("navajowhite 3", 13480843);
        colors.put("navajowhite 4", 9140574);
        colors.put("eggshell", 16574153);
        colors.put("tan", 13808780);
        colors.put("brick", 10249759);
        colors.put("cadmiumyellow", 16750866);
        colors.put("antiquewhite", 16444375);
        colors.put("antiquewhite 1", 16773083);
        colors.put("antiquewhite 2", 15654860);
        colors.put("antiquewhite 3", 13484208);
        colors.put("antiquewhite 4", 9143160);
        colors.put("burlywood", 14596231);
        colors.put("burlywood 1", 16765851);
        colors.put("burlywood 2", 15648145);
        colors.put("burlywood 3", 13478525);
        colors.put("burlywood 4", 9139029);
        colors.put("bisque 1 (bisque)", 16770244);
        colors.put("bisque 2", 15652279);
        colors.put("bisque 3", 13481886);
        colors.put("bisque 4", 9141611);
        colors.put("melon", 14919785);
        colors.put("carrot", 15569185);
        colors.put("darkorange", 16747520);
        colors.put("darkorange 1", 0xFF7F00);
        colors.put("darkorange 2", 15627776);
        colors.put("darkorange 3", 13460992);
        colors.put("darkorange 4", 9127168);
        colors.put("orange", 0xFF8000);
        colors.put("tan 1", 16753999);
        colors.put("tan 2", 15637065);
        colors.put("tan 3 (peru)", 13468991);
        colors.put("tan 4", 9132587);
        colors.put("linen", 16445670);
        colors.put("peachpuff 1 (peachpuff)", 16767673);
        colors.put("peachpuff 2", 15649709);
        colors.put("peachpuff 3", 13479829);
        colors.put("peachpuff 4", 9140069);
        colors.put("seashell 1 (seashell)", 0xFFF5EE);
        colors.put("seashell 2", 0xEEE5DE);
        colors.put("seashell 3", 13485503);
        colors.put("seashell 4", 9143938);
        colors.put("sandybrown", 16032864);
        colors.put("rawsienna", 13066516);
        colors.put("chocolate", 13789470);
        colors.put("chocolate 1", 16744228);
        colors.put("chocolate 2", 15627809);
        colors.put("chocolate 3", 13461021);
        colors.put("chocolate 4 (saddlebrown)", 9127187);
        colors.put("ivoryblack", 2696225);
        colors.put("flesh", 16743744);
        colors.put("cadmiumorange", 16736515);
        colors.put("burntsienna", 9057807);
        colors.put("sienna", 10506797);
        colors.put("sienna 1", 16745031);
        colors.put("sienna 2", 15628610);
        colors.put("sienna 3", 13461561);
        colors.put("sienna 4", 9127718);
        colors.put("lightsalmon 1 (lightsalmon)", 16752762);
        colors.put("lightsalmon 2", 15635826);
        colors.put("lightsalmon 3", 13468002);
        colors.put("lightsalmon 4", 9131842);
        colors.put("coral", 16744272);
        colors.put("orangered 1 (orangered)", 16729344);
        colors.put("orangered 2", 0xEE4000);
        colors.put("orangered 3", 13448960);
        colors.put("orangered 4", 9118976);
        colors.put("sepia", 6170130);
        colors.put("darksalmon", 15308410);
        colors.put("salmon 1", 16747625);
        colors.put("salmon 2", 15630946);
        colors.put("salmon 3", 13463636);
        colors.put("salmon 4", 9129017);
        colors.put("coral 1", 16740950);
        colors.put("coral 2", 15624784);
        colors.put("coral 3", 13458245);
        colors.put("coral 4", 9125423);
        colors.put("burntumber", 9057060);
        colors.put("tomato 1 (tomato)", 16737095);
        colors.put("tomato 2", 15621186);
        colors.put("tomato 3", 13455161);
        colors.put("tomato 4", 9123366);
        colors.put("salmon", 16416882);
        colors.put("mistyrose 1 (mistyrose)", 16770273);
        colors.put("mistyrose 2", 15652306);
        colors.put("mistyrose 3", 13481909);
        colors.put("mistyrose 4", 9141627);
        colors.put("snow 1 (snow)", 0xFFFAFA);
        colors.put("snow 2", 0xEEE9E9);
        colors.put("snow 3", 0xCDC9C9);
        colors.put("snow 4", 0x8B8989);
        colors.put("rosybrown", 12357519);
        colors.put("rosybrown 1", 0xFFC1C1);
        colors.put("rosybrown 2", 0xEEB4B4);
        colors.put("rosybrown 3", 13474715);
        colors.put("rosybrown 4", 9136489);
        colors.put("lightcoral", 0xF08080);
        colors.put("indianred", 0xCD5C5C);
        colors.put("indianred 1", 0xFF6A6A);
        colors.put("indianred 2", 0xEE6363);
        colors.put("indianred 4", 9124410);
        colors.put("indianred 3", 0xCD5555);
        colors.put("brown", 0xA52A2A);
        colors.put("brown 1", 0xFF4040);
        colors.put("brown 2", 0xEE3B3B);
        colors.put("brown 3", 0xCD3333);
        colors.put("brown 4", 9118499);
        colors.put("firebrick", 0xB22222);
        colors.put("firebrick 1", 0xFF3030);
        colors.put("firebrick 2", 0xEE2C2C);
        colors.put("firebrick 3", 13444646);
        colors.put("firebrick 4", 9116186);
        colors.put("red 1 (red*)", 0xFF0000);
        colors.put("red*", 0xFF0000);
        colors.put("red 2", 0xEE0000);
        colors.put("red 3", 0xCD0000);
        colors.put("red 4 (darkred)", 0x8B0000);
        colors.put("maroon*", 0x800000);
        colors.put("sgi beet", 0x8E388E);
        colors.put("sgi slateblue", 7434694);
        colors.put("sgi lightblue", 8232640);
        colors.put("sgi teal", 0x388E8E);
        colors.put("sgi chartreuse", 7456369);
        colors.put("sgi olivedrab", 0x8E8E38);
        colors.put("sgi brightgray", 12960170);
        colors.put("sgi salmon", 13005169);
        colors.put("sgi darkgray", 0x555555);
        colors.put("sgi gray 12", 0x1E1E1E);
        colors.put("sgi gray 16", 0x282828);
        colors.put("sgi gray 32", 0x515151);
        colors.put("sgi gray 36", 0x5B5B5B);
        colors.put("sgi gray 52", 0x848484);
        colors.put("sgi gray 56", 0x8E8E8E);
        colors.put("sgi lightgray", 0xAAAAAA);
        colors.put("sgi gray 72", 0xB7B7B7);
        colors.put("sgi gray 76", 0xC1C1C1);
        colors.put("sgi gray 92", 0xEAEAEA);
        colors.put("sgi gray 96", 0xF4F4F4);
        colors.put("white*", 0xFFFFFF);
        colors.put("white smoke (gray 96)", 0xF5F5F5);
        colors.put("gainsboro", 0xDCDCDC);
        colors.put("lightgrey", 0xD3D3D3);
        colors.put("silver*", 0xC0C0C0);
        colors.put("darkgray", 0xA9A9A9);
        colors.put("gray*", 0x808080);
        colors.put("dimgray (gray 42)", 0x696969);
        colors.put("black*", 0);
        colors.put("gray 99", 0xFCFCFC);
        colors.put("gray 98", 0xFAFAFA);
        colors.put("gray 97", 0xF7F7F7);
        colors.put("white smoke (gray 96)", 0xF5F5F5);
        colors.put("gray 95", 0xF2F2F2);
        colors.put("gray 94", 0xF0F0F0);
        colors.put("gray 93", 0xEDEDED);
        colors.put("gray 92", 0xEBEBEB);
        colors.put("gray 91", 0xE8E8E8);
        colors.put("gray 90", 0xE5E5E5);
        colors.put("gray 89", 0xE3E3E3);
        colors.put("gray 88", 0xE0E0E0);
        colors.put("gray 87", 0xDEDEDE);
        colors.put("gray 86", 0xDBDBDB);
        colors.put("gray 85", 0xD9D9D9);
        colors.put("gray 84", 0xD6D6D6);
        colors.put("gray 83", 0xD4D4D4);
        colors.put("gray 82", 0xD1D1D1);
        colors.put("gray 81", 0xCFCFCF);
        colors.put("gray 80", 0xCCCCCC);
        colors.put("gray 79", 0xC9C9C9);
        colors.put("gray 78", 0xC7C7C7);
        colors.put("gray 77", 0xC4C4C4);
        colors.put("gray 76", 0xC2C2C2);
        colors.put("gray 75", 0xBFBFBF);
        colors.put("gray 74", 0xBDBDBD);
        colors.put("gray 73", 0xBABABA);
        colors.put("gray 72", 0xB8B8B8);
        colors.put("gray 71", 0xB5B5B5);
        colors.put("gray 70", 0xB3B3B3);
        colors.put("gray 69", 0xB0B0B0);
        colors.put("gray 68", 0xADADAD);
        colors.put("gray 67", 0xABABAB);
        colors.put("gray 66", 0xA8A8A8);
        colors.put("gray 65", 0xA6A6A6);
        colors.put("gray 64", 0xA3A3A3);
        colors.put("gray 63", 0xA1A1A1);
        colors.put("gray 62", 0x9E9E9E);
        colors.put("gray 61", 0x9C9C9C);
        colors.put("gray 60", 0x999999);
        colors.put("gray 59", 0x969696);
        colors.put("gray 58", 0x949494);
        colors.put("gray 57", 0x919191);
        colors.put("gray 56", 0x8F8F8F);
        colors.put("gray 55", 0x8C8C8C);
        colors.put("gray 54", 0x8A8A8A);
        colors.put("gray 53", 0x878787);
        colors.put("gray 52", 0x858585);
        colors.put("gray 51", 0x828282);
        colors.put("gray 50", 0x7F7F7F);
        colors.put("gray 49", 0x7D7D7D);
        colors.put("gray 48", 0x7A7A7A);
        colors.put("gray 47", 0x787878);
        colors.put("gray 46", 0x757575);
        colors.put("gray 45", 0x737373);
        colors.put("gray 44", 0x707070);
        colors.put("gray 43", 0x6E6E6E);
        colors.put("gray 42", 0x6B6B6B);
        colors.put("dimgray (gray 42)", 0x696969);
        colors.put("gray 40", 0x666666);
        colors.put("gray 39", 0x636363);
        colors.put("gray 38", 0x616161);
        colors.put("gray 37", 0x5E5E5E);
        colors.put("gray 36", 0x5C5C5C);
        colors.put("gray 35", 0x595959);
        colors.put("gray 34", 0x575757);
        colors.put("gray 33", 0x545454);
        colors.put("gray 32", 0x525252);
        colors.put("gray 31", 0x4F4F4F);
        colors.put("gray 30", 0x4D4D4D);
        colors.put("gray 29", 0x4A4A4A);
        colors.put("gray 28", 0x474747);
        colors.put("gray 27", 0x454545);
        colors.put("gray 26", 0x424242);
        colors.put("gray 25", 0x404040);
        colors.put("gray 24", 0x3D3D3D);
        colors.put("gray 23", 0x3B3B3B);
        colors.put("gray 22", 0x383838);
        colors.put("gray 21", 0x363636);
        colors.put("gray 20", 0x333333);
        colors.put("gray 19", 0x303030);
        colors.put("gray 18", 0x2E2E2E);
        colors.put("gray 17", 0x2B2B2B);
        colors.put("gray 16", 0x292929);
        colors.put("gray 15", 0x262626);
        colors.put("gray 14", 0x242424);
        colors.put("gray 13", 0x212121);
        colors.put("gray 12", 0x1F1F1F);
        colors.put("gray 11", 0x1C1C1C);
        colors.put("gray 10", 0x1A1A1A);
        colors.put("gray 9", 0x171717);
        colors.put("gray 8", 0x141414);
        colors.put("gray 7", 0x121212);
        colors.put("gray 6", 986895);
        colors.put("gray 5", 855309);
        colors.put("gray 4", 657930);
        colors.put("gray 3", 526344);
        colors.put("gray 2", 328965);
        colors.put("gray 1", 197379);
        rgbvalues = new ArrayList<Integer>(colors.values());
    }

    private static class RandomIter
    implements Iterator<Integer> {
        private RandomIter() {
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public Integer next() {
            int index = (int)(Math.random() * (double)rgbvalues.size()) % rgbvalues.size();
            return (Integer)rgbvalues.get(index);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class InfiIter
    implements Iterator<Integer> {
        int index;
        int increment;

        InfiIter(int start, int increment) {
            if (start < 0 || increment <= 0) {
                throw new IllegalArgumentException();
            }
            this.increment = increment;
            this.index = start % colors.size();
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public Integer next() {
            int v = (Integer)rgbvalues.get(this.index);
            this.index = (this.index + this.increment) % colors.size();
            return v;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

