/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.graphs;

import com.pnfsoftware.jeb.client.api.IUnitFragment;
import com.pnfsoftware.jeb.core.events.PropertyChangeNotification;
import com.pnfsoftware.jeb.core.output.IActionableItem;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.impl.AbstractTextPartAsDocumentProxy;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.AddressableInstruction;
import com.pnfsoftware.jeb.core.units.code.IFlowInformation;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.render.INativeDisassemblyDocument;
import com.pnfsoftware.jeb.core.units.code.asm.render.NativeDisassemblyProperties;
import com.pnfsoftware.jeb.rcpclient.GlobalPosition;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.ReferencesDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.Graph;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.GraphNode;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.parts.units.TextFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.graphs.AbstractControlFlowGraphFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.graphs.NodeContentsTextFragment;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;

public class NativeCodeGraphFragment
extends AbstractControlFlowGraphFragment<INativeCodeUnit<IInstruction>> {
    private static final ILogger logger = GlobalLog.getLogger(NativeCodeGraphFragment.class);
    private INativeDisassemblyDocument disasDoc;
    private INativeMethodItem currentMethod;

    public NativeCodeGraphFragment(Composite parent, int style, RcpClientContext context, INativeCodeUnit<IInstruction> unit, IRcpUnitView unitView) {
        super(parent, style, unit, unitView, context);
    }

    @Override
    public boolean isValidActiveAddress(String address, Object object) {
        return ((INativeCodeUnit)this.unit).getCanonicalMemoryAddress(address) != -1L;
    }

    @Override
    public boolean setActiveAddress(String address, Object extra, boolean record) {
        GraphNode graphNode;
        GlobalPosition pos0;
        long a = ((INativeCodeUnit)this.unit).getCanonicalMemoryAddress(address);
        if (a == -1L) {
            return false;
        }
        List<INativeMethodItem> methods = ((INativeCodeUnit)this.unit).getInternalMethods(a);
        if (methods.isEmpty()) {
            for (IUnitFragment iUnitFragment : this.unitView.getFragments()) {
                if (!(iUnitFragment instanceof TextFragment)) continue;
                logger.i("Jumping to address: %s", address);
                if (!((TextFragment)iUnitFragment).isValidActiveAddress(address, null)) continue;
                this.unitView.setActiveFragment(iUnitFragment);
                boolean found = this.unitView.setActiveAddress(address, null, true);
                if (found) {
                    return true;
                }
                this.unitView.setActiveFragment(this);
            }
            for (UnitPartManager unitPartManager : this.context.getPartManager().getPartManagersForUnit(this.unit)) {
                for (IUnitFragment iUnitFragment : unitPartManager.getFragments()) {
                    if (!(iUnitFragment instanceof TextFragment)) continue;
                    logger.i("Jumping to address: %s", address);
                    if (!((TextFragment)iUnitFragment).isValidActiveAddress(address, null)) continue;
                    unitPartManager.requestFocus();
                    unitPartManager.setActiveFragment(iUnitFragment);
                    boolean found = unitPartManager.setActiveAddress(address, null, true);
                    if (!found) continue;
                    return true;
                }
            }
            return false;
        }
        int index = -1;
        if (methods.size() == 1) {
            index = 0;
        } else if (methods.size() >= 2) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (INativeMethodItem iNativeMethodItem : methods) {
                arrayList.add(iNativeMethodItem.getAddress());
            }
            ReferencesDialog dlg = new ReferencesDialog(this.getShell(), "Select a routine", arrayList, null, this.unit);
            String string = String.format("There are more than one routine sharing code at address %s.\nSelect the routine you would like to visualize the CFG of:", address);
            dlg.setMessage(string);
            index = dlg.open();
        }
        if (index < 0 || index >= methods.size()) {
            return false;
        }
        INativeMethodItem iNativeMethodItem = methods.get(index);
        GlobalPosition globalPosition = pos0 = !record || this.getViewManager() == null ? null : this.getViewManager().getCurrentGlobalPosition();
        if (iNativeMethodItem != this.currentMethod) {
            this.replaceGraph(iNativeMethodItem);
        }
        if (pos0 != null) {
            this.getViewManager().recordGlobalPosition(pos0);
        }
        if ((graphNode = this.findNodeByInstructionAddress(a)) == null) {
            return false;
        }
        Graph g = this.getGraph();
        g.showNode(graphNode, true);
        g.setActiveNode(graphNode, false);
        NodeContentsTextFragment contents = (NodeContentsTextFragment)graphNode.getContents();
        return contents.setActiveAddress(address, null, false);
    }

    @Override
    protected boolean doItemFollow() {
        String address;
        IItem item = this.getActiveItem();
        if (item instanceof IActionableItem && (address = ((INativeCodeUnit)this.unit).getAddressOfItem(((IActionableItem)((Object)item)).getItemId())) != null) {
            return this.setActiveAddress(address);
        }
        return false;
    }

    @Override
    protected ITextDocument getTextForBlock(final BasicBlock<IInstruction> b) {
        return new AbstractTextPartAsDocumentProxy(this.disasDoc){

            @Override
            protected ITextDocumentPart getPartAsDocument() {
                return ((INativeDisassemblyDocument)this.getFullDocument()).getDisassemblyPart(b.getFirstAddress(), b.getEndAddress());
            }
        };
    }

    private void replaceGraph(INativeMethodItem method) {
        this.reset(true);
        this.currentMethod = method;
        CFG<IInstruction> cfg = method.getData().getCFG();
        boolean restructureCFG = true;
        for (AddressableInstruction<?> ainsn : cfg.addressableInstructions()) {
            IFlowInformation flowinfo = ainsn.getBreakingFlow();
            if (flowinfo.isBroken() && flowinfo.getDelaySlotCount() != 0) {
                restructureCFG = false;
                break;
            }
            flowinfo = ainsn.getRoutineCall();
            if (!flowinfo.isBroken() || flowinfo.getDelaySlotCount() == 0) continue;
            restructureCFG = false;
            break;
        }
        if (restructureCFG && (cfg.getFlags() & 1) == 0) {
            int flags = cfg.getFlags() | 1 | 2;
            cfg = new CFG<IInstruction>(cfg.getInstructionsMap(), null, null, cfg.getEntryAddress(), flags);
        }
        this.disasDoc = ((INativeCodeUnit)this.unit).getDisassemblyDocument();
        this.setDocumentProperties();
        this.generateGraphForCFG(cfg);
    }

    @Override
    protected void onClientPropertyChange(PropertyChangeNotification n) {
        if (n.has(".ui.text.cfg.ShowAddresses", ".ui.text.cfg.ShowBytesCount")) {
            this.setDocumentProperties();
        }
    }

    private void setDocumentProperties() {
        if (this.disasDoc == null) {
            return;
        }
        NativeDisassemblyProperties propertyOverrides = new NativeDisassemblyProperties();
        propertyOverrides.setLabelAreaLength(0);
        propertyOverrides.setShowAddresses(this.pm.getBoolean(".ui.text.cfg.ShowAddresses"));
        propertyOverrides.setShowBytesCount(this.pm.getInteger(".ui.text.cfg.ShowBytesCount"));
        propertyOverrides.setRoutineSeparatorLength(0);
        propertyOverrides.setShowSegmentHeaders(false);
        propertyOverrides.setShowSpaceBetweenBlocks(false);
        propertyOverrides.setInstructionAreaLength(25);
        propertyOverrides.setBlockXrefsCount(0);
        this.disasDoc.setPropertyOverrides(propertyOverrides);
    }
}

