/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.graphs;

import com.pnfsoftware.jeb.core.events.PropertyChangeNotification;
import com.pnfsoftware.jeb.core.output.IActionableItem;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.output.code.coordinates.ICodeCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.InstructionCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.MethodCoordinates;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.impl.AbstractTextPartAsDocumentProxy;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDalvikInstruction;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.core.units.code.android.render.DexDisassemblyProperties;
import com.pnfsoftware.jeb.core.units.code.android.render.IDexDisassemblyDocument;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.IrregularFlowData;
import com.pnfsoftware.jeb.rcpclient.GlobalPosition;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.Graph;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.GraphNode;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.parts.units.graphs.AbstractControlFlowGraphFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.graphs.NodeContentsTextFragment;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.swt.widgets.Composite;

public class DalvikCodeGraphFragment
extends AbstractControlFlowGraphFragment<IDexUnit> {
    private static final ILogger logger = GlobalLog.getLogger(DalvikCodeGraphFragment.class);
    private IDexDisassemblyDocument disasDoc;
    private IDexMethod currentMethod;

    public DalvikCodeGraphFragment(Composite parent, int style, RcpClientContext context, IDexUnit unit, IRcpUnitView unitView) {
        super(parent, style, unit, unitView, context);
    }

    private Couple<IDexMethod, Integer> processAddress(String address) {
        int offset;
        int methodId;
        ICodeCoordinates cc = ((IDexUnit)this.unit).getCodeCoordinatesFromAddress(address);
        if (cc == null) {
            return null;
        }
        if (cc instanceof MethodCoordinates) {
            methodId = ((MethodCoordinates)cc).getMethodId();
            offset = 0;
        } else if (cc instanceof InstructionCoordinates) {
            methodId = ((InstructionCoordinates)cc).getMethodId();
            offset = ((InstructionCoordinates)cc).getOffset();
        } else {
            return null;
        }
        IDexMethod method = ((IDexUnit)this.unit).getMethod(methodId);
        if (method == null) {
            return null;
        }
        return new Couple<IDexMethod, Integer>(method, offset);
    }

    @Override
    protected String buildAddress(long offset) {
        return ((IDexUnit)this.unit).getAddressFromCodeCoordinates(new InstructionCoordinates(this.currentMethod.getIndex(), (int)offset));
    }

    @Override
    public boolean canDisplayAtAddress(String address) {
        return this.processAddress(address) != null;
    }

    @Override
    public boolean isValidActiveAddress(String address, Object object) {
        return this.processAddress(address) != null;
    }

    @Override
    public boolean setActiveAddress(String address, Object extra, boolean record) {
        GraphNode node;
        Couple<IDexMethod, Integer> details = this.processAddress(address);
        if (details == null) {
            return false;
        }
        GlobalPosition pos0 = !record || this.getViewManager() == null ? null : this.getViewManager().getCurrentGlobalPosition();
        IDexMethod method = details.getFirst();
        int offset = details.getSecond();
        if (method.getData() == null || method.getData().getCodeItem() == null) {
            return false;
        }
        if (method != this.currentMethod) {
            this.replaceGraph(method);
        }
        if (pos0 != null) {
            this.getViewManager().recordGlobalPosition(pos0);
        }
        if ((node = this.findNodeByInstructionAddress(offset)) == null) {
            return false;
        }
        Graph g = this.getGraph();
        g.showNode(node, true);
        g.setActiveNode(node, false);
        NodeContentsTextFragment contents = (NodeContentsTextFragment)node.getContents();
        return contents.setActiveAddress(address);
    }

    @Override
    protected boolean doItemFollow() {
        long itemId;
        String address;
        IItem item = this.getActiveItem();
        if (item instanceof IActionableItem && (address = ((IDexUnit)this.unit).getAddressOfItem(itemId = ((IActionableItem)((Object)item)).getItemId())) != null) {
            this.setActiveAddress(address);
        }
        return false;
    }

    @Override
    protected ITextDocument getTextForBlock(final BasicBlock<IInstruction> b) {
        return new AbstractTextPartAsDocumentProxy(this.disasDoc){

            @Override
            protected ITextDocumentPart getPartAsDocument() {
                return ((IDexDisassemblyDocument)this.getFullDocument()).getItemDisassembly(new InstructionCoordinates(DalvikCodeGraphFragment.this.currentMethod.getIndex(), (int)b.getFirstAddress()));
            }
        };
    }

    private void replaceGraph(IDexMethod method) {
        this.reset(true);
        this.currentMethod = method;
        HashMap<Long, IDalvikInstruction> insnmap = new HashMap<Long, IDalvikInstruction>();
        com.pnfsoftware.jeb.core.units.code.android.controlflow.CFG<? extends IDalvikInstruction> cfg0 = method.getData().getCodeItem().getControlFlowGraph();
        if (cfg0 == null) {
            this.currentMethod = null;
            return;
        }
        for (IDalvikInstruction iDalvikInstruction : cfg0.getInstructions()) {
            insnmap.put(iDalvikInstruction.getOffset(), iDalvikInstruction);
        }
        ArrayList<IrregularFlowData> irrdata = new ArrayList<IrregularFlowData>();
        for (com.pnfsoftware.jeb.core.units.code.android.controlflow.IrregularFlowData o : cfg0.generateIrregularFlowDataObjects()) {
            irrdata.add(new IrregularFlowData(o.getFirstAddress(), o.getLastAddress(), o.getTargetAddress()));
        }
        CFG<IInstruction> cFG = new CFG<IInstruction>(insnmap, irrdata, null, 0L, 3);
        this.disasDoc = ((IDexUnit)this.unit).getDisassemblyDocument();
        this.setDocumentProperties();
        this.generateGraphForCFG(cFG);
    }

    @Override
    protected void onClientPropertyChange(PropertyChangeNotification n) {
        if (n.has(".ui.text.cfg.ShowAddresses", ".ui.text.cfg.ShowBytesCount")) {
            this.setDocumentProperties();
        }
    }

    private void setDocumentProperties() {
        if (this.disasDoc == null) {
            return;
        }
        DexDisassemblyProperties propertyOverrides = new DexDisassemblyProperties();
        IPropertyManager pm = this.context.getPropertyManager();
        propertyOverrides.setShowAddresses(pm.getBoolean(".ui.text.cfg.ShowAddresses"));
        propertyOverrides.setShowBytecode(pm.getInteger(".ui.text.cfg.ShowBytesCount") > 0);
        this.disasDoc.setPropertyOverrides(propertyOverrides);
    }
}

