/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.debuggers;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.core.exceptions.DebuggerException;
import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jeb.core.units.code.debug.DebuggerThreadStatus;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerThread;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerThreadStackFrame;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerVariable;
import com.pnfsoftware.jeb.core.units.code.debug.ITypedValue;
import com.pnfsoftware.jeb.core.units.code.debug.impl.AbstractValueComposite;
import com.pnfsoftware.jeb.core.units.code.debug.impl.AbstractValueNumber;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueDouble;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueFloat;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueObject;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueRaw;
import com.pnfsoftware.jeb.rcpclient.AssetManagerOverlay;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UIRunnable;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.PatternTreeView;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.AbstractArrayGroupFilteredTreeContentProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTreeViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.TreeStateMaintainer;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.rcpclient.util.DbgTypedValueUtil;
import com.pnfsoftware.jeb.rcpclient.util.regex.IValueProvider;
import com.pnfsoftware.jeb.rcpclient.util.regex.SimplePatternMatcher;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class DbgVariablesFragment
extends AbstractUnitFragment<IDebuggerUnit>
implements IContextMenu {
    private static final ILogger logger = GlobalLog.getLogger(DbgVariablesFragment.class);
    private PatternTreeView ftv;
    private FilteredTreeViewer viewer;
    private TreeStateMaintainer<IDebuggerVariable> stateMaintainer;
    private IDebuggerThreadStackFrame targetFrame;

    public DbgVariablesFragment(Composite parent, int flags, IRcpClientContext context, IDebuggerUnit unit) {
        super(parent, flags, unit, null, context);
        this.setLayout((Layout)new FillLayout());
        String[] titleColumns = new String[]{S.s(591), S.s(779), S.s(815), "Extra"};
        LabelProvider labelProvider = new LabelProvider();
        SimplePatternMatcher patternMatcher = new SimplePatternMatcher(labelProvider);
        boolean expandAfterFilter = context.getPropertyManager().getBoolean(".ui.ExpandTreeNodesOnFiltering");
        this.ftv = new PatternTreeView(this, 65536, titleColumns, null, patternMatcher, expandAfterFilter);
        this.ftv.setFilterVisibility(false, false);
        this.viewer = this.ftv.getTreeViewer();
        Tree tree = this.ftv.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeColumn[] cols = tree.getColumns();
        TreeViewerColumn tcv1 = new TreeViewerColumn((TreeViewer)this.viewer.getViewer(), cols[1]);
        tcv1.setEditingSupport(new ValueEditingSupport((ColumnViewer)this.viewer.getViewer(), 2));
        TreeViewerColumn tcv2 = new TreeViewerColumn((TreeViewer)this.viewer.getViewer(), cols[2]);
        tcv2.setEditingSupport(new ValueEditingSupport((ColumnViewer)this.viewer.getViewer(), 0));
        TreeViewerColumn tcv3 = new TreeViewerColumn((TreeViewer)this.viewer.getViewer(), cols[3]);
        tcv3.setEditingSupport(new ValueEditingSupport((ColumnViewer)this.viewer.getViewer(), 1));
        this.viewer.setContentProvider(new TreeContentProvider());
        this.viewer.setLabelProvider(labelProvider);
        this.viewer.setInput(unit);
        this.stateMaintainer = new TreeStateMaintainer<IDebuggerVariable>((TreeViewer)this.viewer.getViewer()){

            @Override
            public boolean likeEquals(IDebuggerVariable currentObject, IDebuggerVariable previousObject) {
                return Strings.equals(currentObject.getName(), previousObject.getName());
            }
        };
        this.viewer.expandToLevel(2);
        this.packColumns(true);
        new ContextMenu((Control)tree).addContextMenu(this);
    }

    public void packColumns(boolean force) {
        TreeColumn[] cols;
        for (TreeColumn col : cols = this.ftv.getTree().getColumns()) {
            if (!force && col.getWidth() != 0) continue;
            col.pack();
        }
    }

    @Override
    public void fillContextMenu(IMenuManager menuMgr) {
        Object elt = this.getSelectedNode();
        if (elt instanceof IDebuggerVariable) {
            final IDebuggerVariable v = (IDebuggerVariable)elt;
            menuMgr.add(new Action("View string representation"){

                @Override
                public void run() {
                    if (v.getTypedValue() instanceof ValueObject) {
                        try {
                            IDebuggerThread t = ((IDebuggerUnit)DbgVariablesFragment.this.getUnit()).getDefaultThread();
                            if (t != null) {
                                long threadId = t.getId();
                                ITypedValue result = ((ValueObject)v.getTypedValue()).invoke("toString", threadId, null);
                                if (result != null) {
                                    logger.info(result.toString(), new Object[0]);
                                }
                            } else {
                                logger.error("Can not call toString: no default thread", new Object[0]);
                            }
                        }
                        catch (JebException e) {
                            logger.catching(e);
                        }
                    }
                }

                @Override
                public boolean isEnabled() {
                    return v.getTypedValue() instanceof ValueObject && ((ValueObject)v.getTypedValue()).getObjectId() != 0L;
                }
            });
        }
        this.addOperationsToContextMenu(menuMgr);
    }

    public void setTargetFrame(IDebuggerThreadStackFrame frame) {
        this.targetFrame = frame;
        this.viewer.refresh();
    }

    public IDebuggerThreadStackFrame getTargetFrame() {
        List<? extends IDebuggerThreadStackFrame> frames;
        if (this.targetFrame != null) {
            return this.targetFrame;
        }
        IDebuggerThread t = ((IDebuggerUnit)this.getUnit()).getDefaultThread();
        if (t != null && t.getStatus() == DebuggerThreadStatus.PAUSED && (frames = t.getFrames()) != null && !frames.isEmpty()) {
            return frames.get(0);
        }
        return null;
    }

    private Object getSelectedNode() {
        ITreeSelection treesel = (ITreeSelection)this.viewer.getSelection();
        if (treesel.isEmpty()) {
            return null;
        }
        return treesel.getFirstElement();
    }

    private boolean copyValueToClipboard(ITypedValue value) {
        String s = this.formatValue(value);
        if (s != null) {
            UIUtil.copyTextToClipboard(s);
            return true;
        }
        return false;
    }

    private String formatValue(ITypedValue value) {
        String s = null;
        s = value instanceof AbstractValueComposite ? ((AbstractValueComposite)value).format() : value.toString();
        return s;
    }

    private String formatCell(ITypedValue value, int index) {
        if (index == 0 || index == 1) {
            return DbgTypedValueUtil.formatValue(value, index, (IDebuggerUnit)this.unit);
        }
        return "";
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case COPY: {
                return this.getSelectedNode() != null;
            }
        }
        return false;
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case COPY: {
                Object elt = this.getSelectedNode();
                if (elt instanceof IDebuggerVariable) {
                    return this.copyValueToClipboard(((IDebuggerVariable)elt).getTypedValue());
                }
                if (elt instanceof ITypedValue) {
                    return this.copyValueToClipboard((ITypedValue)elt);
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public byte[] export() {
        return Strings.encodeUTF8(this.viewer.exportToString());
    }

    @Override
    public AbstractUnitFragment.FragmentType getFragmentType() {
        return AbstractUnitFragment.FragmentType.TREE;
    }

    class ValueEditingSupport
    extends EditingSupport {
        private static final int COLUMN_VALUE = 0;
        private static final int COLUMN_EXTRA = 1;
        private static final int COLUMN_TYPE = 2;
        ColumnViewer columnVviewer;
        TextCellEditor editor;
        int index;

        public ValueEditingSupport(ColumnViewer viewer, int index) {
            super(viewer);
            this.columnVviewer = viewer;
            Composite parent = (Composite)viewer.getControl();
            this.editor = new TextCellEditor(parent);
            this.index = index;
        }

        @Override
        protected CellEditor getCellEditor(Object element) {
            if (!(element instanceof IDebuggerVariable)) {
                return null;
            }
            return this.editor;
        }

        @Override
        protected boolean canEdit(Object element) {
            if (!(element instanceof IDebuggerVariable)) {
                return false;
            }
            IDebuggerVariable v = (IDebuggerVariable)element;
            ITypedValue t = v.getTypedValue();
            if (this.index == 0) {
                return v.canEditValue();
            }
            if (this.index == 1) {
                if (t instanceof AbstractValueNumber) {
                    return v.canEditValue() && !(t instanceof ValueFloat) && !(t instanceof ValueDouble);
                }
            } else if (this.index == 2) {
                return v.canEditType();
            }
            return false;
        }

        @Override
        protected Object getValue(Object element) {
            IDebuggerVariable v = (IDebuggerVariable)element;
            return DbgVariablesFragment.this.formatCell(v.getTypedValue(), this.index);
        }

        @Override
        protected void setValue(Object element, Object value) {
            IDebuggerVariable v = (IDebuggerVariable)element;
            if (this.index == 0 || this.index == 1) {
                boolean success;
                IDebuggerThreadStackFrame frame;
                ITypedValue newValue = this.buildValue(v.getTypedValue(), (String)value);
                if (newValue != null && (frame = DbgVariablesFragment.this.getTargetFrame()) != null && (success = v.setTypedValue(newValue))) {
                    this.columnVviewer.refresh();
                }
            } else if (this.index == 2) {
                String visuType = (String)value;
                logger.i("visuType= %s", visuType);
                if (!Strings.isBlank(visuType) && v.setTypeHint(visuType)) {
                    this.columnVviewer.refresh();
                }
            }
        }

        public ITypedValue buildValue(ITypedValue value, String newValue) {
            if (newValue == null) {
                return null;
            }
            if (DbgTypedValueUtil.equals(value, newValue, (IDebuggerUnit)DbgVariablesFragment.this.unit)) {
                return null;
            }
            ITypedValue typedValue = DbgTypedValueUtil.buildValue(value, newValue);
            if (typedValue != null && Objects.equals(typedValue.getValue(), value.getValue())) {
                return null;
            }
            if (typedValue == null) {
                logger.i("Illegal value for IDebuggerVariable '%s'", newValue);
            }
            return typedValue;
        }
    }

    class LabelProvider
    extends StyledCellLabelProvider
    implements IValueProvider {
        LabelProvider() {
        }

        @Override
        public void update(ViewerCell cell) {
            Object elt = cell.getElement();
            int index = cell.getColumnIndex();
            cell.setText(Strings.safe(this.getStringAt(elt, index)));
            if (index == 0) {
                int flags;
                Image img = null;
                if (elt instanceof IDebuggerVariable && (flags = ((IDebuggerVariable)elt).getFlags()) != 0) {
                    String visibilityFlag = null;
                    visibilityFlag = (flags & 1) != 0 ? "eclipse/field_public_obj.png" : ((flags & 4) != 0 ? "eclipse/field_protected_obj.png" : ((flags & 2) != 0 ? "eclipse/field_private_obj.png" : "eclipse/field_default_obj.png"));
                    AssetManagerOverlay overlay = null;
                    if ((flags & 8) != 0) {
                        if (overlay == null) {
                            overlay = new AssetManagerOverlay();
                        }
                        overlay.addLayer("eclipse/static_co.png", new Point(0, 0));
                    }
                    if ((flags & 0x10) != 0) {
                        if (overlay == null) {
                            overlay = new AssetManagerOverlay();
                        }
                        overlay.addLayer("eclipse/final_co.png", new Point(9, 0));
                    }
                    img = UIAssetManager.getInstance().getImage(visibilityFlag, overlay);
                }
                if (img != null) {
                    cell.setImage(img);
                }
            } else if (index == 2 && elt instanceof IDebuggerVariable && ((IDebuggerVariable)elt).getTypedValue() instanceof ValueRaw) {
                cell.setFont(DbgVariablesFragment.this.context.getFontManager().getCodeFont());
            }
            super.update(cell);
        }

        @Override
        public String getString(Object element) {
            return null;
        }

        @Override
        public String getStringAt(Object element, int index) {
            Object v;
            if (element instanceof IDebuggerVariable) {
                v = (IDebuggerVariable)element;
                if (index == 0) {
                    String name = v.getName();
                    if (v.getAlternateName() != null) {
                        name = name + " (" + v.getAlternateName() + ")";
                    }
                    return name;
                }
                if (index == 1) {
                    return v.getTypedValue().getTypeName();
                }
                if (index >= 2 && index < 5) {
                    return DbgVariablesFragment.this.formatCell(v.getTypedValue(), index - 2);
                }
            }
            if (element instanceof ITypedValue) {
                v = (ITypedValue)element;
                if (index == 0) {
                    return "";
                }
                if (index == 1) {
                    return v.getTypeName();
                }
                if (index >= 2 && index < 5) {
                    return DbgVariablesFragment.this.formatCell((ITypedValue)v, index - 2);
                }
            }
            return AbstractArrayGroupFilteredTreeContentProvider.getStringAt(element, index);
        }
    }

    public class TreeContentProvider
    extends AbstractArrayGroupFilteredTreeContentProvider {
        IDebuggerUnit dbg;
        IEventListener listener;

        public TreeContentProvider() {
            super(255, 100, 100);
        }

        @Override
        public void dispose() {
        }

        @Override
        public void inputChanged(final Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput != null && this.listener != null) {
                ((IDebuggerUnit)oldInput).removeListener(this.listener);
                this.listener = null;
            }
            this.dbg = (IDebuggerUnit)newInput;
            if (this.dbg == null) {
                return;
            }
            this.listener = new IEventListener(){

                @Override
                public void onEvent(IEvent e) {
                    logger.i("Event: %s", e);
                    if (TreeContentProvider.this.dbg != null && e.getSource() == TreeContentProvider.this.dbg) {
                        UIExecutor.async((Widget)viewer.getControl(), new UIRunnable(){

                            @Override
                            public void runi() {
                                if (TreeContentProvider.this.dbg != null && !viewer.getControl().isDisposed()) {
                                    Object state = DbgVariablesFragment.this.stateMaintainer.saveState();
                                    viewer.refresh();
                                    DbgVariablesFragment.this.packColumns(false);
                                    DbgVariablesFragment.this.stateMaintainer.restoreState(state);
                                }
                            }
                        });
                    }
                }
            };
            this.dbg.addListener(this.listener);
        }

        @Override
        public Object[] getElements(Object inputElement) {
            try {
                List<? extends IDebuggerVariable> variables;
                IDebuggerThreadStackFrame frame;
                if (((IDebuggerUnit)DbgVariablesFragment.this.unit).isAttached() && (frame = DbgVariablesFragment.this.getTargetFrame()) != null && (variables = frame.getVariables()) != null) {
                    return variables.toArray();
                }
            }
            catch (DebuggerException e) {
                logger.catching(e);
            }
            return ArrayUtil.NO_OBJECT;
        }

        @Override
        public Object getParent(Object element) {
            return null;
        }

        @Override
        public boolean hasChildren2(Object element) {
            ITypedValue val = this.getTypedValue(element);
            if (val instanceof AbstractValueComposite) {
                return ((AbstractValueComposite)val).hasChildren();
            }
            return false;
        }

        @Override
        public List<?> getChildren2(Object parentElement) {
            ITypedValue val = this.getTypedValue(parentElement);
            if (val instanceof AbstractValueComposite) {
                return ((AbstractValueComposite)val).getValue();
            }
            return null;
        }

        @Override
        public void sort(Object[] elements) {
            DbgVariablesFragment.this.viewer.getComparator().sort((Viewer)DbgVariablesFragment.this.viewer.getViewer(), elements);
        }

        private ITypedValue getTypedValue(Object parentElement) {
            if (parentElement instanceof IDebuggerVariable) {
                return ((IDebuggerVariable)parentElement).getTypedValue();
            }
            if (parentElement instanceof ITypedValue) {
                return (ITypedValue)parentElement;
            }
            return null;
        }

        public String getString(Object element) {
            return null;
        }

        @Override
        public Object[] getRowElements(Object row) {
            return new Object[]{this.getString(row)};
        }
    }
}

