/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStructureType;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.rcpclient.dialogs.TextDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.ItemEntry;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.NativeTypeStructureEditorView;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StructEditorAction;

public class StructEditorActionSetType
extends StructEditorAction {
    public StructEditorActionSetType(NativeTypeStructureEditorView v) {
        super("Set Type", v);
        this.keyCode = 121;
        this.setAccelerator(89);
    }

    @Override
    public boolean isEnabled() {
        return this.v.getSelectedEntry() != null;
    }

    @Override
    public void run() {
        if (!this.verifyType()) {
            return;
        }
        ItemEntry e = this.v.getSelectedEntry();
        if (e == null) {
            return;
        }
        String currentFieldSig = "";
        if (e.type != null) {
            currentFieldSig = e.type.getSignature(true);
        }
        TextDialog dlg = new TextDialog(this.v.getShell(), "Edit type of field", currentFieldSig, null);
        dlg.setSelected(true);
        String fieldSig = dlg.open();
        if (fieldSig == null) {
            return;
        }
        IStructureType structType = this.v.getInputType();
        ITypeManager typeman = structType.getTypeManager();
        INativeType fieldType = typeman.getType(fieldSig);
        if (fieldType == null) {
            UI.error(String.format("The type \"%s\" was not found", fieldSig));
            return;
        }
        if (StructEditorActionSetType.setFieldType(this.v, e, structType, fieldType)) {
            this.v.refresh();
        }
    }

    static boolean setFieldType(NativeTypeStructureEditorView v, ItemEntry e, IStructureType structType, INativeType newFieldType) {
        if (newFieldType == e.type) {
            return false;
        }
        if (structType.isCircular(newFieldType)) {
            UI.error("A cycle was detected: a structure cannot contain itself");
            return false;
        }
        if (!StructEditorActionSetType.offerClearFields(v, structType, e.offset, newFieldType.getSize())) {
            return false;
        }
        if (structType.getTypeManager().addStructureField(structType, e.name, newFieldType, e.offset) == null) {
            UI.error(String.format("A field of type \"%s\" could not be created at offset %Xh", newFieldType.getName(true), e.offset));
            return false;
        }
        return true;
    }
}

