/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units;

import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.ContextMenuFilter;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilteredTableView;
import com.pnfsoftware.jeb.rcpclient.extensions.export.ExportUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTableViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTableContentProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.TablePatternMatcher;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractTableFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.util.regex.ILabelValueProvider;
import com.pnfsoftware.jeb.rcpclient.util.regex.PatternFilter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableColumn;

public abstract class AbstractFilteredTableFragment<T extends IUnit, V>
extends AbstractTableFragment<T, V> {
    private static final ILogger logger = GlobalLog.getLogger(AbstractFilteredTableFragment.class);
    private FilteredTableView filteredView;
    private FilteredTableViewer filteredViewer;
    private ContextMenu menu;
    private IFilteredTableContentProvider provider;
    private ILabelValueProvider labelProvider;

    public AbstractFilteredTableFragment(Composite parent, int style, T unit, IRcpUnitView unitView, RcpClientContext context, IFilteredTableContentProvider provider) {
        super(parent, style, unit, unitView, context);
        this.provider = provider;
    }

    public IFilteredTableContentProvider getProvider() {
        return this.provider;
    }

    protected void setLabelProvider(ILabelValueProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public ILabelValueProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new DefaultCellLabelProvider(this.provider);
        }
        return this.labelProvider;
    }

    protected FilteredTableViewer buildFilteredViewer(Composite parent, String[] columnNames) {
        return this.buildFilteredViewer(parent, columnNames, true);
    }

    protected FilteredTableViewer buildFilteredViewer(Composite parent, String[] columnNames, boolean defaultMenu) {
        long time0 = System.currentTimeMillis();
        TablePatternMatcher patternMatcher = new TablePatternMatcher(this.provider, this.getLabelProvider());
        this.buildSimpleInner(parent, 898, columnNames);
        this.filteredViewer.setFilterPatternFactory(new PatternFilter(patternMatcher, "", columnNames));
        Object viewer = this.filteredViewer.getViewer();
        if (defaultMenu) {
            this.menu = ContextMenuFilter.addContextMenu(viewer, this.filteredView.getFilterText(), this.getLabelProvider(), columnNames, null);
        }
        this.filteredViewer.setInput(this.unit, true);
        this.filteredViewer.setDisplayFilteredRowCount(true);
        long time1 = System.currentTimeMillis();
        if (this.filteredView.getTable().getItemCount() < 10000) {
            for (TableColumn tc : this.filteredView.getTable().getColumns()) {
                tc.pack();
            }
        }
        long time2 = System.currentTimeMillis();
        logger.i("Table %s refresh time: %dms", this, time2 - time0);
        logger.i("Table %s pack time: %dms", this, time2 - time1);
        return this.filteredViewer;
    }

    protected FilteredTableViewer buildSimple(Composite parent, int style, String[] columnNames) {
        this.buildSimpleInner(parent, style, columnNames);
        this.filteredViewer.setInput(this.unit, true);
        return this.filteredViewer;
    }

    private FilteredTableViewer buildSimpleInner(Composite parent, int style, String[] columnNames) {
        this.filteredView = new FilteredTableView(parent, style, columnNames);
        this.initFilteredView(this.filteredView);
        this.filteredViewer = new FilteredTableViewer(this.filteredView);
        this.filteredViewer.setContentProvider(this.provider);
        this.filteredViewer.setLabelProvider(this.getLabelProvider());
        return this.filteredViewer;
    }

    protected void addContextMenu(IContextMenu menuItem) {
        if (this.menu == null) {
            throw new IllegalStateException("No menu exist for this fragment");
        }
        this.menu.addContextMenu(menuItem);
    }

    public FilteredTableViewer getViewer() {
        return this.filteredViewer;
    }

    public void refresh() {
        this.filteredViewer.refresh();
    }

    @Override
    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.filteredViewer.getSelection();
    }

    public Object getSelectedRawRow() {
        IStructuredSelection sel = this.getSelection();
        if (sel.isEmpty()) {
            return null;
        }
        return sel.getFirstElement();
    }

    protected abstract boolean isCorrectRow(Object var1);

    @Override
    public String exportElementToString(Object obj) {
        if (this.isCorrectRow(obj)) {
            return this.exportRowToStringV(obj);
        }
        return null;
    }

    protected String exportRowToStringV(V obj) {
        Object[] row = this.provider.getRowElements(obj);
        return ExportUtil.buildCsvLine(this.getLabelProvider(), obj, row.length);
    }

    protected void initFilteredView(FilteredTableView view) {
    }

    @Override
    public byte[] export() {
        return Strings.encodeUTF8(this.filteredView.exportToString());
    }
}

