/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts;

import com.google.common.net.MediaType;
import com.pnfsoftware.jeb.core.ILiveArtifact;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.units.IArchiveUnit;
import com.pnfsoftware.jeb.core.units.IBinaryUnit;
import com.pnfsoftware.jeb.core.units.IDuplicatedUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.util.regex.IValueProvider;
import com.pnfsoftware.jeb.util.format.Strings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;

public class ProjectTreeLabelProvider
extends StyledCellLabelProvider
implements IValueProvider {
    public static final int FGCOLOR_UNIT_REPARSED = 160;
    public static final int BGCOLOR_DEBUGGER_ATTACHED = 10223003;
    private static Map<String, String> typeToPath = new HashMap<String, String>();

    @Override
    public void update(ViewerCell cell) {
        Color fgcolor = null;
        Color bgcolor = null;
        String text = "?";
        Image img = null;
        Object element = cell.getElement();
        if (element instanceof IRuntimeProject) {
            IRuntimeProject project = (IRuntimeProject)element;
            text = project.getName();
            img = UIAssetManager.getInstance().getImage("eclipse/prj_obj.png");
        } else if (element instanceof ILiveArtifact) {
            ILiveArtifact artifact = (ILiveArtifact)element;
            text = artifact.getArtifact().getName();
            img = UIAssetManager.getInstance().getImage("eclipse/generic_element.png");
        } else if (element instanceof IUnit) {
            IUnit unit = (IUnit)element;
            fgcolor = ProjectTreeLabelProvider.determineLabelFgcolor(unit);
            bgcolor = ProjectTreeLabelProvider.determineLabelBgcolor(unit);
            text = unit.getName();
            if (element instanceof IDuplicatedUnit) {
                cell.setFont(UIAssetManager.getInstance().getFont(cell.getFont(), null, (Integer)2));
                unit = ((IDuplicatedUnit)element).getOriginal();
                text = text + " (duplicate of " + this.getDupName((IUnit)element, unit) + ")";
            }
            String type = unit.getFormatType();
            String unitIconKey = "unit:/" + type;
            img = JFaceResources.getImage(unitIconKey);
            if (img == null) {
                String iconRelPath;
                byte[] iconData = unit.getIconData();
                if (iconData != null) {
                    img = new Image((Device)UIAssetManager.getInstance().getDisplay(), (InputStream)new ByteArrayInputStream(iconData));
                    JFaceResources.getImageRegistry().put(unitIconKey, img);
                }
                if (img == null && (iconRelPath = ProjectTreeLabelProvider.getUnitIconRelativePath(unit)) != null) {
                    img = UIAssetManager.getInstance().getImage(iconRelPath);
                }
            }
        } else if (element instanceof String && (text = (String)element).startsWith("<i>")) {
            text = text.substring(3);
            cell.setFont(UIAssetManager.getInstance().getFont(cell.getFont(), null, (Integer)2));
        }
        cell.setForeground(fgcolor);
        cell.setBackground(bgcolor);
        cell.setText(text);
        if (img != null) {
            cell.setImage(img);
        }
        super.update(cell);
    }

    private CharSequence getDupName(IUnit element, IUnit target) {
        int j;
        int i;
        List<String> buildPath = UnitUtil.buildFullyQualifiedUnitPathList(element, true);
        List<String> buildPathTarget = UnitUtil.buildFullyQualifiedUnitPathList(target, true);
        for (i = 0; i < buildPath.size() && i < buildPathTarget.size() && buildPath.get(i).equals(buildPathTarget.get(i)); ++i) {
        }
        StringBuilder name = new StringBuilder();
        if (i == 0) {
            name.append("/ ");
        } else {
            for (j = i + 1; j < buildPath.size(); ++j) {
                name.append(".. > ");
            }
        }
        if (i == buildPathTarget.size()) {
            name.append("/ ");
            i = 0;
        }
        name.append(buildPathTarget.get(i));
        for (j = ++i; j < buildPathTarget.size(); ++j) {
            name.append(" > ").append(buildPathTarget.get(j));
        }
        return name;
    }

    private static boolean isTransientUnit(IUnit unit) {
        IUnitCreator parent = unit.getParent();
        if (parent instanceof IUnit) {
            return ((IUnit)parent).isTransientChild(unit);
        }
        return false;
    }

    private static Color determineLabelFgcolor(IUnit unit) {
        if (ProjectTreeLabelProvider.isTransientUnit(unit)) {
            return UIAssetManager.getInstance().getColor(160);
        }
        return null;
    }

    private static Color determineLabelBgcolor(IUnit unit) {
        if (!unit.isProcessed()) {
            return null;
        }
        if (unit instanceof IDebuggerUnit && ((IDebuggerUnit)unit).isAttached()) {
            return UIAssetManager.getInstance().getColor(10223003);
        }
        return null;
    }

    public static String getUnitIconRelativePath(IUnit unit) {
        String[] parts;
        String mimeType;
        String type = unit.getFormatType();
        if (type != null) {
            for (String t : typeToPath.keySet()) {
                if (!t.equalsIgnoreCase(type)) continue;
                return typeToPath.get(t);
            }
            if (type.startsWith("dcmp_")) {
                return "eclipse/debugt_obj.png";
            }
            if (type.startsWith("dbug_")) {
                return "eclipse/debug_view.png";
            }
            String lt = type.toLowerCase();
            if (lt.contains("stream")) {
                return "eclipse/builder.png";
            }
            if (lt.contains("image")) {
                return "eclipse/image_application.png";
            }
            if (unit instanceof ICodeUnit) {
                return "images/processor-icon.png";
            }
            String name = Strings.safe(unit.getName()).toLowerCase();
            if (Strings.contains(name, "metadata", "header", "information")) {
                return "eclipse/info_tsk.png";
            }
        }
        if (unit instanceof IArchiveUnit) {
            return "eclipse/importzip_wiz.png";
        }
        if (unit instanceof IBinaryUnit && (mimeType = ((IBinaryUnit)unit).getMimeType()) != null && (parts = mimeType.split("/")).length == 2) {
            try {
                MediaType m = MediaType.create((String)parts[0], (String)parts[1]);
                if (m.is(MediaType.ANY_IMAGE_TYPE)) {
                    return "eclipse/image_application.png";
                }
                if (m.is(MediaType.ANY_AUDIO_TYPE)) {
                    return "eclipse/image_application.png";
                }
                if (m.is(MediaType.ANY_VIDEO_TYPE)) {
                    return "eclipse/image_application.png";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "eclipse/unknown_obj.png";
    }

    @Override
    public String getString(Object element) {
        if (element instanceof IRuntimeProject) {
            return ((IRuntimeProject)element).getName();
        }
        if (element instanceof ILiveArtifact) {
            return ((ILiveArtifact)element).getArtifact().getName();
        }
        if (element instanceof IUnit) {
            return ((IUnit)element).getName();
        }
        if (element != null) {
            return element.toString();
        }
        return null;
    }

    @Override
    public String getStringAt(Object element, int filterLabelIndex) {
        return this.getString(element);
    }

    static {
        typeToPath.put("composite", "eclipse/fldr_obj.png");
        typeToPath.put("odex", "images/odex_icon.png");
        typeToPath.put("dex", "android.png");
        typeToPath.put("apk", "eclipse/importzip_wiz.png");
        typeToPath.put("arsc", "android.png");
        typeToPath.put("xapk", "eclipse/importzip_wiz.png");
        typeToPath.put("art", "android.png");
        typeToPath.put("vdex", "images/odex_icon.png");
        typeToPath.put("cdex", "images/odex_icon.png");
        typeToPath.put("crx", "images/chrome_icon.png");
        typeToPath.put("zip", "eclipse/importzip_wiz.png");
        typeToPath.put("sevenzip", "eclipse/importzip_wiz.png");
        typeToPath.put("jar", "eclipse/jar_obj.png");
        typeToPath.put("ar", "eclipse/importzip_wiz.png");
        typeToPath.put("tar", "eclipse/importzip_wiz.png");
        typeToPath.put("gzip", "eclipse/importzip_wiz.png");
        typeToPath.put("html", "eclipse/html_tag_obj.png");
        typeToPath.put("xml", "eclipse/generic_xml_obj.png");
        typeToPath.put("json", "images/json_icon.png");
        typeToPath.put("cert", "eclipse/owned_monitor_obj.png");
        typeToPath.put("java", "eclipse/jcu_obj.png");
        typeToPath.put("javaclass", "images/java_icon.png");
        typeToPath.put("javascript", "images/js_icon.png");
        typeToPath.put("text", "eclipse/file_obj.png");
        typeToPath.put("pdf", "images/pdf_icon.png");
        typeToPath.put("text", "eclipse/file_obj.png");
        typeToPath.put("msdoc", "images/word_icon.png");
        typeToPath.put("msxls", "images/excel_icon.png");
        typeToPath.put("msppt", "images/powerpoint_icon.png");
        typeToPath.put("msoutlook", "images/outlook_icon.png");
        typeToPath.put("msthumbs", "images/thumbs_icon.png");
        typeToPath.put("ihex", "images/ihex_icon.png");
        typeToPath.put("elf", "images/elf_icon.png");
        typeToPath.put("winpe", "images/pe_icon.png");
        typeToPath.put("macho", "eclipse/builder.png");
        typeToPath.put("wincoff", "eclipse/builder.png");
        typeToPath.put("c", "eclipse/file_obj.png");
        typeToPath.put("cpp", "eclipse/file_obj.png");
        typeToPath.put("wasm", "images/wasm_icon.png");
        typeToPath.put("eth", "images/ethereum_icon.png");
    }
}

