/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.iviewers.tree;

import com.pnfsoftware.jeb.core.output.tree.INode;
import com.pnfsoftware.jeb.core.output.tree.ITreeDocument;
import com.pnfsoftware.jeb.rcpclient.iviewers.tree.InteractiveTreeViewer;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

class LazyContentProvider
implements ILazyTreeContentProvider {
    private static final ILogger logger = GlobalLog.getLogger(LazyContentProvider.class);
    InteractiveTreeViewer iviewer;
    ITreeDocument idoc;
    TreeViewer viewer;

    public LazyContentProvider(InteractiveTreeViewer iviewer) {
        this.iviewer = iviewer;
        this.viewer = iviewer.getViewer();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        this.idoc = (ITreeDocument)newInput;
    }

    @Override
    public Object getParent(Object e) {
        logger.debug("getParent() e=%s", e);
        return null;
    }

    @Override
    public void updateElement(Object e, int index) {
        logger.debug("updateElement() e=%s index=%d", e, index);
        if (e instanceof ITreeDocument) {
            INode element = ((ITreeDocument)e).getRoots().get(index);
            this.viewer.replace(e, index, element);
            this.viewer.setChildCount(element, element.getChildren().size());
        } else if (e instanceof INode) {
            INode element = ((INode)e).getChildren().get(index);
            this.viewer.replace(e, index, element);
            this.viewer.setChildCount(element, element.getChildren().size());
        }
    }

    @Override
    public void updateChildCount(Object e, int currentChildCount) {
        int cnt;
        logger.debug("updateChildCount() e=%s currentChildCount=%d", e, currentChildCount);
        if (e instanceof ITreeDocument) {
            int cnt2 = ((ITreeDocument)e).getRoots().size();
            if (cnt2 != currentChildCount) {
                this.viewer.setChildCount(e, cnt2);
            }
        } else if (e instanceof INode && (cnt = ((INode)e).getChildren().size()) != currentChildCount) {
            this.viewer.setChildCount(e, cnt);
        }
    }
}

