/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.file.export;

import com.pnfsoftware.jeb.core.units.code.ICodeClass;
import com.pnfsoftware.jeb.core.units.code.ICodePackage;
import com.pnfsoftware.jeb.core.units.code.ISourceUnit;
import com.pnfsoftware.jeb.rcpclient.handlers.file.export.IFileExport;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FileExportCodeClass
implements IFileExport<ICodeClass> {
    private List<? extends ICodeClass> allClasses;

    public FileExportCodeClass(List<? extends ICodeClass> allClasses) {
        this.allClasses = allClasses;
    }

    @Override
    public List<? extends ICodeClass> getItems() {
        return this.allClasses;
    }

    @Override
    public boolean canProcess(ICodeClass item) {
        return (item.getGenericFlags() & 0x100000) == 0;
    }

    @Override
    public List<String> getPath(ICodeClass c) {
        ArrayList<String> packages = new ArrayList<String>();
        for (ICodePackage p = c.getPackage(); p != null; p = p.getParentPackage()) {
            if (p.getName(true) == null) continue;
            packages.add(0, p.getName(true));
        }
        return packages;
    }

    @Override
    public String getFullName(ICodeClass c) {
        return FileExportCodeClass.getFullPackage(this.getPath(c)) + "." + c.getName(true);
    }

    @Override
    public String getNameFromSourceUnit(ISourceUnit sourceUnit) {
        String fullName = sourceUnit.getFullyQualifiedName();
        return fullName.substring(1, fullName.length() - 1).replace('/', '.');
    }

    public static String getFullPackage(List<String> p) {
        return StringUtils.join(p, (char)'.');
    }

    @Override
    public boolean isAtAddress(ICodeClass c, String address) {
        return address.startsWith(c.getAddress().substring(0, c.getAddress().lastIndexOf(59)));
    }
}

