/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.debugger;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.RuntimeProjectUtil;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerBreakpoint;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.rcpclient.handlers.debugger.DebuggerBaseHandler;
import com.pnfsoftware.jeb.rcpclient.parts.UIState;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import java.util.List;
import org.eclipse.swt.SWT;

public class DebuggerToggleBreakpointHandler
extends DebuggerBaseHandler {
    public DebuggerToggleBreakpointHandler() {
        super("dbgToggleBreakpoint", S.s(578), null, null, SWT.MOD1 | 0x42);
    }

    @Override
    public boolean canExecute() {
        return this.getCodeUnitAddress(this.part) != null;
    }

    @Override
    public void execute() {
        UnitPartManager unitPart = (UnitPartManager)this.part.getManager();
        ICodeUnit unit = (ICodeUnit)unitPart.getUnit();
        String address = unitPart.getActiveAddress();
        IRuntimeProject prj = this.context.getOpenedProject();
        List<IDebuggerUnit> debuggers = RuntimeProjectUtil.findUnitsByType(prj, IDebuggerUnit.class, false);
        for (IDebuggerUnit dbg : debuggers) {
            if (!dbg.getPotentialDebuggees().contains(unit) || !dbg.isAttached()) continue;
            IDebuggerBreakpoint bp = dbg.getBreakpoint(address, unit);
            if (bp == null) {
                dbg.setBreakpoint(address, unit);
            } else {
                dbg.clearBreakpoint(bp);
            }
            return;
        }
        UIState uiState = this.context.getUIState(unit);
        if (!uiState.isBreakpoint(address)) {
            uiState.setBreakpoint(address, true);
        } else {
            uiState.removeBreakpoint(address);
        }
    }
}

