/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.debugger;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.RuntimeProjectUtil;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerBreakpoint;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.handlers.debugger.DebuggerBaseHandler;
import com.pnfsoftware.jeb.rcpclient.parts.UIState;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import java.util.List;
import org.eclipse.swt.SWT;

public class DebuggerRunToLineHandler
extends DebuggerBaseHandler {
    public DebuggerRunToLineHandler() {
        super("dbgRunToLine", S.s(555), null, "eclipse/runtoline_co.png", SWT.MOD4 | 0x52);
    }

    @Override
    public boolean canExecute() {
        return this.canStepOperation(this.part) && this.getCodeUnitAddress(this.part) != null;
    }

    @Override
    public void execute() {
        this.setTemporaryBp(this.part);
        IDebuggerUnit dbg = this.getCurrentDebugger(this.part);
        this.executeWithPopup(() -> dbg.run());
    }

    private boolean setTemporaryBp(IMPart part) {
        UnitPartManager unitPart = (UnitPartManager)part.getManager();
        ICodeUnit unit = (ICodeUnit)unitPart.getUnit();
        String address = unitPart.getActiveAddress();
        IRuntimeProject prj = this.context.getOpenedProject();
        List<IDebuggerUnit> debuggers = RuntimeProjectUtil.findUnitsByType(prj, IDebuggerUnit.class, false);
        for (IDebuggerUnit dbg : debuggers) {
            IDebuggerBreakpoint bp;
            if (!dbg.getPotentialDebuggees().contains(unit) || (bp = dbg.getBreakpoint(address, unit)) == null) continue;
            return false;
        }
        UIState uiState = this.context.getUIState(unit);
        for (IDebuggerUnit dbg : debuggers) {
            if (!dbg.getPotentialDebuggees().contains(unit)) continue;
            dbg.setBreakpoint(address, unit);
            uiState.setTemporaryBreakpoint(address, 1);
            return true;
        }
        if (uiState.isBreakpoint(address)) {
            return false;
        }
        uiState.setTemporaryBreakpoint(address, 1);
        return true;
    }
}

