/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class TreeStateMaintainer<T> {
    private TreeViewer viewer;

    public TreeStateMaintainer() {
    }

    public TreeStateMaintainer(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public void setViewer(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public Object saveState() {
        Tree tree = this.viewer.getTree();
        State state = new State();
        for (TreeItem topItem = tree.getTopItem(); topItem != null; topItem = topItem.getParentItem()) {
            Object object = topItem.getData();
            state.pathForTop.add(0, object);
        }
        state.expandedTree = new Node<Object>(null);
        this.saveExpansionState(tree, state.expandedTree);
        return state;
    }

    private void saveExpansionState(Object item, Node<T> node) {
        TreeItem[] childrenItems;
        for (TreeItem childItem : childrenItems = TreeStateMaintainer.getChildrenItems(item)) {
            if (!childItem.getExpanded()) continue;
            Node<Object> c = node.addChild(childItem.getData());
            this.saveExpansionState(childItem, c);
        }
    }

    public void restoreState(Object state) {
        State _state = (State)state;
        Tree tree = this.viewer.getTree();
        this.restoreExpansionState(tree, _state.expandedTree);
        Tree base = tree;
        TreeItem matchedItem = null;
        for (Object previousObject : _state.pathForTop) {
            matchedItem = null;
            for (TreeItem item : TreeStateMaintainer.getChildrenItems(base)) {
                if (!this.likeEquals(item.getData(), previousObject)) continue;
                matchedItem = item;
                break;
            }
            if (matchedItem == null) break;
            base = matchedItem;
        }
        if (matchedItem != null) {
            tree.setTopItem(matchedItem);
        }
    }

    private void restoreExpansionState(Object base, Node<T> node) {
        for (Node c : node.children) {
            TreeItem item = this.findMatchingItem(base, c.object);
            if (item == null) break;
            this.viewer.expandToLevel(item.getData(), 1);
            this.restoreExpansionState(item, c);
        }
    }

    public static final TreeItem[] getChildrenItems(Object base) {
        if (base instanceof Tree) {
            return ((Tree)base).getItems();
        }
        if (base instanceof TreeItem) {
            return ((TreeItem)base).getItems();
        }
        return null;
    }

    TreeItem findMatchingItem(Object base, T previousObject) {
        TreeItem[] items;
        for (TreeItem item : items = TreeStateMaintainer.getChildrenItems(base)) {
            Object currentObject = item.getData();
            if (!this.likeEquals(currentObject, previousObject)) continue;
            return item;
        }
        return null;
    }

    public abstract boolean likeEquals(T var1, T var2);

    private static class Node<T> {
        T object;
        List<Node<T>> children = new ArrayList<Node<T>>();

        Node(T o) {
            this.object = o;
        }

        Node<T> addChild(T o) {
            Node<T> c = new Node<T>(o);
            this.children.add(c);
            return c;
        }

        public String toString() {
            return this.object == null ? null : this.object.toString();
        }
    }

    public static class State<T> {
        List<T> pathForTop = new ArrayList<T>();
        Node<T> expandedTree;
    }
}

