/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.viewers;

import com.pnfsoftware.jeb.rcpclient.extensions.controls.AbstractFilteredView;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilteredTreeView;
import com.pnfsoftware.jeb.rcpclient.extensions.filter.AbstractFilteredFilter;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.AbstractFilteredViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DndDragSource;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DndDropTarget;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredViewerComparator;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IDndProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTreeContentProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.TreeStateMaintainer;
import com.pnfsoftware.jeb.rcpclient.iviewers.tree.TreeUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class FilteredTreeViewer
extends AbstractFilteredViewer<Tree, TreeViewer> {
    private static final ILogger logger = GlobalLog.getLogger(FilteredTreeViewer.class);
    private static final int EXPAND_LIMIT = 2000;
    public static final int EXPAND_ERROR = -1;
    Object[] expandedElements;
    private boolean expandAfterFilter;
    private TreeStateMaintainer<?> treeStateMaintainer;

    public FilteredTreeViewer(FilteredTreeView widget, boolean expandAfterFilter) {
        super(widget);
        this.expandAfterFilter = expandAfterFilter;
        this.comparator = new FilteredViewerComparator(Strings.getDefaultComparator(), this);
        ((TreeViewer)this.getViewer()).setComparator(this.comparator);
        int colIndex = 0;
        for (TreeColumn col : widget.getTree().getColumns()) {
            col.addSelectionListener((SelectionListener)new ColumnSelectionListener(colIndex, col));
            ++colIndex;
        }
    }

    @Override
    protected TreeViewer buildViewer(AbstractFilteredView<Tree> widget) {
        return new TreeViewer(widget.getElement());
    }

    @Override
    protected AbstractFilteredFilter buildFilter(TreeViewer viewer) {
        return new RegexViewerFilter(viewer);
    }

    @Override
    protected Object doAfterEmptyFilter() {
        if (this.expandedElements != null) {
            ((TreeViewer)this.getViewer()).collapseAll();
            ((TreeViewer)this.getViewer()).setExpandedElements(this.expandedElements);
            this.expandedElements = null;
        }
        return null;
    }

    @Override
    protected void doBeforeNotNullFilter() {
        if (this.expandedElements == null) {
            this.expandedElements = ((TreeViewer)this.getViewer()).getExpandedElements();
        }
    }

    @Override
    protected Object doAfterNotNullFilter() {
        if (this.expandAfterFilter) {
            try {
                ((TreeViewer)this.getViewer()).getTree().setRedraw(false);
                TreeItem[] items = ((TreeViewer)this.getViewer()).getTree().getItems();
                Integer n = this.expandFiltered(items, items.length);
                return n;
            }
            finally {
                ((TreeViewer)this.getViewer()).getTree().setRedraw(true);
            }
        }
        return null;
    }

    private int expandFiltered(TreeItem[] items, int opened) {
        if (items == null || items.length == 0) {
            return opened;
        }
        ArrayList<TreeItem> toExpand = new ArrayList<TreeItem>();
        for (TreeItem item : items) {
            boolean childMatch;
            if (!this.getProvider().hasChildren(item.getData()) || !(childMatch = this.isOneChildMatchFilter(item.getData()))) continue;
            toExpand.add(item);
        }
        for (TreeItem item : toExpand) {
            ((TreeViewer)this.getViewer()).setExpandedState(item.getData(), true);
            if ((opened += item.getItems().length) <= 2000) continue;
            return -1;
        }
        for (int i = 0; i < toExpand.size(); ++i) {
            opened = this.expandFiltered(((TreeItem)toExpand.get(i)).getItems(), opened);
            if (opened > 2000) {
                return -1;
            }
            if (opened != -1) continue;
            return -1;
        }
        return opened;
    }

    private boolean isOneChildMatchFilter(Object root) {
        Object[] children;
        if (root == null || !this.getProvider().hasChildren(root)) {
            return false;
        }
        for (Object child : children = this.getProvider().getChildren(root)) {
            if (!this.filter.isElementMatch(child)) continue;
            return true;
        }
        for (Object child : children) {
            boolean childMatch = this.isOneChildMatchFilter(child);
            if (!childMatch) continue;
            return true;
        }
        return false;
    }

    public void addDragnDropSupport(IDndProvider dndProvider) {
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        int operations = 10;
        DndDragSource dragSource = new DndDragSource(dndProvider);
        ((TreeViewer)this.getViewer()).addDragSupport(operations, types, dragSource);
        ((TreeViewer)this.getViewer()).addDropSupport(operations, types, (DropTargetListener)new DndDropTarget((Viewer)this.getViewer(), dndProvider, dragSource));
    }

    public void setContentProvider(IFilteredTreeContentProvider provider) {
        super.setContentProvider(provider);
    }

    public IFilteredTreeContentProvider getProvider() {
        return (IFilteredTreeContentProvider)this.provider;
    }

    public void expandAll() {
        ((TreeViewer)this.getViewer()).expandAll();
    }

    public void expandToLevel(int level) {
        ((TreeViewer)this.getViewer()).expandToLevel(level);
    }

    public void expandToLevel(Object elementOrTreePath, int level) {
        ((TreeViewer)this.getViewer()).expandToLevel(elementOrTreePath, level);
    }

    public String exportToString() {
        return TreeUtil.buildXml(((TreeViewer)this.getViewer()).getTree(), 2);
    }

    @Override
    public void refresh() {
        Object state = null;
        if (this.treeStateMaintainer != null) {
            try {
                state = this.treeStateMaintainer.saveState();
            }
            catch (Exception e) {
                logger.catchingSilent(e);
            }
        }
        super.refresh();
        if (this.treeStateMaintainer != null && state != null) {
            try {
                this.treeStateMaintainer.restoreState(state);
            }
            catch (Exception e) {
                logger.catchingSilent(e);
            }
        }
    }

    public void setTreeStateMaintainer(TreeStateMaintainer<?> treeStateMaintainer) {
        treeStateMaintainer.setViewer((TreeViewer)this.getViewer());
        this.treeStateMaintainer = treeStateMaintainer;
    }

    public TreeStateMaintainer<?> getTreeStateMaintainer() {
        return this.treeStateMaintainer;
    }

    public class RegexViewerFilter
    extends AbstractFilteredFilter {
        private Set<Object> parentMatches;

        public RegexViewerFilter(StructuredViewer viewer) {
            super(viewer);
            this.parentMatches = Collections.newSetFromMap(new WeakHashMap());
        }

        @Override
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.patternChanged) {
                this.patternChanged = false;
                this.parentMatches.clear();
            }
            if (this.parentMatches.contains(element)) {
                return true;
            }
            if (this.isParentMatches(parentElement)) {
                if (!(element instanceof String)) {
                    this.parentMatches.add(element);
                }
                return true;
            }
            boolean elementMatch = this.isElementMatch(element);
            if (elementMatch) {
                this.parentMatches.add(element);
                return true;
            }
            Object[] children = this.getProvider().getChildren(element);
            if (children != null) {
                for (Object child : children) {
                    boolean r = this.select(viewer, element, child);
                    if (!r) continue;
                    return true;
                }
            }
            return elementMatch;
        }

        @Override
        public IFilteredTreeContentProvider getProvider() {
            return FilteredTreeViewer.this.getProvider();
        }

        private boolean isParentMatches(Object parentElement) {
            return this.parentMatches.contains(parentElement);
        }

        @Override
        protected void onRefreshDone() {
        }
    }

    class ColumnSelectionListener
    extends SelectionAdapter {
        int columnIndex;
        TreeColumn column;

        public ColumnSelectionListener(int columnIndex, TreeColumn column) {
            this.columnIndex = columnIndex;
            this.column = column;
        }

        public void widgetSelected(SelectionEvent e) {
            if (FilteredTreeViewer.this.comparator != null) {
                FilteredTreeViewer.this.comparator.setColumn(this.columnIndex);
                int dir = FilteredTreeViewer.this.comparator.getDirection();
                ((Tree)FilteredTreeViewer.this.getWidget().getElement()).setSortDirection(dir);
                ((Tree)FilteredTreeViewer.this.getWidget().getElement()).setSortColumn(this.column);
                FilteredTreeViewer.this.refresh();
            }
        }
    }
}

