/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.themes;

import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilterText;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.Graph;
import com.pnfsoftware.jeb.rcpclient.extensions.themes.DarkTheme;
import com.pnfsoftware.jeb.rcpclient.extensions.themes.IThemeChangeListener;
import com.pnfsoftware.jeb.rcpclient.extensions.themes.StandardTheme;
import com.pnfsoftware.jeb.rcpclient.extensions.themes.Theme;
import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.collect.WeakIdentityHashMap;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class ThemeManager {
    private static final ILogger logger = GlobalLog.getLogger(ThemeManager.class);
    public static final String ID_THEME_STANDARD = "theme.standard";
    public static final String ID_THEME_DARK = "theme.dark";
    private static final Theme standardTheme = new StandardTheme();
    private static ThemeManager instance = new ThemeManager();
    Display display;
    Listener filter;
    LinkedHashMap<String, Theme> themes = new LinkedHashMap();
    Theme activeTheme;
    List<IThemeChangeListener> listeners = new ArrayList<IThemeChangeListener>();
    WeakIdentityHashMap<Widget, Integer> seen = new WeakIdentityHashMap();
    public static final int FLAG_PROCEED = 0;
    public static final int FLAG_SKIP_GENERIC = 1;
    public static final int FLAG_SKIP_RECURSION = 2;
    public static final int FLAG_SKIP_ALL = 3;

    public static ThemeManager getInstance() {
        return instance;
    }

    private ThemeManager() {
        this.display = Display.getCurrent();
        if (this.display == null) {
            throw new RuntimeException("The display must be initialized");
        }
        this.activeTheme = this.registerTheme(standardTheme);
        this.registerTheme(new DarkTheme());
        this.filter = new Listener(){

            public void handleEvent(Event event) {
                ThemeManager.this.processControls(event.widget);
            }
        };
        this.display.addFilter(26, this.filter);
        this.display.addFilter(15, this.filter);
        this.display.addFilter(22, this.filter);
    }

    private Theme registerTheme(Theme theme) {
        if (this.themes.put(theme.getId(), theme) != null) {
            throw new RuntimeException("Attempt to overwrite a theme");
        }
        return theme;
    }

    public Collection<String> getThemes() {
        return Collections.unmodifiableCollection(this.themes.keySet());
    }

    public String getActiveTheme() {
        return this.activeTheme.getId();
    }

    public boolean isStandardTheme() {
        return ID_THEME_STANDARD.equals(this.activeTheme.getId());
    }

    public boolean isDarkTheme() {
        return ID_THEME_DARK.equals(this.activeTheme.getId());
    }

    public boolean setNextTheme() {
        ArrayList<String> ids = new ArrayList<String>(this.themes.keySet());
        if (ids.size() <= 1) {
            return false;
        }
        for (int i = 0; i < ids.size(); ++i) {
            String id = (String)ids.get(i);
            if (!id.equals(this.activeTheme.getId())) continue;
            String nextId = (String)ids.get((i + 1) % ids.size());
            return this.setActiveTheme(nextId);
        }
        return false;
    }

    public boolean setActiveTheme(String themeId) {
        Theme wantedTheme;
        if (themeId == null || themeId.isEmpty()) {
            themeId = ID_THEME_STANDARD;
        }
        if ((wantedTheme = this.themes.get(themeId)) == null) {
            throw new IllegalArgumentException("Unknown theme: " + themeId);
        }
        this.setThemeInternal(wantedTheme, false, true);
        return true;
    }

    public void reapplyTheme() {
        this.setThemeInternal(this.activeTheme, true, true);
    }

    private void setThemeInternal(Theme theme, boolean force, boolean notify) {
        if (theme == this.activeTheme && !force) {
            return;
        }
        this.activeTheme = theme;
        this.seen = new WeakIdentityHashMap();
        for (Shell shell : this.display.getShells()) {
            this.processControls((Widget)shell);
        }
        if (notify) {
            this.notifyThemeChangeListeners(theme == null ? null : theme.getId());
        }
    }

    public void processControlForcibly(Widget w) {
        this.processControls(w, true);
    }

    void processControls(Widget w) {
        this.processControls(w, false);
    }

    void processControls(Widget w, boolean force) {
        if (w == null) {
            return;
        }
        if (this.seen.get(w) != null) {
            if (!force) {
                return;
            }
        } else {
            this.seen.put(w, 0);
        }
        if (!(w instanceof Control)) {
            return;
        }
        Control ctl = (Control)w;
        int r = this.processSpecificControl(ctl);
        if ((r & 1) == 0) {
            if (ctl.getData("storedOriginalColors") == null) {
                ctl.setData("cBackground", (Object)ctl.getBackground());
                ctl.setData("cForeground", (Object)ctl.getForeground());
                ctl.setData("storedOriginalColors", (Object)true);
            }
            if (this.activeTheme == standardTheme) {
                ctl.setBackground((Color)ctl.getData("cBackground"));
                ctl.setForeground((Color)ctl.getData("cForeground"));
            } else {
                ctl.setBackground(this.activeTheme.cBackground);
                ctl.setForeground(this.activeTheme.cForeground);
            }
        }
        if ((r & 2) == 0 && ctl instanceof Composite) {
            for (Control c : ((Composite)ctl).getChildren()) {
                this.processControls((Widget)c, force);
            }
        }
    }

    private int processSpecificControl(Control ctl) {
        if (ctl instanceof CTabFolder) {
            CTabFolder c = (CTabFolder)ctl;
            if (ctl.getData("storedOriginalColors") == null) {
                ctl.setData("cBackgroundSelectedTab", (Object)c.getSelectionBackground());
                ctl.setData("cForegroundSelectedTab", (Object)c.getSelectionForeground());
                ctl.setData("storedOriginalColors", (Object)true);
            }
            if (this.activeTheme == standardTheme) {
                c.setSelectionBackground((Color)ctl.getData("cBackgroundSelectedTab"));
                c.setSelectionForeground((Color)ctl.getData("cForegroundSelectedTab"));
            } else {
                c.setSelectionBackground(this.activeTheme.cBackgroundSelectedTab);
                c.setSelectionForeground(this.activeTheme.cForegroundSelectedTab);
            }
            return 0;
        }
        if (ctl instanceof Table) {
            Table c = (Table)ctl;
            if (ctl.getData("storedOriginalColors") == null) {
                ctl.setData("cBackgroundTableHeader", (Object)c.getHeaderBackground());
                ctl.setData("cForegroundTableHeader", (Object)c.getHeaderForeground());
                ctl.setData("cBackgroundTable", (Object)c.getBackground());
                ctl.setData("cForegroundTable", (Object)c.getForeground());
                ctl.setData("storedOriginalColors", (Object)true);
            }
            if (this.activeTheme == standardTheme) {
                c.setHeaderBackground((Color)ctl.getData("cBackgroundTableHeader"));
                c.setHeaderForeground((Color)ctl.getData("cForegroundTableHeader"));
                c.setBackground((Color)ctl.getData("cBackgroundTable"));
                c.setForeground((Color)ctl.getData("cForegroundTable"));
            } else {
                c.setHeaderBackground(this.activeTheme.cBackgroundTableHeader);
                c.setHeaderForeground(this.activeTheme.cForegroundTableHeader);
                c.setBackground(this.activeTheme.cBackgroundTable);
                c.setForeground(this.activeTheme.cForegroundTable);
            }
            return 1;
        }
        if (ctl instanceof Tree) {
            Tree c = (Tree)ctl;
            if (ctl.getData("storedOriginalColors") == null) {
                ctl.setData("cBackgroundTableHeader", (Object)c.getHeaderBackground());
                ctl.setData("cForegroundTableHeader", (Object)c.getHeaderForeground());
                ctl.setData("cBackgroundTable", (Object)c.getBackground());
                ctl.setData("cForegroundTable", (Object)c.getForeground());
                ctl.setData("storedOriginalColors", (Object)true);
            }
            if (this.activeTheme == standardTheme) {
                c.setHeaderBackground((Color)ctl.getData("cBackgroundTableHeader"));
                c.setHeaderForeground((Color)ctl.getData("cForegroundTableHeader"));
                c.setBackground((Color)ctl.getData("cBackgroundTable"));
                c.setForeground((Color)ctl.getData("cForegroundTable"));
            } else {
                c.setHeaderBackground(this.activeTheme.cBackgroundTableHeader);
                c.setHeaderForeground(this.activeTheme.cForegroundTableHeader);
                c.setBackground(this.activeTheme.cBackgroundTable);
                c.setForeground(this.activeTheme.cForegroundTable);
            }
            return 1;
        }
        if (ctl instanceof FilterText) {
            if (ctl.getData("storedOriginalColors") == null) {
                ctl.setData("cBackgroundFilter", (Object)ctl.getBackground());
                ctl.setData("cForegroundFilter", (Object)ctl.getForeground());
                ctl.setData("storedOriginalColors", (Object)true);
            }
            if (this.activeTheme == standardTheme) {
                ctl.setBackground((Color)ctl.getData("cBackgroundFilter"));
                ctl.setForeground((Color)ctl.getData("cForegroundFilter"));
            } else {
                ctl.setBackground(this.activeTheme.cBackgroundFilter);
                ctl.setForeground(this.activeTheme.cForegroundFilter);
            }
            return 3;
        }
        if (ctl instanceof Text) {
            if (ctl.getData("storedOriginalColors") == null) {
                ctl.setData("cBackgroundTextbox", (Object)ctl.getBackground());
                ctl.setData("cForegroundTextbox", (Object)ctl.getForeground());
                ctl.setData("storedOriginalColors", (Object)true);
            }
            if (this.activeTheme == standardTheme) {
                ctl.setBackground((Color)ctl.getData("cBackgroundTextbox"));
                ctl.setForeground((Color)ctl.getData("cForegroundTextbox"));
            } else {
                Color fg;
                Color bg;
                boolean isReadOnly;
                boolean bl = isReadOnly = (((Text)ctl).getStyle() & 8) != 0;
                if (isReadOnly) {
                    bg = this.activeTheme.cBackgroundFilterRO;
                    fg = this.activeTheme.cForegroundFilterRO;
                } else {
                    bg = this.activeTheme.cBackgroundFilter;
                    fg = this.activeTheme.cForegroundFilter;
                }
                ctl.setBackground(bg);
                ctl.setForeground(fg);
            }
            return 3;
        }
        if ((ctl.getStyle() & 8) != 0) {
            if (ctl.getData("storedOriginalColors") == null) {
                ctl.setData("cBackgroundTextbox", (Object)ctl.getBackground());
                ctl.setData("cForegroundTextbox", (Object)ctl.getForeground());
                ctl.setData("storedOriginalColors", (Object)true);
            }
            if (this.activeTheme == standardTheme) {
                if (!OSType.determine().isLinux()) {
                    ctl.setBackground((Color)ctl.getData("cBackgroundTextbox"));
                }
                ctl.setForeground((Color)ctl.getData("cForegroundTextbox"));
            } else {
                ctl.setBackground(this.activeTheme.cBackgroundFilter);
                ctl.setForeground(this.activeTheme.cForegroundFilter);
            }
            return 3;
        }
        if (ctl instanceof Graph) {
            return 1;
        }
        return 0;
    }

    public void addThemeChangeListener(IThemeChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeThemeChangeListener(IThemeChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyThemeChangeListeners(String themeId) {
        for (IThemeChangeListener listener : this.listeners) {
            listener.onThemeChange(this.activeTheme);
        }
    }

    public Color getBackgroundColor() {
        return this.activeTheme.getBackground();
    }

    public Color getForegroundColor() {
        return this.activeTheme.getForeground();
    }

    public void registerWidget(final Control ctl) {
        ctl.setBackground(this.getBackgroundColor());
        final IThemeChangeListener listener = new IThemeChangeListener(){

            @Override
            public void onThemeChange(Theme theme) {
                if (!ctl.isDisposed()) {
                    ctl.setBackground(ThemeManager.this.getBackgroundColor());
                }
            }
        };
        this.addThemeChangeListener(listener);
        ctl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ThemeManager.this.removeThemeChangeListener(listener);
            }
        });
    }
}

