/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.tab;

import com.pnfsoftware.jeb.rcpclient.extensions.tab.ITabFolderListener;
import com.pnfsoftware.jeb.rcpclient.extensions.tab.TabFolderEvent;
import com.pnfsoftware.jeb.rcpclient.parts.ILazyView;
import com.pnfsoftware.jeb.rcpclient.util.CTabFolderUtils;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public class TabFolderView
extends Composite
implements CTabFolder2Listener {
    private static final ILogger logger = GlobalLog.getLogger(TabFolderView.class);
    private static final String LAZY_INITIALIZED = "initialized";
    private CTabFolder folder;
    private SelectionListener selectionListener;
    private List<ITabFolderListener> listeners = new ArrayList<ITabFolderListener>();
    private List<Entry> entries = new ArrayList<Entry>();
    private boolean addSpaces;
    private final boolean lazyInit;
    private boolean doNotFocusSelectedTab;
    private List<Entry> entriesByFocusOrder = new ArrayList<Entry>();
    private boolean clearing;

    public TabFolderView(Composite parent, int flags, boolean addSpaces, boolean lazyInit) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.addSpaces = addSpaces;
        this.folder = new CTabFolder((Composite)this, flags);
        CTabFolderUtils.setCTabFolderHeight(this.folder, -1);
        this.folder.addCTabFolder2Listener((CTabFolder2Listener)this);
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TabFolderView.this.clearing) {
                    return;
                }
                CTabItem selectedTab = TabFolderView.this.folder.getSelection();
                for (Entry e : TabFolderView.this.entries) {
                    if (e.tab != selectedTab) continue;
                    Control control = selectedTab.getControl();
                    if (TabFolderView.this.isLazyInitializationToPerform(control)) {
                        ((ILazyView)control).lazyInitialization();
                        control.setData(TabFolderView.LAZY_INITIALIZED, (Object)Boolean.TRUE);
                    }
                    if (TabFolderView.this.doNotFocusSelectedTab) break;
                    e.control.setFocus();
                    if (TabFolderView.this.entriesByFocusOrder.contains(e)) {
                        TabFolderView.this.entriesByFocusOrder.remove(e);
                    }
                    TabFolderView.this.entriesByFocusOrder.add(0, e);
                    break;
                }
            }
        };
        this.folder.addSelectionListener(this.selectionListener);
        this.folder.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.lazyInit = lazyInit;
    }

    public void cleanUp() {
        this.folder.removeSelectionListener(this.selectionListener);
        this.entries.clear();
        this.listeners.clear();
    }

    public void addListener(ITabFolderListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ITabFolderListener l) {
        this.listeners.remove(l);
    }

    public CTabFolder getContainer() {
        return this.folder;
    }

    public List<Control> getControls() {
        ArrayList<Control> r = new ArrayList<Control>();
        for (Entry entry : this.entries) {
            r.add(entry.control);
        }
        return r;
    }

    public int getEntryCount() {
        return this.entries.size();
    }

    public int getEntryVisibleCount() {
        int i = 0;
        for (Entry entry : this.entries) {
            if (entry.tab == null) continue;
            ++i;
        }
        return i;
    }

    private boolean isImmediateLazyInitialization(Control control) {
        return control instanceof ILazyView && !this.lazyInit;
    }

    private boolean isLazyInitializationToPerform(Control control) {
        return control instanceof ILazyView && this.lazyInit && control.getData(LAZY_INITIALIZED) == null;
    }

    public boolean addEntry(String name, Control control) {
        return this.addEntry(name, control, null, true);
    }

    public boolean addEntry(String name, Control control, Integer index) {
        return this.addEntry(name, control, index, true);
    }

    public boolean addEntry(String name, Control control, boolean showTab) {
        return this.addEntry(name, control, null, showTab);
    }

    public boolean addEntry(String name, Control control, Integer index, boolean showTab) {
        if (control == null) {
            return false;
        }
        if (this.isImmediateLazyInitialization(control)) {
            ((ILazyView)control).lazyInitialization();
            control.setData(LAZY_INITIALIZED, (Object)Boolean.TRUE);
        }
        CTabItem item = null;
        if (showTab) {
            item = this.createCTabItem(name, control, index);
        }
        Entry entry = new Entry(name, control, item);
        this.entries.add(entry);
        for (ITabFolderListener l : this.listeners) {
            l.tabAdded(new TabFolderEvent(this, name));
        }
        return true;
    }

    public boolean hideEntry(String name) {
        Entry entry = this.getEntry(name);
        if (entry == null) {
            return false;
        }
        if (entry.tab != null) {
            entry.tab.dispose();
            entry.tab = null;
        }
        return true;
    }

    public boolean removeEntry(String name) {
        Entry entry = this.getEntry(name);
        if (entry == null) {
            return false;
        }
        return this.removeEntry(entry);
    }

    public boolean removeEntry(Control ctl) {
        Entry entry = this.getEntry(ctl);
        if (entry == null) {
            return false;
        }
        return this.removeEntry(entry);
    }

    private boolean removeEntry(Entry entry) {
        if (entry.tab != null) {
            entry.tab.dispose();
            entry.tab = null;
            entry.control.dispose();
            entry.control = null;
        }
        this.entries.remove(entry);
        this.entriesByFocusOrder.remove(entry);
        for (ITabFolderListener l : this.listeners) {
            l.tabRemoved(new TabFolderEvent(this, entry.name));
        }
        return true;
    }

    public void removeAllEntries() {
        this.clearing = true;
        try {
            while (!this.entries.isEmpty()) {
                this.removeEntry(this.entries.get((int)0).name);
            }
        }
        finally {
            this.clearing = false;
        }
    }

    public boolean showEntry(int index, boolean setFocus) {
        if (index < 0 || index >= this.entries.size()) {
            return false;
        }
        Entry entry = this.entries.get(index);
        this.showEntry(entry, setFocus);
        return true;
    }

    public boolean showEntry(Control control, boolean setFocus) {
        Entry entry = this.getEntry(control);
        if (entry == null) {
            return false;
        }
        this.showEntry(entry, setFocus);
        return true;
    }

    public boolean showEntry(String name, boolean setFocus) {
        Entry entry = this.getEntry(name);
        if (entry == null) {
            return false;
        }
        this.showEntry(entry, setFocus);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showEntry(Entry entry, boolean setFocus) {
        if (entry.tab == null) {
            CTabItem item;
            entry.tab = item = this.createCTabItem(entry.name, entry.control, null);
        }
        this.folder.setSelection(entry.tab);
        this.doNotFocusSelectedTab = !setFocus;
        try {
            this.folder.notifyListeners(13, new Event());
        }
        finally {
            this.doNotFocusSelectedTab = false;
        }
        if (setFocus) {
            entry.tab.getControl().setFocus();
        }
    }

    private CTabItem createCTabItem(String name, Control control, Integer index) {
        if (control.getParent() != this.folder) {
            control.setParent((Composite)this.folder);
        }
        if (index == null) {
            index = this.folder.getItemCount();
        }
        if (index < 0) {
            index = index + this.folder.getItemCount();
        }
        CTabItem item = new CTabItem(this.folder, 0, index.intValue());
        String displayName = name;
        if (this.addSpaces) {
            displayName = "   " + name + "   ";
        }
        item.setText(displayName);
        item.setControl(control);
        return item;
    }

    public Control getCurrentEntryControl() {
        for (Entry entry : this.entries) {
            if (this.folder.getSelection() != entry.tab) continue;
            return entry.control;
        }
        return null;
    }

    public String getCurrentEntryName() {
        for (Entry entry : this.entries) {
            if (this.folder.getSelection() != entry.tab) continue;
            return entry.name;
        }
        return null;
    }

    public Control getEntryControl(int index) {
        return this.entries.get((int)index).control;
    }

    public String getEntryName(int index) {
        return this.entries.get((int)index).name;
    }

    public List<Entry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    private Entry getEntry(String name) {
        for (Entry entry : this.entries) {
            if (!entry.name.equals(name)) continue;
            return entry;
        }
        return null;
    }

    private Entry getEntry(Control control) {
        for (Entry entry : this.entries) {
            if (entry.control != control) continue;
            return entry;
        }
        return null;
    }

    public CTabItem getTab(Control control) {
        for (CTabItem item : this.folder.getItems()) {
            if (item.getControl() != control) continue;
            return item;
        }
        return null;
    }

    public CTabItem getMostRecentlyFocusedTab() {
        return this.entriesByFocusOrder.isEmpty() ? null : this.entriesByFocusOrder.get((int)0).tab;
    }

    public List<CTabItem> getPreviouslyFocusedTabs() {
        ArrayList<CTabItem> li = new ArrayList<CTabItem>(this.entriesByFocusOrder.size());
        for (Entry e : this.entriesByFocusOrder) {
            li.add(e.tab);
        }
        return li;
    }

    public void close(CTabFolderEvent e) {
        CTabItem tab = (CTabItem)e.item;
        for (Entry entry : this.entries) {
            if (entry.tab != tab) continue;
            entry.tab = null;
            break;
        }
    }

    public void maximize(CTabFolderEvent e) {
    }

    public void minimize(CTabFolderEvent e) {
    }

    public void restore(CTabFolderEvent e) {
    }

    public void showList(CTabFolderEvent e) {
    }

    public static class Entry {
        String name;
        Control control;
        CTabItem tab;

        Entry(String name, Control control, CTabItem tab) {
            this.name = name;
            this.control = control;
            this.tab = tab;
        }

        public String getName() {
            return this.name;
        }

        public Control getControl() {
            return this.control;
        }

        public boolean hasTab() {
            return this.tab != null;
        }
    }
}

