/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.controls;

import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.AbstractFilteredView;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.ITableEventListener;
import com.pnfsoftware.jeb.rcpclient.iviewers.table.TableUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class FilteredTableView
extends AbstractFilteredView<Table> {
    private List<ITableEventListener> listeners = new ArrayList<ITableEventListener>();

    public FilteredTableView(Composite parent, int style, String[] columnNames) {
        this(parent, style, columnNames, null, false);
    }

    public FilteredTableView(Composite parent, int style, String[] columnNames, int[] columnWidths, boolean displayIndex) {
        super(parent, style, columnNames, columnWidths, displayIndex);
        this.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!(e.item instanceof TableItem)) {
                    return;
                }
                Object object = e.item.getData();
                boolean selected = FilteredTableView.this.getTable().getSelectionCount() > 0;
                boolean checked = ((TableItem)e.item).getChecked();
                for (ITableEventListener listener : FilteredTableView.this.listeners) {
                    listener.onTableEvent(object, selected, checked);
                }
            }
        });
    }

    @Override
    protected Table buildElement(Composite parent, int style) {
        Table table = new Table(parent, 0x10000 | style | 2);
        table.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(1, true, true));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        return table;
    }

    @Override
    protected void buildColumn(Table parent, String name, int initialWidth) {
        TableColumn tc = new TableColumn(parent, 16384);
        tc.setText(name);
        tc.setResizable(true);
        tc.setMoveable(true);
        if (initialWidth > 0) {
            tc.setWidth(initialWidth);
        }
    }

    public Table getTable() {
        return (Table)this.getElement();
    }

    @Override
    public int getSelectionIndex() {
        return ((Table)this.getElement()).getSelectionIndex();
    }

    @Override
    public void setSelection(int index) {
        ((Table)this.getElement()).setSelection(index);
        ((Table)this.getElement()).showSelection();
    }

    @Override
    public int getItemCount() {
        return ((Table)this.getElement()).getItemCount();
    }

    public void addTableEventListener(ITableEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeTableEventListener(ITableEventListener listener) {
        this.listeners.remove(listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        ((Table)this.getElement()).addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        ((Table)this.getElement()).removeSelectionListener(listener);
    }

    public void pack(boolean changed) {
        super.pack(changed);
        int cnt = ((Table)this.getElement()).getColumns().length;
        int cx = ((Table)this.getElement()).getSize().x;
        if (cnt <= 1) {
            if (cnt == 1) {
                ((Table)this.getElement()).getColumns()[0].setWidth(cx);
            }
            return;
        }
        int maxWidthColumn = cx / cnt;
        for (TableColumn tc : ((Table)this.getElement()).getColumns()) {
            tc.pack();
            if (tc.getWidth() <= maxWidthColumn) continue;
            tc.setWidth(maxWidthColumn);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        int minHeight = ((Table)this.getElement()).getItemHeight() + ((Table)this.getElement()).getHeaderHeight();
        Rectangle trim = ((Table)this.getElement()).computeTrim(0, 0, 0, minHeight);
        minHeight = trim.height;
        if ((minHeight += this.computeInnerHeight(wHint, hHint, changed)) > size.y) {
            size.y = minHeight;
        }
        return size;
    }

    public String exportToString() {
        return TableUtil.buildCsv(this.getTable());
    }
}

