/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.swt.SWTException;

public abstract class UIRunnable
implements Runnable {
    private static final ILogger logger = GlobalLog.getLogger(UIRunnable.class);
    public static final long UITHREAD_BLOCK_WARNING_TIME = 100L;
    public static final long UITHREAD_BLOCK_REPORTING_TIME = 1000L;
    private final String name;
    private final boolean logOnUIThreadBlock;
    private final long createdTs = System.currentTimeMillis();
    private long execStartTs;
    private long execEndTs;

    public UIRunnable(String name, boolean logOnUIThreadBlock) {
        StackTraceElement[] elts;
        if (name == null && Licensing.isDebugBuild() && (elts = Thread.currentThread().getStackTrace()).length >= 2) {
            StackTraceElement e = elts[1];
            name = Licensing.isDebugBuild() ? e.toString() : String.format("%s.%s", e.getClassName(), e.getMethodName());
        }
        this.name = name;
        this.logOnUIThreadBlock = logOnUIThreadBlock;
    }

    public UIRunnable(String name) {
        this(name, true);
    }

    public UIRunnable() {
        this(null, true);
    }

    public String getName() {
        return this.name;
    }

    public abstract void runi();

    @Override
    public final void run() {
        try {
            this.execStartTs = System.currentTimeMillis();
            this.runi();
        }
        catch (SWTException e) {
            block7: {
                try {
                    if (e.code != 24 && e.code != 44 && e.code != 45) break block7;
                    logger.debug("Object is disposed: %s", e.toString());
                    logger.catchingSilent(e);
                }
                catch (Throwable throwable) {
                    this.execEndTs = System.currentTimeMillis();
                    long exectime = this.execEndTs - this.execStartTs;
                    if (this.logOnUIThreadBlock && exectime > 100L) {
                        logger.debug("[!] UI task \"%s\" completed execution in %dms (longer than threshold %dms)", this.name, exectime, 100L);
                    }
                    throw throwable;
                }
            }
            this.execEndTs = System.currentTimeMillis();
            long exectime = this.execEndTs - this.execStartTs;
            if (this.logOnUIThreadBlock && exectime > 100L) {
                logger.debug("[!] UI task \"%s\" completed execution in %dms (longer than threshold %dms)", this.name, exectime, 100L);
            }
        }
        this.execEndTs = System.currentTimeMillis();
        long exectime = this.execEndTs - this.execStartTs;
        if (this.logOnUIThreadBlock && exectime > 100L) {
            logger.debug("[!] UI task \"%s\" completed execution in %dms (longer than threshold %dms)", this.name, exectime, 100L);
        }
    }

    public boolean isStarted() {
        return this.execStartTs != 0L;
    }

    public boolean isDone() {
        return this.execEndTs != 0L;
    }

    public long getCreatedTs() {
        return this.createdTs;
    }

    public long getExecStartTs() {
        return this.execStartTs;
    }

    public long getExecEndTs() {
        return this.execEndTs;
    }
}

