/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.rcpclient.extensions.UIRunnable;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class UIExecutor {
    private static UIExecutor instance = new UIExecutor();
    private static AtomicInteger synccnt = new AtomicInteger();
    private static AtomicInteger executingSyncCnt = new AtomicInteger();
    private static Object alock = new Object();
    private static AtomicInteger asynccnt = new AtomicInteger();
    private static int asynccntExec;
    private static Map<String, Integer> asyncCallers;
    private static long asyncBestWaitTime;
    private static long asyncWorstWaitTime;
    private static long asyncAvgWaitTime;

    private UIExecutor() {
    }

    public static UIExecutor getInstance() {
        return instance;
    }

    public static void async(Widget w, UIRunnable runnable) {
        UIExecutor.asyncInternal(w.getDisplay(), runnable);
    }

    public static void async(Display d, UIRunnable runnable) {
        UIExecutor.asyncInternal(d, runnable);
    }

    public static void asyncIfNotOnUIThread(Display d, UIRunnable runnable) {
        UIExecutor.asyncInternal(d, runnable, true);
    }

    public static void sync(Widget w, Runnable runnable) {
        UIExecutor.sync(w.getDisplay(), runnable);
    }

    public static void sync(Display d, Runnable runnable) {
        if (d.isDisposed()) {
            return;
        }
        if (d.getThread() == Thread.currentThread()) {
            runnable.run();
            return;
        }
        executingSyncCnt.incrementAndGet();
        synccnt.incrementAndGet();
        d.syncExec(runnable);
        executingSyncCnt.decrementAndGet();
    }

    private static void asyncInternal(Display d, UIRunnable runnable) {
        UIExecutor.asyncInternal(d, runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void asyncInternal(Display d, UIRunnable runnable, boolean bypassQueue) {
        if (d.isDisposed()) {
            return;
        }
        if (bypassQueue && d.getThread() == Thread.currentThread()) {
            runnable.run();
            return;
        }
        boolean debug = Licensing.isDebugBuild();
        if (debug) {
            StackTraceElement[] elts = Thread.currentThread().getStackTrace();
            String caller = "unknown";
            if (elts.length >= 4) {
                caller = elts[3].toString();
            }
            Map<String, Integer> map = asyncCallers;
            synchronized (map) {
                Integer cnt = asyncCallers.get(caller);
                if (cnt == null) {
                    asyncCallers.put(caller, 1);
                } else {
                    asyncCallers.put(caller, cnt + 1);
                }
            }
        }
        asynccnt.incrementAndGet();
        d.asyncExec((Runnable)runnable);
        if (debug) {
            UIExecutor.monitorUITask(runnable);
        }
    }

    private static void monitorUITask(final UIRunnable task) {
        String threadName = "monitorUITask: " + UIExecutor.getCaller();
        ThreadUtil.start(threadName, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!task.isDone()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                Object object = alock;
                synchronized (object) {
                    asynccntExec++;
                    long waitTime = task.getExecStartTs() - task.getCreatedTs();
                    if (waitTime < asyncBestWaitTime) {
                        asyncBestWaitTime = waitTime;
                    }
                    if (waitTime > asyncWorstWaitTime) {
                        asyncWorstWaitTime = waitTime;
                    }
                    if (asynccntExec == 1) {
                        asyncAvgWaitTime = waitTime;
                    } else {
                        long n = (long)asynccntExec - 1L;
                        asyncAvgWaitTime = (n * asyncAvgWaitTime + waitTime) / (long)asynccntExec;
                    }
                }
            }
        });
    }

    private static String getCaller() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        for (int i = 1; i < stack.length; ++i) {
            if (stack[i].getClassName().startsWith(UIExecutor.class.getName()) || stack[i].getClassName().contains(".Abstract")) continue;
            return stack[i].getClassName();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format() {
        ArrayList<Map.Entry<String, Integer>> list;
        StringBuilder sb = new StringBuilder();
        Map<String, Integer> map = asyncCallers;
        synchronized (map) {
            list = new ArrayList<Map.Entry<String, Integer>>(asyncCallers.entrySet());
        }
        Collections.sort(list, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return -Integer.compare(o1.getValue(), o2.getValue());
            }
        });
        sb.append(String.format("=> %d sync executed (currently executing: %d)\n", synccnt.get(), executingSyncCnt.get()));
        sb.append(String.format("=> %d/%d async executed (wait times: avg=%dms best=%dms worst=%dms)\n", asynccntExec, asynccnt.get(), asyncAvgWaitTime, asyncBestWaitTime, asyncWorstWaitTime));
        sb.append("Top callers:\n");
        int i = 0;
        for (Map.Entry entry : list) {
            if (i >= 10) break;
            sb.append(String.format("- %4d %s\n", entry.getValue(), entry.getKey()));
            ++i;
        }
        return sb.toString().trim();
    }

    public String toString() {
        return UIExecutor.format();
    }

    static {
        asyncCallers = Collections.synchronizedMap(new HashMap());
        asyncBestWaitTime = Long.MAX_VALUE;
        asyncWorstWaitTime = 0L;
    }
}

